<?php
/************************************************************************/
/* BALISTE ECMS                                                         */
/* ===========================                                          */
/* Copyright (c) 2004 by Stephan Acquatella (stephan@balistis.com)      */
/* http://www.balistis.com                                              */
/*                                                                      */
/*   																	*/
/* Baliste "Annuaire de Acteur" Module . Stephan ACQUATELLA 2004		*/
/* Project: Environmental Corsican Observatory       					*/
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

// Init Part
if (!preg_match("#modules.php#i", $_SERVER['PHP_SELF'])) {
	die ("You can't access this file directly...");
}

require_once("core/becms_mainlib_lib.php");
$module_name = basename(dirname(__FILE__));
get_lang($module_name);

function listCats() {
	global $prefix, $db, $module_name;
	$categories = array();
	$catsinit = explode("//",_ACT_CAT_CAT_VALUES);
	for ($i=1;$i<=count($catsinit);$i++) {
		$cats[$i]=$catsinit[$i-1];
		$result = $db->sql_query("select Id, label  from ".$prefix."_annuaire_categorie where categorie=$i order by categorie ASC");
		if (!$result) {
			print_r($db->sql_error());
			die('Invalid query');
		}
		$temp = array();
		while (list($Id, $label) = $db->sql_fetchrow($result)) {
			$temp[$Id] = $label;
		}
		$categories[$i] = $temp;
	}
	$nbre_cols = 2;
	$nbre_cats = count($categories);
	$nbre_lignes = ceil($nbre_cats/$nbre_cols);
	$largeur = floor((100 - (($nbre_cols-1)*2))/$nbre_cols);
	
/*	echo "&nbsp;<br>";
	echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\">";
	for ($l=1; $l<=$nbre_lignes;$l++) {
		echo "<tr>";
		for ($c=1;$c<=$nbre_cols;$c++) {
			echo "<td width=\"$largeur%\" valign=\"top\">";
			$temp = $categories[$c+($l-1)*$nbre_cols];
			if (count($temp) != 0) {
				echo "<fieldset><legend>".$cats[$c+($l-1)*$nbre_cols]."</legend>";
				echo "<ul  class=\"listcomp\">";
				foreach ($temp as $key => $lacat) {
					echo "<li><a href=\"modules.php?name=$module_name&sop=listActeur&catid=$key\">".$lacat."</a></li>";
				}
				echo "</ul>";
				echo "</fieldset>";
			}
			echo "</td>";
			if ($c != $nbre_cols) {
				echo "<td width=\"2%\">";
				echo "&nbsp;";
				echo "</td>";
			}
		}
		echo "</tr>";
	}
	echo "</table>";*/
	
	$colonne = array();
	echo "&nbsp;<br>";
	echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\"><tr>";
	for ($l=1; $l<=$nbre_lignes;$l++) {
		for ($c=1;$c<=$nbre_cols;$c++) {
			$temp = $categories[$c+($l-1)*$nbre_cols];
			if (count($temp) != 0) {
				$colonne[$c] .= "<fieldset><legend>".$cats[$c+($l-1)*$nbre_cols]."</legend>";
				$colonne[$c] .= "<ul  class=\"listcomp\">";
				foreach ($temp as $key => $lacat) {
					$colonne[$c] .= "<li><a href=\"modules.php?name=$module_name&sop=listActeur&catid=$key#results\">".$lacat."</a></li>";
				}
				$colonne[$c] .= "</ul>";
				$colonne[$c] .= "</fieldset>\n"."&nbsp;<br>\n";
			}
		}
	}
	for ($c=1;$c<=$nbre_cols;$c++) {
		echo "<td width=\"$largeur%\" valign=\"top\">";
		echo $colonne[$c];
		echo "</td>";
		if ($c != $nbre_cols) {
			echo "<td width=\"2%\">";
			echo "&nbsp;";
			echo "</td>";
		}
	}
	echo "</tr></table>";
}

/**
 * displayAccess
 * display liste by organisme type, and competences
 * @param
 * @return
 * @see
 */
function displayAccess() {
	global $sitename, $prefix, $db, $module_name;
	include ('header.php');
	echo "<h1>".ANNUTITLE."</h1>";
	echo "<fieldset><legend>"._SEARCHCRITERIA."</legend>";
	echo "<div class=\"search_search\">";
	echo "<form action=\"modules.php?name=Search\" method=\"post\">"
	."<input type=\"hidden\" name=\"type\" value=\"annuaire\">"
	.""._SEARCHONACTEUR." <input type=\"name\" name=\"query\" size=\"30\">&nbsp;&nbsp;"
	."<input type=\"submit\" value=\""._SEARCH."\">"
	."</form>"
	."<div><br>[ "
	."<a href=\"modules.php?name=$module_name\">"._ALPHAACCES."</a>"
	." ]</div>";
	echo "</div>";
	echo "</fieldset>";
	
	listCats();
	
	include ('footer.php');
}
/**
 * listActeur()
 * display acteur list sorted by compentence or activity or organisme type
 * @param typid :organism type id
 * @param comid :competences domaine id
 * @param sortBy : data sorted by competence or organism type
 * @return
 * @see
 */
function listActeur($catid) {
	global $sitename, $prefix, $db, $module_name, $db, $colsannulist;
	include ('header.php');
	echo "<h1>".ANNUTITLE."</h1>";
	echo "<fieldset><legend>"._SEARCHCRITERIA."</legend>";
	echo "<div class=\"search_search\">";
	echo "<form action=\"modules.php?name=Search\" method=\"post\">"
	."<input type=\"hidden\" name=\"type\" value=\"annuaire\">"
	.""._SEARCHONACTEUR." <input type=\"name\" name=\"query\" size=\"30\">&nbsp;&nbsp;"
	."<input type=\"submit\" value=\""._SEARCH."\">"
	."</form>"
	."<div><br>[ "
	."<a href=\"modules.php?name=$module_name\">"._ALPHAACCES."</a>"
	." ]</div>";
	echo "</div>";
	echo "</fieldset>";
	
	listCats();

	echo "&nbsp;<br>";
	if (!is_null($catid)) {
		//$result = $db->sql_query("select select Id, nom, adresse, tel, fax, email,web from ".$prefix."_annuaire right join ".$prefix."_annuaire_lien_categorie on Id=id_annuaire where id_categorie=".$catid." order by nom asc");
		$result = $db->sql_query("select Id, nom, adresse, tel, fax, email,web from ".$prefix."_annuaire right join ".$prefix."_annuaire_lien_categorie on Id=id_annuaire where id_categorie=".$catid." order by nom asc");
		if (!$result) {
			print_r($db->sql_error());
			die('Invalid query');
		}
		$result2 = $db->sql_query("select categorie, label from ".$prefix."_annuaire_categorie where Id=".$catid);
		if (!$result2) {
			print_r($db->sql_error());
			die('Invalid query');
		}
		list($idxcat, $label) = $db->sql_fetchrow($result2);
		$catsinit = explode("//",_ACT_CAT_CAT_VALUES);
		$cat_title = $catsinit[$idxcat-1]." : ".$label;
		echo "<fieldset><legend><a name=\"results\"></a>".ucfirst($cat_title)."</legend>";
		echo "<div class=\"padfield\"></div>";
		if ($db->sql_numrows($result) > 0) {
			echo "<table class=\"tabannu\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">";
			$pos=1;
			/*while(list($Id, $nom, $tel) = $db->sql_fetchrow($result)) {
				if ($pos % 2 == 0)	{
					$style = " class=\"odd\"";
				}
				else {
					$style = " class=\"notodd\"";
				}
				$sectionLink="<a href=\"modules.php?name=$module_name&sop=viewActeur&Id=$Id\" >";
				echo "<tr>"
				."<th align=\"left\"".$style.">$sectionLink$nom</th>"
				."<td align=\"center\"".$style.">$tel</a></td>"
				."</tr>";
				$pos++;
			}*/
			while(list($Id, $nom, $adresse, $tel, $fax, $email, $web) = $db->sql_fetchrow($result)) {
				if ($pos % 2 == 0)	{
					$style = " class=\"odd\"";
				}
				else {
					$style = " class=\"notodd\"";
				}
				echo "<tr>";
				if (in_array("nom",$colsannulist)) {
					$nom = ($nom != "") ? $nom : "-";
					echo "<th align=\"left\"".$style."><a href=\"modules.php?name=".$module_name."&sop=viewActeur&Id=".$Id."\">".$nom."</a></th>";
				}
				if (in_array("produits",$colsannulist)) {
					$produits = "";
					$sql = "select label from ".$prefix."_annuaire_categorie join ".$prefix."_annuaire_lien_categorie on id_categorie=Id where categorie=1 and id_annuaire=$Id";
					$result2 = $db->sql_query($sql);
					$categories = array();
					if ($db->sql_numrows($result2) > 0) {
						while(list($label) = $db->sql_fetchrow($result2)) {
							$categories[] = $label;
						}
					}
					$produits = join(", ",$categories);
					if ($produits == "") {
						$produits = "-";
					}
					echo "<td align=\"center\"".$style.">$produits</td>";
				}
				if (in_array("adresse",$colsannulist)) {
					$adresse = ($adresse != "") ? $adresse : "-";
					echo "<td align=\"center\"".$style.">$adresse</td>";
				}
				if (in_array("tel",$colsannulist)) {
					$tel = ($tel != "") ? $tel : "-";
					echo "<td align=\"center\"".$style." nowrap=\"nowrap\">$tel</td>";
				}
				if (in_array("fax",$colsannulist)) {
					$fax = ($fax != "") ? $fax : "-";
					echo "<td align=\"center\"".$style." nowrap=\"nowrap\">$fax</td>";
				}
				if (in_array("email",$colsannulist)) {
					if ($email != "") {
						echo "<td align=\"center\"".$style." nowrap=\"nowrap\"><a href=\"mailto:$email\">$email</a></td>";
					}
					else {
						echo "<td align=\"center\"".$style.">-</td>";
					}
				}
				if (in_array("web",$colsannulist)) {
					$web = str_replace("http://","",$web);
					$web = str_replace("http:/","",$web);
					$web = str_replace("http:","",$web);
					if ($web != "") {
						echo "<td align=\"center\"".$style." nowrap=\"nowrap\"><a href=\"http://$web\" target=\"_blank\">$web</td>";
					}
					else {
						echo "<td align=\"center\"".$style.">-</td>";
					}
				}
				echo "</tr>";
				$pos++;
			}
			echo "</table>";

			
		}
		else {
			echo "<p>"._ANNUNOORGTYPE."</p>";
		}
		echo "</fieldset>";
	}
	include ('footer.php');
}
/**
 * listActeurArbo()
 * Affiche les acteurs regroups par domaine puis par type. Si aucune domaine n'est indiqu, tous sont affichs, sinon seul le domaine indiqu est affich.
 * @param domid :competences domaine id
 * @see
 */
function listActeurArbo($domid) {
	global $sitename, $prefix, $db, $module_name;
	include ('header.php');
	echo "<h1>".ANNUTITLE."</h1>";
	$result4 = $db->sql_query("select domainename,domid from ".$prefix."_annuaireacteur_liste_domaine order by domainename asc ");
	if (!$result4) {
		print_r($db->sql_error());
		die('Invalid query');
	}
	$menu_dom = '<select name="domid" size="1" onchange="window.location.href=\'modules.php?name='.$module_name.'&sop=listActeurArbo&domid=\'+this.value">';
	$menu_dom .= '<option value="">'._ANNUFIRSTLINECHOOSE.'</option>';
	while (list($domaine,$domidsel)= $db->sql_fetchrow($result4)) {
		$select = ($domid == $domidsel) ? " selected=\"selected\"" : "";
		$menu_dom .= '<option value="'.$domidsel.'"'.$select.'>'.$domaine.'</option>';
	}
	$menu_dom .= "</select>";
	echo "<fieldset><legend>"._ANNUCHOOSEDOM."</legend>";
	echo "<div class=\"search_search\">";
	echo "<form action=\"\" method=\"post\">"
	.""._ANNUCHOOSEDOMMENU.$menu_dom
	."</form>";
	echo "</div>";
	echo "</fieldset>";
	echo "&nbsp;<br />";
	if ($domid == "-1" || $domid == "") {
		$result2 = $db->sql_query("select domainename,domid from ".$prefix."_annuaireacteur_liste_domaine order by domainename asc ");
	}
	else {
		$result2 = $db->sql_query("select domainename,domid from ".$prefix."_annuaireacteur_liste_domaine where domid='$domid'");
	}
	if (!$result2) {
		print_r($db->sql_error());
		die('Invalid query');
	}
	while (list($domaine,$domid)= $db->sql_fetchrow($result2)) {
		echo "<h2>".ucfirst($domaine)."</h2>";
		$result = $db->sql_query("select distinct type_acteur from ".$prefix."_annuaireacteur_domaine inner join ".$prefix."_annuaireacteur_acteur on acteur_actid=actid where domaine_domid='$domid'");
		if (!$result) {
			print_r($db->sql_error());
			die('Invalid query'));
		}
		if ($db->sql_numrows($result) > 0) {
			while(list($typid) = $db->sql_fetchrow($result)) {
				$result3 = $db->sql_query("select type_organisme,typid from ".$prefix."_annuaireacteur_liste_type where typid='$typid'");
				if (!$result3) {
					print_r($db->sql_error());
					die('Invalid query');
				}
				while (list($type_organisme,$typid)= $db->sql_fetchrow($result3)) {
					echo "<h3>".ucfirst($type_organisme)."</h3>";
					$result5 = $db->sql_query("select actid, nom_acteur, ville_acteur, sigle_acteur, web_acteur from ".$prefix."_annuaireacteur_acteur inner join ".$prefix."_annuaireacteur_domaine on acteur_actid=actid where type_acteur='$typid' and domaine_domid='$domid' order by nom_acteur");
					if (!$result5) {
						print_r($db->sql_error());
						die('Invalid query');
					}
					if ($db->sql_numrows($result5) > 0) {
						echo "<ul class=\"listact\">";
						while(list($acteurid, $nom_acteur, $ville_acteur, $sigle_acteur, $web_acteur) = $db->sql_fetchrow($result5)) {
							echo "<li><a href=\"modules.php?name=$module_name&sop=viewActeur&actid=$acteurid\">".strtoupper($nom_acteur)."</a></li>";
						}
						echo "</ul>";
					}
					else {
						echo "<p>"._ANNUNOORGTYPE."</p>";
					}
				}
			}
		}
		else {
			echo "<p>"._ANNUNOORGCOMP."</p>";
		}
	}
	include ('footer.php');
}
/**
 * listOrganismType()
 * display list of existinf organism type
 * @param
 * @return
 * @see
 */
function listOrganismType() {
	global $sitename, $prefix, $db, $module_name;
	$result = $db->sql_query("select typid, type_organisme from ".$prefix."_annuaireacteur_liste_type order by type_organisme");
	//	$mycontent="";
	//	//$mycontent.="<TABLE borderColor=#ffffff cellSpacing=2 borderColorDark=#ff8000 cellPadding=2 width=300 border=0>";
	//	$mycontent.="<TABLE class=\"tab\" cellSpacing=2 cellPadding=2 width=260 border=0>";
	//	$mycontent.="<TBODY>";
	//	//$mycontent.="<TR borderColor=#ffffff bgColor=darkorange>";
	//	$mycontent.="<TR>";
	//	$mycontent.="<TD height=39 align=center class=\"titretab\">";
	//	//$mycontent.="<FONT style=\"BACKGROUND-COLOR: darkorange\" color=#ffffff><B>Acc&egrave;s par type d'organisme</B></FONT></TD>";
	//	$mycontent.="Acc&egrave;s par type d'organisme</TD>";
	if ($db->sql_numrows($result) != 0){
		$mycontent ="<ul class=\"listcomp\">";
		while(list($typid, $type_organisme) = $db->sql_fetchrow($result)) {
			//		$mycontent.="<TR >";
			//		$mycontent.="<TD width=351 ><A href=\"modules.php?name=$module_name&amp;sop=listActeur&typid=$typid\">$type_organisme</A></TD>";
			//		$mycontent.="</TR>";
			$mycontent.="<li><a href=\"modules.php?name=$module_name&amp;sop=listActeur&typid=$typid\">$type_organisme</a></li>";
		}
		$mycontent.="</ul>";
	}
	else {
		$mycontent = "<p>"._ANNULISTNOTHING."</p>";
	}
	// $mycontent.="</TABLE>";
	return $mycontent;
}
/**
 * listCompetence()
 * list existing competences domaine
 * @param
 * @return
 * @see
 */
function listCompetence() {
	global $sitename, $prefix, $db, $module_name;
	$result = $db->sql_query("select domid, domainename from ".$prefix."_annuaireacteur_liste_domaine order by domainename");
	//	$mycontent.="<TABLE  class=\"tab\" cellSpacing=2  cellPadding=2 width=270 border=0>";
	//	$mycontent.="<TBODY>";
	//	$mycontent.="<TR>";
	//	$mycontent.="<TD height=39 align=center class=\"titretab\">";
	//	$mycontent.="Acc&egrave;s par domaines de comp&eacute;tence</TD>";
	//	$mycontent.="</TR>";
	if ($db->sql_numrows($result) != 0){
		$mycontent ="<ul class=\"listcomp\">";
		while(list($domid, $domainename) = $db->sql_fetchrow($result)) {
			//$mycontent.="<TR borderColor=#ffffff bgColor=navajowhite>";
			//		$mycontent.="<TR >";
			//		$mycontent.="<TD width=351><A href=\"modules.php?name=$module_name&amp;sop=listActeur&domid=$domid\">$domainename</A></TD>";
			//		$mycontent.="</TR>";
			$mycontent.="<li><a href=\"modules.php?name=$module_name&amp;sop=listActeur&domid=$domid\">".ucfirst($domainename)."</a></li>";
		}
		$mycontent.="</ul>";
	}
	else {
		$mycontent = "<p>"._ANNULISTNOTHING."</p>";
	}
	//	$mycontent.="</TABLE>";
	return $mycontent;
}
/**
 * listActeurByChar()
 *
 *
 *
 *
 */
function listActeurByChar($myfilter){
	global $sitename, $prefix, $db, $module_name, $db, $colsannulist;
	include ('header.php');
	if ($myfilter == "") $myfilter="A";
	if ($myfilter!="") 	$thefilter="WHERE nom LIKE '$myfilter%'";
	//$result = $db->sql_query("select Id, nom, tel from ".$prefix."_annuaire $thefilter order by nom ASC");
	$result = $db->sql_query("select Id, nom, adresse, tel, fax, email,web from ".$prefix."_annuaire $thefilter order by nom ASC");

	echo "<h1>".ANNUTITLE."</h1>";
	echo "<fieldset><legend>"._SEARCHCRITERIA."</legend>";
	echo "<div class=\"search_search\">";
	echo "<form action=\"modules.php?name=Search\" method=\"post\">"
	."<input type=\"hidden\" name=\"type\" value=\"annuaire\">"
	.""._SEARCHONACTEUR." <input type=\"name\" name=\"query\" size=\"30\">&nbsp;&nbsp;"
	."<input type=\"submit\" value=\""._SEARCH."\">"
	."</form>"
	."<div><br>[ <a href=\"modules.php?name=$module_name&sop=displayAccess\">"._THEMECATEGORYACCES."</a> ]</div>";
	echo "</div>";
	echo "</fieldset>";

	echo "&nbsp;<br>";

	echo "<fieldset><legend>"._ANNUALPHA."</legend>";
	echo "<table class=\"tabannu\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr>"
	//."<td class=\"titretab\ width=\"75%\"><b>"._ACTEUR_NAME."</b></td>"
	//."<td class=\"titretab\ width=\"25%\"><b>"._ACTEUR_SIGLE."</b></td>"
	."<td class=\"acttab\" colspan=".count($colsannulist).">"._ANNULISTALPHA.displayAlphabet("modules.php?name=$module_name&sop=listActeurByChar",$myfilter)."</td>"
	."</tr>";
	echo "<tr><td colspan=\"".count($colsannulist)."\"><hr class=\"annu\"></td></tr>";

	$pos=1;
	//while(list($Id, $nom, $tel) = $db->sql_fetchrow($result)) {
	while(list($Id, $nom, $adresse, $tel, $fax, $email, $web) = $db->sql_fetchrow($result)) {
		if ($pos % 2 == 0)	{
			$style = " class=\"odd\"";
		}
		else {
			$style = " class=\"notodd\"";
		}
		echo "<tr>";
		if (in_array("nom",$colsannulist)) {
			$nom = ($nom != "") ? $nom : "-";
			echo "<th align=\"left\"".$style."><a href=\"modules.php?name=".$module_name."&sop=viewActeur&Id=".$Id."\">".$nom."</a></th>";
		}
		if (in_array("produits",$colsannulist)) {
			$produits = "";
			$sql = "select label from ".$prefix."_annuaire_categorie join ".$prefix."_annuaire_lien_categorie on id_categorie=Id where categorie=1 and id_annuaire=$Id";
			$result2 = $db->sql_query($sql);
			$categories = array();
			if ($db->sql_numrows($result2) > 0) {
				while(list($label) = $db->sql_fetchrow($result2)) {
					$categories[] = $label;
				}
			}
			$produits = join(", ",$categories);
			if ($produits == "") {
				$produits = "-";
			}
			echo "<td align=\"center\"".$style.">$produits</td>";
		}
		if (in_array("adresse",$colsannulist)) {
			$adresse = ($adresse != "") ? $adresse : "-";
			echo "<td align=\"center\"".$style.">$adresse</td>";
		}
		if (in_array("tel",$colsannulist)) {
			$tel = ($tel != "") ? $tel : "-";
			echo "<td align=\"center\"".$style." nowrap=\"nowrap\">$tel</td>";
		}
		if (in_array("fax",$colsannulist)) {
			$fax = ($fax != "") ? $fax : "-";
			echo "<td align=\"center\"".$style." nowrap=\"nowrap\">$fax</td>";
		}
		if (in_array("email",$colsannulist)) {
			if ($email != "") {
				echo "<td align=\"center\"".$style." nowrap=\"nowrap\"><a href=\"mailto:$email\">$email</a></td>";
			}
			else {
				echo "<td align=\"center\"".$style.">-</td>";
			}
		}
		if (in_array("web",$colsannulist)) {
			$web = str_replace("http://","",$web);
			$web = str_replace("http:/","",$web);
			$web = str_replace("http:","",$web);
			if ($web != "") {
				echo "<td align=\"center\"".$style." nowrap=\"nowrap\"><a href=\"http://$web\" target=\"_blank\">$web</td>";
			}
			else {
				echo "<td align=\"center\"".$style.">-</td>";
			}
		}
		echo "</tr>";
		$pos++;
	}
	echo "</table>";
	echo "</fieldset>";

	include ('footer.php');
}


function display_line_not_null($libelle,$texte) {
	if ($texte != "") {
		return "<tr><td class=annuaireAttr>$libelle</td><td align=left>$texte</td></tr>";
	}
	else {
		return "";
	}
}

/**
 * viewActeur()
 * view Acteur data
 * @param acid :acteur id
 * @return
 * @see
 */
function viewActeur($Id) {
	global $sitename, $prefix, $db, $admin, $module_name;
	include ('header.php');
	echo "<h1>".ANNUTITLE."</h1>";
	$result = $db->sql_query("select `Id`, `nom`, `adresse`, `tel`, `fax`, `email`, `web`, `dirigeant`, `description`, `typevente`, `agrotourisme`, `produits`  from ".$prefix."_annuaire where Id='$Id'");
	if (!$result) {
		print_r($db->sql_error());
		die('Invalid query');
	}
	list($Id, $nom, $adresse, $tel, $fax, $email, $web, $dirigeant, $description, $typevente, $agrotourisme, $produits) = $db->sql_fetchrow($result);
	$catsinit = explode("//",_ACT_CAT_CAT_VALUES);
	for ($i=1;$i<=count($catsinit);$i++) {
		$cats[$i]=$catsinit[$i-1];
	}
	$categories = array();
	for ($i=1;$i<=count($catsinit);$i++) {
		$result2 = $db->sql_query("select label, icone from ".$prefix."_annuaire_categorie join ".$prefix."_annuaire_lien_categorie on Id=id_categorie where id_annuaire=$Id and categorie=$i order by label ASC;");
		if (!$result2) {
			print_r($db->sql_error());
			die('Invalid query');
		}
		$temp = array();
		while(list($label,$icone) = $db->sql_fetchrow($result2)) {
			$temp [] = array("label" => $label,"icone" => $icone);
		}
		$categories[$i] = $temp;
	}
	echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"tabfiche\" align=\"center\">";
	echo "<tr><td colspan=\"5\" class=\"nom\">";
	echo $nom;
	echo "</td></tr>";
	echo "<tr><td colspan=\"5\" class=\"dirig\">";
	if ($dirigeant != "") {
		echo $dirigeant;
	}
	else {
		echo "&nbsp;";
	}
	echo "</td></tr>";
	echo "<tr><td>";
	echo nl2br($adresse);
	echo "<td rowspan=\"9\" width=\"20\"></td>";
	echo "<td rowspan=\"9\" class=\"vente\" valign=\"top\">".nl2br($typevente)."</td>";
	echo "<td rowspan=\"9\"width=\"20\"></td>";
	echo "<td rowspan=\"9\" class=\"icns\" valign=\"top\">";
	foreach ($categories[1] as $catprod) {
		echo "<img src=\"images/annuaire/".$catprod["icone"]."\" alt=\"".$catprod["label"]."\"><br><br>";
	}foreach ($categories[3] as $catprod) {
		echo "<img src=\"images/annuaire/".$catprod["icone"]."\" alt=\"".$catprod["label"]."\"><br><br>";
	}
	echo "</td>";
	echo "</td></tr>";
	echo "<tr><td>";
	$microregs = array();
	foreach($categories[4] as $microreg) {
		$microregs[] = $microreg["label"];
	}
	echo join(" - ",$microregs);
	echo "</td></tr>";
	echo "<tr><td>";
	if ($fax.$tel != "") {
		echo _TELFAX_ACTEUR.$tel;
		echo ($fax != "") ? "/".$fax : "";
		echo "</td></tr>";
	}
	if ($email != "") {
		echo "<tr><td>";
		echo _EMAIL_ACTEUR."<a href=\"mailto:".$email."\">".$email."</a>";
		echo "</td></tr>";
	}
	if ($web != "") {
		$web = str_replace("http://","",$web);
		$web = str_replace("http:/","",$web);
		$web = str_replace("http:","",$web);
		echo "<tr><td>";
		echo _WEB_ACTEUR."<a href=\"http://".$web."\" target=\"_blank\">".$web."</a>";
		echo "</td></tr>";
	}
	echo "<tr><td class=\"prods\">";
	echo nl2br($produits);
	echo "</td></tr>";
	echo "<tr><td class=\"descr\">";
	echo nl2br($description);
	echo "</td></tr>";
	if ($agrotourisme != "") {
		echo "<tr><td class=\"agro\">";
		echo _ANNUAGRO.nl2br($agrotourisme);
		echo "</td></tr>";
	}
	echo "</table>";

	// Contact
	/*if ($db->sql_numrows($result4) != 0) {
		echo "&nbsp;<br />";
		echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"tabfiche\" align=\"center\"><tr><td valign=\"top\">";
		echo "<fieldset><legend>"._CONTACT."</legend>";
		echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\">";
		while(list($nom_contact, $prenom_contact, $telephone_contact, $telephone_mobile_contact, $fax_contact, $email_contact, $web_contact, $titre_contact, $domaine_contact, $role_contact) = $db->sql_fetchrow($result4)) {
			if (trim($telephone_contact) != "") {
				$TelephoneDisplay = "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td>";
				$TelephoneDisplay .= "<img src=\"images/annuaire_acteur/attribut/icone_telephonenumber.gif\" border=\"0\">";
				$TelephoneDisplay .= "</td><td>";
				$TelephoneDisplay .= $telephone_contact;
				$TelephoneDisplay .= "</td></tr></table>";
			}
			if (trim($email_contact) != "") {
				$MailDisplay = "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td>";
				$MailDisplay .= "<img src=\"images/annuaire_acteur/attribut/icone_mail.gif\" border=\"0\">";
				$MailDisplay .= "</td><td>";
				$MailDisplay .= $email_contact;
				$MailDisplay .= "</td></tr></table>";
			}
			echo "<tr><td class=\"annuaireAttr\" colspan=\"3\" id=\"contact\">$nom_contact $prenom_contact </td>"
			."<tr class=annuaireTexteAttr ><td width=\"30%\"> $domaine_contact</td><td width=\"35%\">$TelephoneDisplay</td><td width=\"35%\">$MailDisplay</td></tr>";
		}
		echo "</table>";
		echo "</fieldset>";
		echo "</td></tr></table>";
	}*/

	// Impression et PDF
	$bardef=array(
	"print"=>"modules.php?name=$module_name&sop=printActeurPage&Id=$Id",
	//"pdf"=>"modules.php?name=$module_name&sop=exportActeurAsPdf&Id=$Id",
	//"pdf"=>"modules.php?name=balisteEcmspdf&sop=view&Id=$Id&pdfname=FicheActeur",
	"back"=>"javascript:window.history.back();",
	"top"=>"#top"
	);
	buttonBar($bardef, "align");

	/*echo "<br><table width=\"100%\"><tr><td align=right>";
	 echo "<a href=\"modules.php?name=$module_name&sop=printActeurPage&amp;actid=$actid\" target=\"_blank\"><img src=\"images/print.gif\" border=\"0\" Alt=\""._PRINTER."\" width=\"18\" height=\"20\"></a>"
	 ." <a href=\"modules.php?name=balisteEcmspdf&sop=view&amp;actid=$actid&pdfname=FicheActeur\"><img src=\"images/pdf15x15.jpg\" border=\"0\" Alt=\""._PDF."\" width=\"15\" height=\"15\"></a>"
	 ."</font></td></tr></table>";*/

	adminEditButton("system.php?op=S_acteurEdit&onglet=acteur&Id=".$Id);

	include ('footer.php');
}

/**
 * printActeurPage($acid)
 * format acteur page for an HTML print
 * @param acid :acteur id
 * @return
 * @see
 */
function printActeurPage($Id, $ok=1) {
	global $site_logo,$Default_Theme, $nukeurl, $sitename, $datetime, $prefix, $db, $module_name;

	$printPage = "<html>"
	."<head>"
	."<title>$sitename</title>"
	."<LINK REL=\"StyleSheet\" HREF=\"themes/$Default_Theme/style/style.css\" TYPE=\"text/css\">\n\n\n"
	."</head>"
	."<body bgcolor=\"#FFFFFF\" text=\"#000000\" >"
	."<table border=\"0\"><tr><td>"
	."<table border=\"0\" width=\"640\" cellpadding=\"0\" cellspacing=\"1\" bgcolor=\"#000000\"><tr><td>"
	."<table border=\"0\" width=\"640\" cellpadding=\"20\" cellspacing=\"1\" bgcolor=\"#FFFFFF\"><tr><td>"
	."<center>"
	."<img src=\"images/$site_logo\" border=\"0\" alt=\"\"><br><br></center>";

	$result = $db->sql_query("select `Id`, `nom`, `adresse`, `tel`, `fax`, `email`, `web`, `dirigeant`, `description`, `typevente`, `agrotourisme`, `produits`  from ".$prefix."_annuaire where Id='$Id'");
	if (!$result) {
		print_r($db->sql_error());
		die('Invalid query');
	}
	list($Id, $nom, $adresse, $tel, $fax, $email, $web, $dirigeant, $description, $typevente, $agrotourisme, $produits) = $db->sql_fetchrow($result);
	$catsinit = explode("//",_ACT_CAT_CAT_VALUES);
	for ($i=1;$i<=count($catsinit);$i++) {
		$cats[$i]=$catsinit[$i-1];
	}
	$categories = array();
	for ($i=1;$i<=count($catsinit);$i++) {
		$result2 = $db->sql_query("select label, icone from ".$prefix."_annuaire_categorie join ".$prefix."_annuaire_lien_categorie on Id=id_categorie where id_annuaire=$Id and categorie=$i order by label ASC;");
		if (!$result2) {
			print_r($db->sql_error());
			die('Invalid query');
		}
		$temp = array();
		while(list($label,$icone) = $db->sql_fetchrow($result2)) {
			$temp [] = array("label" => $label,"icone" => $icone);
		}
		$categories[$i] = $temp;
	}
	$printPage .= "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"tabfiche\" align=\"center\">";
	$printPage .= "<tr><td colspan=\"5\" class=\"nom\">";
	$printPage .= $nom;
	$printPage .= "</td></tr>";
	$printPage .= "<tr><td colspan=\"5\" class=\"dirig\">";
	if ($dirigeant != "") {
		$printPage .= $dirigeant;
	}
	else {
		$printPage .= "&nbsp;";
	}
	$printPage .= "</td></tr>";
	$printPage .= "<tr><td>";
	$printPage .= nl2br($adresse);
	$printPage .= "<td rowspan=\"9\" width=\"20\"></td>";
	$printPage .= "<td rowspan=\"9\" class=\"vente\" valign=\"top\">".nl2br($typevente)."</td>";
	$printPage .= "<td rowspan=\"9\"width=\"20\"></td>";
	$printPage .= "<td rowspan=\"9\" class=\"icns\" valign=\"top\">";
	foreach ($categories[1] as $catprod) {
		$printPage .= "<img src=\"images/annuaire/".$catprod["icone"]."\" alt=\"".$catprod["label"]."\"><br><br>";
	}foreach ($categories[3] as $catprod) {
		$printPage .= "<img src=\"images/annuaire/".$catprod["icone"]."\" alt=\"".$catprod["label"]."\"><br><br>";
	}
	$printPage .= "</td>";
	$printPage .= "</td></tr>";
	$printPage .= "<tr><td>";
	$microregs = array();
	foreach($categories[4] as $microreg) {
		$microregs[] = $microreg["label"];
	}
	$printPage .= join(" - ",$microregs);
	$printPage .= "</td></tr>";
	$printPage .= "<tr><td>";
	if ($fax.$tel != "") {
		$printPage .= _TELFAX_ACTEUR.$tel;
		$printPage .= ($fax != "") ? "/".$fax : "";
		$printPage .= "</td></tr>";
	}
	if ($email != "") {
		$printPage .= "<tr><td>";
		$printPage .= _EMAIL_ACTEUR.$email;
		$printPage .= "</td></tr>";
	}
	if ($web != "") {
		$printPage .= "<tr><td>";
		$printPage .= _WEB_ACTEUR.$web;
		$printPage .= "</td></tr>";
	}
	$printPage .= "<tr><td class=\"prods\">";
	$printPage .= nl2br($produits);
	$printPage .= "</td></tr>";
	$printPage .= "<tr><td class=\"descr\">";
	$printPage .= nl2br($description);
	$printPage .= "</td></tr>";
	if ($agrotourisme != "") {
		$printPage .= "<tr><td class=\"descr\">";
		$printPage .= _ANNUAGRO.nl2br($agrotourisme);
		$printPage .= "</td></tr>";
	}
	$printPage .= "</table>";
	
	$printPage .= "</td></tr></table>";
	$printPage .= "</td></tr></table>";
	$printPage .= " <br><center>
    <font class=\"annuairePrintFooter\">
    "._COMESFROM." $sitename :::
	<a href=\"$nukeurl\">$nukeurl</a><br><br>
	</font></center>
	</td></tr></table>
	</body>
	</html>
    ";
	if ($ok) {
		echo $printPage;
	}
	else{
		return $printPage;
	}
}
/**
 * exportActeurAsPdf()
 * export Acteur page as a pdf document
 * @param acid :acteur id
 * @return
 * @see
 */
function exportActeurAsPdf($Id) {
	require("modules/balisteEcmspdf/templates/Default/html2pdf.php");
	$myhtmlPage=printActeurPage($Id,0);

	if (isset($myhtmlPage))
	{
		$pdf = new createPDF(
		$myhtmlPage,   // html  convertir
		$mytitle,  // titre de l'article
		$myurl,    // URL de l'article
		$author, // nom de l'auteur
		time()
		);
		$pdf->run();
	}
}
/**
 * displayAlphabet()
 *
 * @param datatype paramname description
 * @return datatype description
 */
function displayAlphabet($thelink,$lettreencours="A"){
	global $db;
	$acteurLink=$thelink."&myfilter=";
	//$lettres = array("A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z");
	$lettres = array();
	$result = $db->sql_query("SELECT DISTINCT SUBSTRING(becms_annuaire.nom,1,1) as initiale FROM `becms_annuaire`");
	if ($db->sql_numrows($result)) {
		while($initiale = $db->sql_fetchrow($result)) {
			$lettres[] = $initiale[0];
		}
	}
	$alpha = "<div class=\"pages\">";
	foreach($lettres as $lettre) {
		if ($lettreencours == $lettre) {
			$alpha .= "<div class=\"pagevide\">".$lettre."</div>";
		}
		else {
			$alpha .= "<div class=\"page\"><a href=\"".$acteurLink.$lettre."\">".$lettre."</a></div>";
		}
	}
	$alpha .= "</div>";
	return $alpha;
}

/*--------------------------------------*/
/*           start Switch				*/
/*--------------------------------------*/
$index = 1;
switch($sop) {

	case "displayAccess":
		displayAccess();
		break;

	case "listActeur":
		listActeur($catid);
		break;

	case "listOrganismType":
		listOrganismType();
		break;

	case "listCompetence":
		listCompetence();
		break;

	case "viewActeur":
		viewActeur($Id);
		break;

	case "printActeurPage":
		printActeurPage($Id);
		break;

	case "listActeurByChar":
		listActeurByChar($myfilter);
		break;

	case "listActeurArbo" :
		listActeurArbo($domid);
		break;

	case "exportActeurAsPdf":
		exportActeurAsPdf($Id);
		break;

	default:
		listActeurByChar($myfilter);
		break;
}

?>