<?php
/**
* Classes des fonctions pour afficher les cartes.
* 
* Elles sont dans une classe pour les isoler des autres fonctions. 
* @package becmsSimpleCarto
* @version 0.1
* @author Vincent RUIZ <webmaster@arobase.fr>
* @copyright Copyright  2007, Vincent RUIZ
* @license http://opensource.org/licenses/gpl-license.php GNU Public License 
*/
require_once("g_db.php");
require_once("ba_admincarto.php");

/**
* Classe des fonctions.
* 
* Cette clase contient galement les fonctions utiles (calcul de taille de texte, conversion de couleurs,...).
* @package becmsSimpleCarto
*/
class displayCartos {
	
/**
* @var object Classe qui donne accs au fonctions d'affichage des cartes.
*/		
//	var $sgbd;
/**
* Initialise $sgbd avec la classe des fonctions d'accs  la base de donnes des cartes
*/	
/*	function displayCartos() {
		$this->sgbd = new BD_Cartos();
	}*/
/**
* [Deprecated] Renvoie un tableau HTML listant tous les lieux de la carte dsigne.
* 
* Ce tableau permet de visualiser tousles les lieux de la carte.
* @param array $My_SQL Paramtres de la base de donnes
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL
* @return string Tableau HTML des lieux.
*/
/*	function get_lieux_tab($My_SQL,$vars_mod) {
		$lieux = $this->sgbd->getLieux($My_SQL,"",$vars_mod[$vars_mod["id_carte"]]);
		$observations = "";
		if (count($lieux) != 0) {
			$observations = '<table border="0" cellpadding="0" celspacing="0" class="observations">';
			$observations .= '<tr><th colspan="4">Dtails</th></tr>';
			foreach ($lieux as $lieu) {
				if ($lieu["istext"] == "0" && $lieu["isbordure"] == "0") {
					$observations .= '<tr>';
					$observations .= '<td>';
					$observations .= '<img src="'.$lieu["icone"].'" />';
					$observations .= '</td><!--<td>';
					$observations .= conditionnerHTML($lieu["icone"]);
					$observations .= '</td>--><td>';
					$observations .= conditionnerHTML($lieu["lieu"]);
					$observations .= '</td><td>';
					$observations .= conditionnerHTML($lieu["commentaire"]);
					$observations .= '</td><td>';
					if ($lieu["fiche"] != "") {
						$observations .= '<a href="'.conditionnerHTML($lieu["fiche"]).'" target="'.$lieu["target"].'">[voir fiche]</a>';
					}
					$observations .= '</td>';
					$observations .= '</tr>';
				}
			}
			$observations .= '</table>';
		}
		return $observations;
	}*/
/**
* Renvoie les lments  afficher de la carte dsigne.
* 
* Ces lments sont conditionns pour leur usage dans le code Javascript d'affichage de la carte
* @param array $My_SQL Paramtres de la base de donnes
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL
* @return array Tableau PHP contenant les codes Javascript : "lieux","polygones" et "options".
*/
	function get_lieux_JS($My_SQL,$vars_mod) {
		global $cartobuttons, $cartopospicto, $cartopictowidth, $cartopictoheight, $cartopleinecran;
		/*$lieux = $this->sgbd->getLieux($My_SQL,"",$vars_mod[$vars_mod["id_carte"]]);
		$carte = $this->sgbd->getCartes($My_SQL,$vars_mod[$vars_mod["id_carte"]]);*/
		$touspoints ="";
		/*$touspoints = "touspoints = new Array;";
		$i = 0;
		foreach ($lieux as $lieu) {
			if ($lieu["isbordure"] != "1") {
				if ($touspoints != "") {
					$touspoints .= "\n";
				}
				$touspoints .= "\t\ttouspoints[$i] = ".$lieu["latitude"].";";
				$i++;
				$touspoints .= " touspoints[$i] = ".$lieu["longitude"].";";
				$i++;
				$touspoints .= " touspoints[$i] = \"".adminCartos::conditionnerJS($lieu["icone"])."\";";
				$i++;
				$touspoints .= " touspoints[$i] = \"".adminCartos::conditionnerJS($lieu["lieu"])."\";";
				$i++;
				$touspoints .= " touspoints[$i] = \"".adminCartos::conditionnerJS($lieu["fiche"])."\";";
				$i++;
				$touspoints .= " touspoints[$i] = \"".$lieu["istext"]."\";";
				$i++;
				$touspoints .= " touspoints[$i] = \"".adminCartos::conditionnerJS($lieu["commentaire"])."\";";
				$i++;
				if ($lieu["istext"]) {
					$touspoints .= " touspoints[$i] = \"".adminCartos::tailleLieuDit($lieu["lieu"],$lieu["angle"],$lieu["typo"],$lieu["taille"],$vars_mod["cheminPolices"])."\";";
					$i++;
					$touspoints .= " touspoints[$i] = \"".$lieu["angle"]."\";";
					$i++;
					$touspoints .= " touspoints[$i] = \"".$lieu["couleur"]."\";";
					$i++;
					$touspoints .= " touspoints[$i] = \"".$lieu["typo"]."\";";
					$i++;
					$touspoints .= " touspoints[$i] = \"".$lieu["taille"]."\";";
					$i++;
				}
				else {
					$touspoints .= " touspoints[$i] = \"\";";
					$i++;
					$touspoints .= " touspoints[$i] = \"\";";
					$i++;
					$touspoints .= " touspoints[$i] = \"\";";
					$i++;
					$touspoints .= " touspoints[$i] = \"\";";
					$i++;
					$touspoints .= " touspoints[$i] = \"\";";
					$i++;
				}
				$touspoints .= " touspoints[$i] = \"".adminCartos::conditionnerJS($lieu["target"])."\";";
				$i++;
			}
		}*/
		$touspolys = "";
		/*$touspolys = "touspolygones = new Array;";
		$i = 0;
		foreach ($lieux as $lieu) {
			if ($lieu["isbordure"]) {
				if ($touspolys != "") {
					$touspolys .= "\n";
				}
				$touspolys .= "\t\ttouspolygones[$i] = \"".adminCartos::conditionnerJS($lieu["lieu"])."\";";
				$i++;
				$touspolys .= " touspolygones[$i] = \"".$lieu["bordure"]."\";";
				$i++;
				$touspolys .= " touspolygones[$i] = \"".$lieu["b_visibilite"]."\";";
				$i++;
				$touspolys .= " touspolygones[$i] = \"".$lieu["b_epaisseur"]."\";";
				$i++;
				$touspolys .= " touspolygones[$i] = \"".$lieu["b_couleur"]."\";";
				$i++;
				$touspolys .= " touspolygones[$i] = \"".$lieu["b_opacite"]."\";";
				$i++;
				$touspolys .= " touspolygones[$i] = \"".$lieu["b_plein"]."\";";
				$i++;
			}
		}*/
		$options = "options = new Array;\n";
		$options .= "\t\toptions[\"print\"] = true;\n";
		if ($vars_mod[$vars_mod["bulles"]] == "T") {
			$options .= "\t\toptions[\"bulle\"] = \"T\";\n";
		}
		if ($vars_mod[$vars_mod["bulles"]] == "C") {
			$options .= "\t\toptions[\"bulle\"] = \"C\";\n";
		}
		if ($vars_mod[$vars_mod["bulles"]] == "TC") {
			$options .= "\t\toptions[\"bulle\"] = \"TC\";\n";
		}
		if ($vars_mod[$vars_mod["bulles"]] != "T" && $vars_mod[$vars_mod["bulles"]] != "C" && $vars_mod[$vars_mod["bulles"]] != "TC") {
			$options .= "\t\toptions[\"bulle\"] = \"TC\";\n";
		}
		if ($vars_mod[$vars_mod["limites"]] == "1") {
			$options .= "\t\toptions[\"bordure\"] = true;\n";
		}
		else {
			$options .= "\t\toptions[\"bordure\"] = false;\n";
		}
		if ($vars_mod[$vars_mod["polygones"]] == "1") {
			$options .= "\t\toptions[\"polygones\"] = true;\n";
		}
		else {
			$options .= "\t\toptions[\"polygones\"] = false;\n";
		}
		if ($vars_mod[$vars_mod["pictos"]] == "1") {
			$options .= "\t\toptions[\"lieux\"] = true;\n";
		}
		else {
			$options .= "\t\toptions[\"lieux\"] = false;\n";
		}
		if ($vars_mod[$vars_mod["legende"]] == "1") {
			$options .= "\t\toptions[\"obs\"] = true;\n";
		}
		else {
			$options .= "\t\toptions[\"obs\"] = false;\n";
		}
		$options .= "\t\toptions[\"type_map\"] = \"".$vars_mod[$vars_mod["type_map"]]."\";\n";
		if ($vars_mod[$vars_mod["mini-map"]] == "1") {
			$options .= "\t\toptions[\"mini_vue\"] = true;\n";
		}
		else {
			$options .= "\t\toptions[\"mini_vue\"] = false;\n";
		}
		if ($vars_mod[$vars_mod["titre"]] == "1") {
			$options .= "\t\toptions[\"titre\"] = true;\n";
		}
		else {
			$options .= "\t\toptions[\"titre\"] = false;\n";
		}
		if ($vars_mod[$vars_mod["commenter"]] == "1") {
			$options .= "\t\toptions[\"commenter\"] = true;\n";
		}
		else {
			$options .= "\t\toptions[\"commenter\"] = false;\n";
		}
		$options .= "\t\toptions[\"seuil_texte\"] = \"".$vars_mod[$vars_mod["seuil_texte"]]."\";\n";
		if ($vars_mod[$vars_mod["controles"]] == "1") {
			$options .= "\t\toptions[\"controles\"] = true;\n";
		}
		else {
			$options .= "\t\toptions[\"controles\"] = false;\n";
		}
		if ($vars_mod[$vars_mod["taille"]] != "") {
			list($hauteur,$largeur) = explode("/",$vars_mod[$vars_mod["taille"]]);
			$options .= "\t\toptions[\"map_h\"] = \"$hauteur\";\n";
			$options .= "\t\toptions[\"map_v\"] = \"$largeur\";\n";
		}
		else {
			$options .= "\t\toptions[\"map_h\"] = \"\";\n";
			$options .= "\t\toptions[\"map_v\"] = \"\";\n";
		}
		$options .= "\t\toptions[\"zoom_min\"] = \"".$vars_mod[$vars_mod["zoom_min"]]."\";\n";
		$options .= "\t\toptions[\"zoom_max\"] = \"".$vars_mod[$vars_mod["zoom_max"]]."\";\n";
		$btns = "";
		foreach ($cartobuttons as $typedemap) {
			$btns .= ($btns == "") ? "" : ",";
			$btns .= "'".$typedemap."'";
		}
		$options .= "\t\toptions[\"btnstypes\"] = [".$btns."];\n";
		$options .= "\t\toptions[\"anchor_picto\"] = \"$cartopospicto\";\n";
		$options .= "\t\toptions[\"width_picto\"] = $cartopictowidth;\n";
		$options .= "\t\toptions[\"height_picto\"] = $cartopictoheight;\n";
		if($cartopleinecran == "1") {
			$options .= "\t\toptions[\"fullscreen\"] = true;\n";
		} else {
			$options .= "\t\toptions[\"fullscreen\"] = false;\n";
		}
		
		/*$options .= "\t\toptions[\"titre\"] = \"".$carte[0]["designation"]."\";\n";
		$options .= "\t\toptions[\"latitudeinit\"] = ".$carte[0]["latitudeinit"].";\n";
		$options .= "\t\toptions[\"longitudeinit\"] = ".$carte[0]["longitudeinit"].";\n";
		$options .= "\t\toptions[\"zoominit\"] = ".$carte[0]["zoominit"].";\n";
		$options .= "\t\toptions[\"zoomclic\"] = ".$carte[0]["zoomclic"].";\n";
		$options .= "\t\toptions[\"points_bordure\"] = \"".$carte[0]["bordure"]."\";\n";
		$options .= "\t\toptions[\"points_visibilite\"] = \"".$carte[0]["visibilite"]."\";\n";
		$options .= "\t\toptions[\"points_epaisseur\"] = ".$carte[0]["epaisseur"].";\n";
		$options .= "\t\toptions[\"points_couleur\"] = \"".$carte[0]["couleur"]."\";\n";
		$options .= "\t\toptions[\"points_opacite\"] = ".$carte[0]["opacite"].";\n";*/
		
		$options .= "\t\tvar racine_lib_module = \"".$vars_mod["cheminIcones"]."\";";
		
		return array("lieux"=>$touspoints,"polygones"=>$touspolys,"options"=>$options);
	}	

/**
* Affiche la carte dsigne.
* 
* Renvoie le code HTML et Javascript pour visualiser la carte.
* Toutes les options de visualisation sont dans $vars_mod.
* La liste des options est la suivante :
* - Idc : identifiant de la carte
* - br (0,1): Permet l'affichage des limites de la carte (trac permanent)
* - bl ("T","C","TC", "0") : Permet l'affichage de bulles avec texte uniquement("T"), carte zoome uniquement ("C") ou tabule avec texte et carte ("TC") 
* - tl (0,1) : Permet l'affichage du tableau des pictogrammes (la lgende)
* - ic (0,1) : Permet l'affichage des pictogrammes
* - pl (0,1) : Permet l'affichage des polygones
* - v ("P","S","M") : Permet le choix de l'affichage de la carte : Plan, Satellite ou Mixte.
* 
* @param array $My_SQL Paramtres de la base de donnes
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL
* @param string $keymap Clef d'accs  l'API Google
* @return string Tableau HTML des lieux.
*/	
	function get_map($My_SQL,$vars_mod,$keymap) {
		global $module_name;
		$codeJS = $this->get_lieux_JS($My_SQL,$vars_mod,$theme);
		if (file_exists("themes/".get_theme()."/style/".$module_name.".css")) {
			$stylecarto = "";
		}
		else {
			$stylecarto = '		<link href="'.$vars_mod["cheminIcones"].'/style-map.css" rel="stylesheet" type="text/css" media="all"/>
		';
		}
		//$contenu = join('',file("mapping.htm"));
		$contenu ='
		<!--<script type="text/javascript" src="http://maps.google.com/maps?file=api&v=2&key='.$keymap.'" charset="UTF-8"></script>-->
		<script type="text/javascript" src="https://maps.googleapis.com/maps/api/js?v=3&key='.$keymap.'" charset="UTF-8"></script>
	    <script type="text/javascript" src="'.$vars_mod["cheminIcones"].'/getscript_display.php"  charset="UTF-8"></script>
		<script type="text/javascript">
		//<![CDATA[
		'/*.$codeJS["lieux"].'
		'.$codeJS["polygones"].'
		'*/.$codeJS["options"].'
	    //]]>
	    </script>
	    <script type="text/javascript">
		// <![CDATA[
			addToStart("GetMap(\''.$vars_mod[$vars_mod["id_carte"]].'\')");
			//addToStart("ajout_bouton(map,1,\'Village\', \'Zoom sur village\', 42.61491751022249, 8.905513286590576, 16, G_NORMAL_MAP)");
			//addToStart("ajout_bouton(map,2,\'Village\', \'Zoom sur village\', 42.31032319883329, 9.150924682617188, 14, G_NORMAL_MAP)");
			//addToStart("listLieux(\''.$vars_mod[$vars_mod["id_carte"]].'\',\'obs\')");
			//addToStart("titrer(\''.$vars_mod[$vars_mod["id_carte"]].'\',\'titre\')");
			//addToStart("commenter(\''.$vars_mod[$vars_mod["id_carte"]].'\',\'commentaire\')");
			//addToStart(minivue);
			//addToStop(GUnload);
		// ]]>
		</script>
	    '.$stylecarto;
	    $tmpl_file = "themes/".get_theme()."/pattern_map.html";
	    if (!file_exists($tmpl_file)) {
		    $contenu .= '
		<div class="carto">
			<h1 id="titre"></h1>
			<div id="commentaire"></div>
			<p>&nbsp;</p>
			<div id="map"></div>
			<p>&nbsp;</p>
			<div id="obs"></div>
		</div>
		';
	    }
	    else {
			$contenu .= implode("", file($tmpl_file));
	    }
	    	
		return $contenu;
	}
	
/**
* Affiche la liste des cartes disponibles.
* 
* Renvoie le code HTML de la liste des cartes. 
* @param array $My_SQL Paramtres de la base de donnes
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL
* @return string Tableau HTML des lieux.
*/	
	function get_list_map($My_SQL,$vars_mod) {
		global $module_name;
		$admin = new adminCartos();
		$sgbd = new BD_Cartos();
		$cartes = $sgbd->getCartes($My_SQL,$Idc);
		if (count($cartes) != 0) {
			$listmaps = "<ul>";
			foreach ($cartes as $carte) {
				$listmaps .= "<li><a href=\"modules.php?name=SimpleCarto&sop=display&".$vars_mod["id_carte"]."=".$carte["Id"]."\">".$admin->conditionnerHTML($carte["designation"])."</a></li>";
			}
			$listmaps .= "</ul>";
		}
		else {
			$listmaps = "";
		}
		$contenu = '
		<div class="carto">
			<h1>'._AVAILABLEMAPS.'</h1>
			'.$listmaps.'
		</div>';
			
		return $contenu;
	}
	
	function get_all_maps($My_SQL) {
		$sgbd = new BD_Cartos();
		$cartes = $sgbd->getCartes($My_SQL,"");
		return $cartes;
	}
}
?>