/**
* Librairie permettant l'affichage d'un menu de choix de couleur.
*
* Usage : dans le fichier principal, appeler cette librairie puis intger le code suivant
* <input type="hidden" id="pick1101735856field" name="b_couleur" value=""/>
* <a id="pick1101735856" style="display: block; margin: 2px; padding: 0; border: 1px solid #000000; font-family: 'verdana'; font-size: 12px; text-decoration: none" onclick="if (document.formfiche.isbordure.checked) { pickColor(\'pick1101735856\'); };return false" href="#">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</a>
* <script type="text/javascript">relateColor(\'pick1101735856\', getObj(\'pick1101735856field\').value);</script>
* 
* @package becmsSimpleCarto
* @version 1
* @author Vincent RUIZ <webmaster@arobase.fr>
* @copyright Copyright  2007, Vincent RUIZ
* @license http://opensource.org/licenses/gpl-license.php GNU Public License 
*/
var perline = 9;
var divSet = false;
var curId;
var colorLevels = Array('0', '3', '6', '9', 'C', 'F');
var colorArray = Array();
var ie = false;
var nocolor = 'none';

if (document.all) {
	ie = true;
	nocolor = '';
}

function getObj(id) {
	if (ie) {
		return document.all[id];
	}
	else {
		return document.getElementById(id);
	}
}

function addColor(r, g, b) {
	var red = colorLevels[r];
	var green = colorLevels[g];
	var blue = colorLevels[b];
	addColorValue(red, green, blue);
}

function addColorValue(r, g, b) {
	colorArray[colorArray.length] = '#' + r + r + g + g + b + b;
}

function setColor(color) {
	var link = getObj(curId);
	var field = getObj(curId + 'field');
	var picker = getObj('colorpicker');
	if (color != "") {
		field.value = color;
	}
	if (color == '') {
 		color = nocolor;
	}
	else {
 		link.style.background = color;
 		link.style.color = color;
	}
	picker.style.display = 'none';
	eval(getObj(curId + 'field').title);
	//dclenche une action sur validation d'une couleur
	if (typeof(action_preview) != "undefined") {
		if(typeof(action_preview) == 'function'){
			action_preview();
		}
	}
}
   
function setDiv() {     
	if (!document.createElement) { return; }
	var elemDiv = document.createElement('div');
	if (typeof(elemDiv.innerHTML) != 'string') { return; }
	genColors();
	elemDiv.id = 'colorpicker';
	elemDiv.style.position = 'absolute';
	elemDiv.style.display = 'none';
	elemDiv.style.border = '#000000 1px solid';
	elemDiv.style.background = '#FFFFFF';
	elemDiv.style.margin = '0px';
	elemDiv.style.padding = '0px';
	elemDiv.innerHTML = '<span style="font-family: verdana; font-size: 10px;">' 
    + '[<a href="javascript:setColor(\'\');" style="color: #000000; text-decoration: none;">annuler</a>]<br>' 
   	+ getColorTable();
   	document.body.appendChild(elemDiv);
	divSet = true;
}

function pickColor(id) {
	if (!divSet) {
		setDiv();
	}
	var picker = getObj('colorpicker');     	
	if (id == curId && picker.style.display == 'block') {
		picker.style.display = 'none';
		return;
	}
	curId = id;
	var thelink = getObj(id);
	//picker.style.zIndexhj= "100";
	picker.style.top = eval(getAbsoluteOffsetTop(thelink)+14)+"px";
	picker.style.left = eval(getAbsoluteOffsetLeft(thelink)+0)+"px";
	//alert(picker.style.top+"//"+picker.style.left);    
	picker.style.display = 'block';
}

function genColors() {
	addColorValue('0','0','0');
   	addColorValue('3','3','3');
	addColorValue('6','6','6');
	addColorValue('8','8','8');
	addColorValue('9','9','9');                
	addColorValue('A','A','A');
	addColorValue('C','C','C');
	addColorValue('E','E','E');
	addColorValue('F','F','F');
         
	for (a = 1; a < colorLevels.length; a++) addColor(0,0,a);
	for (a = 1; a < colorLevels.length - 1; a++) addColor(a,a,5);
	for (a = 1; a < colorLevels.length; a++) addColor(0,a,0);
	for (a = 1; a < colorLevels.length - 1; a++) addColor(a,5,a);
	for (a = 1; a < colorLevels.length; a++) addColor(a,0,0);
	for (a = 1; a < colorLevels.length - 1; a++) addColor(5,a,a);

	for (a = 1; a < colorLevels.length; a++) addColor(a,a,0);
	for (a = 1; a < colorLevels.length - 1; a++) addColor(5,5,a);
	for (a = 1; a < colorLevels.length; a++) addColor(0,a,a);
	for (a = 1; a < colorLevels.length - 1; a++) addColor(a,5,5);
	for (a = 1; a < colorLevels.length; a++) addColor(a,0,a);			
	for (a = 1; a < colorLevels.length - 1; a++) addColor(5,a,5);

	for (a = 1; a < colorLevels.length - 1; a++) addColor(5,5-a,0);
	addColor(2,1,0);
	for (a = 1; a < colorLevels.length - 1; a++) addColor(0,5-a,5);
	
	for (a = 1; a < colorLevels.length - 1; a++) addColor(5-a,5,0);
	addColor(3,2,0);		
	for (a = 1; a < colorLevels.length - 1; a++) addColor(5-a,0,5);
	
	for (a = 1; a < colorLevels.length - 1; a++) addColor(0,5,5-a);
	addColor(4,2,0);
	for (a = 1; a < colorLevels.length - 1; a++) addColor(5,0,5-a);

  	return colorArray;
}

function getColorTable() {
    var colors = colorArray;
 	 var tableCode = '';
    tableCode += '<table border="0" cellpadding="1" cellspacing="1">';
    for (i = 0; i < colors.length; i++) {
         if (i % perline == 0) { tableCode += '<tr>'; }
         tableCode += '<td bgcolor="#000000"><a style="outline: 1px solid #000000; color: ' 
         	  + colors[i] + '; background: ' + colors[i] + '; font-size: 10px;" title="' 
         	  + colors[i] + '" href="javascript:setColor(\'' + colors[i] + '\');">&nbsp;&nbsp;&nbsp;&nbsp;</a></td>';
         if (i % perline == perline - 1) { tableCode += '</tr>'; }
    }
    if (i % perline != 0) { tableCode += '</tr>'; }
    tableCode += '</table>';
 	 return tableCode;
}

function relateColor(id, color) {
	var link = getObj(id);
	if (color == '') {
	 	link.style.background = nocolor;
	 	link.style.color = nocolor;
	 	color = nocolor;
	}
	else {
 		link.style.background = color;
 		link.style.color = color;
	}
	eval(getObj(id + 'field').title);
}

function getAbsoluteOffsetTop(obj) {
	var top = obj.offsetTop;
	var parent = obj.offsetParent;
	while (parent) {
		top += parent.offsetTop;
		parent = parent.offsetParent;
	}
	return top;
}

function getAbsoluteOffsetLeft(obj) {
	var left = obj.offsetLeft;
	var parent = obj.offsetParent;
	while (parent) {
		left += parent.offsetLeft;
		parent = parent.offsetParent;
	}
	return left;
}