<?php
/**
* Classes des fonctions pour grer le catalogue et les commandes.
* 
* Elles sont dans deux classes pour les isoler des autres fonctions. 
* @package becmsSimpleCatalog
* @version 1.0
* @author Vincent RUIZ <webmaster@arobase.fr>
* @copyright Copyright  2007, Vincent RUIZ
* @license http://opensource.org/licenses/gpl-license.php GNU Public License 
*/
require_once("g_db.php");
$wysiwygEditor="fckeditor"; // must be set in preferences
//include("modules/".$module_name."/editors/".$wysiwygEditor."/setting.php");
if (!defined("INPAYPAL")) {
	include("javascripts/".$wysiwygEditor."/fckeditor.php");
}

		  

/**
* Classe des fonctions d'aministration du catalogue.
* 
* Cette clase contient galement les fonctions utiles (mise en forme de texte, conversion de format de date,...).
* @package becmsSimpleCatalog
*/
class adminCatalog {
/**
* @var object Classe qui donne accs au fonctions de manipulation du catalogue.
*/		
	var $sgbd;
/**
* Initialise $sgbd avec la classe des fonctions d'accs  la base de donnes du catalogue.
*/	
	function adminCatalog() {
		$this->sgbd = new BD_Catalog();
	}

/**
* Rcupre les variables envoyes par GET ou POST.
* 
* Renvoie ces variables sous la forme de paramtres d'URL.
* @param string $sauf Liste des paramtres  ne pas rcuprer.
* @return string Liste des variables rcupres.
*/	
	function getVars($sauf) {
		//global $_GET;

		$elimines = explode("|", $sauf);
		$args = "";
		$elts = array_merge($_GET,$_POST);
		if (count($elts) != 0) {
			while (list ($key, $val) = each($elts)) {
				$ok = true;
				foreach ($elimines as $elimine) {
					if ($elimine == $key) {
						$ok = false;
					}
				}
				if ($ok) {
					if ($args != "") {
						$args .= "&";
					}
					$args .= $key . "=" . stripslashes($val);
				}
			}
		}
		else {
			$args = "";
		}
		return $args;
	}

/**
* Renvoie l'indexation des rsultats  afficher par page.
* 
* @param array $criteres Tableau contenant les divers paramtres : .
* @return string Code HTML de l'index des pages  afficher.
*/	
	function getPagesIndex_old($vars_mod,$criteres,$nbreFiches,$found,$not_found) {
		print_r($vars_mod);
		print_r($criteres);
		$repParPage = $criteres["articles_par_page"];
		$p = $criteres["page_en_cours"];
		$nbrepages = ceil($nbreFiches/$repParPage);
		if ($p>$nbrepages) {
			$p = $nbrepages;
		}
		$indexPages .= "<div class=\"pages\">";
		if ($nbreFiches != 0) {
			$indexPages .= $nbreFiches.$found;
		}
		else {
			$indexPages .= $not_found;
		}
		$indexPages .= _CATALOGARTICLESPAGES;
		for ($i=1;$i<=$nbrepages;$i++) {
			if ($i == $p ) {
				$indexPages .= "<div class=\"pagevide\">";
				$indexPages .= "$i";
				$indexPages .= "</div>";
			}
			else {
				$indexPages .= "<div class=\"page\">";
				$indexPages .= "<a href=\"?"
					.$this->getVars($vars_mod["page_en_cours"]."|".$vars_mod["action"]."|designation_F|designation_E|designation_A|designation_I|designation_S|description_F|description_E|description_A|description_I|description_S|options_F|options_E|options_A|options_I|options_S|ref_article|photo|marque|tarif_ht|taux_tva|taux_solde|deb_solde|fin_solde|deb_promo|fin_promo|tarif_promo|keywords|choix|list_pays|Id|valid|valide")
					."&".$vars_mod["page_en_cours"]."=$i\">$i</a>";
				$indexPages .= "</div>";
			}
		}
		$indexPages .= "</div>";
		return $indexPages;
	}
	
	function getPagesIndex($vars_mod,$criteres,$nbreFiches,$found,$not_found) {
		$nboites = 5;
		$ligne_par_page = $criteres["articles_par_page"];
		$page = $criteres["page_en_cours"];
		
		$liminf = $page - floor($nboites/2);
		$limsup = $page + floor($nboites/2);
		if ($liminf < 1) {
			$liminf = 1;
			$limsup = $nboites;
			if ($limsup > ceil($nbreFiches/$ligne_par_page)) {
				$limsup = ceil($nbreFiches/$ligne_par_page);
			}
		}
		if ($limsup > ceil($nbreFiches/$ligne_par_page)) {
			$limsup = ceil($nbreFiches/$ligne_par_page);
			$liminf = $limsup - $nboites;
			if ($liminf < 1) {
				$liminf = 1;
			}
		}
		$min = 1;
		$max = ceil($nbreFiches/$ligne_par_page);


		$repParPage = $ligne_par_page;
		$p = $page;
		$nbrepages = ceil($nbreFiches/$repParPage);
		if ($p>$nbrepages) {
			$p = $nbrepages;
		}
		$indexPages .= "<div class=\"pages\">";
		if ($nbreFiches != 0) {
			$indexPages .= $nbreFiches.$found;
			$indexPages .= _CATALOGARTICLESPAGES;
			if ($min < $liminf) {
				if ($min == $p ) {
					$indexPages .= "<div class=\"pagevide\">";
					$indexPages .= "$min";
					$indexPages .= "</div>";
				}
				else {
					$indexPages .= "<div class=\"page\">";
					//$indexPages .= "<a href=\"system.php?op=users_newsletter_multigroup&action=list_users&page=$min"."\">$min</a>";
					$indexPages .= "<a href=\"?"
					.$this->getVars($vars_mod["page_en_cours"]."|".$vars_mod["action"]."|designation_F|designation_E|designation_A|designation_I|designation_S|description_F|description_E|description_A|description_I|description_S|options_F|options_E|options_A|options_I|options_S|ref_article|photo|marque|tarif_ht|taux_tva|taux_solde|deb_solde|fin_solde|deb_promo|fin_promo|tarif_promo|keywords|choix|list_pays|Id|valid|valide")
					."&".$vars_mod["page_en_cours"]."=$min\">$min</a>";
					
					$indexPages .= "</div>";
				}
				if ($min < $liminf - 1) {
					$indexPages .= "...";
				}
			}
			for ($i=$liminf;$i<=$limsup;$i++) {
				if ($i == $p ) {
					$indexPages .= "<div class=\"pagevide\">";
					$indexPages .= "$i";
					$indexPages .= "</div>";
				}
				else {
					$indexPages .= "<div class=\"page\">";
					//$indexPages .= "<a href=\"system.php?op=users_newsletter_multigroup&action=list_users&page=$i"."\">$i</a>";
					$indexPages .= "<a href=\"?"
					.$this->getVars($vars_mod["page_en_cours"]."|".$vars_mod["action"]."|designation_F|designation_E|designation_A|designation_I|designation_S|description_F|description_E|description_A|description_I|description_S|options_F|options_E|options_A|options_I|options_S|ref_article|photo|marque|tarif_ht|taux_tva|taux_solde|deb_solde|fin_solde|deb_promo|fin_promo|tarif_promo|keywords|choix|list_pays|Id|valid|valide")
					."&".$vars_mod["page_en_cours"]."=$i\">$i</a>";
					$indexPages .= "</div>";
				}
			}
			if ($max > $limsup) {
				if ($max > $limsup + 1) {
					$indexPages .= "...";
				}
				if ($max == $p ) {
					$indexPages .= "<div class=\"pagevide\">";
					$indexPages .= "$max";
					$indexPages .= "</div>";
				}
				else {
					$indexPages .= "<div class=\"page\">";
					//$indexPages .= "<a href=\"system.php?op=users_newsletter_multigroup&action=list_users&page=$max"."\">$max</a>";
					$indexPages .= "<a href=\"?"
					.$this->getVars($vars_mod["page_en_cours"]."|".$vars_mod["action"]."|designation_F|designation_E|designation_A|designation_I|designation_S|description_F|description_E|description_A|description_I|description_S|options_F|options_E|options_A|options_I|options_S|ref_article|photo|marque|tarif_ht|taux_tva|taux_solde|deb_solde|fin_solde|deb_promo|fin_promo|tarif_promo|keywords|choix|list_pays|Id|valid|valide")
					."&".$vars_mod["page_en_cours"]."=$max\">$max</a>";
					$indexPages .= "</div>";
				}

			}
		}
		else {
			$indexPages .= $not_found;
		}
		$indexPages .= "</div>";
		return $indexPages;
	}
	
/**
* Renvoie l'article dsign.
* 
* Si l'article est introuvable ou que son identifiant est -1, un article vide est retourn.
* @param array $My_SQL Paramtres de la base de donnes.
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
* @return array Tableau contenant l'article.
*/	
	function get_article_edit($My_SQL,$vars_mod) {
		if ($vars_mod[$vars_mod["id_article"]] != "-1") {
			$articlesEdit = $this->sgbd->getArticles($My_SQL,$vars_mod[$vars_mod["id_article"]],"");
			if (count($articlesEdit) == 0) {
				$ArticleEdit = array("Id"=>"", "ref_article"=>"", "photo"=>"","marque"=>"", "designation_F"=>"", "designation_E"=>"", "designation_A"=>"", "designation_I"=>"", "designation_S"=>"", "description_F"=>"", "description_E"=>"", "description_A"=>"", "description_I"=>"", "description_S"=>"", "conditionnement_F"=>"", "conditionnement_E"=>"", "conditionnement_A"=>"", "conditionnement_I"=>"", "conditionnement_S"=>"", "tarif_ht"=>"", "taux_tva"=>"", "tarif_promo"=>"", "taux_solde"=>"", "deb_promo"=>"", "fin_promo"=>"", "deb_solde"=>"", "fin_solde"=>"", "valide"=>"");
			}
			else {
				$ArticleEdit = $articlesEdit[0];
			}
		}
		else {
			$ArticleEdit = array("Id"=>"", "ref_article"=>"", "photo"=>"","marque"=>"", "designation_F"=>"", "designation_E"=>"", "designation_A"=>"", "designation_I"=>"", "designation_S"=>"", "description_F"=>"", "description_E"=>"", "description_A"=>"", "description_I"=>"", "description_S"=>"", "conditionnement_F"=>"", "conditionnement_E"=>"", "conditionnement_A"=>"", "conditionnement_I"=>"", "conditionnement_S"=>"", "tarif_ht"=>"", "taux_tva"=>"", "tarif_promo"=>"", "taux_solde"=>"", "deb_promo"=>"", "fin_promo"=>"", "deb_solde"=>"", "fin_solde"=>"", "valide"=>"");
		}
		return $ArticleEdit;
	}

/**
* Renvoie le formulaire de cration d'un nouvel article dans le catalogue.
* @param array $My_SQL Paramtres de la base de donnes.
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
* @return string Formulaire HTML du nouvel article.
*/	
		
	function new_article($My_SQL,$vars_mod,$criteres,$seps) {
		global $header_system;
		
		$header_system = '
<script src="'.$vars_mod["cheminModule"].'lib/lib_AJAX.js" type="text/javascript"></script>
<script src="'.$vars_mod["cheminModule"].'lib/lib_XML_parser.js" type="text/javascript"></script>	
<script type="text/javascript" src="javascripts/windows_js/javascripts/prototype.js"></script>
<script type="text/javascript" src="javascripts/windows_js/javascripts/effects.js"></script>
<script type="text/javascript" src="javascripts/windows_js/javascripts/window.js"></script>
<script type="text/javascript" src="javascripts/windows_js/javascripts/window_ext.js"></script>
<script type="text/javascript" src="javascripts/windows_js/javascripts/debug.js"></script>
<link href="javascripts/windows_js/themes/default.css" rel="stylesheet" type="text/css" />
<link href="javascripts/windows_js/themes/becms_alphacube.css" rel="stylesheet" type="text/css" />
<script type="text/javascript">
	var win=null;
	function ouvre_dialogue(titre,url,width) {
		win = new Window({className: "becms_alphacube", title: titre, width:width, height:400, destroyOnClose: true, recenterAuto:true, url: url, minimizable: false, maximizable: false});
		win.showCenter(true);
	}
	function addTarif(Id, tarif_ht, tarif_promo, taux_solde, deb_promo,fin_promo, seuil) {
		var btns = \'<a href="system.php?op=catalog&act=edit_tarif&Id=\' + Id + \'" title="Modification d\\\'un tarif" onclick="ouvre_dialogue(this.title, this.href, 800); return false"><img src="system/skins/joomla/edit_16x16.png" /></a>\';
		btns += \'&nbsp;<a href="#"><img src="system/skins/joomla/delete_16x16.png" /></a>\';
		var nouveau_prix = "<tr id=\'" + Id + "\'><td>" + tarif_ht + "</td><td>" + taux_solde + "</td><td>" + tarif_promo + "</td><td>" + deb_promo + "</td><td>" + fin_promo + "</td><td>" + seuil + "</td><td>" + btns + "</td></tr>";
		var zTarifs = document.getElementById("allprix");
		var contenu = zTarifs.innerHTML;
		if (contenu == "") {
			contenu = "<table><tr><th>Prix H.T.</th><th>% solde</th><th>Prix promo</th><th>Dbut promo</th><th>Fin promo</th><th>Seuil d\'application</th><th>Actions</th></tr>" + nouveau_prix + "</table>";
		}
		else {
			contenu = contenu.replace("</table>", nouveau_prix + "</table>");
		}
		zTarifs.innerHTML = contenu;
	}
	function updateTarif() {
		var listeTarifs = "";
		var lesTarifsSTR = GetAJAXData("system.php?op=catalog&act=tarifsXML&id_produit='.$vars_mod[$vars_mod["id_article"]].'");
		var lesTarifsXML = getXMLroot(lesTarifsSTR);
		var racine_tarifs = getXMLchild(lesTarifsXML,"tarifs");
		if (racine_tarifs != null) {
			var tarif = getXMLchild(racine_tarifs,"tarif");
			while (tarif) {
				var Id = getXMLvalue(tarif,"Id");
				var tarif_ht = getXMLvalue(tarif,"tarif_ht");
				var tarif_promo = getXMLvalue(tarif,"tarif_promo");
				var deb_promo = getXMLvalue(tarif,"deb_promo");
				var fin_promo = getXMLvalue(tarif,"fin_promo");
				var taux_solde = getXMLvalue(tarif,"taux_solde");
				var seuil = getXMLvalue(tarif,"seuil");
				var btns = \'<a href="system.php?op=catalog&act=edit_tarif&Id=\' + Id + \'" title="Modification d\\\'un tarif" onclick="ouvre_dialogue(this.title, this.href, 800); return false"><img src="system/skins/joomla/edit_16x16.png" /></a>\';
				btns += \' &nbsp;<a href="#" onclick="deleteTarif(\' + Id + \'); return false"><img src="system/skins/joomla/delete_16x16.png"></a>\';
				listeTarifs += "<tr id=\'" + Id + "\'><td>" + tarif_ht + "</td><td>" + taux_solde + "</td><td>" + tarif_promo + "</td><td>" + deb_promo + "</td><td>" + fin_promo + "</td><td>" + seuil + "</td><td>" + btns + "</td></tr>";
				tarif = next_sibling(tarif);
			}
		}
		if (listeTarifs != "") {
			var contenu = "<table><tr><th>Prix H.T.</th><th>% solde</th><th>Prix promo</th><th>Dbut promo</th><th>Fin promo</th><th>Seuil d\'application</th><th>Actions</th></tr>" + listeTarifs + "</table>";
		}
		else {
			var contenu = "";
		}
		var zTarifs = document.getElementById("allprix");
		zTarifs.innerHTML = contenu;
	}
	function deleteTarif(Id) {
		if (confirm("tes-vous sr(e) de vouloir supprimer ce tarif ?")) {
			GetAJAXData("system.php?op=catalog&act=delete_tarif&Id="+Id);
		}
		updateTarif();
	}
</script>
';
		//$ClientEdit = array("Id"=>"-1","nom"=>"","prenom"=>"","adresse"=>"","codepostal"=>"","ville"=>"","pays"=>"","tel"=>"","fax"=>"","portable"=>"","email"=>"","services"=>"","codeclient"=>"","valide"=>"","divers"=>"");
		$checked = " checked=\"checked\"";
		$srcphoto = $vars_mod["cheminModule"]."lib/icns/nophoto.gif";
		$var_en_plus = "";
		if ($criteres["page_en_cours"] != "1") {
			$var_en_plus .= "&".$vars_mod["page_en_cours"]."=".$criteres["page_en_cours"];
		}
		if ($vars_mod[$vars_mod["tri"]] != "") {
			$var_en_plus .= '&'.$vars_mod["tri"].'='.$vars_mod[$vars_mod["tri"]];
		}
		$checked = "";
		$list_pays_select = explode($seps["sep_valeur"], array());//pourra servir pour les pays attribus par dfaut
		$pays = $this->sgbd->getPays($My_SQL,"_F");
		$list_pays = '<select name="list_pays[]" multiple="multiple" size="10" class="saisie_long2">';
		foreach($pays as $unpays) {
			if (in_array($unpays["code"],$list_pays_select)){
				$selected = ' selected="selected"';
			}
			else {
				$selected = "";
			}
			$list_pays .= '<option value="'.$unpays["code"].'"'.$selected.'>'.$unpays["pays_F"].'</option>';
		}
		$list_pays .= '</select>';
		
		$tabtarif = '';
		$tarifs = $this->sgbd->getTarif($My_SQL,"","-1");
		foreach($tarifs as $untarif) {
			$actions = '<a href="system.php?op=catalog&act=edit_tarif&Id='.$untarif["Id"].'" title="Modification d\'un tarif" onclick="ouvre_dialogue(this.title, this.href, 800); return false"><img src="system/skins/joomla/edit_16x16.png" /></a>
						&nbsp;<a href="#" onclick="deleteTarif('.$untarif["Id"].'); return false"><img src="system/skins/joomla/delete_16x16.png" /></a>';
			$tabtarif .= '<tr id="'.$untarif["Id"].'"><td>'.$untarif["tarif_ht"].'</td><td>'.$untarif["taux_solde"].'</td><td>'.$untarif["tarif_promo"].'</td><td>'.$this->date2JMA($untarif["deb_promo"]).'</td><td>'.$this->date2JMA($untarif["fin_promo"]).'</td><td>'.$untarif["seuil"].'</td><td>'.$actions.'</td></tr>';
		}
		if ($tabtarif != "") {
			$tabtarif = '<table><tr><th>Prix H.T.</th><th>% solde</th><th>Prix promo</th><th>Dbut promo</th><th>Fin promo</th><th>Seuil d\'application</th><th>Actions</th></tr>'.$tabtarif.'</table>';
		}
		
		$formedit = '
		<div align="center">&nbsp;<br />
		<fieldset class="article"><legend>'._ARTICLEFILE.'</legend>
		<form name="form1" action="system.php?op=catalog&onglet=article&'.$vars_mod["action"].'=save_new'.$var_en_plus.'" method="post" onsubmit="return verif_new_article(this);" enctype="multipart/form-data">
		<script type="text/javascript" src="javascripts/fckeditor/fckeditor.js"></script>
		<script type="text/javascript" src="javascripts/initfck.js"></script>
		<table border="0" cellpadding="0" cellspacing="0"><tr>
		<td valign="top">
		<img src="'.$srcphoto.'" class="illustration" ></td>
		<td width="20"></td>
		<td valign="top">
		<div class="boite_article">
		<ul class="menulangue">
			<li id="menuF" style="font-weight: bold"><a href="#" onclick="view_cat_lang(\'F\');return false;">Francais </a></li>
			<li id="menuE" style="font-weight: normal"><a href="#" onclick="view_cat_lang(\'E\');return false;">Anglais </a></li>
			<li id="menuA" style="font-weight: normal"><a href="#" onclick="view_cat_lang(\'A\');return false;">Allemand </a></li>
			<li id="menuI" style="font-weight: normal"><a href="#" onclick="view_cat_lang(\'I\');return false;">Italien </a></li>
			<li id="menuS" style="font-weight: normal"><a href="#" onclick="view_cat_lang(\'S\');return false;">Espagnol </a></li>
		</ul>
		<div style="clear: both"></div>

		<div id="viewF">
			<table class="saisiecatalog" border="0" cellspacing="2" cellpadding="0">
				<tr>
					<td class="col1">'._ARTICLEDESIGN.'</td>
					<td width="10"></td>
					<td><input class="saisie_long_lang" type="text" name="designation_F" size="42"></td>
				</tr>
				<tr>
					<td class="col1">Conditionnement</td>
					<td width="10"></td>
					<td><input class="saisie_long_lang" type="text" name="conditionnement_F" size="42"></td>
				</tr>
				<tr>
					<td class="col1">'._ARTICLEDESCRIP.'</td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
					<textarea id="description_F" style="color:#FFFFFF" class="saisie_long_lang" name="description_F" rows="6" cols="40"></textarea>
					<script type="text/javascript">editFour(\'description_F\');</script>
					</td>
				</tr>
				<tr>
					<td class="col1">'._ARTICLEOPTIONS.'</td>
					<td width="10"></td>
					<td><textarea class="saisie_long_lang" name="options_F" rows="4" cols="40"></textarea></td>
				</tr>
			</table>
		</div>
		<div id="viewE" style="display: none;">
			<table class="saisiecatalog" border="0" cellspacing="2" cellpadding="0">
				<tr>
					<td class="col1">'._ARTICLEDESIGN.'</td>
					<td width="10"></td>
					<td><input class="saisie_long_lang" type="text" name="designation_E" size="42"></td>
				</tr>
				<tr>
					<td class="col1">Conditionnement</td>
					<td width="10"></td>
					<td><input class="saisie_long_lang" type="text" name="conditionnement_E" size="42"></td>
				</tr>
				<tr>
					<td class="col1">'._ARTICLEDESCRIP.'</td>
					<td width="10"></td>
					<td class="saisie_long_lang2"><textarea id="description_E" style="width: 478px" class="saisie_long_lang" name="description_E" rows="6" cols="40"></textarea></td>
					<script type="text/javascript">editFour(\'description_E\');</script>
					</tr>
				<tr>
					<td class="col1">'._ARTICLEOPTIONS.'</td>
					<td width="10"></td>
					<td><textarea class="saisie_long_lang" name="options_E" rows="4" cols="40"></textarea></td>
				</tr>
			</table>
		</div>
		<div id="viewA" style="display: none;">
			<table class="saisiecatalog" border="0" cellspacing="2" cellpadding="0">
				<tr>
					<td class="col1">'._ARTICLEDESIGN.'</td>
					<td width="10"></td>
					<td><input class="saisie_long_lang" type="text" name="designation_A" size="42"></td>
				</tr>
				<tr>
					<td class="col1">Conditionnement</td>
					<td width="10"></td>
					<td><input class="saisie_long_lang" type="text" name="conditionnement_A" size="42"></td>
				</tr>
				<tr>
					<td class="col1">'._ARTICLEDESCRIP.'</td>
					<td width="10"></td>
					<td class="saisie_long_lang2"><textarea id="description_A" style="width: 480px" class="saisie_long_lang" name="description_A" rows="6" cols="40"></textarea></td>
					<script type="text/javascript">editFour(\'description_A\');</script>
					</tr>
				<tr>
					<td class="col1">'._ARTICLEOPTIONS.'</td>
					<td width="10"></td>
					<td><textarea class="saisie_long_lang" name="options_A" rows="4" cols="40"></textarea></td>
				</tr>
			</table>
		</div>
		<div id="viewI" style="display: none;">
			<table class="saisiecatalog" border="0" cellspacing="2" cellpadding="0">
				<tr>
					<td class="col1">'._ARTICLEDESIGN.'</td>
					<td width="10"></td>
					<td><input class="saisie_long_lang" type="text" name="designation_I" size="42"></td>
				</tr>
				<tr>
					<td class="col1">Conditionnement</td>
					<td width="10"></td>
					<td><input class="saisie_long_lang" type="text" name="conditionnement_I" size="42"></td>
				</tr>
				<tr>
					<td class="col1">'._ARTICLEDESCRIP.'</td>
					<td width="10"></td>
					<td class="saisie_long_lang2"><textarea id="description_I" style="width: 480px" class="saisie_long_lang" name="description_I" rows="6" cols="40"></textarea></td>
					<script type="text/javascript">editFour(\'description_I\');</script>
					</tr>
				<tr>
					<td class="col1">'._ARTICLEOPTIONS.'</td>
					<td width="10"></td>
					<td><textarea class="saisie_long_lang" name="options_I" rows="4" cols="40"></textarea></td>
				</tr>
			</table>
		</div>
		<div id="viewS" style="display: none;">
			<table class="saisiecatalog" border="0" cellspacing="2" cellpadding="0">
				<tr>
					<td class="col1">'._ARTICLEDESIGN.'</td>
					<td width="10"></td>
					<td><input class="saisie_long_lang" type="text" name="designation_S" size="42"></td>
				</tr>
				<tr>
					<td class="col1">Conditionnement</td>
					<td width="10"></td>
					<td><input class="saisie_long_lang" type="text" name="conditionnement_S" size="42"></td>
				</tr>
				<tr>
					<td class="col1">'._ARTICLEDESCRIP.'</td>
					<td width="10"></td>
					<td class="saisie_long_lang2"><textarea id="description_S" style="width: 480px" class="saisie_long_lang" name="description_S" rows="6" cols="40"></textarea></td>
					<script type="text/javascript">editFour(\'description_S\');</script>
					</tr>
				<tr>
					<td class="col1">'._ARTICLEOPTIONS.'</td>
					<td width="10"></td>
					<td><textarea class="saisie_long_lang" name="options_S" rows="4" cols="40"></textarea></td>
				</tr>
			</table>
		</div>
		<table class="saisiecatalog" border="0" cellspacing="2" cellpadding="0">
			<tr>
				<td class="col1">'._ARTICLEREFERENCE.'</td>
				<td width="10"></td>
				<td><input class="saisie_long" type="text" name="ref_article" size="16"></td>
			</tr>			
			<tr>
				<td class="col1">'._ARTICLEPHOTO.'</td>
				<td width="10"></td>
				<td><input type="file" name="photo" size="16" class="saisie_long_fic"></td>
			</tr>
			<tr>
				<td class="col1">'._ARTICLEMARQUE.'</td>
				<td width="10"></td>
				<td><input class="saisie_long" type="text" name="marque" size="24"></td>
			</tr>
			<tr>
				<td class="col1">'._ARTICLEDISPO.'</td>
				<td width="10"></td>
				<td><input type="checkbox" name="valide" value="1"'.$checked.'></td>
			</tr>
			<tr>
				<td>'._ARTICLETAUXTVA.'</td>
				<td width="10"></td>
				<td><input class="saisie_long" type="text" name="taux_tva" size="24" value="'.$vars_mod["tva_def"].'"></td>
			</tr>
		</table>
		<table class="saisiecatalog" border="0" cellspacing="2" cellpadding="0" style="width: 100%">
				<tr>
					<td>Tarifs applicables : <a href="system.php?op=catalog&act=edit_tarif&Id=-1&id_produit='.$ArticleEdit["Id"].'" title="Ajout d\'un nouveau tarif" onclick="ouvre_dialogue(this.title, this.href, 800); return false"><img src="images/netvibes.gif" alt="Ajout tarif" align="absmiddle" /></a>
<div id="allprix">'.$tabtarif.'</div></td>
				</tr>
			</table>
			<table class="saisiecatalog" border="0" cellspacing="2" cellpadding="0">
			<!--<tr>
				<td class="col1">'._ARTICLETARIF.'</td>
				<td width="10"></td>
				<td><input class="saisie_court" type="text" name="tarif_ht" size="24"></td>
				<td width="10"></td>
				<td>'._ARTICLETAUXTVA.'</td>
				<td width="10"></td>
				<td><input class="saisie_court" type="text" name="taux_tva" size="24"></td>
				<td width="10"></td>
				<td>'._ARTICLETAUXSOLDE.'</td>
				<td width="10"></td>
				<td><input class="saisie_court" type="text" name="taux_solde" size="24"><input type="hidden" name="deb_solde"><input type="hidden" name="fin_solde"></td>
			</tr>-->
			<!--<tr>
				<td>'._ARTICLEDEBSOLDE.'</td>
				<td width="10"></td>
				<td><input class="saisie_court" type="text" name="deb_solde" size="24" onfocus="showPopUpCal(this)"></td>
				<td width="10"></td>
				<td>'._ARTICLEFINSOLDE.'</td>
				<td width="10"></td>
				<td><input class="saisie_court" type="text" name="fin_solde" size="24" onfocus="showPopUpCal(this)"></td>
				<td width="10"></td>
				<td>'._ARTICLETAUXSOLDE.'</td>
				<td width="10"></td>
				<td><input class="saisie_court" type="text" name="taux_solde" size="24"></td>
			</tr>-->
			<!--<tr>
				<td class="col1">'._ARTICLEDEBPROMO.'</td>
				<td width="10"></td>
				<td><input class="saisie_court" type="text" name="deb_promo" size="24" onfocus="showPopUpCal(this)"></td>
				<td width="10"></td>
				<td>'._ARTICLEFINPROMO.'</td>
				<td width="10"></td>
				<td><input class="saisie_court" type="text" name="fin_promo" size="24" onfocus="showPopUpCal(this)"></td>
				<td width="10"></td>
				<td>'._ARTICLEPRIXPROMO.'</td>
				<td width="10"></td>
				<td><input class="saisie_court" type="text" name="tarif_promo" size="24"></td>
			</tr>-->
			<tr><td>&nbsp;</td></tr>
		</table>
			<table class="saisiecatalog" border="0" cellspacing="2" cellpadding="0">
				<tr>
					<td align="center">'._ARTICLECATEGORIES.'</td>
					<td width="20"></td>
					<td align="center">'._ARTICLEALLCATEGORIES.'</td>
					<td align="center">'._ARTICLEARBOCATEGORIES.'</td>
				</tr>
				<tr height="200">
					<td height="200">'.$this->get_my_categories($My_SQL,"-1").'</td>
					<td width="20"><img src="'.$vars_mod["cheminModule"].'lib/icns/flecheG.gif" alt="" border="0" /></td>
					<td height="200">'.$this->get_list_categories($My_SQL).'</td>
					<td height="200"><div class="zoneArbo">'.$this->tree_open($My_SQL,$vars_mod).'</div></td>
				</tr>
			</table>
			<table class="saisiecatalog" border="0" cellspacing="2" cellpadding="0">
				<tr><td align="center">'._ARTICLEPAYSLIVRE.'</td></tr>
				<tr><td align="center">'.$list_pays.'</td></tr>
			</table>
		</div></td>
		</tr></table>
		<div align="center">&nbsp;<br /><input type="hidden" value="-1" name="'.$vars_mod["id_article"].'"><input type="submit" name="valid" value="'._ARTICLESAVEEDIT.'"></div>
		</form>
		</fieldset>
		</div>
<script src="'.$vars_mod["cheminModule"].'lib/lib_autostart.js" type="text/javascript"></script>
<link href="'.$vars_mod["cheminModule"].'lib/style-calendar.css" rel="stylesheet" type="text/css" media="all" />
<script src="'.$vars_mod["cheminModule"].'lib/lib_cal.js" type="text/javascript"></script>
<script type="text/javascript">
 //<![CDATA[
	function validMail(email) {
		if (email == "") {
			return(true);
		}
		else {
			if ((email.indexOf("@") == -1) || (email.indexOf("@") == 0) || (email.indexOf("@") != email.lastIndexOf("@")) || (email.indexOf(".") == email.indexOf("@")-1) || (email.indexOf(".") == email.indexOf("@") + 1) || (email.indexOf("@") == email.length -1) || (email.indexOf (".") == -1) || (email.lastIndexOf (".") == email.length -1) || (email.indexOf (";") != -1) || (email.indexOf (" ") != -1)) {
				return(false);
			}
			else return(true);
		}
	}
	function getfield(idzone) {        
       	var FCKGetInstance = FCKeditorAPI.GetInstance(idzone);  
        var getText = FCKGetInstance.GetData(); 
        var StripTag = getText.replace(/(<([^>]+)>)/ig,"");
        return StripTag; 
    }
	function verif_new_article(formulaire) {
		if (formulaire.photo.value == "") {
			if (!confirm("'._ARTICLEVERIFPHOTO.'")) {
				return false;
			}
		}
		if (formulaire.photo.value != "") {
			var reg=new RegExp("^([a-zA-Z0-9\-_\.])+[\.]{1}(gif|jpg|jpeg|png){1}$","g");
			var nomphoto0 = 	formulaire.photo.value;	
			var tabnomphoto1 = nomphoto0.split("\\\\");
			var nomphoto1 = tabnomphoto1[tabnomphoto1.length - 1];
			var tabnomphoto2 = nomphoto1.split("/");
			var nomphoto2 = tabnomphoto2[tabnomphoto2.length - 1];
			if (!reg.test(nomphoto2)) {
				alert(nomphoto2 + "\n'._ARTICLEVERIFBADNAMEPHOTO.'");
				return false;
			}
		}
		if (formulaire.keywords.value == "") {
			if (!confirm("'._ARTICLEVERIFCATEGORIE.'")) {
				return false;
			}
		}
		if ((formulaire.designation_F.value + formulaire.designation_E.value + formulaire.designation_A.value + formulaire.designation_I.value + formulaire.designation_S.value) == "") {
			alert("'._ARTICLEVERIFDESIGN.'");
			return false;
		}
		if ((getfield("description_F") + getfield("description_E") + getfield("description_A") + getfield("description_I") + getfield("description_S")) == "") {
			alert("'._ARTICLEVERIFDESCRIP.'");
			return false;
		}
		return true;
	}
	function view_cat_lang(lang) {
		var ie = false;
		if (document.all) {
			ie = true;
		}
		if (ie) {
			var obj = document.all["viewF"];
			obj.style.display = "none";
			obj = document.all["viewE"];
			obj.style.display = "none";
			obj = document.all["viewI"];
			obj.style.display = "none";
			obj = document.all["viewA"];
			obj.style.display = "none";
			obj = document.all["viewS"];
			obj.style.display = "none";
			obj = document.all["view"+lang];
			obj.style.display = "block";
			obj = document.all["menuF"];
			obj.style.fontWeight = "normal";
			obj = document.all["menuE"];
			obj.style.fontWeight = "normal";
			obj = document.all["menuI"];
			obj.style.fontWeight = "normal";
			obj = document.all["menuA"];
			obj.style.fontWeight = "normal";
			obj = document.all["menuS"];
			obj.style.fontWeight = "normal";
			obj = document.all["menu"+lang];
			obj.style.fontWeight = "bold";
		}
		else {
			var obj = document.getElementById("viewF");
			obj.style.display = "none";
			obj = document.getElementById("viewE");
			obj.style.display = "none";
			obj = document.getElementById("viewI");
			obj.style.display = "none";
			obj = document.getElementById("viewA");
			obj.style.display = "none";
			obj = document.getElementById("viewS");
			obj.style.display = "none";
			obj = document.getElementById("view"+lang);
			obj.style.display = "block";
			obj = document.getElementById("menuF");
			obj.style.fontWeight = "normal";
			obj = document.getElementById("menuE");
			obj.style.fontWeight = "normal";
			obj = document.getElementById("menuI");
			obj.style.fontWeight = "normal";
			obj = document.getElementById("menuA");
			obj.style.fontWeight = "normal";
			obj = document.getElementById("menuS");
			obj.style.fontWeight = "normal";
			obj = document.getElementById("menu"+lang);
			obj.style.fontWeight = "bold";
		}
		return true;
	}
	
	function affiche() {
		var reg = new RegExp("\n([ \f\n\r\t\v])*\n","g");
		var montexte = document.form1.keywords.value;
		montexte = montexte.replace(reg,"\n");
		document.form1.keywords.value = montexte;
		ok = true;
		
		if (document.form1.keywords.value == "") {
			alert("Vous n\'avez saisi aucun mot clef. Ils sont obligatoires");
			ok = false;
		}
		if (document.form1.orientation.value == ""){
			alert("Il faut saisir l\'orientation de la photo.");
			ok = false;
		}
		if (ok){
			document.form1.submit();
		}	
	}
	function ajoutmc() {
		if (document.form1.keywords.value == "") {
			document.form1.keywords.value = document.form1.choix.value;
		}
		else {
			document.form1.keywords.value = document.form1.keywords.value + "\n" + document.form1.choix.value;
		}
	}
	function ajoutmctree(mot) {
		if (document.form1.keywords.value == "") {
			document.form1.keywords.value = mot;
		}
		else {
			document.form1.keywords.value += "\n" + mot;
		}
	}
	
    //]]>
</script>
<script type="text/javascript">
		addToStart("view_cat_lang(\'F\')");
		addToStart(newPopUpCal);
		</script>';
		return $formedit;
	}
	
/**
* Renvoie le formulaire de modifification d'un article dans le catalogue.
* @param array $My_SQL Paramtres de la base de donnes.
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
* @return string Formulaire HTML de l'article.
*/
	function edit_article($My_SQL,$vars_mod,$criteres,$seps) {
		global $header_system;
		
		$header_system = '
<script src="'.$vars_mod["cheminModule"].'lib/lib_AJAX.js" type="text/javascript"></script>
<script src="'.$vars_mod["cheminModule"].'lib/lib_XML_parser.js" type="text/javascript"></script>	
<script type="text/javascript" src="javascripts/windows_js/javascripts/prototype.js"></script>
<script type="text/javascript" src="javascripts/windows_js/javascripts/effects.js"></script>
<script type="text/javascript" src="javascripts/windows_js/javascripts/window.js"></script>
<script type="text/javascript" src="javascripts/windows_js/javascripts/window_ext.js"></script>
<script type="text/javascript" src="javascripts/windows_js/javascripts/debug.js"></script>
<link href="javascripts/windows_js/themes/default.css" rel="stylesheet" type="text/css" />
<link href="javascripts/windows_js/themes/becms_alphacube.css" rel="stylesheet" type="text/css" />
<script type="text/javascript">
	var win=null;
	function ouvre_dialogue(titre,url,width) {
		win = new Window({className: "becms_alphacube", title: titre, width:width, height:400, destroyOnClose: true, recenterAuto:true, url: url, minimizable: false, maximizable: false});
		win.showCenter(true);
	}
	function addTarif(Id, tarif_ht, tarif_promo, taux_solde, deb_promo,fin_promo, seuil) {
		var btns = \'<a href="system.php?op=catalog&act=edit_tarif&Id=\' + Id + \'" title="Modification d\\\'un tarif" onclick="ouvre_dialogue(this.title, this.href, 800); return false"><img src="system/skins/joomla/edit_16x16.png" /></a>\';
		btns += \'&nbsp;<a href="#"><img src="system/skins/joomla/delete_16x16.png" /></a>\';
		var nouveau_prix = "<tr id=\'" + Id + "\'><td>" + tarif_ht + "</td><td>" + taux_solde + "</td><td>" + tarif_promo + "</td><td>" + deb_promo + "</td><td>" + fin_promo + "</td><td>" + seuil + "</td><td>" + btns + "</td></tr>";
		var zTarifs = document.getElementById("allprix");
		var contenu = zTarifs.innerHTML;
		if (contenu == "") {
			contenu = "<table><tr><th>Prix H.T.</th><th>% solde</th><th>Prix promo</th><th>Dbut promo</th><th>Fin promo</th><th>Seuil d\'application</th><th>Actions</th></tr>" + nouveau_prix + "</table>";
		}
		else {
			contenu = contenu.replace("</table>", nouveau_prix + "</table>");
		}
		zTarifs.innerHTML = contenu;
	}
	function updateTarif() {
		var listeTarifs = "";
		var lesTarifsSTR = GetAJAXData("system.php?op=catalog&act=tarifsXML&id_produit='.$vars_mod[$vars_mod["id_article"]].'");
		var lesTarifsXML = getXMLroot(lesTarifsSTR);
		var racine_tarifs = getXMLchild(lesTarifsXML,"tarifs");
		if (racine_tarifs != null) {
			var tarif = getXMLchild(racine_tarifs,"tarif");
			while (tarif) {
				var Id = getXMLvalue(tarif,"Id");
				var tarif_ht = getXMLvalue(tarif,"tarif_ht");
				var tarif_promo = getXMLvalue(tarif,"tarif_promo");
				var deb_promo = getXMLvalue(tarif,"deb_promo");
				var fin_promo = getXMLvalue(tarif,"fin_promo");
				var taux_solde = getXMLvalue(tarif,"taux_solde");
				var seuil = getXMLvalue(tarif,"seuil");
				var btns = \'<a href="system.php?op=catalog&act=edit_tarif&Id=\' + Id + \'" title="Modification d\\\'un tarif" onclick="ouvre_dialogue(this.title, this.href, 800); return false"><img src="system/skins/joomla/edit_16x16.png" /></a>\';
				btns += \' &nbsp;<a href="#" onclick="deleteTarif(\' + Id + \'); return false"><img src="system/skins/joomla/delete_16x16.png"></a>\';
				listeTarifs += "<tr id=\'" + Id + "\'><td>" + tarif_ht + "</td><td>" + taux_solde + "</td><td>" + tarif_promo + "</td><td>" + deb_promo + "</td><td>" + fin_promo + "</td><td>" + seuil + "</td><td>" + btns + "</td></tr>";
				tarif = next_sibling(tarif);
			}
		}
		if (listeTarifs != "") {
			var contenu = "<table><tr><th>Prix H.T.</th><th>% solde</th><th>Prix promo</th><th>Dbut promo</th><th>Fin promo</th><th>Seuil d\'application</th><th>Actions</th></tr>" + listeTarifs + "</table>";
		}
		else {
			var contenu = "";
		}
		var zTarifs = document.getElementById("allprix");
		zTarifs.innerHTML = contenu;
	}
	function deleteTarif(Id) {
		if (confirm("tes-vous sr(e) de vouloir supprimer ce tarif ?")) {
			GetAJAXData("system.php?op=catalog&act=delete_tarif&Id="+Id);
		}
		updateTarif();
	}
</script>
';
		
		//$ClientEdit = array("Id"=>"-1","nom"=>"","prenom"=>"","adresse"=>"","codepostal"=>"","ville"=>"","pays"=>"","tel"=>"","fax"=>"","portable"=>"","email"=>"","services"=>"","codeclient"=>"","valide"=>"","divers"=>"");
		$checked = "";
		if ($vars_mod[$vars_mod["id_article"]] != "-1") {
			$ArticleEdit = $this->get_article_edit($My_SQL,$vars_mod);
			if ($ArticleEdit["valide"] == "1") {
				$checked = " checked=\"checked\"";
			}
			else {
				$checked = "";
			}
		}
		else {
			$ArticleEdit = $vars_mod;
		}
		if ($ArticleEdit["photo"] == "") {
			//$ArticleEdit["photo"] = "nophoto.gif";
			$srcphoto = $vars_mod["cheminModule"]."lib/icns/nophoto.gif";
		}
		else {
			$srcphoto = $vars_mod["cheminPhotos"].'/'.$ArticleEdit["photo"];
		}
		$var_en_plus = "";
		if ($criteres["page_en_cours"] != "1") {
			$var_en_plus .= "&".$vars_mod["page_en_cours"]."=".$criteres["page_en_cours"];
		}
		if ($vars_mod[$vars_mod["tri"]] != "") {
			$var_en_plus .= '&'.$vars_mod["tri"].'='.$vars_mod[$vars_mod["tri"]];
		}
		$list_pays_select = explode($seps["sep_valeur"], $ArticleEdit["list_pays"]);
		$pays = $this->sgbd->getPays($My_SQL,"_F");
		$list_pays = '<select name="list_pays[]" multiple="multiple" size="10" class="saisie_long2">';
		foreach($pays as $unpays) {
			if (in_array($unpays["code"],$list_pays_select)){
				$selected = ' selected="selected"';
			}
			else {
				$selected = "";
			}
			$list_pays .= '<option value="'.$unpays["code"].'"'.$selected.'>'.$unpays["pays_F"].'</option>';
		}
		$list_pays .= '</select>';
		
		$tabtarif = '';
		$tarifs = $this->sgbd->getTarif($My_SQL,"",$vars_mod[$vars_mod["id_article"]]);
		foreach($tarifs as $untarif) {
			$actions = '<a href="system.php?op=catalog&act=edit_tarif&Id='.$untarif["Id"].'" title="Modification d\'un tarif" onclick="ouvre_dialogue(this.title, this.href, 800); return false"><img src="system/skins/joomla/edit_16x16.png" /></a>
						&nbsp;<a href="#" onclick="deleteTarif('.$untarif["Id"].'); return false"><img src="system/skins/joomla/delete_16x16.png" /></a>';
			$tabtarif .= '<tr id="'.$untarif["Id"].'"><td>'.$untarif["tarif_ht"].'</td><td>'.$untarif["taux_solde"].'</td><td>'.$untarif["tarif_promo"].'</td><td>'.$this->date2JMA($untarif["deb_promo"]).'</td><td>'.$this->date2JMA($untarif["fin_promo"]).'</td><td>'.$untarif["seuil"].'</td><td>'.$actions.'</td></tr>';
		}
		if ($tabtarif != "") {
			$tabtarif = '<table><tr><th>Prix H.T.</th><th>% solde</th><th>Prix promo</th><th>Dbut promo</th><th>Fin promo</th><th>Seuil d\'application</th><th>Actions</th></tr>'.$tabtarif.'</table>';
		}
		
		$formedit = '
		<div align="center">&nbsp;<br />
		<fieldset class="article"><legend>'._ARTICLEFILE.'</legend>
		<script type="text/javascript" src="javascripts/fckeditor/fckeditor.js"></script>
		<script type="text/javascript" src="javascripts/initfck.js"></script>		
		<form name="form1" action="system.php?op=catalog&onglet=article&'.$vars_mod["action"].'=save'.$var_en_plus.'" method="post" onsubmit="return verif_new_article(this);" enctype="multipart/form-data">
		<table border="0" cellpadding="0" cellspacing="0"><tr>
		<td valign="top">
		<img src="'.$srcphoto.'" class="illustration" ></td>
		<td width="20"></td>
		<td valign="top">
		<div class="boite_article">
		<ul class="menulangue">
			<li id="menuF" style="font-weight: bold"><a href="#" onclick="view_cat_lang(\'F\');return false;">Francais </a></li>
			<li id="menuE" style="font-weight: normal"><a href="#" onclick="view_cat_lang(\'E\');return false;">Anglais </a></li>
			<li id="menuA" style="font-weight: normal"><a href="#" onclick="view_cat_lang(\'A\');return false;">Allemand </a></li>
			<li id="menuI" style="font-weight: normal"><a href="#" onclick="view_cat_lang(\'I\');return false;">Italien </a></li>
			<li id="menuS" style="font-weight: normal"><a href="#" onclick="view_cat_lang(\'S\');return false;">Espagnol </a></li>
		</ul>
		<div style="clear: both;"></div>
		<div id="viewF">
			<table class="saisiecatalog" border="0" cellspacing="2" cellpadding="0">
				<tr>
					<td class="col1">'._ARTICLEDESIGN.'</td>
					<td width="10"></td>
					<td><input id="designation_F" class="saisie_long_lang" type="text" name="designation_F" size="42" value="'.$this->conditionnerFORM($ArticleEdit["designation_F"]).'"></td>
				</tr>
				<tr>
					<td class="col1">Conditionnement</td>
					<td width="10"></td>
					<td><input id="conditionnement_F" class="saisie_long_lang" type="text" name="conditionnement_F" size="42" value="'.$this->conditionnerFORM($ArticleEdit["conditionnement_F"]).'"></td>
				</tr>
				<tr>
					<td class="col1">'._ARTICLEDESCRIP.'</td>
					<td width="10"></td>
					<td class="saisie_long_lang2">
					<textarea id="description_F" style="width: 480px" class="saisie_long_lang" name="description_F" rows="6" cols="40">'.$ArticleEdit["description_F"].'</textarea>
					<script type="text/javascript">editFour(\'description_F\');</script>
					</td>
				</tr>
				<tr>
					<td class="col1">'._ARTICLEOPTIONS.'</td>
					<td width="10"></td>
					<td><textarea class="saisie_long_lang" name="options_F" rows="4" cols="40">'.$ArticleEdit["options_F"].'</textarea></td>
				</tr>
			</table>
		</div>
		<div id="viewE" style="display: none;">
			<table class="saisiecatalog" border="0" cellspacing="2" cellpadding="0">
				<tr>
					<td class="col1">'._ARTICLEDESIGN.'</td>
					<td width="10"></td>
					<td><input class="saisie_long_lang" type="text" name="designation_E" size="42" value="'.$this->conditionnerFORM($ArticleEdit["designation_E"]).'"></td>
				</tr>
				<tr>
					<td class="col1">Conditionnement</td>
					<td width="10"></td>
					<td><input id="conditionnement_E" class="saisie_long_lang" type="text" name="conditionnement_E" size="42" value="'.$this->conditionnerFORM($ArticleEdit["conditionnement_E"]).'"></td>
				</tr>
				<tr>
					<td class="col1">'._ARTICLEDESCRIP.'</td>
					<td width="10"></td>
					<td class="saisie_long_lang2"><textarea id="description_E" style="width: 480px" class="saisie_long_lang" name="description_E" rows="6" cols="40">'.$ArticleEdit["description_E"].'</textarea></td>
					<script type="text/javascript">editFour(\'description_E\');</script>
					</tr>
				<tr>
					<td class="col1">'._ARTICLEOPTIONS.'</td>
					<td width="10"></td>
					<td><textarea class="saisie_long_lang" name="options_E" rows="4" cols="40">'.$ArticleEdit["options_E"].'</textarea></td>
				</tr>
			</table>
		</div>
		<div id="viewA" style="display: none;">
			<table class="saisiecatalog" border="0" cellspacing="2" cellpadding="0">
				<tr>
					<td class="col1">'._ARTICLEDESIGN.'</td>
					<td width="10"></td>
					<td><input class="saisie_long_lang" type="text" name="designation_A" size="42" value="'.$this->conditionnerFORM($ArticleEdit["designation_A"]).'"></td>
				</tr>
				<tr>
					<td class="col1">Conditionnement</td>
					<td width="10"></td>
					<td><input id="conditionnement_A" class="saisie_long_lang" type="text" name="conditionnement_A" size="42" value="'.$this->conditionnerFORM($ArticleEdit["conditionnement_A"]).'"></td>
				</tr>
				<tr>
					<td class="col1">'._ARTICLEDESCRIP.'</td>
					<td width="10"></td>
					<td class="saisie_long_lang2"><textarea id="description_A" style="width: 480px" class="saisie_long_lang" name="description_A" rows="6" cols="40">'.$ArticleEdit["description_A"].'</textarea></td>
					<script type="text/javascript">editFour(\'description_A\');</script>
					</tr>
				<tr>
					<td class="col1">'._ARTICLEOPTIONS.'</td>
					<td width="10"></td>
					<td><textarea class="saisie_long_lang" name="options_A" rows="4" cols="40">'.$ArticleEdit["options_A"].'</textarea></td>
				</tr>
			</table>
		</div>
		<div id="viewI" style="display: none;">
			<table class="saisiecatalog" border="0" cellspacing="2" cellpadding="0">
				<tr>
					<td class="col1">'._ARTICLEDESIGN.'</td>
					<td width="10"></td>
					<td><input class="saisie_long_lang" type="text" name="designation_I" size="42" value="'.$this->conditionnerFORM($ArticleEdit["designation_I"]).'"></td>
				</tr>
				<tr>
					<td class="col1">Conditionnement</td>
					<td width="10"></td>
					<td><input id="conditionnement_I" class="saisie_long_lang" type="text" name="conditionnement_I" size="42" value="'.$this->conditionnerFORM($ArticleEdit["conditionnement_I"]).'"></td>
				</tr>
				<tr>
					<td class="col1">'._ARTICLEDESCRIP.'</td>
					<td width="10"></td>
					<td class="saisie_long_lang2"><textarea id="description_I" style="width: 480px" class="saisie_long_lang" name="description_I" rows="6" cols="40">'.$ArticleEdit["description_I"].'</textarea></td>
					<script type="text/javascript">editFour(\'description_I\');</script>
					</tr>
				<tr>
					<td class="col1">'._ARTICLEOPTIONS.'</td>
					<td width="10"></td>
					<td><textarea class="saisie_long_lang" name="options_I" rows="4" cols="40">'.$ArticleEdit["options_I"].'</textarea></td>
				</tr>
			</table>
		</div>
		<div id="viewS" style="display: none;">
			<table class="saisiecatalog" border="0" cellspacing="2" cellpadding="0">
				<tr>
					<td class="col1">'._ARTICLEDESIGN.'</td>
					<td width="10"></td>
					<td><input class="saisie_long_lang" type="text" name="designation_S" size="42" value="'.$this->conditionnerFORM($ArticleEdit["designation_S"]).'"></td>
				</tr>
				<tr>
					<td class="col1">Conditionnement</td>
					<td width="10"></td>
					<td><input id="conditionnement_S" class="saisie_long_lang" type="text" name="conditionnement_S" size="42" value="'.$this->conditionnerFORM($ArticleEdit["conditionnement_S"]).'"></td>
				</tr>
				<tr>
					<td class="col1">'._ARTICLEDESCRIP.'</td>
					<td width="10"></td>
					<td class="saisie_long_lang2"><textarea id="description_S" class="saisie_long_lang" name="description_S" rows="6" cols="40">'.$ArticleEdit["description_S"].'</textarea>
					<script type="text/javascript">editFour(\'description_S\');</script>
					</td>
					
					</tr>
				<tr>
					<td class="col1">'._ARTICLEOPTIONS.'</td>
					<td width="10"></td>
					<td><textarea class="saisie_long_lang" name="options_S" rows="4" cols="40">'.$ArticleEdit["options_S"].'</textarea></td>
				</tr>
			</table>
		</div>
		<table class="saisiecatalog" border="0" cellspacing="2" cellpadding="0">
			<tr>
				<td class="col1">'._ARTICLEREFERENCE.'</td>
				<td width="10"></td>
				<td><input class="saisie_long" type="text" name="ref_article" size="16" value="'.$ArticleEdit["ref_article"].'"></td>
			</tr>
			<tr>
				<td class="col1">'._ARTICLEPHOTO.'</td>
				<td width="10"></td>
				<td><input class="saisie_long_fic" type="text" name="photo" size="16" value="'.$ArticleEdit["photo"].'" readonly="readonly" /> <input type="button" value="'._ARTICLENEWPHOTO.'" onclick="window.location.href=\'system.php?op=catalog&onglet=article&'.$vars_mod["action"].'=new_photo&'.$vars_mod["id_article"].'='.$vars_mod[$vars_mod["id_article"]].'\'" /></td>
			</tr>
			<tr>
				<td class="col1">'._ARTICLEMARQUE.'</td>
				<td width="10"></td>
				<td><input class="saisie_long" type="text" name="marque" size="24" value="'.$ArticleEdit["marque"].'"></td>
			</tr>
			<tr>
				<td class="col1">'._ARTICLEDISPO.'</td>
				<td width="10"></td>
				<td><input type="checkbox" name="valide" value="1"'.$checked.'></td>
			</tr>
			<tr>
				<td>'._ARTICLETAUXTVA.'</td>
				<td width="10"></td>
				<td><input class="saisie_long" type="text" name="taux_tva" size="24" value="'.$ArticleEdit["taux_tva"].'"></td>
			</tr>
		</table>
		<table class="saisiecatalog" border="0" cellspacing="2" cellpadding="0" style="width: 100%">
				<tr>
					<td>Tarifs applicables : <a href="system.php?op=catalog&act=edit_tarif&Id=-1&id_produit='.$ArticleEdit["Id"].'" title="Ajout d\'un nouveau tarif" onclick="ouvre_dialogue(this.title, this.href, 800); return false"><img src="images/netvibes.gif" alt="Ajout tarif" align="absmiddle" /></a>
<div id="allprix">'.$tabtarif.'</div></td>
				</tr>
			</table>
		<table class="saisiecatalog" border="0" cellspacing="2" cellpadding="0">
				<!--<tr>
					<td class="col1">'._ARTICLETARIF.'</td>
					<td width="10"></td>
					<td><input class="saisie_court" type="text" name="tarif_ht" size="24" value="'.$ArticleEdit["tarif_ht"].'"></td>
					<td width="10"></td>
					<td>'._ARTICLETAUXTVA.'</td>
					<td width="10"></td>
					<td><input class="saisie_court" type="text" name="taux_tva" size="24" value="'.$ArticleEdit["taux_tva"].'"></td>
					<td width="10"></td>
					<td>'._ARTICLETAUXSOLDE.'</td>
					<td width="10"></td>
					<td><input class="saisie_court" type="text" name="taux_solde" size="24" value="'.$ArticleEdit["taux_solde"].'"><input type="hidden" name="deb_solde" value="'.$this->date2JMA($ArticleEdit["deb_solde"]).'"><input type="hidden" name="fin_solde" value="'.$this->date2JMA($ArticleEdit["fin_solde"]).'"></td>
				</tr>-->
				<!--<tr>
					<td>'._ARTICLEDEBSOLDE.'</td>
					<td width="10"></td>
					<td><input class="saisie_court" type="text" name="deb_solde" size="24" value="'.$this->date2JMA($ArticleEdit["deb_solde"]).'" onfocus="showPopUpCal(this)"></td>
					<td width="10"></td>
					<td>'._ARTICLEFINSOLDE.'</td>
					<td width="10"></td>
					<td><input class="saisie_court" type="text" name="fin_solde" size="24" value="'.$this->date2JMA($ArticleEdit["fin_solde"]).'" onfocus="showPopUpCal(this)"></td>
					<td width="10"></td>
					<td>'._ARTICLETAUXSOLDE.'</td>
					<td width="10"></td>
					<td><input class="saisie_court" type="text" name="taux_solde" size="24" value="'.$ArticleEdit["taux_solde"].'"></td>
				</tr>-->
				<!--<tr>
					<td class="col1">'._ARTICLEDEBPROMO.'</td>
					<td width="10"></td>
					<td><input class="saisie_court" type="text" name="deb_promo" size="24" value="'.$this->date2JMA($ArticleEdit["deb_promo"]).'" onfocus="showPopUpCal(this)"></td>
					<td width="10"></td>
					<td>'._ARTICLEFINPROMO.'</td>
					<td width="10"></td>
					<td><input class="saisie_court" type="text" name="fin_promo" size="24" value="'.$this->date2JMA($ArticleEdit["fin_promo"]).'" onfocus="showPopUpCal(this)"></td>
					<td width="10"></td>
					<td>'._ARTICLEPRIXPROMO.'</td>
					<td width="10"></td>
					<td><input class="saisie_court" type="text" name="tarif_promo" size="24" value="'.$ArticleEdit["tarif_promo"].'"></td>
				</tr>-->
				<tr><td>&nbsp;</td></tr>
			</table>
			<table class="saisiecatalog" border="0" cellspacing="2" cellpadding="0">
				<tr>
					<td align="center">'._ARTICLECATEGORIES.'</td>
					<td width="20"></td>
					<td align="center">'._ARTICLEALLCATEGORIES.'</td>
					<td align="center">'._ARTICLEARBOCATEGORIES.'</td>
				</tr>
				<tr height="200">
					<td height="200">'.$this->get_my_categories($My_SQL,$vars_mod[$vars_mod["id_article"]]).'</td>
					<td width="20"><img src="'.$vars_mod["cheminModule"].'lib/icns/flecheG.gif" alt="" border="0" /></td>
					<td height="200">'.$this->get_list_categories($My_SQL).'</td>
					<td height="200"><div class="zoneArbo">'.$this->tree_open($My_SQL,$vars_mod).'</div></td>
				</tr>
			</table>
			<table class="saisiecatalog" border="0" cellspacing="2" cellpadding="0">
				<tr><td align="center">'._ARTICLEPAYSLIVRE.'</td></tr>
				<tr><td align="center">'.$list_pays.'</td></tr>
			</table>
		</div></td>
		</tr></table>
		<div align="center">&nbsp;<br /><input type="hidden" value="'.$ArticleEdit["Id"].'" name="'.$vars_mod["id_article"].'"><input type="submit" name="valid" value="'._ARTICLESAVEEDIT.'"></div>
		</form>
		</fieldset>
		</div>
<script src="'.$vars_mod["cheminModule"].'/lib/lib_autostart.js" type="text/javascript"></script>
<link href="'.$vars_mod["cheminModule"].'lib/style-calendar.css" rel="stylesheet" type="text/css" media="all" />
<script src="'.$vars_mod["cheminModule"].'lib/lib_cal.js" type="text/javascript"></script>
<script type="text/javascript">
 //<![CDATA[
	function validMail(email) {
		if (email == "") {
			return(true);
		}
		else {
			if ((email.indexOf("@") == -1) || (email.indexOf("@") == 0) || (email.indexOf("@") != email.lastIndexOf("@")) || (email.indexOf(".") == email.indexOf("@")-1) || (email.indexOf(".") == email.indexOf("@") + 1) || (email.indexOf("@") == email.length -1) || (email.indexOf (".") == -1) || (email.lastIndexOf (".") == email.length -1) || (email.indexOf (";") != -1) || (email.indexOf (" ") != -1)) {
				return(false);
			}
			else return(true);
		}
	}
	function getfield(idzone) {        
       	var FCKGetInstance = FCKeditorAPI.GetInstance(idzone);  
        var getText = FCKGetInstance.GetData(); 
        var StripTag = getText.replace(/(<([^>]+)>)/ig,"");
        return StripTag; 
    }
	function verif_new_article(formulaire) {
		if (formulaire.photo.value == "") {
			if (!confirm("'._ARTICLEVERIFPHOTO.'")) {
				return false;
			}
		}
		if (formulaire.keywords.value == "") {
			if (!confirm("'._ARTICLEVERIFCATEGORIE.'")) {
				return false;
			}
		}
		if ((formulaire.designation_F.value + formulaire.designation_E.value + formulaire.designation_A.value + formulaire.designation_I.value + formulaire.designation_S.value) == "") {
			alert("'._ARTICLEVERIFDESIGN.'");
			return false;
		}
		if ((getfield("description_F") + getfield("description_E") + getfield("description_A") + getfield("description_I") + getfield("description_S")) == "") {
			alert("'._ARTICLEVERIFDESCRIP.'");
			return false;
		}
		return true;
	}
	function view_cat_lang(lang,menu) {
		var ie = false;
		if (document.all) {
			ie = true;
		}
		if (ie) {
			var obj = document.all["viewF"];
			obj.style.display = "none";
			obj = document.all["viewE"];
			obj.style.display = "none";
			obj = document.all["viewI"];
			obj.style.display = "none";
			obj = document.all["viewA"];
			obj.style.display = "none";
			obj = document.all["viewS"];
			obj.style.display = "none";
			obj = document.all["view"+lang];
			obj.style.display = "block";
			obj = document.all["menuF"];
			obj.style.fontWeight = "normal";
			obj = document.all["menuE"];
			obj.style.fontWeight = "normal";
			obj = document.all["menuI"];
			obj.style.fontWeight = "normal";
			obj = document.all["menuA"];
			obj.style.fontWeight = "normal";
			obj = document.all["menuS"];
			obj.style.fontWeight = "normal";
			obj = document.all["menu"+lang];
			obj.style.fontWeight = "bold";
		}
		else {
			var obj = document.getElementById("viewF");
			obj.style.display = "none";
			obj = document.getElementById("viewE");
			obj.style.display = "none";
			obj = document.getElementById("viewI");
			obj.style.display = "none";
			obj = document.getElementById("viewA");
			obj.style.display = "none";
			obj = document.getElementById("viewS");
			obj.style.display = "none";
			obj = document.getElementById("view"+lang);
			obj.style.display = "block";
			obj = document.getElementById("menuF");
			obj.style.fontWeight = "normal";
			obj = document.getElementById("menuE");
			obj.style.fontWeight = "normal";
			obj = document.getElementById("menuI");
			obj.style.fontWeight = "normal";
			obj = document.getElementById("menuA");
			obj.style.fontWeight = "normal";
			obj = document.getElementById("menuS");
			obj.style.fontWeight = "normal";
			obj = document.getElementById("menu"+lang);
			obj.style.fontWeight = "bold";
		}

	}
	
	function affiche() {
		var reg = new RegExp("\n([ \f\n\r\t\v])*\n","g");
		var montexte = document.form1.keywords.value;
		montexte = montexte.replace(reg,"\n");
		document.form1.keywords.value = montexte;
		ok = true;
		
		if (document.form1.keywords.value == "") {
			alert("Vous n\'avez saisi aucun mot clef. Ils sont obligatoires");
			ok = false;
		}
		if (document.form1.orientation.value == ""){
			alert("Il faut saisir l\'orientation de la photo.");
			ok = false;
		}
		if (ok){
			document.form1.submit();
		}	
	}
	function ajoutmc() {
		if (document.form1.keywords.value == "") {
			document.form1.keywords.value = document.form1.choix.value;
		}
		else {
			document.form1.keywords.value = document.form1.keywords.value + "\n" + document.form1.choix.value;
		}
	}
	function ajoutmctree(mot) {
		if (document.form1.keywords.value == "") {
			document.form1.keywords.value = mot;
		}
		else {
			document.form1.keywords.value += "\n" + mot;
		}
	}
    //]]>
</script>
<script type="text/javascript">
	addToStart("view_cat_lang(\'F\')");
	addToStart(newPopUpCal);
</script>';
		return $formedit;
	}
	
/**
* Renvoie le formulaire de remplacement de photo d'un article.
* 
* Cette fonction attribue une photo  un article qui n'en a pas ou assure remplacement d'une photo existante.
* @param array $My_SQL Paramtres de la base de donnes.
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
* @return string Formulaire HTML de l'attributin d'une photo.
*/
	function exchange_photo($My_SQL,$vars_mod) {
		$checked = "";
		$ArticleEdit = $this->get_article_edit($My_SQL,$vars_mod);
		
		if ($ArticleEdit["photo"] == "") {
			$photos = "modules/SimpleCatalog/lib/icns/nophoto.gif";
		}
		else {
			$photos = $vars_mod["cheminPhotos"].'/'.$ArticleEdit["photo"];
		}
		
		$formedit = '
		<center>
		<img src="'.$photos.'" class="illustration"><br />
		<div class="boite_article">
		<form name="form1" action="system.php?op=catalog&onglet=article&'.$vars_mod["action"].'=save_new_photo" method="post" onsubmit="return verif_new_photo(this);" enctype="multipart/form-data">
		
		<table class="saisiecatalog" border="0" cellspacing="2" cellpadding="0">
			<tr>
				<td>'._ARTICLEREFERENCE.'</td>
				<td width="10"></td>
				<td><input class="saisie_long" type="text" name="ref_article" size="16" value="'.$ArticleEdit["ref_article"].'" readonly="readonly" /></td>
			</tr>
			<tr>
				<td>'._ARTICLEPHOTO.'</td>
				<td width="10"></td>
				<td><input type="file" name="photo" size="16"></td>
			</tr>
			<tr>
				<td>'._ARTICLEMARQUE.'</td>
				<td width="10"></td>
				<td><input class="saisie_long" type="text" name="marque" size="24" value="'.$ArticleEdit["marque"].'" readonly="readonly" /></td>
			</tr>
		</table>
		<p><input type="hidden" value="'.$ArticleEdit["Id"].'" name="Id"><input type="hidden" value="'.$ArticleEdit["photo"].'" name="old_photo"><input type="submit" name="valid" value="'._ARTICLESAVEEDIT.'"></p>
		</form>
		</div>
		</center>
<script type="text/javascript">
 //<![CDATA[
	function verif_new_photo(formulaire) {
		if (formulaire.photo.value == "") {
			alert("'._ARTICLEVERIFNEWPHOTO.'");
			return false;
		}
		if (formulaire.photo.value != "") {
			var reg=new RegExp("^([a-zA-Z0-9\-_\.])+[\.]{1}(gif|jpg|jpeg|png){1}$","g");
			var nomphoto0 = 	formulaire.photo.value;	
			var tabnomphoto1 = nomphoto0.split("\\\\");
			var nomphoto1 = tabnomphoto1[tabnomphoto1.length - 1];
			var tabnomphoto2 = nomphoto1.split("/");
			var nomphoto2 = tabnomphoto2[tabnomphoto2.length - 1];
			if (!reg.test(nomphoto2)) {
				alert(nomphoto2 + "\n'._ARTICLEVERIFBADNAMEPHOTO.'");
				return false;
			}
		}
		return true;
	}
    //]]>
</script>';
		return $formedit;
	}

/**
* Renvoie un tableau HTML listant tous les articles.
* 
* Ce tableau permet de modifier ou supprimer les articles.
* @param array $My_SQL Paramtres de la base de donnes.
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
* @param array $criteres Tableau contenant les infos de pages.
* @return string Tableau HTML des articles.
*/	
	function get_list_articles ($My_SQL,$vars_mod,$criteres) {
		$critTriPlus = "";
		
		$nbreFiches = $this->sgbd->getNumArticles($My_SQL);
		$nbrepages = ceil($nbreFiches/$criteres["articles_par_page"]);
		if ($criteres["page_en_cours"] > $nbrepages) {
			$criteres["page_en_cours"] = $nbrepages;
		}
		$indexPages = $this ->getPagesIndex($vars_mod,$criteres, $nbreFiches,_CATALOGARTICLESFOUNDPAGES,_CATALOGARTICLESNOTFOUNDPAGES);
		$limInf = ($criteres["page_en_cours"]-1)*$criteres["articles_par_page"];
		$limit_article = $limInf.",".$criteres["articles_par_page"];
		
		$articles = $this->sgbd->getArticles($My_SQL,"",$vars_mod[$vars_mod["tri"]],$limit_article);
		$tri = "";
		if ($vars_mod[$vars_mod["tri"]] != "") {
			$tri = '&'.$vars_mod["tri"].'='.$vars_mod[$vars_mod["tri"]];
		}
		$var_en_plus = "";
		if ($criteres["page_en_cours"] != "1") {
			$var_en_plus = "&".$vars_mod["page_en_cours"]."=".$criteres["page_en_cours"];
		}
		
		$liste = '<form name="listarticles" action="system.php?op=catalog&onglet=article&'.$vars_mod["action"].'=deletegroup&'.$tri.$var_en_plus.'" method="POST">'
				.$indexPages.'
				<table  class="lisTable">
				<tr class="systemTabHeader">
					<th class="systemTabHeader"><a href="system.php?'.$vars_mod["action"].'=list&op=catalog&onglet=client&'.$vars_mod["tri"].'=designation_F'.$critTriPlus.'">'._ARTICLEONGLETDESIGNATION.'</a></th>
					<th class="systemTabHeader"><a href="system.php?'.$vars_mod["action"].'=list&op=catalog&onglet=client&'.$vars_mod["tri"].'=marque'.$critTriPlus.'">'._ARTICLEONGLETMARQUE.'</a></th>
					<th class="systemTabHeader"><a href="system.php?'.$vars_mod["action"].'=list&op=catalog&onglet=client&'.$vars_mod["tri"].'=ref_article'.$critTriPlus.'">'._ARTICLEONGLETREFERENCE.'</a></th>
					<th class="systemTabHeader">'._ARTICLEONGLETPHOTO.'</th>
					<th class="systemTabHeader">'._ARTICLEONGLETTARIF.' (seuil)</th>
					<th class="systemTabHeader">Avec promo</th>
					<th class="systemTabHeader">Avec solde</th>
    				<th class="systemTabHeader">'._ARTICLEONGLETTAUXTVA.'</th>
    				<!--<th class="systemTabHeader">'._ARTICLEONGLETSOLDE.'</th>-->
					<th class="systemTabHeader"><a href="system.php?'.$vars_mod["action"].'=list&op=catalog&onglet=client&'.$vars_mod["tri"].'=valide'.$critTriPlus.'">'._ARTICLEONGLETVALIDE.'</a></th>
					<th class="systemTabHeader">'._ARTICLEONGLETCACTION.'</th>
    				</tr>';
		$pos=0;
		if (count($articles) != 0) {
			foreach ($articles as $article) {
				$prixTab = $this->sgbd->getTarif($My_SQL,"",$article["Id"]) ;
				$tarifs = "";
				$avecpromo = '<input type="checkbox" value="" disabled="disabled" />';
				$avecsolde = '<input type="checkbox" value="" disabled="disabled" />';
				foreach ($prixTab as $unprix) {
					$tarifs .= ($tarifs != "") ? " - " : ""; 
					$tarifs .= $unprix["tarif_ht"]." (".$unprix["seuil"].")";
					if ($unprix["tarif_promo"] != 0) {
						$avecpromo = '<input type="checkbox" value="" checked="checked" disabled="disabled" />';
					}
					if ($unprix["taux_solde"] != 0) {
						$avecsolde = '<input type="checkbox" value="" checked="checked" disabled="disabled" />';
					}
				}
				
				if ($this->conditionnerHTML($article["valide"]) =="1") {
					//$valide = "&bull;";
					$valide = '<input type="checkbox" value="" checked="checked" disabled="disabled" />';
				}
				else {
					//$valide = "";
						$valide = '<input type="checkbox" value="" disabled="disabled" />';
				}
				$barDef=array(	"edit"=> array( "text"=>_EDIT,"icon"=>"edit_16x16.png","url"=>"system.php?op=catalog&onglet=article&".$vars_mod["action"]."=edit&".$vars_mod["id_article"]."=".$article["Id"].$tri.$var_en_plus,"comment"=>_EDIT, "status"=>"ON"),
  					  			"delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png","url"=>"system.php?op=catalog&onglet=article&".$vars_mod["action"]."=delete&".$vars_mod["id_article"]."=".$article["Id"].$tri.$var_en_plus,"comment"=>_DELETE,"status"=>"ON"));
				
				if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
				$pos++;
				
				$liste .= '<tr class="'.$thestyle.'">';
				$liste .= '<td>';
				$liste .= "<b>".'<input type="checkbox" name="groupdelarticle[]" value="'.$article["Id"].'"> '.$this->conditionnerHTML($article["designation_F"])."</b>";
				$liste .= '</td><td align="center">';
				$liste .= $this->conditionnerHTML($article["marque"]);
				$liste .= '</td><td align="center">';
				$liste .= $this->conditionnerHTML($article["ref_article"]);
				$liste .= '</td><td align="center">';
				$liste .= $this->conditionnerHTML($article["photo"]);
				$liste .= '</td><td align="center">';
				$liste .= $this->conditionnerHTML($tarifs);
				$liste .= '</td><td align="center">';
				$liste .= $this->conditionnerHTML($avecpromo);
				$liste .= '</td><td align="center">';
				$liste .= $this->conditionnerHTML($avecsolde);
				$liste .= '</td><td align="center">';
				$liste .= $this->conditionnerHTML($article["taux_tva"]);
				//$liste .= '</td><td align="center">';
				//$liste .= $this->conditionnerHTML($article["taux_solde"]);
				$liste .= '</td><td align="center">';
				$liste .= $valide;
				$liste .= '</td><td align="center">';
				$liste .= displayActionBar("add","Bar d'action",$barDef,"img","",true);
				$liste .= '</td>';
				$liste .= '</tr>';
			}
			
		}
		$liste .= '</table>';
		//$liste .= '<a href="system.php?op=catalog&onglet=article&'.$vars_mod["action"].'=deletegroup&'.$tri.$var_en_plus.'">Effacer les articles cochs</a>';
		$liste .= '<a href="#" onclick="document.forms[\'listarticles\'].submit(); return false">Effacer les articles cochs</a>';
		$liste .= '</form>';
		return $liste;
	}
	
/**
* Renvoie un tableau HTML listant toutes les priodes de soldes.
* 
* Ce tableau permet de modifier ou supprimer les priodes de solde.
* Celles-ci permettent de programmer les soldes sans avoir  changer tous les articles rapidement. Les taux des soldes sont fixs dans la fiche article.
* @param array $My_SQL Paramtres de la base de donnes.
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
* @return string Tableau HTML des priodes.
*/	
	function list_soldes($My_SQL,$vars_mod) {
		$critTriPlus = "";
		$soldes = $this->sgbd->getAllPeriodSolde($My_SQL);
		$liste = '
				<table  class="lisTable">
				<tr class="systemTabHeader">
					<th class="systemTabHeader">'._ARTICLEONGLETSOLDES.'</th>
					<th class="systemTabHeader" width="100">'._ARTICLEONGLETCACTION.'</th>
    			</tr>';
		$pos=0;
		if (count($soldes) != 0) {
			foreach ($soldes as $solde) {
				$barDef=array(	"edit"=> array( "text"=>_EDIT,"icon"=>"edit_16x16.png","url"=>"system.php?op=catalog&onglet=soldes&".$vars_mod["action"]."=edit_period_soldes&".$vars_mod["id_solde"]."=".$solde["Id"],"comment"=>_EDIT, "status"=>"ON"),
  					  			"delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png","url"=>"system.php?op=catalog&onglet=soldes&".$vars_mod["action"]."=delete_period_soldes&".$vars_mod["id_solde"]."=".$solde["Id"],"comment"=>_DELETE,"status"=>"ON"));
				
				if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
				$pos++;
				
				$liste .= '<tr class="'.$thestyle.'">';
				$liste .= '<td>du ';
				$liste .= "<b>".$this->date2JMA($solde["deb_solde"])."</b>";
				$liste .= ' au ';
				$liste .= "<b>".$this->date2JMA($solde["fin_solde"])."</b>";
				$liste .= '</td><td align="center" width="100">';
				$liste .= displayActionBar("add","Bar d'action",$barDef,"img","",true);
				$liste .= '</td>';
				$liste .= '</tr>';
			}
			
		}
		$liste .= '</table>';
		return $liste;
	}

/**
* Renvoie le formulaire d'dition des priodes de soldes.
* 
* Ce formulaire permet de crer ou modifier les priodes de solde.
* @param array $My_SQL Paramtres de la base de donnes.
* @param array $new_period_soldes Tableau contenant les valeurs de la priode  modifier ou une priode vierge.
* @return string Formulaire HTML d'dition des priodes de solde.
*/
	function edit_soldes($My_SQL,$vars_mod,$new_period_soldes) {
		if ($vars_mod[$vars_mod["id_solde"]] == "-1") {
			$SoldeEdit = $new_period_soldes;
		}
		else {
			$SoldesEdit = $this->sgbd->getAllPeriodSolde($My_SQL,$vars_mod[$vars_mod["id_solde"]]);
			$SoldeEdit = $SoldesEdit[0];
			$SoldeEdit["deb_solde"] = $this->date2JMA($SoldeEdit["deb_solde"]);
			$SoldeEdit["fin_solde"] = $this->date2JMA($SoldeEdit["fin_solde"]);
		}
		$formedit = '
		<center>
		<div class="boite_article">
		<form name="form1" action="system.php?op=catalog&onglet=soldes&'.$vars_mod["action"].'=save_period_soldes" method="post" onsubmit="return verif_soldes(this);">
		<table class="saisiecatalog" border="0" cellspacing="2" cellpadding="0">
			<tr>
				<td>'._ARTICLEDEBSOLDE.'</td>
				<td width="10"></td>
				<td><input class="saisie_long" type="text" name="deb_solde" size="16" value="'.$SoldeEdit["deb_solde"].'" onfocus="showPopUpCal(this)" /></td>
			</tr>
			<tr>
				<td>'._ARTICLEFINSOLDE.'</td>
				<td width="10"></td>
				<td><input class="saisie_long" type="text" name="fin_solde" size="16" value="'.$SoldeEdit["fin_solde"].'" onfocus="showPopUpCal(this)" /></td>
			</tr>
		</table>
		<p><input type="hidden" value="'.$SoldeEdit["Id"].'" name="'.$vars_mod["id_solde"].'"><input type="submit" name="valid" value="'._ARTICLESAVEEDIT.'" /></p>
		</form>
		</div>
		</center>
<script src="'.$vars_mod["cheminModule"].'lib/lib_autostart.js" type="text/javascript"></script>
<link href="'.$vars_mod["cheminModule"].'lib/style-calendar.css" rel="stylesheet" type="text/css" media="all" />
<script src="'.$vars_mod["cheminModule"].'lib/lib_cal.js" type="text/javascript"></script>
<script type="text/javascript">
 //<![CDATA[
	function verif_soldes(formulaire) {
		if (formulaire.deb_solde.value == "" || formulaire.fin_solde.value == "") {
			alert("'._ARTICLEVERIFNEWPERIODSOLDE.'");
			return false;
		}
		return true;
	}
	addToStart(newPopUpCal);
    //]]>
</script>';
		return $formedit;
	}
	
/**
* Effectue l'enregistrement d'une priode de solde.
* 
* Ne renvoie pas le rsultat sous forme de chane de caractre car c'est le formulaire d'dition qui est affich aprs l'enregistrement.
* @param array $My_SQL Paramtres de la base de donnes.
* @param array $periodsoldes Tableau contenant les valeurs de la priode  modifier ou une priode vierge.
* @return boolean Rsultat de l'enregistrement d'une priode.
*/
	function save_soldes($My_SQL,$periodsoldes) {
		$periodsoldes["deb_solde"] = $this->date2AMJ($periodsoldes["deb_solde"]);
		$periodsoldes["fin_solde"] = $this->date2AMJ($periodsoldes["fin_solde"]);
		return $this->sgbd->savePeriodSolde($My_SQL,$periodsoldes);
	}
	
/**
* Effectue la suppression d'une priode de solde.
* @param array $My_SQL Paramtres de la base de donnes.
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
* @return string Rsultat de la suppression de la priode dsigne.
*/
	function delete_soldes($My_SQL,$vars_mod) {
		if ($this->sgbd->delPeriodSolde($My_SQL,$vars_mod[$vars_mod["id_solde"]])) {
			$sortie = _CATALOGDELOK;
		}
		else {
			$sortie = _CATALOGDELPASOK;
		}
		return $sortie;
	}
	
/**
* Renvoie un tableau HTML listant toutes les catgories des articles.
* 
* Ce tableau permet de modifier ou supprimer les catgories.
* Celles-ci ne sont pas prsentes de manire hirarchique.
* @param array $My_SQL Paramtres de la base de donnes.
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
* @return string Tableau HTML des catgories.
*/	 
	function list_categories($My_SQL,$vars_mod) {
		$critTriPlus = "";
		$categories = $this->sgbd->getAllCategories($My_SQL);
		$liste = '
				<table  class="lisTable">
				<tr class="systemTabHeader">
					<th class="systemTabHeader">'._ARTICLEONGLETCATEGORIE.'</th>
					<th class="systemTabHeader" width="100">'._ARTICLEONGLETCACTION.'</th>
    			</tr>';
		$pos=0;
		if (count($categories) != 0) {
			foreach ($categories as $categorie) {
				$barDef=array(	"edit"=> array( "text"=>_EDIT,"icon"=>"edit_16x16.png","url"=>"system.php?op=catalog&onglet=categorie&".$vars_mod["action"]."=edit_category&".$vars_mod["id_categorie"]."=".$categorie["Id"],"comment"=>_EDIT, "status"=>"ON"),
  					  			"delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png","url"=>"system.php?op=catalog&onglet=categorie&".$vars_mod["action"]."=delete_category&".$vars_mod["id_categorie"]."=".$categorie["Id"],"comment"=>_DELETE,"status"=>"ON"));
				
				if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
				$pos++;
				
				$liste .= '<tr class="'.$thestyle.'">';
				$liste .= '<td>';
				$liste .= "<b>".$this->conditionnerHTML($categorie["categorie"])."</b>";
				$liste .= '</td><td align="center" width="100">';
				$liste .= displayActionBar("add","Bar d'action",$barDef,"img","",true);
				$liste .= '</td>';
				$liste .= '</tr>';
			}
			
		}
		$liste .= '</table>';
		return $liste;
	}
	
/**
* Renvoie un formulaire permettant d'diter une catgories d'article.
* 
* La modification de la catgorie se reportera automatiquement sur tous les articles de cette catgorie (par la liaison n-n).
* Elles sont cres lors de l'enregistrement des articles.
* @param array $My_SQL Paramtres de la base de donnes.
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
* @return string Formulaire d'dition de la catgorie.
*/
	function edit_categorie($My_SQL,$vars_mod) {
		$checked = "";
		$CategoriesEdit = $this->sgbd->getAllCategories($My_SQL,$vars_mod[$vars_mod["id_categorie"]]);
		$CategorieEdit = $CategoriesEdit[0];
		$formedit = '
		<center>
		<div class="boite_article">
		<form name="form1" action="system.php?op=catalog&onglet=categorie&'.$vars_mod["action"].'=save_category" method="post" onsubmit="return verif_categorie(this);">
		<table class="saisiecatalog" border="0" cellspacing="2" cellpadding="0">
			<tr>
				<td>'._CATEGORIEDESIGNATION.'</td>
				<td width="10"></td>
				<td><input class="saisie_long" type="text" name="categorie" size="16" value="'.$CategorieEdit["categorie"].'" /></td>
			</tr>
		</table>
		<p><input type="hidden" value="'.$CategorieEdit["Id"].'" name="'.$vars_mod["id_categorie"].'"><input type="submit" name="valid" value="'._ARTICLESAVEEDIT.'"></p>
		</form>
		</div>
		</center>
<script type="text/javascript">
 //<![CDATA[
	function verif_categorie(formulaire) {
		if (formulaire.categorie.value == "") {
			alert("'._ARTICLEVERIFNEWCATEGORIE.'");
			return false;
		}
		return true;
	}
    //]]>
</script>';
		return $formedit;
	}
	
/**
* Effectue l'enregistrement d'une catgorie d'article.
* 
* Ne renvoie pas le rsultat sous forme de chane de caractre car c'est la liste des catgories qui est affiche aprs l'enregistrement.
* @param array $My_SQL Paramtres de la base de donnes.
* @param array $categorie Tableau contenant les valeurs de la catgorie  enregistrer.
* @return boolean Rsultat de l'enregistrement d'une catgorie.
*/
	function save_categorie($My_SQL,$categorie) {
		return $this->sgbd->saveCategorie($My_SQL,$categorie["categorie"],$categorie["Id"]);
	}
	
/**
* Effectue la suppression d'une catgorie d'article.
* @param array $My_SQL Paramtres de la base de donnes.
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
* @return string Rsultat de la suppression de la catgorie dsigne.
*/
	function delete_categorie($My_SQL,$vars_mod) {
		if ($this->sgbd->delCategorie($My_SQL,$vars_mod[$vars_mod["id_categorie"]])) {
			$sortie = _CATALOGDELOK;
		}
		else {
			$sortie = _CATALOGDELPASOK;
		}
		return $sortie;
	}

/**
* Renvoie le formulaire d'dition des arborescences de catgorie.
* 
* Ce formulaire permet de modifier ou supprimer les arborescences de catgories.
* Dans la version actuelle, il n'y a qu'une seule arborescence disponible pour les articles.
* @param array $My_SQL Paramtres de la base de donnes.
* @param array $new_period_soldes Tableau contenant les valeurs de la priode  modifier ou une priode vierge.
* @return string Formulaire HTML d'dition d'arborescence.
*/
	function edit_arborescence($My_SQL,$vars_mod) {
		$checked = "";
		$ArboEdit = $this->sgbd->getArborescence($My_SQL,$vars_mod[$vars_mod["id_cat_arbo"]]);
		$ArboEdit = $ArboEdit[0];
		$formedit = '
		<center>
		<div class="boite_article">
		<form name="form1" action="system.php?op=catalog&onglet=arbo&'.$vars_mod["action"].'=save_arbo" method="post" onsubmit="return verif_arbo(this);">
		<table class="saisiecatalog" border="0" cellspacing="2" cellpadding="0">
			<tr>
				<td>'._ARBONOM.'</td>
				<td width="10"></td>
				<td><input class="saisie_long" type="text" name="nom" size="16" value="'.$ArboEdit["nom"].'" /></td>
			</tr>
			<tr>
				<td>'._ARBOSTRUCT.'</td>
				<td width="10"></td>
				<td><textarea class="saisie_long" name="arbo" rows="20" cols="40">'.$ArboEdit["arbo"].'</textarea></td>
			</tr>
		</table>
		<p><input type="hidden" value="'.$ArboEdit["Id"].'" name="'.$vars_mod["id_cat_arbo"].'"><input type="submit" name="valid" value="'._ARTICLESAVEEDIT.'"></p>
		</form>
		</div>
		</center>
<script type="text/javascript">
 //<![CDATA[
	function verif_arbo(formulaire) {
		if (formulaire.nom.value == "") {
			alert("'._ARTICLEVERIFNEWARBO.'");
			return false;
		}
		return true;
	}
    //]]>
</script>';
		return $formedit;
	}

/**
* Effectue l'enregistrement d'une arborescence de catgorie d'article.
* 
* Ne renvoie pas le rsultat sous forme de chane de caractre car c'est la liste des arborescences qui est affiche aprs l'enregistrement.
* @param array $My_SQL Paramtres de la base de donnes.
* @param array $new_arbo Tableau contenant les valeurs de l'arborescence  enregistrer.
* @return boolean Rsultat de l'enregistrement d'une catgorie.
*/
	function save_arborescence($My_SQL,$new_arbo) {
		return $this->sgbd->saveArborescence($My_SQL,$new_arbo);
	}
	
/**
* Renvoie un tableau HTML listant toutes les arborescences de catgories d'articles.
* 
* Ce tableau permet de modifier ou supprimer les arborescences.
* Dans la version actuelle, il n'y a qu'une seule arborescence disponible pour les articles.
* @param array $My_SQL Paramtres de la base de donnes.
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
* @return string Tableau HTML des catgories.
*/	
	function list_arborescence($My_SQL,$vars_mod) {
		$critTriPlus = "";
		$arborescences = $this->sgbd->getArborescence($My_SQL);
		$liste = '
				<table  class="lisTable">
				<tr class="systemTabHeader">
					<th class="systemTabHeader">'._ARTICLEONGLETARBOCATEGORIE.'</th>
					<th class="systemTabHeader" width="100">'._ARTICLEONGLETCACTION.'</th>
    			</tr>';
		$pos=0;
		if (count($arborescences) != 0) {
			foreach ($arborescences as $arborescence) {
				$barDef=array(	"edit"=> array( "text"=>_EDIT,"icon"=>"edit_16x16.png","url"=>"system.php?op=catalog&onglet=arbo&".$vars_mod["action"]."=edit_arbo&".$vars_mod["id_cat_arbo"]."=".$arborescence["Id"],"comment"=>_EDIT, "status"=>"ON"),
  					  			"delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png","url"=>"system.php?op=catalog&onglet=arbo&".$vars_mod["action"]."=delete_arbo&".$vars_mod["id_cat_arbo"]."=".$arborescence["Id"],"comment"=>_DELETE,"status"=>"ON"));
				
				if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
				$pos++;
				
				$liste .= '<tr class="'.$thestyle.'">';
				$liste .= '<td>';
				$liste .= "<b>".$this->conditionnerHTML($arborescence["nom"])."</b>";
				$liste .= '</td><td align="center" width="100">';
				$liste .= displayActionBar("add","Bar d'action",$barDef,"img","",true);
				$liste .= '</td>';
				$liste .= '</tr>';
			}
			
		}
		$liste .= '</table>';
		return $liste;
	}
	
/**
* Effectue la suppression d'une arborescence de catgorie d'article.
* 
* Il ne faut pas supprimer l'arborescence car on ne peut en crer pour l'instant.
* @param array $My_SQL Paramtres de la base de donnes.
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
* @return string Rsultat de la suppression de l'arborescence dsigne.
*/
	function delete_arbo($My_SQL,$vars_mod) {
		if ($this->sgbd->delArborescence($My_SQL,$vars_mod[$vars_mod["id_cat_arbo"]])) {
			$sortie = _CATALOGDELOK;
		}
		else {
			$sortie = _CATALOGDELPASOK;
		}
		return $sortie;
	}

/**
* Enregistre un nouvel article et renvoie son identifiant.
* 
* Cette fonction n'est utilise que pour la cration d'un nouvel article ( cause de l'upload de photo).
* @param array $My_SQL Paramtres de la base de donnes.
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
* @param array $newarticle Tableau contenant le nouvel article.
* @return integer Identifiant du nouvel article enregistr.
*/
	function save_new_article ($My_SQL,$vars_mod,$newarticle,$seps) {
		if ($_FILES["photo"]["name"] != "") {
			$newarticle["photo"] = $this->upload_photo($vars_mod["cheminPhotos"],$vars_mod["photo_width_max"],$vars_mod["photo_height_max"],$vars_mod["photo_qualite"]);
		}
		$newarticle["deb_solde"] = $this->date2AMJ($newarticle["deb_solde"]);
		$newarticle["fin_solde"] = $this->date2AMJ($newarticle["fin_solde"]);
		$newarticle["deb_promo"] = $this->date2AMJ($newarticle["deb_promo"]);
		$newarticle["fin_promo"] = $this->date2AMJ($newarticle["fin_promo"]);
		
		$newarticle["tarif_ht"] = $this->str2dec($newarticle["tarif_ht"]);
		$newarticle["taux_tva"] = $this->str2dec($newarticle["taux_tva"]);
		$newarticle["tarif_promo"] = $this->str2dec($newarticle["tarif_promo"]);
		$newarticle["taux_solde"] = $this->str2dec($newarticle["taux_solde"]);
		
		$newarticle["list_pays"] = join($seps["sep_valeur"], $newarticle["list_pays"]);
		
		if ($this->sgbd->saveArticle($My_SQL,$newarticle)) {
			if ($newarticle["Id"] == "-1") {
				$savedIndex = $this->sgbd->getLastId($My_SQL);
			}
			else {
				$savedIndex = $newarticle["Id"];
			}
		}
		else {
			$savedIndex = "-1";
		}
		if ($savedIndex != "-1") {
			$this->insert_categories($My_SQL,$savedIndex,$newarticle["keywords"]);
		}
		return $savedIndex;
	}

/**
* Enregistre un article et renvoie son identifiant.
* 
* Cette fonction n'est utilise que pour la modification d'un article.
* @param array $My_SQL Paramtres de la base de donnes.
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
* @param array $newarticle Tableau contenant l'article  enregistrer.
* @return integer Identifiant de l'article enregistr.
*/
	function save_article ($My_SQL,$vars_mod,$newarticle,$seps) {
		$newarticle["deb_solde"] = $this->date2AMJ($newarticle["deb_solde"]);
		$newarticle["fin_solde"] = $this->date2AMJ($newarticle["fin_solde"]);
		$newarticle["deb_promo"] = $this->date2AMJ($newarticle["deb_promo"]);
		$newarticle["fin_promo"] = $this->date2AMJ($newarticle["fin_promo"]);
		
		$newarticle["tarif_ht"] = $this->str2dec($newarticle["tarif_ht"]);
		$newarticle["taux_tva"] = $this->str2dec($newarticle["taux_tva"]);
		$newarticle["tarif_promo"] = $this->str2dec($newarticle["tarif_promo"]);
		$newarticle["taux_solde"] = $this->str2dec($newarticle["taux_solde"]);
		
		$newarticle["list_pays"] = join($seps["sep_valeur"], $newarticle["list_pays"]);
		
		$this->sgbd->saveArticle($My_SQL,$newarticle);
		$this->insert_categories($My_SQL,$newarticle["Id"],$newarticle["keywords"]);
		
		return $newarticle["Id"];
	}
	
/**
* Enregistre une nouvelle photo pour un article.
* 
* Cette fonction n'est utilise que pour les articles existants.
* @param array $My_SQL Paramtres de la base de donnes.
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
* @param array $newarticle Tableau contenant le nouvel article.
* @return string Nom de la nouvelle photo.
*/
	function save_new_photo ($My_SQL,$vars_mod,$newarticle) {
		if ($newarticle["old_photo"] != "") {
			if (file_exists($vars_mod["cheminPhotos"]."/".$newarticle["old_photo"])) {
				if ($this->remove_photo($vars_mod["cheminPhotos"]."/".$newarticle["old_photo"])) {
					if ($_FILES["photo"]["name"] != "") {
						$newphoto = $this->upload_photo($vars_mod["cheminPhotos"],$vars_mod["photo_width_max"],$vars_mod["photo_height_max"],$vars_mod["photo_qualite"]);
						$article_en_cours = $this->sgbd->getArticles($My_SQL,$newarticle["Id"]);
						$article_en_cours[0]["photo"] = $newphoto;
						$this->sgbd->saveArticle($My_SQL,$article_en_cours[0]);
						return $newphoto;
					}
				}
				else {
					return "";
				}
			}
			else {
				if ($_FILES["photo"]["name"] != "") {
					$newphoto = $this->upload_photo($vars_mod["cheminPhotos"],$vars_mod["photo_width_max"],$vars_mod["photo_height_max"],$vars_mod["photo_qualite"]);
					$article_en_cours = $this->sgbd->getArticles($My_SQL,$newarticle["Id"]);
					$article_en_cours[0]["photo"] = $newphoto;
					$this->sgbd->saveArticle($My_SQL,$article_en_cours[0]);
					return $newphoto;
				}
			}
		}
		else {
			if ($_FILES["photo"]["name"] != "") {
				$newphoto = $this->upload_photo($vars_mod["cheminPhotos"],$vars_mod["photo_width_max"],$vars_mod["photo_height_max"],$vars_mod["photo_qualite"]);
				$article_en_cours = $this->sgbd->getArticles($My_SQL,$newarticle["Id"]);
				$article_en_cours[0]["photo"] = $newphoto;
				$this->sgbd->saveArticle($My_SQL,$article_en_cours[0]);
				return $newphoto;
			}
		}
	}
	
/**
* Demande confirmation de la suppression de l'lment dsign.
* @param array $My_SQL Paramtres de la base de donnes
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
* @param message $message Message affich  l'utilisateur pour confirmer la suppression
* @return string Message  afficher en HTML.
*/	
	function confirm_delete($My_SQL,$vars_mod,$message) {
		$sortie = "<p>$message</p>";
		$sortie .= "<p>&nbsp;</p>";
		$sortie .= "<p>";
		
		if ($vars_mod[$vars_mod["action"]] == "deletegroup") {
			$tri = "";
			if ($vars_mod[$vars_mod["tri"]] != "") {
				$tri = '&'.$vars_mod["tri"].'='.$vars_mod[$vars_mod["tri"]];
			}
			$sortie .= '<a href="system.php?op=catalog&onglet=article&'.$vars_mod["action"].'='.$vars_mod[$vars_mod["action"]].'&articles_group='.join("/",$vars_mod["group_articles"]).$tri.'&'.$vars_mod["confirm"].'=y">';
		
			$sortie .= "["._ARTICLECONFSUPPROUI."]";
			$sortie .= "</a>";
			$sortie .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
			$sortie .= '<a href="javascript:window.history.back()">';
			$sortie .= "["._ARTICLECONFSUPPRNON."]";
			$sortie .= '</a>';
		}
		if ($vars_mod[$vars_mod["action"]] == "delete") {
			$tri = "";
			if ($vars_mod[$vars_mod["tri"]] != "") {
				$tri = '&'.$vars_mod["tri"].'='.$vars_mod[$vars_mod["tri"]];
			}
			$sortie .= '<a href="system.php?op=catalog&onglet=article&'.$vars_mod["action"].'='.$vars_mod[$vars_mod["action"]].'&'.$vars_mod["id_article"].'='.$vars_mod[$vars_mod["id_article"]].$tri.'&'.$vars_mod["confirm"].'=y">';
		
			$sortie .= "["._ARTICLECONFSUPPROUI."]";
			$sortie .= "</a>";
			$sortie .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
			$sortie .= '<a href="javascript:window.history.back()">';
			$sortie .= "["._ARTICLECONFSUPPRNON."]";
			$sortie .= '</a>';
		}
		if ($vars_mod[$vars_mod["action"]] == "delete_category") {
			$tri = "";
			if ($vars_mod[$vars_mod["tri"]] != "") {
				$tri = '&'.$vars_mod["tri"].'='.$vars_mod[$vars_mod["tri"]];
			}
			$sortie .= '<a href="system.php?op=catalog&onglet=categorie&'.$vars_mod["action"].'='.$vars_mod[$vars_mod["action"]].'&'.$vars_mod["id_categorie"].'='.$vars_mod[$vars_mod["id_categorie"]].$tri.'&'.$vars_mod["confirm"].'=y">';
		
			$sortie .= "["._ARTICLECONFSUPPROUI."]";
			$sortie .= "</a>";
			$sortie .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
			$sortie .= '<a href="javascript:window.history.back()">';
			$sortie .= "["._ARTICLECONFSUPPRNON."]";
			$sortie .= '</a>';
		}
		if ($vars_mod[$vars_mod["action"]] == "delete_arbo") {
			$tri = "";
			if ($vars_mod[$vars_mod["tri"]] != "") {
				$tri = '&'.$vars_mod["tri"].'='.$vars_mod[$vars_mod["tri"]];
			}
			$sortie .= '<a href="system.php?op=catalog&onglet=arbo&'.$vars_mod["action"].'='.$vars_mod[$vars_mod["action"]].'&'.$vars_mod["id_cat_arbo"].'='.$vars_mod[$vars_mod["id_cat_arbo"]].$tri.'&'.$vars_mod["confirm"].'=y">';
		
			$sortie .= "["._ARTICLECONFSUPPROUI."]";
			$sortie .= "</a>";
			$sortie .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
			$sortie .= '<a href="javascript:window.history.back()">';
			$sortie .= "["._ARTICLECONFSUPPRNON."]";
			$sortie .= '</a>';
		}
		if ($vars_mod[$vars_mod["action"]] == "delete_period_soldes") {
			$sortie .= '<a href="system.php?op=catalog&onglet=soldes&'.$vars_mod["action"].'='.$vars_mod[$vars_mod["action"]].'&'.$vars_mod["id_solde"].'='.$vars_mod[$vars_mod["id_solde"]].$tri.'&'.$vars_mod["confirm"].'=y">';
		
			$sortie .= "["._ARTICLECONFSUPPROUI."]";
			$sortie .= "</a>";
			$sortie .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
			$sortie .= '<a href="javascript:window.history.back()">';
			$sortie .= "["._ARTICLECONFSUPPRNON."]";
			$sortie .= '</a>';
		}
		if ($vars_mod[$vars_mod["action"]] == "delete_port") {
			$sortie .= '<a href="system.php?op=catalog&onglet=listeports&'.$vars_mod["action"].'='.$vars_mod[$vars_mod["action"]].'&'.$vars_mod["id_port"].'='.$vars_mod[$vars_mod["id_port"]].$tri.'&'.$vars_mod["confirm"].'=y">';
		
			$sortie .= "["._ARTICLECONFSUPPROUI."]";
			$sortie .= "</a>";
			$sortie .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
			$sortie .= '<a href="javascript:window.history.back()">';
			$sortie .= "["._ARTICLECONFSUPPRNON."]";
			$sortie .= '</a>';
		}
		$sortie .= "</p>";
		return $sortie;
	}

/**
* Supprime l'article dsign et renvoie le rsultat de l'opration en HTML.
* @param array $My_SQL Paramtres de la base de donnes.
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
* @return string Rsultat de l'opration en HTML.
*/
	function delete_article($My_SQL,$vars_mod) {
		$ArticleEdit = $this->get_article_edit($My_SQL,$vars_mod);
		if ($this->sgbd->delArticle($My_SQL,$vars_mod[$vars_mod["id_article"]])) {
			if ($ArticleEdit["photo"] != "") {
				$srcphoto = $vars_mod["cheminPhotos"].'/'.$ArticleEdit["photo"];
				$this->remove_photo($srcphoto);
			}
			$sortie = _CATALOGDELOK;
		}
		else {
			$sortie = _CATALOGDELPASOK;
		}
		return $sortie;
	}
	
	function delete_articles($My_SQL,$vars_mod) {
		if (count($vars_mod["group_articles"]) > 0) {
			$sortie = true;
			foreach ($vars_mod["group_articles"] as $idarticle) {
				$vars_mod[$vars_mod["id_article"]] = $idarticle;
				$ArticleEdit = $this->get_article_edit($My_SQL,$vars_mod);
				if ($this->sgbd->delArticle($My_SQL,$vars_mod[$vars_mod["id_article"]])) {
					if ($ArticleEdit["photo"] != "") {
						$srcphoto = $vars_mod["cheminPhotos"].'/'.$ArticleEdit["photo"];
						$this->remove_photo($srcphoto);
					}
					$sortie = $sortie && true;
				}
				else {
					$sortie = $sortie && false;
				}
			}
			if ($sortie) {
				return _CATALOGDELOK;
			}
			else {
				return _CATALOGDELPASOK;
			}
		}
		else {
			return "Rien  effacer";
		}
	}

/**
* Rcupre la valeur de l'indentifiant du dernier enregistrement cr.
* @param array $My_SQL Paramtres de la base de donnes
* @return integer Identifiant
*/
	function getLastId($My_SQL) {
		return $this->sgbd->getLastId($My_SQL);
	}
	
/**
* Prpare les donnes  tre enregistres dans la base de donnes en codant les apostrophes.
* @param string $texte Texte  prparer
* @return string Texte encod.
*/
	function conditionnertodb($texte) {
		//$texte = utf8_encode($texte);
		$texte = str_replace("'","''",stripslashes($texte));
		return ($texte);
	}
	
/**
* Prpare les donnes  tre affiches en HTML.
* @param string $texte Texte  prparer
* @return string Texte encod.
*/
	function conditionnerHTML($texte) {
		//return (htmlentities($texte,ENT_QUOTES,UTF-8));
		return $texte;
	}
	
/**
* Prpare les donnes  tre envoyes aux procdures Javascript.
* @param string $texte Texte  prparer
* @return string Texte encod.
*/
	function conditionnerJS($texte, $doubleSlash=false) {
		if ($doubleSlash) {
			$texte = str_replace('"','\\\\"',$texte);
		}
		else {
			$texte = str_replace('"','\"',$texte);
		}
		$texte = str_replace("\n",'\n',$texte);
		$texte = str_replace("\r","",$texte);
		return $texte;
	}
	
/**
* Prpare les donnes  tre incluses dans les formulaires.
* @param string $texte Texte  prparer
* @return string texte encod.
*/
	function conditionnerFORM($texte) {
		return (str_replace('"','&quot;',$texte));
	}
	
/**
* Remplace une donne nulle ou vide par zero.
* @param string $valeur Valeur  tester.
* @return integer Valeur ou zero.
*/
	function notVide($valeur) {
		if ($valeur == "") {
			return 0;
		}
		else {
			return $valeur;
		}
	}
/**
* Convertit une date du format Anne-Mois-Jour (SQL) au format Jour/Mois/Anne (Franais).
* @param string $ladate Date  convertir.
* @return string Date convertie.
*/
	function date2JMA($ladate){
		if ($ladate == "0000-00-00" || $ladate == "") {
			return "";
		}
		else {
			list($an,$mois,$jour) = explode("-",$ladate);
			return $jour."/".$mois."/".$an;
		}
	}
	
/**
* Convertit une date du format Jour/Mois/Anne (Franais) au format Anne-Mois-Jour (SQL).
* @param string $ladate Date  convertir.
* @return string Date convertie.
*/
	function date2AMJ($ladate){
		if ($ladate == "") {
			return "0000-00-00";
		}
		else {
			list($jour,$mois,$annee) = explode("/",$ladate);
			$jour = str_pad($jour, 2, "0",STR_PAD_LEFT);
			$mois = str_pad($mois, 2, "0",STR_PAD_LEFT);
			if (strlen($annee) == 2) {
				$annee = "20".$annee;
			}
			elseif (strlen($annee) == 1) {
				$annee = "200".$annee;
			}
		}
		return "$annee-$mois-$jour";
	}
	
/**
* Formate une valeur numrique du format Franais vers le format PHP.
* @param string $ladate Date  convertir.
* @return string Date convertie.
*/
	function str2dec($valeur) {
		$valeur = str_replace(",",".",$valeur);
		$valeur = str_replace(" ","",$valeur);
		return $valeur;
	}
	
/**
* Prpare les donnes  tre exportes en XML.
* @param string $texte Texte  prparer
* @return string Texte encod.
*/
	function conditionnerXML($texte) {
		//$texte = str_replace("\n",'\n',$texte);
		//$texte = str_replace("\r","",$texte);
		$texte = utf8_encode($texte);
		return $texte;
	}

/**
* Ouvre l'arborescence dsigne et renvoie le code HTML d'un menu arborescent ouvert.
* 
* Ce menu permet de fixer aisment des catgories  un article du catalogue.
* @param array $My_SQL Paramtres de la base de donnes
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
* @return string Rsultat de l'opration en HTML.
*/
	function tree_open($My_SQL,$vars_mod) {
	
	  $img_expand   = "tree_expand.gif";
	  $img_collapse = "tree_collapse.gif";
	  $img_line     = "tree_vertline.gif";  
	  $img_split	= "tree_split.gif";
	  $img_end      = "tree_end.gif";
	  $img_leaf     = "tree_leaf.gif";
	  $img_spc      = "tree_space.gif";
	 
	  $maxlevel=0;
	  $cnt=0;
	  $sortie = "";
	  $racine =  $vars_mod["cheminModule"]."lib/icns/";

	  $arbo = $this->sgbd->getArborescence($My_SQL,$vars_mod[$vars_mod["def_cats_arbo"]]);
	  $fd = $arbo[0]["arbo"];
	  $fdtab = explode("\n",$fd);
	  
	  //if ($fd=="") die("Fichier non trouv : ".$treefile);
	  //while ($buffer = fgets($fd, 4096))
	  foreach($fdtab as $buffer)
	  {
	    $tree[$cnt][0]=strspn($buffer,".");
	    $tmp=rtrim(substr($buffer,$tree[$cnt][0]));
	    $node=explode("|",$tmp);
	    if (!isset($node[0])) {$node[0]=0;};
	    if (!isset($node[1])) {$node[1]=0;};
	    if (!isset($node[2])) {$node[2]=0;};
	    $tree[$cnt][1]=$node[0];
	    $tree[$cnt][2]=$node[1];
	    $tree[$cnt][3]=$node[2];
	    $tree[$cnt][4]=0;
	    $tree[$cnt][5]="";
	    if ($tree[$cnt][0] > $maxlevel) $maxlevel=$tree[$cnt][0];   
	    $cnt++;
	  }
	  //fclose($fd);
	
	  for ($i=0; $i<count($tree); $i++) {
	     $expand[$i]=1;
	     $visible[$i]=1;
	     $levels[$i]=0;
	  }
	
	  /*********************************************/
	  /*  dtermination des paramtres             */
	  /*********************************************/
	  	$mots = array();
		for ($i=0; $i<count($tree); $i++) {
			$mots[$tree[$i][0]] = $tree[$i][2];
			$rien = "";
			for ($j=1;$j<=$tree[$i][0];$j++){
				if ($rien != "") {
					$rien .= "\\n";
				}
				$rien .= $mots[$j];
			}
			$tree[$i][5] = $rien;
		}
	
	  /*********************************************/
	  /*  Get Node numbers to expand               */
	  /*********************************************/
	  
	  if (!isset($p)) {$p="";};
	  if ($p!="") {$explevels = explode("|",$p);} else {$explevels=array();};
	  
	  $i=0;
	  while($i<count($explevels))
	  {
	    $expand[$explevels[$i]]=1;
	    $i++;
	  }
	  
	  /*********************************************/
	  /*  Find last nodes of subtrees              */
	  /*********************************************/
	  
	  $lastlevel=$maxlevel;
	  for ($i=count($tree)-1; $i>=0; $i--)
	  {
	     if ( $tree[$i][0] < $lastlevel )
	     {
	       for ($j=$tree[$i][0]+1; $j <= $maxlevel; $j++)
	       {
	          $levels[$j]=0;
	       }
	     }
	     if ( $levels[$tree[$i][0]]==0 )
	     {
	       $levels[$tree[$i][0]]=1;
	       $tree[$i][4]=1;
	     }
	     else
	       $tree[$i][4]=0;
	     $lastlevel=$tree[$i][0];  
	  }
	  
	  
	  /*********************************************/
	  /*  Determine visible nodes                  */
	  /*********************************************/
	  
	// all root nodes are always visible
	  for ($i=0; $i < count($tree); $i++) if ($tree[$i][0]==1) $visible[$i]=1;
	  for ($i=0; $i < count($explevels); $i++)
	  {
	    $n=$explevels[$i];
	    if (!isset($visible[$n])) {$visible[$n] = 0;};
	    if (!isset($expand[$n])) {$expand[$n] = 0;};
	    if ( ($visible[$n]==1) && ($expand[$n]==1) )
	    {
	       $j=$n+1;
	       while ( $tree[$j][0] > $tree[$n][0] )
	       {
	         if ($tree[$j][0]==$tree[$n][0]+1) $visible[$j]=1;     
	         $j++;
	       }
	    }
	  }
	  
	  
	  /*********************************************/
	  /*  Output nicely formatted tree             */
	  /*********************************************/
	  
	  for ($i=0; $i<$maxlevel; $i++) $levels[$i]=1;
	
	  $maxlevel++;
	  
	  $sortie .= "<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" cols=\"".($maxlevel+3)."\">\n";
	  $cnt=0;
	  while ($cnt<count($tree))
	  {
	  	if (!isset($visible[$cnt])) {$visible[$cnt] = false;};
	    if ($visible[$cnt])
	    {
	      /****************************************/
	      /* start new row                        */
	      /****************************************/      
	      $sortie .= "<tr>";
	      
	      /****************************************/
	      /* vertical lines from higher levels    */
	      /****************************************/
	      $i=0;
	      while ($i<$tree[$cnt][0]-1) 
	      {
	        if ($levels[$i]==1)
	            $sortie .= "<td width=\"16\"><a name='$cnt'></a><img width=\"16\" height=\"16\" src=\"".$racine.$img_line."\"></td>";
	        else
	            $sortie .= "<td width=\"16\"><a name='$cnt'></a><img width=\"16\" height=\"16\" src=\"".$racine.$img_spc."\"></td>";
	        $i++;
	      }
	      
	      /****************************************/
	      /* corner at end of subtree or t-split  */
	      /****************************************/         
	      
	      if ($tree[$cnt][4]==1) 
	      {
	        $sortie .= "<td width=\"16\"><img width=\"16\" height=\"16\" src=\"".$racine.$img_end."\"></td>";
	        $levels[$tree[$cnt][0]-1]=0;
	      }
	      else
	      {
	        $sortie .= "<td width=\"16\"><img width=\"16\" height=\"16\" src=\"".$racine.$img_split."\"></td>";                  
	        $levels[$tree[$cnt][0]-1]=1;    
	      } 
	      
	      /********************************************/
	      /* Node (with subtree) or Leaf (no subtree) */
	      /********************************************/
	      if (!isset($tree[$cnt+1][0])) {$tree[$cnt+1][0]=0;};
	      if ($tree[$cnt+1][0]>$tree[$cnt][0])
	      {
	        
	        /****************************************/
	        /* Create expand/collapse parameters    */
	        /****************************************/
	        $i=0; $params="?p=";
	        $vcount = count($expand);
	        while($i<$vcount)
	        {
	          if (!isset($expand[$i])) {$expand[$i]=0;};
	          if ( ($expand[$i]==1) && ($cnt!=$i) || ($expand[$i]==0 && $cnt==$i))
	          {
	            $params=$params.$i;
	            $params=$params."|";
	          }
	          $i++;
	        }
	        
	        //rajout par vince
	        //$params_plus = lesargs("p");
			$params_plus = "";
	        if ($params != "" && $params_plus != "") {
	        	$params .= "&";
	        }
	        $params .= $params_plus;
	        if ($expand[$cnt]==0)
	            $sortie .= "<td width=\"16\"><img width=\"16\" height=\"16\" src=\"".$racine.$img_expand."\" border=0></td>";
	        else
	            $sortie .= "<td width=\"16\"><img width=\"16\" height=\"16\" src=\"".$racine.$img_collapse."\" border=0></td>";         
	      }
	      else
	      {
	        /*************************/
	        /* Tree Leaf             */
	        /*************************/
	
	        $sortie .= "<td width=\"16\"><img width=\"16\" height=\"16\" src=\"".$racine.$img_leaf."\"></td>";         
	      }
	      /****************************************/
	      /* output item text                     */
	      /****************************************/
	      if ($tree[$cnt][2]=="")
	          $sortie .= "<td colspan=".($maxlevel-$tree[$cnt][0]).">".$tree[$cnt][1]."</td>";
	      else
	         $sortie .= "<td colspan=".($maxlevel-$tree[$cnt][0])."><a href=\"#\" onclick=\"ajoutmctree('".str_replace("'","\'",$tree[$cnt][5])."');return false\" target=\"".$tree[$cnt][3]."\">".$tree[$cnt][1]."</a></td>";
	          
	      /****************************************/
	      /* end row                              */
	      /****************************************/
	              
	      $sortie .= "</tr>\n";      
	    }
	    $cnt++;    
	  }
	  $sortie .= "</table>\n";
	  return $sortie;
	}
	
/**
* Renvoie la liste de toutes les catagories. Si un article est dsign, seules catagories de cet article sont renvoyes. 
* 
* Cette liste permet de fixer aisment des catgories  un article du catalogue.
* Celles-ci sont prsentes par ordre alphabtique.
* @param array $My_SQL Paramtres de la base de donnes.
* @param integer $id_article Identifiant de l'article.
* @return string Liste HTML des catgories.
*/	
	function get_list_categories($My_SQL,$id_article="-1") {
		$mot_clefs = $this->sgbd->getCategories($My_SQL,$id_article);
		$list_mcs = "<select name=\"choix\" multiple size=10 class=\"zoneMotsClef\" onchange=\"ajoutmc();\">\n";
		foreach($mot_clefs as $mc) {
			$list_mcs .= "<option value=\"$mc\">$mc</option>\n";
		}
		$list_mcs .= "</select>\n";
		return $list_mcs;
	}

/**
* Renvoie les catagories attribues  article. 
* 
* Celles-ci sont prsentes par ordre alphabtique dans un contrle de zone de texte.
* @param array $My_SQL Paramtres de la base de donnes.
* @param integer $id_article Identifiant de l'article.
* @return string Zone de texte HTML des catgories.
*/
	function get_my_categories($My_SQL,$id_article="0") {
		if ($id_article == "-1") {
			$id_article = "0";
		}
		$mot_clefs = $this->sgbd->getCategories($My_SQL,$id_article);
		$list_mcs = "<textarea name=\"keywords\" rows=\"15\" cols=\"30\" wrap=\"virtual\" class=\"zoneMotsClef\">";
		$tmp_mcs = "";
		foreach($mot_clefs as $mc) {
			if ($tmp_mcs !="") {
				$tmp_mcs .= "\n";
			}
			$tmp_mcs .= $mc;
		}
		$list_mcs .= $tmp_mcs."</textarea>\n";
		return $list_mcs;
	}
	
/**
* Uploade la photo sur le site. 
* 
* Si le nom de la photo est dj utilis, un "_copy" lui est ajout.
* @param string $chemin Dossier d'enregsitrement des photos des articles.
* @param integer $width_max Largeur maximale de la photo. Si elle est suprieure, cette fonction la redimensionne.
* @param integer $height_max Hauteur maximale de la photo. Si elle est suprieure, cette fonction la redimensionne.
* @param integer $qualite Qualit d'enregistrement de la photo en format JPEG si elle a t redimensionne.
* @return string Nom dfinitif de la photo.
*/
	function upload_photo($chemin="catalog_repository/simple_catalog",$width_max=600,$height_max=600,$qualite=70) {
		//$nomDestination = nextnomphoto();
		$nomDestination = $_FILES["photo"]["name"];
		//vrif de l'existance d'une photo du mme nom et modif
		while (file_exists($chemin."/".$nomDestination)) {
			$tab_nom = explode(".",$nomDestination);
			$nomDestination = "";
			for ($i=0;$i<=(count($tab_nom)-2); $i++) {
				$nomDestination .= $tab_nom[$i];
			}
			$nomDestination .= "_copy";
			$nomDestination .= ".".$tab_nom[(count($tab_nom)-1)];
		}
		$tab_nom = explode(".",$nomDestination);
		
		/*************************************************************/
		/*                   Upload de la photo                      */
		/*************************************************************/

		// ******* test existance rpertoire photos et cration si ncssaire
		if (!file_exists($chemin)) {
			if (mkdir("$chemin", 0777)) {
				chmod("$chemin",0777);
				//echo "Dossier des photos cr&eacute;&eacute;.";
			}
			else {
				die("Dossier $chemin non cr&eacute;&eacute; - V&eacute;rifiez les droits");
			}	
		}
		// ******* dplacement du ficheir dans le bon rpertoire
		if (is_uploaded_file($_FILES["photo"]["tmp_name"])) {
			$img = $chemin."/".$nomDestination;
			if (rename($_FILES["photo"]["tmp_name"],$img)) { 
				chmod($img,0777);
			}
			else {
				die("Le dplacement du fichier temporaire a chou. Vrifiez l'existence du rpertoire $chemin");
			}          
		}
		else {
			die("Le fichier n'a pas t upload (trop gros ? droits ?)");
		}
		// ********** Redimensionnement de l'image si ncessaire
		$size_o = getimagesize($img);
		if (($size_o[0] > $width_max) || ($size_o[1] > $height_max)) {
			if ($tab_nom[(count($tab_nom)-1)] == "jpg" || $tab_nom[(count($tab_nom)-1)] == "jpeg") {
				$img_source=imagecreatefromjpeg($img);
			}
			if ($tab_nom[(count($tab_nom)-1)] == "gif") {
				$img_source=imagecreatefromgif($img);
			}
			if ($tab_nom[(count($tab_nom)-1)] == "png") {
				$img_source=imagecreatefrompng($img);
			}
			$xjpg = ImageSX($img_source);
			$yjpg = ImageSY($img_source);
			if ($xjpg > $yjpg) {
				$xnew = $width_max;
				$ynew = ($yjpg * $width_max) / $xjpg;
			}
			else {
				$xnew = ($xjpg * $height_max) / $yjpg;
				$ynew = $height_max;
			}
			if ($tab_nom[(count($tab_nom)-1)] == "jpg" || $tab_nom[(count($tab_nom)-1)] == "jpeg") {
				$new = ImageCreateTrueColor($xnew,$ynew);
				ImageCopyResampled($new,$img_source,0,0,0,0,$xnew,$ynew,$xjpg,$yjpg);
				imagejpeg($new,$img,$qualite);
			}
			if ($tab_nom[(count($tab_nom)-1)] == "gif") {
				$new = ImageCreateTrueColor($xnew,$ynew);
				$trans = imagecolorallocate($new,255,255,255);
				imagefilledrectangle($new,0,0,$xnew,$ynew,$trans);
				imagecolortransparent($new,$trans);
				ImageCopyResampled($new,$img_source,0,0,0,0,$xnew,$ynew,$xjpg,$yjpg);
				imagetruecolortopalette($new, true, 256);
				imageinterlace($new);
				imagegif($new,$img);
			}
			if ($tab_nom[(count($tab_nom)-1)] == "png") {
				$new = ImageCreateTrueColor($xnew,$ynew);
				imagealphablending($new, false);
				ImageCopyResampled($new,$img_source,0,0,0,0,$xnew,$ynew,$xjpg,$yjpg);
				imagesavealpha($new, true);
				imagepng($new,$img);
			}
			imagedestroy($img_source);
			imagedestroy($new);
		}
		return $nomDestination;
	}
	
/**
* Efface la photo sur le site. 
* @param string $photo Nom de la photo  supprimer. Le chemin est inclus dans le nom.
* @return boolean renvoie true si la photo a t modifie et false sinon.
*/
	function remove_photo($photo) {
		return unlink($photo);
	}

/**
* Effectue l'attribution des catgories pour un article.
* 
* Cre les nouvelles catgories et cre les liens entre les articles et les catgories.
* @param array $My_SQL Paramtres de la base de donnes.
* @param integer $Id_article Identifiant de l'article.
* @param string $keywords Liste des catgories saisies pour l'article en cours.
*/
	function insert_categories($My_SQL,$Id_article,$keywords) {
		$this->sgbd->delLien($My_SQL,$Id_article,"");
		$keywords = $this->conditionnertodb($keywords);
		$keywords = str_replace("\r", "", $keywords);
		$tabKW = explode("\n",$keywords);
		$tabKW = array_unique($tabKW);
		foreach ($tabKW as $motcle) {
			if ($motcle != "") {
				$Id_kwz = $this->sgbd->getCategorieId($My_SQL,$motcle);
				if ($Id_kwz == "-1") {
					if (!$this->sgbd->saveCategorie($My_SQL,$motcle)) {
						$error = $My_SQL["maBase"]->sql_error();
						die("Erreur sur la cr&eacute;ation de fiche catgorie : ".$error["message"]);
					}
					$Id_kwz = $this->sgbd->getLastId($My_SQL);
				}
				if (!$this->sgbd->saveLien($My_SQL,$Id_article,$Id_kwz)) {
					$error = $My_SQL["maBase"]->sql_error();
					die("Erreur sur la cr&eacute;ation de fiche Lien : ".$error["message"]);
				}
			}	
		}
		
	}

/**
* Renvoie un tableau HTML listant tous les transports des articles.
* 
* Ce tableau permet de modifier ou supprimer les frais de port des articles commands.
* @param array $My_SQL Paramtres de la base de donnes.
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
* @return string Tableau HTML des transports.
*/	
	function list_ports($My_SQL,$vars_mod) {
		$critTriPlus = "";
		$ports = $this->sgbd->getPorts($My_SQL);
		$liste = '
				<table  class="lisTable">
				<tr class="systemTabHeader">
					<th class="systemTabHeader">'._ARTICLEONGLETPORTS.'</th>
					<th class="systemTabHeader">'._ARTICLEONGLETPORTSTARIFS.'</th>
					<th class="systemTabHeader">'._ARTICLEONGLETPORTSGRATUIT.'</th>
					<th class="systemTabHeader">'._ARTICLEONGLETPORTSDELAIS.'</th>
					<th class="systemTabHeader" width="100">'._ARTICLEONGLETCACTION.'</th>
    			</tr>';
		$pos=0;
		if (count($ports) != 0) {
			foreach ($ports as $port) {
				$barDef=array(	"edit"=> array( "text"=>_EDIT,"icon"=>"edit_16x16.png","url"=>"system.php?op=catalog&onglet=listeports&".$vars_mod["action"]."=edit_ports&".$vars_mod["id_port"]."=".$port["Id"],"comment"=>_EDIT, "status"=>"ON"),
  					  			"delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png","url"=>"system.php?op=catalog&onglet=listeports&".$vars_mod["action"]."=delete_port&".$vars_mod["id_port"]."=".$port["Id"],"comment"=>_DELETE,"status"=>"ON"));
				
				if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
				$pos++;
				
				$liste .= '<tr class="'.$thestyle.'">';
				$liste .= '<td>';
				$liste .= "<b>".$this->conditionnerHTML($port["designation"])."</b>";
				$liste .= '</td><td align="center">';
				$liste .= number_format($port["tarif"]*(1.0+$port["tva"]/100),2,","," ")." &euro;";
				$liste .= '</td><td align="center">';
				$liste .= number_format($port["seuilfranco"],2,","," ")." &euro;";
				$liste .= '</td><td align="center">';
				$liste .= $port["delai"];
				$liste .= '</td><td align="center" width="100">';
				$liste .= displayActionBar("add","Bar d'action",$barDef,"img","",true);
				$liste .= '</td>';
				$liste .= '</tr>';
			}
		}
		$liste .= '</table>';
		return $liste;
	}

/**
* Renvoie le formulaire d'dition d'un moyen d'expdition d'article.
* 
* Ce formulaire permet de modifier ou crer ces moyens d'expdition.
* Dans la version actuelle, il n'y a qu'une seule arborescence disponible pour les articles.
* @param array $My_SQL Paramtres de la base de donnes.
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
* @param array $new_port Tableau contenant les valeurs du moyen d'expdition  modifier ou un nouveau moyen de transport.
* @param array $seps Tableau contenant les sparateurs de pays.
* @return string Formulaire HTML d'dition d'arborescence.
*/
	function edit_ports($My_SQL,$vars_mod,$new_port, $seps) {
		$checked = "";
		if ($vars_mod[$vars_mod["id_port"]] != "-1") {
			$ports = $this->sgbd->getPorts($My_SQL,$vars_mod[$vars_mod["id_port"]]);
			$portEdit = $ports[0];
		}
		else {
			$portEdit = $new_port;
		}
		$list_pays_select = explode($seps["sep_valeur"], $portEdit["list_pays"]);
		$pays = $this->sgbd->getPays($My_SQL,"_F");
		$list_pays = '<select name="list_pays[]" multiple="multiple" size="10" class="saisie_long">';
		foreach($pays as $unpays) {
			if (in_array($unpays["code"],$list_pays_select)){
				$selected = ' selected="selected"';
			}
			else {
				$selected = "";
			}
			$list_pays .= '<option value="'.$unpays["code"].'"'.$selected.'>'.$unpays["pays_F"].'</option>';
		}
		$list_pays .= '</select>';
		$formedit = '
		<center>
		<div class="boite_article">
		<form name="form1" action="system.php?op=catalog&onglet=listeports&'.$vars_mod["action"].'=save_port" method="post" onsubmit="return verif_port(this);">
		<table class="saisiecatalog" border="0" cellspacing="2" cellpadding="0">
			<tr>
				<td>'._ARTICLEONGLETPORTSDESIGN.'</td>
				<td width="10"></td>
				<td><input class="saisie_long" type="text" name="designation" size="16" value="'.$this->conditionnerFORM($portEdit["designation"]).'" /></td>
			</tr>
			<tr>
				<td>'._ARTICLEONGLETPORTSTARIFSHT.'</td>
				<td width="10"></td>
				<td><input class="saisie_long" type="text" name="tarif" size="16" value="'.$portEdit["tarif"].'" /></td>
			</tr>
			<tr>
				<td>'._ARTICLEONGLETPORTSTVA.'</td>
				<td width="10"></td>
				<td><input class="saisie_long" type="text" name="tva" size="16" value="'.$portEdit["tva"].'" /></td>
			</tr>
			<tr>
				<td>'._ARTICLEONGLETPORTSGRATUIT.'</td>
				<td width="10"></td>
				<td><input class="saisie_long" type="text" name="seuilfranco" size="16" value="'.$portEdit["seuilfranco"].'" /></td>
			</tr>
			<tr>
				<td>'._ARTICLEONGLETPORTSDELAIS.'</td>
				<td width="10"></td>
				<td><input class="saisie_long" type="text" name="delai" size="16" value="'.$portEdit["delai"].'" /></td>
			</tr>
			<tr>
				<td>'._ARTICLEONGLETPORTSPAYS.'</td>
				<td width="10"></td>
				<td>'.$list_pays.'</td>
			</tr>
		</table>
		<p><input type="hidden" value="'.$portEdit["Id"].'" name="'.$vars_mod["id_port"].'"><input type="submit" name="valid" value="'._ARTICLESAVEEDIT.'"></p>
		</form>
		</div>
		</center>
<script type="text/javascript">
 //<![CDATA[
	function verif_port(formulaire) {
		if (formulaire.designation.value == "") {
			alert("'._ARTICLEVERIFPORTDESIGN.'");
			return false;
		}
		if (formulaire.tarif.value == "") {
			formulaire.tarif.value = "0";
		}
		if (formulaire.tva.value == "") {
			formulaire.tva.value = "0";
		}
		if (formulaire.seuilfranco.value == "") {
			formulaire.seuilfranco.value = "0";
		}
		if (formulaire.delai.value == "") {
			formulaire.delai.value = "0";
		}
		return true;
	}
    //]]>
</script>';
		return $formedit;
	}
	
/**
* Enregistre un nouveau moyen de livraison et renvoie son identifiant.
* 
* Cette fonction modifie la fiche de moyen de livraison si elle existe, sinon elle la cre.
* @param array $My_SQL Paramtres de la base de donnes.
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
* @param array $port Tableau contenant le moyen de livraison  enregistrer.
* @return boolean Rsulat de l'enregistrement d'un moyen de transport.
*/
	function save_port ($My_SQL,$vars_mod,$port,$seps) {
		$port["tarif"] = $this->str2dec($port["tarif"]);
		$port["tva"] = $this->str2dec($port["tva"]);
		$port["seuilfranco"] = $this->str2dec($port["seuilfranco"]);
		$port["list_pays"] = join($seps["sep_valeur"], $port["list_pays"]);
		
		return $this->sgbd->savePort($My_SQL,$port);
	}
	
/**
* Effectue la suppression d'un moyen d'expdition d'article.
* @param array $My_SQL Paramtres de la base de donnes.
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
* @return string Rsultat de la suppression du moyen d'expdition dsign.
*/
	function delete_port($My_SQL,$vars_mod) {
		if ($this->sgbd->delPort($My_SQL,$vars_mod[$vars_mod["id_port"]])) {
			$sortie = _CATALOGDELOK;
		}
		else {
			$sortie = _CATALOGDELPASOK;
		}
		return $sortie;
	}
	
	function edit_tarif($My_SQL,$vars_mod) {
		global $new_tarif,$module_name;
		$checked = "";
		if ($vars_mod[$vars_mod["id_tarif"]] != "-1") {
			$TarifEdits = $this->sgbd->getTarif($My_SQL,$vars_mod[$vars_mod["id_tarif"]],$vars_mod["id_produit"]);
			$TarifEdit = $TarifEdits[0];
		}
		else {
			$TarifEdit = $new_tarif;
		}	
		$TarifEdit["deb_promo"] = $this->date2JMA($TarifEdit["deb_promo"]);
		$TarifEdit["fin_promo"] = $this->date2JMA($TarifEdit["fin_promo"]);
		if ($TarifEdit["id_produit"] != "") {
			$article = $this->get_article_edit($My_SQL,array("Id"=>$TarifEdit["id_produit"]));
		}
		else {
			$article = array("designation_F"=>"Produit en cours de cration");
			$TarifEdit["id_produit"] = "-1";
		}
		$formedit = '
		<center>
		<div class="boite_article">		
		<form name="form1" action="system.php?op=catalog&onglet=article&'.$vars_mod["action"].'=save_tarif'.$var_en_plus.'" method="post">
		<table class="saisiecatalog" border="0" cellspacing="2" cellpadding="0">
			<tr>
				<td>Article en cours : </td>
				<td width="10"></td>
				<td>'.$article["designation_F"].'</td>
			</tr>
			<tr>
				<td>Prix de vente HT : </td>
				<td width="10"></td>
				<td><input class="saisie_long" type="text" name="tarif_ht" size="16" value="'.$TarifEdit["tarif_ht"].'" /></td>
			</tr>
			<tr>
				<td>Prix promo : </td>
				<td width="10"></td>
				<td><input class="saisie_long" type="text" name="tarif_promo" size="16" value="'.$TarifEdit["tarif_promo"].'" /></td>
			</tr>
			<tr>
				<td>Dbut des promos : </td>
				<td width="10"></td>
				<td><input class="saisie_long" type="text" name="deb_promo" size="16" value="'.$TarifEdit["deb_promo"].'"  onfocus="showPopUpCal(this)" /></td>
			</tr>
			<tr>
				<td>Fin des promos : </td>
				<td width="10"></td>
				<td><input class="saisie_long" type="text" name="fin_promo" size="16" value="'.$TarifEdit["fin_promo"].'"  onfocus="showPopUpCal(this)" /></td>
			</tr>
			<tr>
				<td>Soldes (%) : </td>
				<td width="10"></td>
				<td><input class="saisie_long" type="text" name="taux_solde" size="16" value="'.$TarifEdit["taux_solde"].'" /></td>
			</tr>
			<tr>
				<td>Seuil d\'application (n >=) : </td>
				<td width="10"></td>
				<td><input class="saisie_long" type="text" name="seuil" size="16" value="'.$TarifEdit["seuil"].'" /></td>
			</tr>
		</table>
		<p><input type="hidden" value="'.$TarifEdit["Id"].'" name="'.$vars_mod["id_tarif"].'"><input type="hidden" value="'.$TarifEdit["id_produit"].'" name="id_produit"><input type="submit" name="valid" value="Enregistrer"></p>
		</form>
		</center>
<script src="'.$vars_mod["cheminModule"].'/lib/lib_autostart.js" type="text/javascript"></script>
<link href="'.$vars_mod["cheminModule"].'lib/style-calendar.css" rel="stylesheet" type="text/css" media="all" />
<script src="'.$vars_mod["cheminModule"].'lib/lib_cal.js" type="text/javascript"></script>
<script type="text/javascript">
	addToStart(newPopUpCal);
</script>';
		
		$sortie = '
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
	<head>
		<meta http-equiv="content-type" content="text/html;charset=iso-8859-1">
		<title>Document</title>
		<link rel="stylesheet" type="text/css" href="system/skins/joomla/system.css">
		<link rel="StyleSheet" href="themes/System/style/style.css" media="screen, handheld" type="text/css">
		<link href="modules/'.$module_name.'/lib/style-edit-catalog.css" rel="stylesheet" type="text/css" media="all" />
	</head>

	<body style="background-color: #F2F2E6">
	';
			
		$sortie .= $formedit;
			
		$sortie .= '
	</body>
</html>';
		
		return $sortie;
	}
	
	function save_tarif($My_SQL,$vars_mod,$new_tarif) {
		$old_tarif = $new_tarif;
		
		$new_tarif["deb_promo"] = $this->date2AMJ($new_tarif["deb_promo"]);
		$new_tarif["fin_promo"] = $this->date2AMJ($new_tarif["fin_promo"]);
		
		if (!$this->sgbd->saveTarif($My_SQL,$new_tarif)) {
			die("Erreur enregistrement tarif - Contactez administrateur");
		}
		if ($new_tarif["Id"] > 0) {
			$idtarif = $new_tarif["Id"];
		}
		else {
			$idtarif = $this->sgbd->getLastId($My_SQL);
		}
		$sortie = '
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
	<head>
		<meta http-equiv="content-type" content="text/html;charset=iso-8859-1">
		<title>Document</title>
		<link rel="stylesheet" type="text/css" href="system/skins/joomla/system.css">
		<link rel="StyleSheet" href="themes/System/style/style.css" media="screen, handheld" type="text/css">
		<link rel="stylesheet" type="text/css" href="modules/'.$module_name.'/system/css/default.css"/>
<script type="text/javascript">
	//window.parent.addTarif("'.$idtarif.'", "'.$old_tarif["tarif_ht"].'", "'.$old_tarif["tarif_promo"].'", "'.$old_tarif["taux_solde"].'", "'.$old_tarif["deb_promo"].'", "'.$old_tarif["fin_promo"].'", "'.$old_tarif["seuil"].'");
    window.parent.updateTarif();
	window.parent.win.close();
</script>
	</head>
	<body style="background-color: #F2F2E6">
	</body>
</html>';
		return $sortie;		
	}
	
	function delete_tarif($My_SQL,$vars_mod) {
		if ($this->sgbd->delTarif($My_SQL,$vars_mod[$vars_mod["id_tarif"]])) {
			$sortie = _CATALOGDELOK;
		}
		else {
			$sortie = _CATALOGDELPASOK;
		}
		return $sortie;
	}
	
	function get_tarifs_xml($My_SQL, $vars_mod) {
		$Tarifs = $this->sgbd->getTarif($My_SQL,"",$vars_mod["id_produit"]);
		$sortie = '<?xml version="1.0" encoding="UTF-8"?>';
		$sortie .= '<tarifs>';
		foreach($Tarifs as $untarif) {
			$untarif["deb_promo"] = $this->date2JMA($untarif["deb_promo"]);
			$untarif["fin_promo"] = $this->date2JMA($untarif["fin_promo"]);
			
			$sortie .= '<tarif>';
			$sortie .= '<Id>'.$untarif["Id"].'</Id>';
			$sortie .= '<tarif_ht>'.$untarif["tarif_ht"].'</tarif_ht>';
			$sortie .= '<tarif_promo>'.$untarif["tarif_promo"].'</tarif_promo>';
			$sortie .= '<deb_promo>'.$untarif["deb_promo"].'</deb_promo>';
			$sortie .= '<fin_promo>'.$untarif["fin_promo"].'</fin_promo>';
			$sortie .= '<taux_solde>'.$untarif["taux_solde"].'</taux_solde>';
			$sortie .= '<seuil>'.$untarif["seuil"].'</seuil>';
			$sortie .= '</tarif>';
		}
		$sortie .= '</tarifs>';
		return $sortie;
	}
}

/**
* Classe des fonctions d'aministration des commandes.
* 
* Cette clase contient galement les fonctions utiles (mise en forme de texte, conversion de format de date,...).
* @package becmsSimpleCatalog
*/
class adminCommand {
/**
* @var object Classe qui donne accs au fonctions de manipulation des commandes.
*/		
	var $sgbd;
/**
* @var object Classe qui donne accs au fonctions de manipulation des articles.
*/		
	var $catalog;
/**
* Initialise $sgbd avec la classe des fonctions d'accs  la base de donnes des commandes
*/	
	function adminCommand() {
		$this->sgbd = new BD_Command();
		$this->catalog = new adminCatalog();
	}

/**
* Renvoie la commande dsigne.
* 
* Si la commane est introuvable ou que son identifiant est -1, une commande vide est retourne.
* @param array $My_SQL Paramtres de la base de donnes.
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
* @return array Tableau contenant la commande.
*/		
	function get_command_edit($My_SQL,$vars_mod) {
		if ($vars_mod[$vars_mod["id_command"]] != "-1") { 
			$commandesEdit = $this->sgbd->getCommandes($My_SQL,$vars_mod[$vars_mod["id_command"]]);
			if (count($commandesEdit) == 0) {
				$commandeEdit = array("Id"=>"","id_client"=>"","client"=>"","date"=>"","numero"=>"","commande"=>"","total_ht"=>"","total_tva"=>"","total_ttc"=>"","status"=>"","port"=>"","port_ht"=>"","paye"=>"","reglement"=>"","code_promo"=>"","reduc_ht"=>"","remarques"=>"");
			}
			else {
				$commandeEdit = $commandesEdit[0];
			}
		}
		else {
			$commandeEdit = array("Id"=>"","id_client"=>"","client"=>"","date"=>"","numero"=>"","commande"=>"","total_ht"=>"","total_tva"=>"","total_ttc"=>"","status"=>"","port"=>"","port_ht"=>"","paye"=>"","reglement"=>"","code_promo"=>"","reduc_ht"=>"","remarques"=>"");
		}
		return $commandeEdit;
	}

/**
* Renvoie le formulaire de modifification de commande.
* @param array $My_SQL Paramtres de la base de donnes.
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
* @param array $seps Tableau contenant les sparateurs d'articles.
* @param array $criteres Tableau contenant les critres d'affichage des commandes.
* @return string Formulaire HTML de modification de la commande.
*/
	function edit_command($My_SQL,$vars_mod,$seps,$criteres) {
		$commande = $this->get_command_edit($My_SQL,$vars_mod);
		$articles = explode($seps["sep_article"],$commande["commande"]);
		//$total_ht = 0;
		//$total_tva = 0;
		$tab_articles = '<table border="0" cellpadding="0" cellspacing="0" class="listearticles">';
		$tab_articles .= '<tr><td colspan="7" class="separation"><hr /></td></tr>';
		foreach($articles as $article) {
			list($Id,$reference,$marque,$designation,$designationClient,$options,$prix,$nbre,$tarif_ht,$taux_tva,$tva) = explode($seps["sep_champ"],$article);
			$tab_articles .= '<tr><td>';
			$tab_articles .= $nbre;
			$tab_articles .= '</td><td width="20"></td><td>';
			if ($marque != "") {
				$tab_articles .= $marque.' - ';
			}
			$tab_articles .= $designationClient;
			if ($options != "") {
				$tab_articles .= ' - '.$options;
			}
			$tab_articles .= '</td><td width="20"></td><td>';
			$tab_articles .= $reference;
			$tab_articles .= '</td><td width="20"></td><td align="right">';
			$tab_articles .= number_format($tarif_ht, 2 , ","," ").'&nbsp;&euro;';
			$tab_articles .= '</td></tr>';
			//$total_ht += $tarif_ht;
			//$total_tva += $tva;
		}
		$total_ttc = $total_ht + $total_tva;
		$tab_articles .= '<tr><td colspan="7" class="separation"><hr /></td></tr>';
		$tab_articles .= '<tr><td colspan="5" align="right">'._CATALOGTOTALHTCADDIE.'</td><td width="20"></td><td align="right">'.number_format($commande["total_ht"], 2 , ","," ").'&nbsp;&euro;</td></tr>';
		if ($commande["code_promo"] != "") {
			$tab_articles .= '<tr><td colspan="5" align="right">'._CATALOGTOTALREDUCCADDIE.'</td><td width="20"></td><td align="right">'.number_format($commande["reduc_ht"], 2 , ","," ").'&nbsp;&euro;</td></tr>';
		}
		$tab_articles .= '<tr><td colspan="5" align="right">'._CATALOGTOTALPORTCADDIE.'</td><td width="20"></td><td align="right">'.number_format($commande["port_ht"], 2 , ","," ").'&nbsp;&euro;</td></tr>';
		$tab_articles .= '<tr><td colspan="5" align="right">'._CATALOGTOTALTVACADDIE.'</td><td width="20"></td><td align="right">'.number_format($commande["total_tva"], 2 , ","," ").'&nbsp;&euro;</td></tr>';
		$tab_articles .= '<tr><td colspan="5" align="right">'._CATALOGTOTALTTCCOMMANDE.'</td><td width="20"></td><td align="right">'.number_format($commande["total_ttc"], 2 , ","," ").'&nbsp;&euro;</td></tr>';
		$tab_articles .= '</table>';
		
		list($civilite,$nom,$prenom,$societe,$adresse,$codepostal,$ville,$pays) = explode($seps["sep_champ"],$commande["client"]);
		$civilites = explode("//",_CLIENTCIVILITES);
		if ($civilite == $civilites[0]) {
			$civilite = "";
		}
		$client = "<p>".$civilite.$prenom." ".$nom;
		if ($societe != "") {
			$client .= "<br />".$societe;
		}
		if ($adresse != "") {
			$client .= "<br />".$adresse;
		}
		$client .= "<br />".$codepostal." ".$ville;
		if ($pays != "") {
			$client .= "<br />".$pays;
		}
		$client .= "</p>";
		
		$statuss = explode("//",_CATALOGCOMMANDSTATUS);
		$menuStatus = '<select name="status" size="1">';
		for ($i=0;$i<count($statuss);$i++) {
			if ($commande["status"] == $i) {
				$selected = ' selected="selected"';
			}
			else {
				$selected = "";
			}
			$menuStatus .= '<option value="'.$i.'"'.$selected.'>'.$statuss[$i].'</option>';
		}
		$menuStatus .= '</select>';
		
		$paids = explode("//",_CATALOGCOMMANDPAID);
		$menuPaye = '<select name="paye" size="1">';
		for ($i=0;$i<count($paids);$i++) {
			if ($commande["paye"] == $i) {
				$selected = ' selected="selected"';
			}
			else {
				$selected = "";
			}
			$menuPaye .= '<option value="'.$i.'"'.$selected.'>'.$paids[$i].'</option>';
		}
		$menuPaye .= '</select>';
		
		$reglements = explode("//",_CATALOGCOMMANDREGLEMENT);
		
		$facture = '';
		$facture .= "<p>"._CATALOGCOMMANDNUMBER.$commande["numero"]."<br />";
		$facture .= _CATALOGCOMMANDDATE.$this->date2JMA($commande["date"])."<br />";
		if ($commande["code_promo"] != "") {
			$facture .= _CATALOGCOMMANDCODEPROMO.$commande["code_promo"]."<br />";
		}
		$facture .= _CATALOGCOMMANDPORT.$commande["port"]."<br />";
		$facture .= _CATALOGCOMMANDCURRENTREGELEMENT.$reglements[$commande["reglement"]]."<br />";
		$facture .= _CATALOGCOMMANDCURRENTPAID.$menuPaye."<br />";
		$facture .= _CATALOGCOMMANDCURRENTSTATUS.$menuStatus."</p>";
		//"Id"=>"","id_client"=>"","client"=>"","date"=>"","numero"=>"","commande"=>"","total_ht"=>"","total_tva"=>"","total_ttc"=>"","status"=>""
		$facture .= '<input type="hidden" name="Id" value="'.$vars_mod[$vars_mod["id_command"]].'">';
		$facture .= '<input type="hidden" name="id_client" value="'.$commande["id_client"].'">';
		$facture .= '<input type="hidden" name="client" value="'.$this->conditionnerFORM($commande["client"]).'">';
		$facture .= '<input type="hidden" name="date" value="'.$commande["date"].'">';
		$facture .= '<input type="hidden" name="numero" value="'.$commande["numero"].'">';
		$facture .= '<input type="hidden" name="reglement" value="'.$commande["reglement"].'">';
		$facture .= '<input type="hidden" name="commande" value="'.$this->conditionnerFORM($commande["commande"]).'">';
		$facture .= '<input type="hidden" name="total_ht" value="'.$commande["total_ht"].'">';
		$facture .= '<input type="hidden" name="total_tva" value="'.$commande["total_tva"].'">';
		$facture .= '<input type="hidden" name="total_ttc" value="'.$commande["total_ttc"].'">';
		$facture .= '<input type="hidden" name="port_ht" value="'.$commande["port_ht"].'">';
		$facture .= '<input type="hidden" name="port" value="'.$commande["port"].'">';
		$facture .= '<input type="hidden" name="reduc_ht" value="'.$commande["reduc_ht"].'">';
		$facture .= '<input type="hidden" name="code_promo" value="'.$commande["code_promo"].'">';
		$facture .= '<input type="hidden" name="remarques" value="'.$this->conditionnerFORM($commande["remarques"]).'">';
		
		$remarques = "";
		if ($commande["remarques"] != "") {
			$remarques = "<hr />".nl2br($commande["remarques"]);
		}
		
		$var_en_plus = "";
		if ($criteres["page_en_cours"] != "1") {
			$var_en_plus .= "&".$vars_mod["page_en_cours"]."=".$criteres["page_en_cours"];
		}
		if ($vars_mod[$vars_mod["tri"]] != "") {
			$var_en_plus .= '&'.$vars_mod["tri"].'='.$vars_mod[$vars_mod["tri"]];
		}
		
		$formedit = '<form name="form1" action="system.php?op=command&onglet=command&'.$vars_mod["action"].'=save'.$var_en_plus.'" method="post">
			<center><table border="0" cellpadding="10" cellspacing="0" class="fichecommand"><tr><td>
			'.$client.$facture.$tab_articles.$remarques.'
			</td></tr></table></center>
			<center>&nbsp;<br /><input type="submit" name="valid_b" value="'._ARTICLESAVEEDIT.'"></center>
			</form>';
		return $formedit;
	}

/**
* Renvoie un tableau HTML listant toutes les commandes.
* 
* Ce tableau permet de modifier ou supprimer les commandes.
* @param array $My_SQL Paramtres de la base de donnes
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL
* @param array $seps Tableau contenant les sparateurs d'articles.
* @param array $criteres Tableau contenant les infos de pages.
* @return string Tableau HTML des commandes.
*/	
	function get_list_command ($My_SQL,$vars_mod,$seps,$criteres) {
		$critTriPlus = "";
		
		$nbreFiches = $this->sgbd->getNumCommandes($My_SQL);
		$nbrepages = ceil($nbreFiches/$criteres["articles_par_page"]);
		if ($criteres["page_en_cours"] > $nbrepages) {
			$criteres["page_en_cours"] = $nbrepages;
		}
		$indexPages = $this->catalog->getPagesIndex($vars_mod,$criteres, $nbreFiches,_CATALOGCOMMANDFOUNDPAGES,_CATALOGCOMMANDNOTFOUNDPAGES);
		$limInf = ($criteres["page_en_cours"]-1)*$criteres["articles_par_page"];
		$limit_article = $limInf.",".$criteres["articles_par_page"];
		
		$commandes = $this->sgbd->getCommandes($My_SQL,"","","",$vars_mod[$vars_mod["tri"]],$limit_article);
		$tri = "";
		if ($vars_mod[$vars_mod["tri"]] != "") {
			$tri = '&'.$vars_mod["tri"].'='.$vars_mod[$vars_mod["tri"]];
		}
		$var_en_plus = "";
		if ($criteres["page_en_cours"] != "1") {
			$var_en_plus = "&".$vars_mod["page_en_cours"]."=".$criteres["page_en_cours"];
		}
		
		$liste = $indexPages.'
				<table  class="lisTable">
				<tr class="systemTabHeader">
					<th class="systemTabHeader"><a href="system.php?'.$vars_mod["action"].'=list&op=command&onglet=command&'.$vars_mod["tri"].'=numero'.$critTriPlus.'">'._COMMANDONGLETNUMERO.'</a></th>
					<th class="systemTabHeader"><a href="system.php?'.$vars_mod["action"].'=list&op=command&onglet=command&'.$vars_mod["tri"].'=date'.$critTriPlus.'">'._COMMANDONGLETDATE.'</a></th>
					<th class="systemTabHeader"><a href="system.php?'.$vars_mod["action"].'=list&op=command&onglet=command&'.$vars_mod["tri"].'=client'.$critTriPlus.'">'._COMMANDONGLETCLIENT.'</a></th>
					<th class="systemTabHeader">'._COMMANDONGLETTOTALHT.'</th>
					<th class="systemTabHeader">'._COMMANDONGLETTOTALTTC.'</th>
					<th class="systemTabHeader">'._COMMANDONGLETPORT.'</th>
    					<th class="systemTabHeader"><a href="system.php?'.$vars_mod["action"].'=list&op=command&onglet=command&'.$vars_mod["tri"].'=paid'.$critTriPlus.'">'._COMMANDONGLETPAID.'</a></th>
					<th class="systemTabHeader"><a href="system.php?'.$vars_mod["action"].'=list&op=command&onglet=command&'.$vars_mod["tri"].'=status'.$critTriPlus.'">'._COMMANDONGLETSTATUS.'</a></th>
					<th class="systemTabHeader">'._COMMANDONGLETCACTION.'</th>
    				</tr>';
		$pos=0;
		if (count($commandes) != 0) {
			foreach ($commandes as $commande) {
				list($civilite,$nom,$prenom,$societe,$adresse,$codepostal,$ville,$pays) = explode($seps["sep_champ"],$commande["client"]);
				$civilites = explode("//",_CLIENTCIVILITES);
				if ($civilite == $civilites[0]) {
					$civilite = "";
				}
				$client = $civilite.$nom." ".$prenom;
				if ($societe != "") {
					$client .= ", ".$societe;
				}
				$client .= ", ".$ville;
				if ($pays != "") {
					$client .= ", ".$pays;
				}
				
				if ($commande["paye"] =="1") {
					$paye = '<input type="checkbox" value="" checked="checked" disabled="disabled" />';
				}
				else {
					$paye = '<input type="checkbox" value="" disabled="disabled" />';
				}
				
				$barDef=array(	"edit"=> array( "text"=>_EDIT,"icon"=>"edit_16x16.png","url"=>"system.php?op=command&onglet=command&".$vars_mod["action"]."=edit&".$vars_mod["id_command"]."=".$commande["Id"].$tri.$var_en_plus,"comment"=>_EDIT, "status"=>"ON"),
  					  			"delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png","url"=>"system.php?op=command&onglet=command&".$vars_mod["action"]."=delete&".$vars_mod["id_command"]."=".$commande["Id"].$tri.$var_en_plus,"comment"=>_DELETE,"status"=>"ON"));
				
				if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
				$pos++;
				
				$statuss = explode("//",_CATALOGCOMMANDSTATUS);
				
				$liste .= '<tr class="'.$thestyle.'">';
				$liste .= '<td>';
				$liste .= "<b>".$this->conditionnerHTML($commande["numero"])."</b>";
				$liste .= '</td><td align="center">';
				$liste .= $this->date2JMA($commande["date"]);
				$liste .= '</td><td align="center">';
				$liste .= $this->conditionnerHTML($client);
				$liste .= '</td><td align="center">';
				$liste .= $this->conditionnerHTML($commande["total_ht"] + $commande["port_ht"] +$commande["reduc_ht"]);
				$liste .= '</td><td align="center">';
				$liste .= $this->conditionnerHTML($commande["total_ttc"]);
				$liste .= '</td><td align="center">';
				$liste .= $this->conditionnerHTML($commande["port"]);
				$liste .= '</td><td align="center">';
				$liste .= $paye;
				$liste .= '</td><td align="center">';
				$liste .= $this->conditionnerHTML($statuss[$commande["status"]]);
				$liste .= '</td><td align="center">';
				$liste .= displayActionBar("add","Bar d'action",$barDef,"img","",true);
				$liste .= '</td>';
				$liste .= '</tr>';
			}
			
		}
		$liste .= '</table>';
		return $liste;
	}

/**
* Enregistre une commande.
* 
* Cette fonction n'est utilise que pour la modification d'une commande.
* @param array $My_SQL Paramtres de la base de donnes.
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
* @param array $new_command Tableau contenant la commande  enregistrer.
* @return boolean Retourne true si la commande a t enregistre et false sinon.
*/
	function save_commande ($My_SQL,$vars_mod,$new_command) {
		return $this->sgbd->saveCommande($My_SQL,$new_command);
	}

/**
* Demande confirmation de la suppression de l'lment dsign.
* @param array $My_SQL Paramtres de la base de donnes
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
* @param message $message Message affich  l'utilisateur pour confirmer la suppression
* @return string Message  afficher en HTML.
*/	
	function confirm_delete($My_SQL,$vars_mod,$message) {
		$sortie = "<p>$message</p>";
		$sortie .= "<p>&nbsp;</p>";
		$sortie .= "<p>";
		if ($vars_mod[$vars_mod["action"]] == "delete") {
			$tri = "";
			if ($vars_mod[$vars_mod["tri"]] != "") {
				$tri = '&'.$vars_mod["tri"].'='.$vars_mod[$vars_mod["tri"]];
			}
			$sortie .= '<a href="system.php?op=command&onglet=command&'.$vars_mod["action"].'='.$vars_mod[$vars_mod["action"]].'&'.$vars_mod["id_command"].'='.$vars_mod[$vars_mod["id_command"]].$tri.'&'.$vars_mod["confirm"].'=y">';
		
			$sortie .= "["._ARTICLECONFSUPPROUI."]";
			$sortie .= "</a>";
			$sortie .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
			$sortie .= '<a href="javascript:window.history.back()">';
			$sortie .= "["._ARTICLECONFSUPPRNON."]";
			$sortie .= '</a>';
		}
		$sortie .= "</p>";
		return $sortie;
	}

/**
* Supprime la commande dsigne et renvoie le rsultat de l'opration en HTML.
* @param array $My_SQL Paramtres de la base de donnes.
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
* @return string Rsultat de l'opration en HTML.
*/
	function delete_command($My_SQL,$vars_mod) {
		if ($this->sgbd->delCommande($My_SQL,$vars_mod[$vars_mod["id_command"]])) {
			$sortie = _CATALOGDELOK;
		}
		else {
			$sortie = _CATALOGDELPASOK;
		}
		return $sortie;
	}

/**
* Rcupre la valeur de l'indentifiant du dernier enregistrement cr.
* @param array $My_SQL Paramtres de la base de donnes
* @return integer Identifiant
*/
	function getLastId($My_SQL) {
		return $this->sgbd->getLastId($My_SQL);
	}
	
/**
* Prpare les donnes  tre enregistres dans la base de donnes en codant les apostrophes.
* @param string $texte Texte  prparer
* @return string Texte encod.
*/
	function conditionnertodb($texte) {
		//$texte = utf8_encode($texte);
		return (str_replace("'","''",stripslashes($texte)));
	}

/**
* Prpare les donnes  tre affiches en HTML.
* @param string $texte Texte  prparer
* @return string Texte encod.
*/
	function conditionnerHTML($texte) {
		//return (htmlentities($texte,ENT_QUOTES,UTF-8));
		return $texte;
	}

/**
* Prpare les donnes  tre envoyes aux procdures Javascript.
* @param string $texte Texte  prparer
* @return string Texte encod.
*/
	function conditionnerJS($texte, $doubleSlash=false) {
		if ($doubleSlash) {
			$texte = str_replace('"','\\\\"',$texte);
		}
		else {
			$texte = str_replace('"','\"',$texte);
		}
		$texte = str_replace("\n",'\n',$texte);
		$texte = str_replace("\r","",$texte);
		return $texte;
	}

/**
* Prpare les donnes  tre incluses dans les formulaires.
* @param string $texte Texte  prparer
* @return string texte encod.
*/
	function conditionnerFORM($texte) {
		return (str_replace('"','&quot;',$texte));
	}

/**
* Convertit une date du format Anne-Mois-Jour (SQL) au format Jour/Mois/Anne (Franais).
* @param string $ladate Date  convertir.
* @return string Date convertie.
*/
	function date2JMA($ladate){
		if ($ladate == "0000-00-00") {
			return "";
		}
		else {
			list($an,$mois,$jour) = explode("-",$ladate);
			return $jour."/".$mois."/".$an;
		}
	}

/**
* Convertit une date du format Jour/Mois/Anne (Franais) au format Anne-Mois-Jour (SQL).
* @param string $ladate Date  convertir.
* @return string Date convertie.
*/
	function date2AMJ($ladate){
		if ($ladate == "") {
			return "0000-00-00";
		}
		else {
			list($jour,$mois,$annee) = explode("/",$ladate);
			$jour = str_pad($jour, 2, "0",STR_PAD_LEFT);
			$mois = str_pad($mois, 2, "0",STR_PAD_LEFT);
			if (strlen($annee) == 2) {
				$annee = "20".$annee;
			}
			elseif (strlen($annee) == 1) {
				$annee = "200".$annee;
			}
		}
		return "$annee-$mois-$jour";
	}
}

/**
* Classe des fonctions d'aministration des promotions.
* 
* Cette clase contient galement les fonctions utiles (mise en forme de texte, conversion de format de date,...).
* @package becmsSimpleCatalog
*/
class adminPromo {
/**
* @var object Classe qui donne accs au fonctions de manipulation des promotions.
*/		
	var $sgbd;
/**
* @var object Classe qui donne accs au fonctions de manipulation des articles.
*/		
	var $catalog;
/**
* Initialise $sgbd avec la classe des fonctions d'accs  la base de donnes des commandes
*/	
	function adminPromo() {
		$this->sgbd = new BD_Promo();
		$this->catalog = new adminCatalog();
	}

/**
* Renvoie la promo dsigne.
* 
* Si la promo est introuvable ou que son identifiant est -1, une promo vide est retourne.
* @param array $My_SQL Paramtres de la base de donnes.
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
* @return array Tableau contenant la promo.
*/		
	function get_promo_edit($My_SQL,$vars_mod) {
		if ($vars_mod[$vars_mod["id_promo"]] != "-1") { 
			$promoEdit = $this->sgbd->getPromo($My_SQL,$vars_mod[$vars_mod["id_promo"]]);
			if (count($promoEdit) == 0) {
				$promoEdit = array("Id"=>"-1","code"=>"","debut"=>"0000-00-00","fin"=>"0000-00-00","pourcent"=>"","somme"=>"","noport"=>"","seuil"=>"","multiple"=>"");
			}
			else {
				$promoEdit = $promoEdit[0];
			}
		}
		else {
			$promoEdit = array("Id"=>"-1","code"=>"","debut"=>"0000-00-00","fin"=>"0000-00-00","pourcent"=>"","somme"=>"","noport"=>"","seuil"=>"","multiple"=>"");
		}
		return $promoEdit;
	}

/**
* Renvoie le formulaire de modifification de promotion.
* @param array $My_SQL Paramtres de la base de donnes.
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
* @param array $criteres Tableau contenant les critres d'affichage des promotions.
* @return string Formulaire HTML de modification de la promotion.
*/
	function edit_promo($My_SQL,$vars_mod,$criteres) {
		$promoEdit = $this->get_promo_edit($My_SQL,$vars_mod);
		$promoEdit["debut"] = $this->date2JMA($promoEdit["debut"]);
		$promoEdit["fin"] = $this->date2JMA($promoEdit["fin"]);
		if ($promoEdit["noport"] == "1") {
			$checked = " checked=\"checked\"";
		}
		else {
			$checked = "";
		}
		if ($promoEdit["multiple"] == "1") {
			$checked2 = " checked=\"checked\"";
		}
		else {
			$checked2 = "";
		}
		$var_en_plus = "";
		if ($criteres["page_en_cours"] != "1") {
			$var_en_plus .= "&".$vars_mod["page_en_cours"]."=".$criteres["page_en_cours"];
		}
		if ($vars_mod[$vars_mod["tri"]] != "") {
			$var_en_plus .= '&'.$vars_mod["tri"].'='.$vars_mod[$vars_mod["tri"]];
		}
		
		$produits = $this->catalog->sgbd->getArticles($My_SQL,"","designation_F");
		$menuproduit = '<select name="id_produit" size="1" class="saisie_long">';
		foreach($produits as $unproduit) {
			$selected = '';
			if ($promoEdit["id_produit"] == $unproduit["Id"]) {
				$selected = ' selected="select"';
			}
			$menuproduit .= '<option value="'.$unproduit["Id"].'"'.$selected.'>'.$unproduit["designation_F"].'</option>'; 
		}
		$menuproduit .= '</select>';
		
		$formedit = '
		<center>
		<div class="boite_article">
		<form name="form1" action="system.php?op=promo&onglet=promo&'.$vars_mod["action"].'=save'.$var_en_plus.'" method="post" onsubmit="return verif_promo(this);">
		<table class="saisiecatalog" border="0" cellspacing="2" cellpadding="0">
			<tr>
				<td>'._ARTICLEEDITPROMOCODE.'</td>
				<td width="10"></td>
				<td><input class="saisie_long" type="text" name="code" size="16" value="'.$promoEdit["code"].'" /></td>
			</tr>
			<tr>
				<td>'._ARTICLEEDITPROMODEB.'</td>
				<td width="10"></td>
				<td><input class="saisie_long" type="text" name="debut" size="16" value="'.$promoEdit["debut"].'" onfocus="showPopUpCal(this)" /></td>
			</tr>
			<tr>
				<td>'._ARTICLEEDITPROMOFIN.'</td>
				<td width="10"></td>
				<td><input class="saisie_long" type="text" name="fin" size="16" value="'.$promoEdit["fin"].'" onfocus="showPopUpCal(this)" /></td>
			</tr>
			<tr>
				<td>Produit concern : </td>
				<td width="10"></td>
				<td>'.$menuproduit.'</td>
			</tr>
			<tr>
				<td>'._ARTICLEEDITPROMOSEUIL.'</td>
				<td width="10"></td>
				<td><input class="saisie_long" type="text" name="seuil" size="16" value="'.$promoEdit["seuil"].'" /></td>
			</tr>
			<tr>
				<td>'._ARTICLEEDITPROMOPOURCENT.'</td>
				<td width="10"></td>
				<td><input class="saisie_long" type="text" name="pourcent" size="16" value="'.$promoEdit["pourcent"].'" /></td>
			</tr>
			<tr>
				<td>'._ARTICLEEDITPROMOSOMME.'</td>
				<td width="10"></td>
				<td><input class="saisie_long" type="text" name="somme" size="16" value="'.$promoEdit["somme"].'" /></td>
			</tr>
			<tr>
				<td>'._ARTICLEEDITPROMOPORT.'</td>
				<td width="10"></td>
				<td><input type="checkbox" name="noport" value="1"'.$checked.'></td>
			</tr>
			<tr>
				<td>'._ARTICLEEDITPROMOMULTIPLE.'</td>
				<td width="10"></td>
				<td><input type="checkbox" name="multiple" value="1"'.$checked2.'></td>
			</tr>
			<tr>
				<td colspan="3" align="center">'._ARTICLEEDITPROMOCOMMENT.'</td>
			</tr>
		</table>
		<p><input type="hidden" value="'.$promoEdit["Id"].'" name="'.$vars_mod["id_promo"].'"><input type="submit" name="valid" value="'._ARTICLESAVEEDIT.'"></p>
		</form>
		</div>
		</center>
<script src="'.$vars_mod["cheminModule"].'/lib/lib_autostart.js" type="text/javascript"></script>
<link href="'.$vars_mod["cheminModule"].'lib/style-calendar.css" rel="stylesheet" type="text/css" media="all" />
<script src="'.$vars_mod["cheminModule"].'lib/lib_cal.js" type="text/javascript"></script>
<script type="text/javascript">
 //<![CDATA[
	function verif_promo(formulaire) {
		if (formulaire.code.value == "") {
			alert("'._ARTICLEVERIFPROMOCODE.'");
			return false;
		}
		if (formulaire.pourcent.value == "") {
			formulaire.pourcent.value = "0";
		}
		if (formulaire.somme.value == "") {
			formulaire.somme.value = "0";
		}
		if (formulaire.seuil.value == "") {
			formulaire.seuil.value = "0";
		}
		return true;
	}
	
	addToStart(newPopUpCal);
    //]]>
</script>';
		return $formedit;
	}

/**
* Renvoie un tableau HTML listant toutes les promotions.
* 
* Ce tableau permet de modifier ou supprimer les promotions.
* @param array $My_SQL Paramtres de la base de donnes
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL
* @param array $criteres Tableau contenant les infos de page.
* @return string Tableau HTML des promotions.
*/	
	function get_list_promo ($My_SQL,$vars_mod,$criteres) {
		$critTriPlus = "";
		
		$nbreFiches = $this->sgbd->getNumPromos($My_SQL);
		$nbrepages = ceil($nbreFiches/$criteres["articles_par_page"]);
		if ($criteres["page_en_cours"] > $nbrepages) {
			$criteres["page_en_cours"] = $nbrepages;
		}
		$indexPages = $this->catalog->getPagesIndex($vars_mod,$criteres, $nbreFiches,_PROMOFOUNDPAGES,_PROMONOTFOUNDPAGES);
		$limInf = ($criteres["page_en_cours"]-1)*$criteres["articles_par_page"];
		$limit_article = $limInf.",".$criteres["articles_par_page"];
		
		$promos = $this->sgbd->getPromo($My_SQL,"","",$vars_mod[$vars_mod["tri"]],$limit_article);
		$tri = "";
		if ($vars_mod[$vars_mod["tri"]] != "") {
			$tri = '&'.$vars_mod["tri"].'='.$vars_mod[$vars_mod["tri"]];
		}
		$var_en_plus = "";
		if ($criteres["page_en_cours"] != "1") {
			$var_en_plus = "&".$vars_mod["page_en_cours"]."=".$criteres["page_en_cours"];
		}
		
		$liste = $indexPages.'
				<table  class="lisTable">
				<tr class="systemTabHeader">
					<th class="systemTabHeader"><a href="system.php?'.$vars_mod["action"].'=list&op=promo&onglet=promo&'.$vars_mod["tri"].'=code'.$critTriPlus.'">'._PROMOONGLETCODE.'</a></th>
					<th class="systemTabHeader"><a href="system.php?'.$vars_mod["action"].'=list&op=promo&onglet=promo&'.$vars_mod["tri"].'=date'.$critTriPlus.'">'._PROMOONGLETPERIOD.'</a></th>
					<th class="systemTabHeader">'._PROMOONGLETSEUIL.'</th>
					<th class="systemTabHeader">'._PROMOONGLETPOURCENT.'</th>
					<th class="systemTabHeader">'._PROMOONGLETREMISE.'</th>
					<th class="systemTabHeader">'._PROMOONGLETNOPORT.'</th>
					<th class="systemTabHeader">'._PROMOONGLETMULTIPLE.'</th>
					<th class="systemTabHeader">'._COMMANDONGLETCACTION.'</th>
    			</tr>';
		$pos=0;
		if (count($promos) != 0) {
			foreach ($promos as $promo) {
				$period = "";
				
				if ($promo["noport"] =="1") {
					$noport = '<input type="checkbox" value="" checked="checked" disabled="disabled" />';
				}
				else {
					$noport = '<input type="checkbox" value="" disabled="disabled" />';
				}
				if ($promo["multiple"] =="1") {
					$multiple = '<input type="checkbox" value="" checked="checked" disabled="disabled" />';
				}
				else {
					$multiple = '<input type="checkbox" value="" disabled="disabled" />';
				}
				
				$barDef=array(	"edit"=> array( "text"=>_EDIT,"icon"=>"edit_16x16.png","url"=>"system.php?op=promo&onglet=promo&".$vars_mod["action"]."=edit&".$vars_mod["id_promo"]."=".$promo["Id"].$tri.$var_en_plus,"comment"=>_EDIT, "status"=>"ON"),
  					  			"delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png","url"=>"system.php?op=promo&onglet=promo&".$vars_mod["action"]."=delete&".$vars_mod["id_promo"]."=".$promo["Id"].$tri.$var_en_plus,"comment"=>_DELETE,"status"=>"ON"));
				
				if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
				$pos++;
				
				$liste .= '<tr class="'.$thestyle.'">';
				$liste .= '<td>';
				$liste .= "<b>".$this->conditionnerHTML($promo["code"])."</b>";
				$liste .= '</td><td align="center">';
				if ($promo["debut"] != "" && $promo["debut"] != "0000-00-00") {
					$liste .= _PROMOONGLETFROM.$this->date2JMA($promo["debut"]);
				}
				if ($promo["fin"] != "" && $promo["fin"] != "0000-00-00") {
					$liste .= _PROMOONGLETTO.$this->date2JMA($promo["fin"]);
				}
				$liste .= '</td><td align="center">';
				$liste .= $this->conditionnerHTML($promo["seuil"]);
				$liste .= '</td><td align="center">';
				$liste .= $this->conditionnerHTML($promo["pourcent"]);
				$liste .= '</td><td align="center">';
				$liste .= $this->conditionnerHTML($promo["somme"]);
				$liste .= '</td><td align="center">';
				$liste .= $noport;
				$liste .= '</td><td align="center">';
				$liste .= $multiple;
				$liste .= '</td><td align="center">';
				$liste .= displayActionBar("add","Bar d'action",$barDef,"img","",true);
				$liste .= '</td>';
				$liste .= '</tr>';
			}
			
		}
		$liste .= '</table>';
		return $liste;
	}

/**
* Enregistre une promotion.
* 
* Cette fonction n'est utilise que pour la modification d'une promotion.
* @param array $My_SQL Paramtres de la base de donnes.
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
* @param array $new_promo Tableau contenant la promotion  enregistrer.
* @return boolean Retourne true si la promotion a t enregistre et false sinon.
*/
	function save_promo ($My_SQL,$vars_mod,$new_promo) {
		$new_promo["debut"] = $this->date2AMJ($new_promo["debut"]);
		$new_promo["fin"] = $this->date2AMJ($new_promo["fin"]);
		
		$new_promo["pourcent"] = $this->str2dec($new_promo["pourcent"]);
		$new_promo["somme"] = $this->str2dec($new_promo["somme"]);
		$new_promo["seuil"] = $this->str2dec($new_promo["seuil"]);
		return $this->sgbd->savePromo($My_SQL,$new_promo);
	}

/**
* Demande confirmation de la suppression de l'lment dsign.
* @param array $My_SQL Paramtres de la base de donnes
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
* @param message $message Message affich  l'utilisateur pour confirmer la suppression
* @return string Message  afficher en HTML.
*/	
	function confirm_delete($My_SQL,$vars_mod,$message) {
		$sortie = "<p>$message</p>";
		$sortie .= "<p>&nbsp;</p>";
		$sortie .= "<p>";
		if ($vars_mod[$vars_mod["action"]] == "delete") {
			$tri = "";
			if ($vars_mod[$vars_mod["tri"]] != "") {
				$tri = '&'.$vars_mod["tri"].'='.$vars_mod[$vars_mod["tri"]];
			}
			$sortie .= '<a href="system.php?op=promo&onglet=promo&'.$vars_mod["action"].'='.$vars_mod[$vars_mod["action"]].'&'.$vars_mod["id_promo"].'='.$vars_mod[$vars_mod["id_promo"]].$tri.'&'.$vars_mod["confirm"].'=y">';
		
			$sortie .= "["._ARTICLECONFSUPPROUI."]";
			$sortie .= "</a>";
			$sortie .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
			$sortie .= '<a href="javascript:window.history.back()">';
			$sortie .= "["._ARTICLECONFSUPPRNON."]";
			$sortie .= '</a>';
		}
		$sortie .= "</p>";
		return $sortie;
	}

/**
* Supprime la promo dsigne et renvoie le rsultat de l'opration en HTML.
* @param array $My_SQL Paramtres de la base de donnes.
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
* @return string Rsultat de l'opration en HTML.
*/
	function delete_promo($My_SQL,$vars_mod) {
		if ($this->sgbd->delPromo($My_SQL,$vars_mod[$vars_mod["id_promo"]])) {
			$sortie = _CATALOGDELOK;
		}
		else {
			$sortie = _CATALOGDELPASOK;
		}
		return $sortie;
	}

/**
* Rcupre la valeur de l'indentifiant du dernier enregistrement cr.
* @param array $My_SQL Paramtres de la base de donnes
* @return integer Identifiant
*/
	function getLastId($My_SQL) {
		return $this->sgbd->getLastId($My_SQL);
	}
	
/**
* Prpare les donnes  tre enregistres dans la base de donnes en codant les apostrophes.
* @param string $texte Texte  prparer
* @return string Texte encod.
*/
	function conditionnertodb($texte) {
		//$texte = utf8_encode($texte);
		return (str_replace("'","''",stripslashes($texte)));
	}

/**
* Prpare les donnes  tre affiches en HTML.
* @param string $texte Texte  prparer
* @return string Texte encod.
*/
	function conditionnerHTML($texte) {
		//return (htmlentities($texte,ENT_QUOTES,UTF-8));
		return $texte;
	}

/**
* Prpare les donnes  tre envoyes aux procdures Javascript.
* @param string $texte Texte  prparer
* @return string Texte encod.
*/
	function conditionnerJS($texte, $doubleSlash=false) {
		if ($doubleSlash) {
			$texte = str_replace('"','\\\\"',$texte);
		}
		else {
			$texte = str_replace('"','\"',$texte);
		}
		$texte = str_replace("\n",'\n',$texte);
		$texte = str_replace("\r","",$texte);
		return $texte;
	}

/**
* Prpare les donnes  tre incluses dans les formulaires.
* @param string $texte Texte  prparer
* @return string texte encod.
*/
	function conditionnerFORM($texte) {
		return (str_replace('"','&quot;',$texte));
	}

/**
* Convertit une date du format Anne-Mois-Jour (SQL) au format Jour/Mois/Anne (Franais).
* @param string $ladate Date  convertir.
* @return string Date convertie.
*/
	function date2JMA($ladate){
		if ($ladate == "0000-00-00") {
			return "";
		}
		else {
			list($an,$mois,$jour) = explode("-",$ladate);
			return $jour."/".$mois."/".$an;
		}
	}

/**
* Convertit une date du format Jour/Mois/Anne (Franais) au format Anne-Mois-Jour (SQL).
* @param string $ladate Date  convertir.
* @return string Date convertie.
*/
	function date2AMJ($ladate){
		if ($ladate == "") {
			return "0000-00-00";
		}
		else {
			list($jour,$mois,$annee) = explode("/",$ladate);
			$jour = str_pad($jour, 2, "0",STR_PAD_LEFT);
			$mois = str_pad($mois, 2, "0",STR_PAD_LEFT);
			if (strlen($annee) == 2) {
				$annee = "20".$annee;
			}
			elseif (strlen($annee) == 1) {
				$annee = "200".$annee;
			}
		}
		return "$annee-$mois-$jour";
	}
	
/**
* Formate une valeur numrique du format Franais vers le format PHP.
* @param string $ladate Date  convertir.
* @return string Date convertie.
*/
	function str2dec($valeur) {
		$valeur = str_replace(",",".",$valeur);
		$valeur = str_replace(" ","",$valeur);
		return $valeur;
	}
}
?>