<?php
/**
* Fichier d'initialisation des variables pour le module de catalogue.
* 
* @package becmsSimpleCatalog 
* @author Vincent RUIZ <webmaster@arobase.fr>
* @copyright Copyright  2007, Vincent RUIZ
* @version 1.0
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*/

//contient le nom des variables  passer pour le fonctionnement du caddie
require_once("g_db.php");

if (!isset($fromBoard)) {
	$fromBoard = false;
}
if (!$fromBoard) {
	$db_session = new BD_Sessions_catalog(); 
	session_set_save_handler(array(&$db_session,"open"), 
							 array(&$db_session,"close"), 
							 array(&$db_session,"read"), 
							 array(&$db_session,"write"), 
							 array(&$db_session,"destroy"), 
							 array(&$db_session,"gc"));
	session_start();
}
/**
 * $var array $My_SQL Tableau contenant les paramtres d'accs  la base de donnes
 */
if (!isset($My_SQL)) {
	$My_SQL = array();
}
$My_SQL["articles"] = "becms_commerce_catalog";
$My_SQL["categories"] = "becms_commerce_categories";
$My_SQL["liens-cat"] = "becms_commerce_liens_cat";
$My_SQL["arbo"] = "becms_commerce_categories_arbo";
$My_SQL["solde"] = "becms_commerce_soldes";
$My_SQL["clients"] = "becms_clients";
$My_SQL["commandes"] = "becms_commerce_commandes";
$My_SQL["pays"] = "becms_commerce_pays";
$My_SQL["ports"] = "becms_commerce_port";
$My_SQL["promos"] = "becms_commerce_promos";
$My_SQL["tempcomm"] = "becms_commerce_comm_temp";
$My_SQL["tarifs"] = "becms_commerce_tarifs";
/**
 *Quelques variables d'initialisation
 */
$cheminModule = "modules/$module_name/";
$cheminPhotos = "catalog_repository/simple_catalog";
$photo_width_max = 1024;
$photo_height_max = 1024;
$photo_qualite = 80;
$longueurtextedescr = 100;
$longueurtextedesign = 35;
$tva_def = "20.00";

$langue_commercant = "_F";

/**
 * Quelques variables utiles
 */
$seps = array("sep_article" => "<<>>", "sep_champ" => "<>", "sep_option" => "\n", "sep_valeur" => "/");

/**
* E-mail du commerant
*/
//$vars_mail = array("from" => "webmaster@arobase.fr", "nom" => "Vincent RUIZ Commercant");
//$vars_mail = array("from" => "info@nanarella.com", "nom" => "Antoinette NUNZI");
//$vars_mail = array("from" => "magina@free.fr", "nom" => "Vincent RUIZ");
$vars_mail = array("from" => $catalogmailadmin, "nom" => $catalogmailname);

/**
* Type de formulaire de recherche
*/
//$type_search = "CMR";//"C":Catgorie - "M":Marque - "R":Rfrence //peut tre n'importe quelle combinaison de ces lettres
$type_search = $catalogwithcat.$catalogwithtm.$catalogwithref;
/**
* Utilisation de codes promotionnels
*/
//$use_code_promo = true;//true : affichage du dialogue de saisie du code - false : pas de dialogue de saisie
$use_code_promo = ($catalogusepromo == "1");
/**
* type d'affichage par dfaut : grille ("display_grid") ou liste ("display")
*/
//$default_display_article = "display_grid";
$default_display_article = $catalogkindlist;
$sop = testinit_catalog($GLOBALS["sop"],$default_display_article);
/**
 * rcup du caddie
 */
$new_caddie = "";
for ($i=0;$i<count($GLOBALS["caddie_Id"]);$i++) {
	if (is_numeric($GLOBALS["caddie_nbre"][$i])) {
		$GLOBALS["caddie_nbre"][$i] = abs($GLOBALS["caddie_nbre"][$i]);
	}
	else {
		$GLOBALS["caddie_nbre"][$i] = "1";
	}
	if ($GLOBALS["caddie_nbre"][$i] != "" && $GLOBALS["caddie_nbre"][$i] != "0") {
		if ($new_caddie != "") {
			$new_caddie .= $seps["sep_article"];
		}
		$new_caddie .= $GLOBALS["caddie_Id"][$i].$seps["sep_champ"].$GLOBALS["caddie_nbre"][$i].$seps["sep_champ"].$GLOBALS["caddie_options"][$i];
	}
}


if ($GLOBALS["articles_group"] != "") {
	$GLOBALS["groupdelarticle"] = explode("/", $GLOBALS["articles_group"]);
}
if (!isset($GLOBALS["groupdelarticle"])) {
	$GLOBALS["groupdelarticle"] = array();
}
/**
 * $var array $vars_mod Tableau contenant le nom et le contenu des variables passes dans l'URL, par la mthode GET ou par POST
 */
$vars_mod = array(
	"page_en_cours"=>"pagecat",
	"action" => "act",
	"id_promo" => "Id",
	"id_article" => "Id",
	"id_port" => "Id",
	"id_command" => "Id",
	"id_solde" => "Id",
	"id_tarif" => "Id",
	"id_categorie" => "Idc",
	"id_cat_arbo" => "Ida",
	"def_cats_arbo"=>"id_arb",
	"cheminModule" => $cheminModule,
	"confirm" => "ok",
	"tri" => "order",
	"cheminPhotos" => $cheminPhotos,
	"photo_width_max" => $photo_width_max,
	"photo_height_max" => $photo_height_max, 
	"photo_qualite" => $photo_qualite,
	"num_comm" => "command",
	"mailclient" => "email",
	"longueurtextedescr" => $longueurtextedescr,
	"longueurtextedesign" => $longueurtextedesign,
	"type_search" => $type_search,
	"use_code_promo"=> $use_code_promo,
	"default_list" => $default_display_article,
	"autorisation" => "auto",
	"group_articles" => $GLOBALS["groupdelarticle"],
	"id_produit" => $GLOBALS["id_produit"],
	"tva_def" => $tva_def
);

if (!isset($GLOBALS[$vars_mod["autorisation"]])) {
	$vars_mod[$vars_mod["autorisation"]] = "";
}
else {
	$vars_mod[$vars_mod["autorisation"]] = $GLOBALS[$vars_mod["autorisation"]];
}

if (!isset($GLOBALS[$vars_mod["action"]])) {
	$vars_mod[$vars_mod["action"]] = "list";
}
else {
	$vars_mod[$vars_mod["action"]] = $GLOBALS[$vars_mod["action"]];
}

if (!isset($GLOBALS[$vars_mod["id_article"]])) {
	$vars_mod[$vars_mod["id_article"]] = -1;
}
else {
	$vars_mod[$vars_mod["id_article"]] = $GLOBALS[$vars_mod["id_article"]];
}

if (!isset($GLOBALS[$vars_mod["id_tarif"]])) {
	$vars_mod[$vars_mod["id_tarif"]] = -1;
}
else {
	$vars_mod[$vars_mod["id_tarif"]] = $GLOBALS[$vars_mod["id_tarif"]];
}

if (!isset($GLOBALS[$vars_mod["id_categorie"]])) {
	$vars_mod[$vars_mod["id_categorie"]] = -1;
}
else {
	$vars_mod[$vars_mod["id_categorie"]] = $GLOBALS[$vars_mod["id_categorie"]];
}

if (!isset($GLOBALS[$vars_mod["id_solde"]])) {
	$vars_mod[$vars_mod["id_solde"]] = -1;
}
else {
	$vars_mod[$vars_mod["id_solde"]] = $GLOBALS[$vars_mod["id_solde"]];
}

if (!isset($GLOBALS[$vars_mod["id_cat_arbo"]])) {
	$vars_mod[$vars_mod["id_cat_arbo"]] = -1;
}
else {
	$vars_mod[$vars_mod["id_cat_arbo"]] = $GLOBALS[$vars_mod["id_cat_arbo"]];
}

if (!isset($GLOBALS[$vars_mod["id_port"]])) {
	$vars_mod[$vars_mod["id_port"]] = -1;
}
else {
	$vars_mod[$vars_mod["id_port"]] = $GLOBALS[$vars_mod["id_port"]];
}

if (!isset($GLOBALS[$vars_mod["def_cats_arbo"]])) {
	$vars_mod[$vars_mod["def_cats_arbo"]] = 2;
}
else {
	$vars_mod[$vars_mod["def_cats_arbo"]] = $GLOBALS[$vars_mod["def_cats_arbo"]];
}

if (!isset($GLOBALS[$vars_mod["confirm"]])) {
	$vars_mod[$vars_mod["confirm"]] = "n";
}
else {
	$vars_mod[$vars_mod["confirm"]] = $GLOBALS[$vars_mod["confirm"]];
}
if (!isset($GLOBALS[$vars_mod["tri"]])) {
	$vars_mod[$vars_mod["tri"]] = "";
}
else {
	$vars_mod[$vars_mod["tri"]] = $GLOBALS[$vars_mod["tri"]];
}

if (!isset($GLOBALS[$vars_mod["num_comm"]])) {
	$vars_mod[$vars_mod["num_comm"]] = "";
}
else {
	$vars_mod[$vars_mod["num_comm"]] = $GLOBALS[$vars_mod["num_comm"]];
}

if (!isset($GLOBALS[$vars_mod["mailclient"]])) {
	$vars_mod[$vars_mod["mailclient"]] = "";
}
else {
	$vars_mod[$vars_mod["mailclient"]] = $GLOBALS[$vars_mod["mailclient"]];
}

function testinit_catalog(&$valeur,$valeurinit="") {
	if (!isset($valeur)) {
		return $valeurinit;
	}
	return $valeur;
}

$vars_mod["sortie_action"] = "";

$_SESSION["id_s_client"] = testinit_catalog($_SESSION["id_s_client"]);
$_SESSION["nom_client"] = testinit_catalog($_SESSION["nom_client"],array());
if (testinit_catalog($GLOBALS["choixport"],"-1") != "-1") {
	$_SESSION["id_port"] = $GLOBALS["choixport"];
}
else {
	$_SESSION["id_port"] = testinit_catalog($_SESSION["id_port"],"-1");
}
if (testinit_catalog($GLOBALS["choixreglement"],"-1") != "-1") {
	$_SESSION["id_reglement"] = $GLOBALS["choixreglement"];
}
else {
	$_SESSION["id_reglement"] = testinit_catalog($_SESSION["id_reglement"],"-1");
}
if (testinit_catalog($GLOBALS["promo_code"]) != "") {
	$_SESSION["code_s_promo"] = $GLOBALS["promo_code"];
}
else {
	$_SESSION["code_s_promo"] = testinit_catalog($_SESSION["code_s_promo"]);
}
if (testinit_catalog($GLOBALS["remarques"]) != "") {
	$_SESSION["lesremarques"] = $GLOBALS["remarques"];
}
else {
	$_SESSION["lesremarques"] = testinit_catalog($_SESSION["lesremarques"]);
}
$_SESSION["paie-total"] = testinit_catalog($_SESSION["paie-total"],0.0);
$_SESSION["paie-refcomm"] = testinit_catalog($_SESSION["paie-refcomm"],"");
$_SESSION["paie-porteur"] = testinit_catalog($_SESSION["paie-porteur"],"");

$clef = array(
"Id"=>testinit_catalog($GLOBALS["Id"],"-1"),
"codeclient"=>testinit_catalog($GLOBALS["codeclient"]),
"passwd"=>testinit_catalog($GLOBALS["passwd"])
);

/**
 * Nouvelle fiche client.
 */
$new_client = array(
"Id"=>testinit_catalog($GLOBALS["Id"],"-1"),
"civilite"=>testinit_catalog($GLOBALS["civilite"]),
"nom"=>testinit_catalog($GLOBALS["nom"]),
"prenom"=>testinit_catalog($GLOBALS["prenom"]),
"societe"=>testinit_catalog($GLOBALS["societe"]),
"adresse"=>testinit_catalog($GLOBALS["adresse"]),
"codepostal"=>testinit_catalog($GLOBALS["codepostal"]),
"ville"=>testinit_catalog($GLOBALS["ville"]),
"pays"=>testinit_catalog($GLOBALS["pays"]),
"tel"=>testinit_catalog($GLOBALS["tel"]),
"fax"=>testinit_catalog($GLOBALS["fax"]),
"portable"=>testinit_catalog($GLOBALS["portable"]),
"email"=>testinit_catalog($GLOBALS["email"]),
"services"=>testinit_catalog($GLOBALS["services"]),
"codeclient"=>testinit_catalog($GLOBALS["codeclient"]),
"passwd"=>testinit_catalog($GLOBALS["passwd"]),
"valide"=>testinit_catalog($GLOBALS["valide"],"1"),
"divers"=>testinit_catalog($GLOBALS["divers"]),
"datenaissance"=>testinit_catalog($GLOBALS["datenaissance"],"0000-00-00"),
"newsletter"=>testinit_catalog($GLOBALS["newsletter"],"0")
);

/**
 * Fiche d'arborescence vierge.
 */
$new_arbo = array(
"Id"=>testinit_catalog($GLOBALS[$vars_mod["id_cat_arbo"]],"-1"),
"nom"=>testinit_catalog($GLOBALS["nom"]),
"arbo"=>testinit_catalog($GLOBALS["arbo"])
);

/**
 * Nouvelle fiche catgorie.
 */
$new_categorie = array(
"Id"=>testinit_catalog($GLOBALS[$vars_mod["id_categorie"]],"-1"),
"categorie"=>testinit_catalog($GLOBALS["categorie"])
);

/**
 * Fiche de priode de soldes.
 */
$new_period_soldes = array(
"Id"=>testinit_catalog($GLOBALS[$vars_mod["id_solde"]],"-1"),
"deb_solde"=>testinit_catalog($GLOBALS["deb_solde"]),
"fin_solde"=>testinit_catalog($GLOBALS["fin_solde"])
);

/**
 * Elment de caddie.
 */
$new_line_caddie = array(
"Id"=>testinit_catalog($GLOBALS[$vars_mod["id_article"]],"-1"),
"nbre"=>testinit_catalog($GLOBALS["nbre"]),
"options"=>testinit_catalog($GLOBALS["options"])
);

/**
 * Fiche vierge d'un article du catalogue.
 */
$new_article = array(
"Id"=>testinit_catalog($GLOBALS[$vars_mod["id_article"]],"-1"),
"ref_article"=>testinit_catalog($GLOBALS["ref_article"]),
"photo"=>testinit_catalog($GLOBALS["photo"]),
"marque"=>testinit_catalog($GLOBALS["marque"]),
"designation_F"=>testinit_catalog($GLOBALS["designation_F"]),
"designation_E"=>testinit_catalog($GLOBALS["designation_E"]),
"designation_A"=>testinit_catalog($GLOBALS["designation_A"]),
"designation_I"=>testinit_catalog($GLOBALS["designation_I"]),
"designation_S"=>testinit_catalog($GLOBALS["designation_S"]),
"description_F"=>testinit_catalog($GLOBALS["description_F"]),
"description_E"=>testinit_catalog($GLOBALS["description_E"]),
"description_A"=>testinit_catalog($GLOBALS["description_A"]),
"description_I"=>testinit_catalog($GLOBALS["description_I"]),
"description_S"=>testinit_catalog($GLOBALS["description_S"]),
"conditionnement_F"=>testinit_catalog($GLOBALS["conditionnement_F"]),
"conditionnement_E"=>testinit_catalog($GLOBALS["conditionnement_E"]),
"conditionnement_A"=>testinit_catalog($GLOBALS["conditionnement_A"]),
"conditionnement_I"=>testinit_catalog($GLOBALS["conditionnement_I"]),
"conditionnement_S"=>testinit_catalog($GLOBALS["conditionnement_S"]),
"options_F"=>testinit_catalog($GLOBALS["options_F"]),
"options_E"=>testinit_catalog($GLOBALS["options_E"]),
"options_A"=>testinit_catalog($GLOBALS["options_A"]),
"options_I"=>testinit_catalog($GLOBALS["options_I"]),
"options_S"=>testinit_catalog($GLOBALS["options_S"]),
"tarif_ht"=>testinit_catalog($GLOBALS["tarif_ht"]),
"taux_tva"=>testinit_catalog($GLOBALS["taux_tva"],$tva_def),
"tarif_promo"=>testinit_catalog($GLOBALS["tarif_promo"]),
"taux_solde"=>testinit_catalog($GLOBALS["taux_solde"]),
"deb_promo"=>testinit_catalog($GLOBALS["deb_promo"]),
"fin_promo"=>testinit_catalog($GLOBALS["fin_promo"]),
"deb_solde"=>testinit_catalog($GLOBALS["deb_solde"]),
"fin_solde"=>testinit_catalog($GLOBALS["fin_solde"]),
"valide"=>testinit_catalog($GLOBALS["valide"],"0"),
"keywords"=>testinit_catalog($GLOBALS["keywords"]),
"old_photo"=>testinit_catalog($GLOBALS["old_photo"]),
"list_pays"=>testinit_catalog($GLOBALS["list_pays"],array())
);

$new_tarif = array( // `id_produit` , `tarif_ht` , `tarif_promo` , `taux_solde` , `deb_promo` , `fin_promo` , `deb_solde` , `fin_solde` , `seuil`
"Id"=>testinit_catalog($GLOBALS[$vars_mod["id_tarif"]],"-1"),
"id_produit"=>testinit_catalog($GLOBALS["id_produit"]),
"tarif_ht"=>testinit_catalog($GLOBALS["tarif_ht"]),
"tarif_promo"=>testinit_catalog($GLOBALS["tarif_promo"]),
"taux_solde"=>testinit_catalog($GLOBALS["taux_solde"]),
"deb_promo"=>testinit_catalog($GLOBALS["deb_promo"],"0000-00-00"),
"fin_promo"=>testinit_catalog($GLOBALS["fin_promo"],"0000-00-00"),
"seuil"=>testinit_catalog($GLOBALS["seuil"],0)
);
/**
 * Paramtres de recherche d'articles par dfaut.
 */
$crit_find_article = array(
"Id"=>testinit_catalog($GLOBALS[$vars_mod["id_article"]],"-1"),
"ref"=>testinit_catalog($GLOBALS["ref"]),
"kwz"=>testinit_catalog($GLOBALS["kwz"]),
"categorie"=>testinit_catalog($GLOBALS["categorie"]),
"marque"=>testinit_catalog($GLOBALS["marque"]),
"page_en_cours"=>testinit_catalog($GLOBALS[$vars_mod["page_en_cours"]],"1"),
"articles_par_page"=>testinit_catalog($GLOBALS["articles_par_page"],"15")
);

/**
 * Paramtres d'affichage des articles dans admin.
 */
$crit_admin_article = array(
"Id"=>testinit_catalog($GLOBALS[$vars_mod["id_article"]],"-1"),
"ref"=>testinit_catalog($GLOBALS["ref"]),
"kwz"=>testinit_catalog($GLOBALS["kwz"]),
"categorie"=>testinit_catalog($GLOBALS["categorie"]),
"marque"=>testinit_catalog($GLOBALS["marque"]),
"page_en_cours"=>testinit_catalog($GLOBALS[$vars_mod["page_en_cours"]],"1"),
"articles_par_page"=>testinit_catalog($GLOBALS["articles_par_page"],"20")
);

/**
 * Fiche commande vierge.
 */
$new_command = array(
"Id"=>testinit_catalog($GLOBALS[$vars_mod["id_command"]],"-1"),
"id_client"=>testinit_catalog($GLOBALS["id_client"]),
"client"=>testinit_catalog($GLOBALS["client"]),
"date"=>testinit_catalog($GLOBALS["date"]),
"numero"=>testinit_catalog($GLOBALS["numero"]),
"commande"=>testinit_catalog($GLOBALS["commande"]),
"total_ht"=>testinit_catalog($GLOBALS["total_ht"]),
"port_ht"=>testinit_catalog($GLOBALS["port_ht"]),
"total_tva"=>testinit_catalog($GLOBALS["total_tva"]),
"total_ttc"=>testinit_catalog($GLOBALS["total_ttc"]),
"port"=>testinit_catalog($GLOBALS["port"]),
"status"=>testinit_catalog($GLOBALS["status"]),
"reglement"=>testinit_catalog($GLOBALS["reglement"]),
"paye"=>testinit_catalog($GLOBALS["paye"],"0"),
"code_promo"=>testinit_catalog($GLOBALS["code_promo"]),
"reduc_ht"=>testinit_catalog($GLOBALS["reduc_ht"]),
"remarques"=>testinit_catalog($GLOBALS["remarques"])
);

/**
 * Fiche de moyen de livraison vierge.
 */
$new_port = array(
"Id"=>testinit_catalog($GLOBALS[$vars_mod["id_port"]],"-1"),
"designation"=>testinit_catalog($GLOBALS["designation"]),
"tarif"=>testinit_catalog($GLOBALS["tarif"]),
"tva"=>testinit_catalog($GLOBALS["tva"]),
"seuilfranco"=>testinit_catalog($GLOBALS["seuilfranco"]),
"delai"=>testinit_catalog($GLOBALS["delai"]),
"list_pays"=>testinit_catalog($GLOBALS["list_pays"],array())
);

/**
 * Fiche de moyen de livraison vierge.
 */
$new_promo = array(
"Id"=>testinit_catalog($GLOBALS[$vars_mod["id_promo"]],"-1"),
"code"=>testinit_catalog($GLOBALS["code"]),
"debut"=>testinit_catalog($GLOBALS["debut"],"0000-00-00"),
"fin"=>testinit_catalog($GLOBALS["fin"],"0000-00-00"),
"pourcent"=>testinit_catalog($GLOBALS["pourcent"],0),
"somme"=>testinit_catalog($GLOBALS["somme"],0),
"noport"=>testinit_catalog($GLOBALS["noport"],0),
"seuil"=>testinit_catalog($GLOBALS["seuil"],0),
"multiple"=>testinit_catalog($GLOBALS["multiple"],0),
"id_produit"=>testinit_catalog($GLOBALS["id_produit"],0)
);
?>