<?php
/**
 * Classes des fonctions pour manipuler les clients.
 *
 * Elles sont dans une classe pour les isoler des autres fonctions.
 * @package becmsSimpleClient
 * @version 0.1
 * @author Vincent RUIZ <webmaster@arobase.fr>
 * @copyright Copyright  2007, Vincent RUIZ
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 */

/**
 * Classe des fonctions.
 *
 * Cette clase contient galement les fonctions utiles (conversion de date, ...).
 * @package becmsSimpleClient
 */
class adminClients {
	/**
	 * @var object Classe qui donne accs au fonctions de manipulation des clients.
	 */
	var $sgbd;

	/**
	 * Initialise $sgbd avec la classe des fonctions d'accs  la base de donnes des clients.
	 */
	function adminClients() {
		$this->sgbd = new BD_Clients();
	}

	/**
	 * Rcupre les variables envoyes par GET ou POST.
	 *
	 * Renvoie ces variables sous la forme de paramtres d'URL.
	 * @param string $sauf Liste des paramtres  ne pas rcuprer.
	 * @return string Liste des variables rcupres.
	 */
	function getVars($sauf,$avec="") {
		$elimines = explode("|", $sauf);
		$args = "";
		$elts = array_merge($_GET,$_POST);
		if (count($elts) != 0 && $sauf!="*") {
			while (list ($key, $val) = each($elts)) {
				$ok = true;
				foreach ($elimines as $elimine) {
					if ($elimine == $key) {
						$ok = false;
					}
				}
				if ($ok) {
					if ($args != "") {
						$args .= "&";
					}
					$args .= $key . "=" . stripslashes($val);
				}
			}
		}
		$ajoutes = explode("|", $avec);
		if (count($elts) != 0 && count($ajoutes) != 0) {
			while (list ($key, $val) = each($elts)) {
				foreach ($ajoutes as $ajoute) {
					if ($ajoute == $key) {
						if ($args != "") {
							$args .= "&";
						}
						$args .= $key . "=" . stripslashes($val);
					}
				}
			}
		}
		return $args;
	}

	/**
	 * Renvoie l'indexation des rsultats  afficher par page.
	 *
	 * @param array $criteres Tableau contenant les divers paramtres : .
	 * @return string Code HTML de l'index des pages  afficher.
	 */
	function getPagesIndex_old($vars_mod,$criteres,$nbreFiches,$found,$not_found) {
		$repParPage = $criteres["articles_par_page"];
		$p = $criteres["page_en_cours"];
		$nbrepages = ceil($nbreFiches/$repParPage);
		if ($p>$nbrepages) {
			$p = $nbrepages;
		}
		$indexPages .= "<div class=\"pages\">";
		if ($nbreFiches != 0) {
			$indexPages .= $nbreFiches.$found;
		}
		else {
			$indexPages .= $not_found;
		}
		$indexPages .= _CLIENTPAGES;
		for ($i=1;$i<=$nbrepages;$i++) {
			if ($i == $p ) {
				$indexPages .= "<div class=\"pagevide\">";
				$indexPages .= "$i";
				$indexPages .= "</div>";
			}
			else {
				$indexPages .= "<div class=\"page\">";
				$sauf="civilite|nom|prenom|societe|adresse|codepostal|ville|pays|valide|newsletter|tel|fax|portable|email|services|codeclient|passwd|datenaissance|categorie|categorielist|pageperso|sop|artid|divers|codeconfirm|Id|validformb";
				$indexPages .= "<a href=\"?".$this->getVars($sauf."|".$vars_mod["page_en_cours"]."|".$vars_mod["action"]."|".$vars_mod["confirm"])."&".$vars_mod["action"]."=list&".$vars_mod["page_en_cours"]."=$i\">$i</a>";
				$indexPages .= "</div>";
			}
		}
		$indexPages .= "</div>";
		return $indexPages;
	}
	
	function getPagesIndex($vars_mod,$criteres,$nbreFiches,$found,$not_found) {
		$nboites = 5;
		$ligne_par_page = $criteres["articles_par_page"];
		$page = $criteres["page_en_cours"];
		
		$liminf = $page - floor($nboites/2);
		$limsup = $page + floor($nboites/2);
		if ($liminf < 1) {
			$liminf = 1;
			$limsup = $nboites;
			if ($limsup > ceil($nbreFiches/$ligne_par_page)) {
				$limsup = ceil($nbreFiches/$ligne_par_page);
			}
		}
		if ($limsup > ceil($nbreFiches/$ligne_par_page)) {
			$limsup = ceil($nbreFiches/$ligne_par_page);
			$liminf = $limsup - $nboites;
			if ($liminf < 1) {
				$liminf = 1;
			}
		}
		$min = 1;
		$max = ceil($nbreFiches/$ligne_par_page);


		$repParPage = $ligne_par_page;
		$p = $page;
		$nbrepages = ceil($nbreFiches/$repParPage);
		if ($p>$nbrepages) {
			$p = $nbrepages;
		}
		$sauf="civilite|nom|prenom|societe|adresse|codepostal|ville|pays|valide|newsletter|tel|fax|portable|email|services|codeclient|passwd|datenaissance|categorie|categorielist|pageperso|sop|artid|divers|codeconfirm|Id|validformb";
		$indexPages .= "<div class=\"pages\">";
		if ($nbreFiches != 0) {
			$indexPages .= $nbreFiches.$found;
			$indexPages .= _CLIENTPAGES;
			if ($min < $liminf) {
				if ($min == $p ) {
					$indexPages .= "<div class=\"pagevide\">";
					$indexPages .= "$min";
					$indexPages .= "</div>";
				}
				else {
					$indexPages .= "<div class=\"page\">";
					//$indexPages .= "<a href=\"system.php?op=users_newsletter_multigroup&action=list_users&page=$min"."\">$min</a>";
					$indexPages .= "<a href=\"?".$this->getVars($sauf."|".$vars_mod["page_en_cours"]."|".$vars_mod["action"]."|".$vars_mod["confirm"])."&".$vars_mod["action"]."=list&".$vars_mod["page_en_cours"]."=$min\">$min</a>";
					$indexPages .= "</div>";
				}
				if ($min < $liminf - 1) {
					$indexPages .= "...";
				}
			}
			for ($i=$liminf;$i<=$limsup;$i++) {
				if ($i == $p ) {
					$indexPages .= "<div class=\"pagevide\">";
					$indexPages .= "$i";
					$indexPages .= "</div>";
				}
				else {
					$indexPages .= "<div class=\"page\">";
					//$indexPages .= "<a href=\"system.php?op=users_newsletter_multigroup&action=list_users&page=$i"."\">$i</a>";
					$indexPages .= "<a href=\"?".$this->getVars($sauf."|".$vars_mod["page_en_cours"]."|".$vars_mod["action"]."|".$vars_mod["confirm"])."&".$vars_mod["action"]."=list&".$vars_mod["page_en_cours"]."=$i\">$i</a>";
					$indexPages .= "</div>";
				}
			}
			if ($max > $limsup) {
				if ($max > $limsup + 1) {
					$indexPages .= "...";
				}
				if ($max == $p ) {
					$indexPages .= "<div class=\"pagevide\">";
					$indexPages .= "$max";
					$indexPages .= "</div>";
				}
				else {
					$indexPages .= "<div class=\"page\">";
					//$indexPages .= "<a href=\"system.php?op=users_newsletter_multigroup&action=list_users&page=$max"."\">$max</a>";
					$indexPages .= "<a href=\"?".$this->getVars($sauf."|".$vars_mod["page_en_cours"]."|".$vars_mod["action"]."|".$vars_mod["confirm"])."&".$vars_mod["action"]."=list&".$vars_mod["page_en_cours"]."=$max\">$max</a>";
					$indexPages .= "</div>";
				}

			}
		}
		else {
			$indexPages .= $not_found;
		}
		$indexPages .= "</div>";
		return $indexPages;
	}

	/**
	 * Renvoie le client dsign.
	 *
	 * Si le client est introuvable ou que sont identifiant est -1, un client vide est retourn.
	 * @param array $My_SQL Paramtres de la base de donnes
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
	 * @return array Tableau contenant les rubriques du client.
	 */
	function get_client_edit($My_SQL,$vars_mod) {
		if ($vars_mod[$vars_mod["id_client"]] != "-1") {
			$clef = array("Id"=>$vars_mod[$vars_mod["id_client"]],"codeclient"=>"","passwd"=>"");
			$clientsEdit = $this->sgbd->getClients($My_SQL,$clef,"");
			if (count($clientsEdit) == 0) {
				$ClientEdit = array("Id"=>"","civilite"=>"","nom"=>"","prenom"=>"","societe"=>"","adresse"=>"","codepostal"=>"","ville"=>"","pays"=>"","tel"=>"","fax"=>"","portable"=>"","email"=>"","services"=>"","codeclient"=>"","valide"=>"","divers"=>"","datenaissance"=>"","categorie"=>"","condeconfirm"=>"","pageperso"=>"","newsletter"=>"");
			}
			else {
				$ClientEdit = $clientsEdit[0];
			}
		}
		else {
			$ClientEdit = array("Id"=>"","civilite"=>"","nom"=>"","prenom"=>"","societe"=>"","adresse"=>"","codepostal"=>"","ville"=>"","pays"=>"","tel"=>"","fax"=>"","portable"=>"","email"=>"","services"=>"","codeclient"=>"","valide"=>"","divers"=>"","datenaissance"=>"","categorie"=>"","condeconfirm"=>"","pageperso"=>"","newsletter"=>"");
		}
		return $ClientEdit;
	}
	/**
	 * Renvoie le formulaire d'dition du client dsign.
	 *
	 * Ce formulaire permet de crer, modifier ou supprimer les clients.
	 * @param array $My_SQL Paramtres de la base de donnes
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
	 * @param array $new_client Tableau contenant les valeurs du client en cours (nouvellement enregistr ou simplmeent dit).
	 * @return string Formulaire HTML du client.
	 */
	function edit_client($My_SQL,$vars_mod,$new_client,$criteres) {
		$checked = "";
		$checked2 = "";
		if ($vars_mod[$vars_mod["id_client"]] != "-1") {
			$ClientEdit = $this->get_client_edit($My_SQL,$vars_mod);
			if ($ClientEdit["valide"] == "1") {
				$checked = " checked=\"checked\"";
			}
			else {
				$checked = "";
			}
			if ($ClientEdit["newsletter"] == "1") {
				$checked2 = " checked=\"checked\"";
			}
			else {
				$checked2 = "";
			}
		}
		else {
			$ClientEdit = $new_client;
		}
		$ClientEdit["datenaissance"] = $this->date2JMA($ClientEdit["datenaissance"]);
		$civilites = explode("//",_CLIENTCIVILITES);
		$menuCivilite = '<select name="civilite" size="1">';
		for ($i=0;$i<count($civilites);$i++) {
			if ($ClientEdit["civilite"] == $i) {
				$selected = ' selected="selected"';
			}
			else {
				$selected = "";
			}
			$menuCivilite .= '<option value="'.$i.'"'.$selected.'>'.$civilites[$i].'</option>';
		}
		$menuCivilite .= '</select>';
		$categoriestab = $this->sgbd->getCategorieClients($My_SQL);
		$menucategorie = '<select name="categorielist" size="1" class="saisie_court" onchange="this.form.categorie.value=this.value">';
		$menucategorie .= '<option value=""'.$selected.'>'._CLIENTCHOOSECAT.'</option>';
		foreach($categoriestab as $categorietab) {
			if ($categorietab == $ClientEdit["categorie"]) {
				$selected = ' selected="selected"';
			}
			else {
				$selected = "";
			}
			$menucategorie .= '<option value="'.$categorietab.'"'.$selected.'>'.$categorietab.'</option>';
		}
		$menucategorie .= '</select>';
		$pays = $this->sgbd->getPays($My_SQL,"_F");
		$menuPays = '<select name="pays" size="1" class="saisie_court">';
		foreach($pays as $unpays) {
			if ($unpays["code"] == $ClientEdit["pays"]){
				$selected = ' selected="selected"';
			}
			else {
				$selected = "";
			}
			$menuPays .= '<option value="'.$unpays["code"].'"'.$selected.'>'.$unpays["pays_F"].'</option>';
		}
		$menuPays .= '</select>';

		$var_en_plus = "";
		if ($criteres["page_en_cours"] != "1") {
			$var_en_plus .= "&".$vars_mod["page_en_cours"]."=".$criteres["page_en_cours"];
		}
		if ($vars_mod[$vars_mod["tri"]] != "") {
			$var_en_plus .= '&'.$vars_mod["tri"].'='.$vars_mod[$vars_mod["tri"]];
		}
		if ($criteres["groupe"] != "") {
			$var_en_plus .= "&group=".urlencode($criteres["groupe"]);
		}

		require_once("modules/Sections/connector_class.php");
		//$urlprefix = "modules.php?name=Sections&sop=viewarticle&artid=";
		$urlprefix = "modules.php?name=SimpleClient&sop=display_client_page&art=";
		$cc = new pageconnector();
		$sections = $cc->getSectionList();
		$menupage = "<select name=\"$nomselect\" size=\"1\" class=\"saisie_court\" onchange=\"if (this.value != '') {this.form.pageperso.value = '$urlprefix'+this.value; }\" class=\"pages\">";
		$menupage .= "<option value=\"\">" . _CARTOPAGESSDISPOCHOIX . "</option>";
		foreach ($sections as $section) {
			$menupage .= "<option value=\"\">" . $section[1] . "</option>";
			$articles = $cc->getPageList($section[0], "");
			if ($articles != "") {
				foreach ($articles as $article) {
					if ($urlprefix.$article[0] == $ClientEdit["pageperso"]) {
						$selected = "selected=\"selected\"";
					} else {
						$selected = "";
					}
					$menupage .= "<option value=\"" . $article[0] . "\" $selected> -> " . $article[1] . "</option>";
				}
			}
		}
		$menupage .= "</select>";

		$formedit = '
		<center>
			<form method="post" action="system.php?op=client&onglet=client&'.$vars_mod["action"].'=save'.$var_en_plus.'" method="post" name="formfiche" onsubmit="return validForm(this);" name="f_client"><br>
			 <table class="saisieclient" border="0" cellpadding="0" cellspacing="0">
			    <tbody>
			      <tr>
			        <td style="vertical-align: top;" colspan="1" rowspan="7">
			        <table style="text-align: left;" border="0" cellpadding="0" cellspacing="2">
			          <tbody>
						<tr>
			              <td style="width: 80px;">'._CLIENTCIVILITEEDIT.'</td>
			              <td>'.$menuCivilite.'</td>
			            </tr>
			            <tr>
			              <td style="width: 80px;">'._CLIENTNOMEDIT.'</td>
			              <td><input name="nom" class="saisie_court" value="'.$this->conditionnerFORM($ClientEdit["nom"]).'" /></td>
			            </tr>
			            <tr>
			              <td>'._CLIENTPRENOMEDIT.'</td>
			              <td><input name="prenom" class="saisie_court" value="'.$this->conditionnerFORM($ClientEdit["prenom"]).'" /></td>
			            </tr>
						<tr>
			              <td>'._CLIENTSOCIETEEDIT.'</td>
			              <td><input name="societe" class="saisie_court" value="'.$this->conditionnerFORM($ClientEdit["societe"]).'" /></td>
			            </tr>
			            <tr>
			              <td>'._CLIENTADRESSEEDIT.'</td>
			              <td><textarea cols="20" rows="3" name="adresse" class="saisie_court">'.$this->conditionnerFORM($ClientEdit["adresse"]).'</textarea></td>
			            </tr>
			            <tr>
			              <td>'._CLIENTCODEPOSTALEDIT.'</td>
			              <td><input name="codepostal" class="saisie_court" value="'.$this->conditionnerFORM($ClientEdit["codepostal"]).'" /></td>
			            </tr>
			            <tr>
			              <td>'._CLIENTVILLEEDIT.'</td>
			              <td><input name="ville" class="saisie_court" value="'.$this->conditionnerFORM($ClientEdit["ville"]).'" /></td>
			            </tr>
			            <tr>
			              <td>'._CLIENTPAYSEDIT.'</td>
			              <td><!--<input name="pays" class="saisie_court" value="'.$this->conditionnerFORM($ClientEdit["pays"]).'" />-->'.$menuPays.'</td>
			            </tr>
						<tr>
			              <td>'._CLIENTVALIDEEDIT.'</td>
			              <td><input name="valide" value="1" type="checkbox"'.$checked.' /></td>
			            </tr>
						<tr>
			              <td>'._CLIENTNEWSLETTEREDIT.'</td>
			              <td><input name="newsletter" value="1" type="checkbox"'.$checked2.' /></td>
			            </tr>
			            <tr>
			              <td>'._CLIENTDIVERSEDIT.'</td>
			              <td></td>
			            </tr>
			          </tbody>
			        </table>
			        </td>
			        <td style="width: 30px;">&nbsp;</td>
			        <td style="vertical-align: top;" colspan="1" rowspan="7">
			        <table border="0" cellpadding="0" cellspacing="2">
			          <tbody>
			            <tr>
			              <td style="width: 80px;">'._CLIENTTELEDIT.'</td>
			              <td><input name="tel" class="saisie_court" value="'.$this->conditionnerFORM($ClientEdit["tel"]).'" /></td>
			            </tr>
			            <tr>
			              <td>'._CLIENTFAXEDIT.'</td>
			              <td><input name="fax" class="saisie_court" value="'.$this->conditionnerFORM($ClientEdit["fax"]).'" /></td>
			            </tr>
			            <tr>
			              <td>'._CLIENTPORTABLEEDIT.'</td>
			              <td><input name="portable" class="saisie_court" value="'.$this->conditionnerFORM($ClientEdit["portable"]).'" /></td>
			            </tr>
			            <tr>
			              <td>'._CLIENTEMAILEDIT.'</td>
			              <td><input name="email" class="saisie_court" value="'.$this->conditionnerFORM($ClientEdit["email"]).'" onchange="copyValue(this,this.form.codeclient,false)" onblur="copyValue(this,this.form.codeclient,false)" /></td>
			            </tr>
			            <tr>
			              <td>'._CLIENTSERVICESEDIT.'</td>
			              <td><input name="services" class="saisie_court" value="'.$this->conditionnerFORM($ClientEdit["services"]).'" /></td>
			            </tr>
			            <tr>
			              <td>'._CLIENTCODECLIENTEDIT.'</td>
			              <td><input name="codeclient" class="saisie_court" value="'.$this->conditionnerFORM($ClientEdit["codeclient"]).'" /></td>
			            </tr>
						<tr>
			              <td>'._CLIENTPASSWDEDIT.'</td>
			              <td><input name="passwd" class="saisie_court" value="'.$this->conditionnerFORM($ClientEdit["passwd"]).'" /></td>
			            </tr>
						<tr>
			              <td>'._CLIENTANNIVERSAIREEDIT.'</td>
			              <td><input name="datenaissance" class="saisie_court" value="'.$ClientEdit["datenaissance"].'" /></td>
			            </tr>
						<tr>
			              <td>'._CLIENTCATEDIT.'</td>
			              <td><input name="categorie" class="saisie_court" value="'.$ClientEdit["categorie"].'" /><br/>'.$menucategorie.'</td>
			            </tr>
						<tr>
			              <td>'._CLIENTPAGEPERSOEDIT.'</td>
			              <td><input name="pageperso" class="saisie_court" value="'.$ClientEdit["pageperso"].'" /><br/>'.$menupage.'</td>
			            </tr>
			          </tbody>
			        </table>
			        </td>
			      </tr>
			      <tr>
			        <td>&nbsp;</td>
			      </tr>
			      <tr>
			        <td>&nbsp;</td>
			      </tr>
			      <tr>
			        <td>&nbsp;</td>
			      </tr>
			      <tr>
			        <td>&nbsp;</td>
			      </tr>
			      <tr>
			        <td>&nbsp;</td>
			      </tr>
			      <tr>
			        <td>&nbsp;</td>
			      </tr>
			      <tr>
			        <td colspan="3" rowspan="1">
			        <table border="0" cellpadding="0" cellspacing="2">
			          <tbody>
			            <tr>
			              <td><textarea cols="40" rows="4" name="divers" class="saisie_long">'.$this->conditionnerFORM($ClientEdit["divers"]).'</textarea></td>
			            </tr>
			          </tbody>
			        </table>
			        <br>
			        </td>
			      </tr>
			      <tr align="center">
			        <td colspan="3" rowspan="1">'._CLIENTFIELDREQUIRED.'<br />&nbsp;<br /><input type="hidden" value="'.$ClientEdit["codeconfirm"].'" name="codeconfirm"><input type="hidden" value="'.$ClientEdit["Id"].'" name="Id"><input type="checkbox" value="1" name="sendmodif" id="sendmailconfirm"><label for="sendmailconfirm"><i>Notifier les changements par e-mail</i></label>&nbsp;&nbsp;&nbsp;&nbsp;<input name="validformb" value="'._CLIENTSAVEEDIT.'" type="submit"></td>
			      </tr>
			    </tbody>
			  </table>
			</form>
		</center>
<script type="text/javascript">
 //<![CDATA[
	function validMail(email) {
		if (email == "") {
			return(false);
		}
		else {
			if ((email.indexOf("@") == -1) || (email.indexOf("@") == 0) || (email.indexOf("@") != email.lastIndexOf("@")) || (email.indexOf(".") == email.indexOf("@")-1) || (email.indexOf(".") == email.indexOf("@") + 1) || (email.indexOf("@") == email.length -1) || (email.indexOf (".") == -1) || (email.lastIndexOf (".") == email.length -1) || (email.indexOf (";") != -1) || (email.indexOf (" ") != -1)) {
				return(false);
			}
			else return(true);
		}
	}
	function validForm(formulaire) {
		if (formulaire.nom.value == "") {
			alert("'._CLIENTVERIFNOM.'");
			return false;
		}
		if (!validMail(formulaire.email.value)) {
			alert("'._CLIENTVERIFEMAIL.'");
			return false;
		}
		if (formulaire.codeclient.value == "") {
			alert("'._CLIENTVERIFCODE.'");
			return false;
		}
		if (formulaire.passwd.value == "") {
			alert("'._CLIENTVERIFPASS.'");
			return false;
		}
		return true;
	}
	function copyValue(from,to,force) {
		if (force) {
			to.value = from.value;
		}
		else {
			if (to.value == "") {
				to.value = from.value;
			}
		}
	}
    //]]>
</script>';
		return $formedit;
	}

	/**
	 * Renvoie un tableau HTML listant tous les clients.
	 *
	 * Ce tableau permet de crer, modifier ou supprimer les clients.
	 * @param array $My_SQL Paramtres de la base de donnes
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
	 * @return string Tableau HTML des clients.
	 */
	function get_list_clients ($My_SQL,$vars_mod,$criteres) {
		global $module_name;
		global $currentlang;

		$catchoix = $this->sgbd->getCategorieClients($My_SQL);
		$menucat = '<select name="group" size="1" onchange="this.form.submit()">';
		$menucat .= '<option value="">'._CLIENTGROUPCHOOSEIT.'</option>';
		foreach($catchoix as $choix) {
			if ($choix != "") {
				$selected = ($criteres["groupe"] == $choix) ? " selected=\"selected\"" : "";
				$menucat .= '<option value="'.$choix.$selected.'">'.$choix.'</option>';
			}
		}
		$menucat .= "</select>";
		$nbreFiches = $this->sgbd->getNumClients($My_SQL,"","",$criteres["groupe"]);
		$nbrepages = ceil($nbreFiches/$criteres["articles_par_page"]);
		if ($criteres["page_en_cours"] > $nbrepages) {
			$criteres["page_en_cours"] = $nbrepages;
		}
		$indexPages = $this->getPagesIndex($vars_mod,$criteres, $nbreFiches,_CLIENTFOUNDPAGES,_CLIENTNOTFOUNDPAGES);
		$limInf = ($criteres["page_en_cours"]-1)*$criteres["articles_par_page"];
		$limit_client = $limInf.",".$criteres["articles_par_page"];

		if ($vars_mod[$vars_mod["id_client"]] == "-1") {
			$id_client = "";
			$critTriPlus = "";
		}
		else {
			$id_client = $vars_mod[$vars_mod["id_client"]];
			$critTriPlus = "";
		}

		$clef = array("Id"=>$id_client,"codeclient"=>"","passwd"=>"");
		$clients = $this->sgbd->getClients($My_SQL,$clef,$vars_mod[$vars_mod["tri"]],$limit_client,"",$criteres["groupe"]);
		$tri = "";
		if ($vars_mod[$vars_mod["tri"]] != "") {
			$tri = '&'.$vars_mod["tri"].'='.$vars_mod[$vars_mod["tri"]];
		}
		$var_en_plus = "";
		if ($criteres["page_en_cours"] != "1") {
			$var_en_plus = "&".$vars_mod["page_en_cours"]."=".$criteres["page_en_cours"];
		}
		if ($criteres["groupe"] != "") {
			$var_en_plus .= "&group=".urlencode($criteres["groupe"]);
		}
		$liste = '<table cellpadding="0" cellspacing="0" border="0" align="center"><tr><td><form name="cat" action="system.php?op=client" method="POST">'._CLIENTGROUPCHOOSE.$menucat.'</form></td><td width="30"></td><td>'.$indexPages.'</td></tr></table>
				<table  class="lisTable">
				<tr class="systemTabHeader">
					<th class="systemTabHeader"><a href="system.php?'.$vars_mod["action"].'=list&op=client&onglet=client&'.$vars_mod["tri"].'=nom'.$critTriPlus.'">'._CLIENTONGLETCNOM.'</a></th>
					<th class="systemTabHeader"><a href="system.php?'.$vars_mod["action"].'=list&op=client&onglet=client&'.$vars_mod["tri"].'=societe'.$critTriPlus.'">'._CLIENTONGLETCSOCIETE.'</a></th>
					<th class="systemTabHeader"><a href="system.php?'.$vars_mod["action"].'=list&op=client&onglet=client&'.$vars_mod["tri"].'=codepostal'.$critTriPlus.'">'._CLIENTONGLETCCODEP.'</a></th>
					<th class="systemTabHeader">'._CLIENTONGLETCVILLE.'</th>
    					<th class="systemTabHeader"><a href="system.php?'.$vars_mod["action"].'=list&op=client&onglet=client&'.$vars_mod["tri"].'=categorie'.$critTriPlus.'">'._CLIENTONGLETCCATEGORIES.'</a></th>
    					<th class="systemTabHeader">'._CLIENTONGLETCCODECLIENT.'</th>
					<th class="systemTabHeader">'._CLIENTONGLETCVALIDE.'</th>
					<th class="systemTabHeader">'._CLIENTONGLETCNEWSLETTER.'</th>
					<th class="systemTabHeader">'._CLIENTONGLETCACTION.'</th>
    				</tr>';
		$pos=0;
		if (count($clients) != 0) {
			foreach ($clients as $client) {
				if ($this->conditionnerHTML($client["valide"]) =="1") {
					//$valide = "&bull;";
					$valide = '<input type="checkbox" value="" checked="checked" disabled="disabled" />';
				}
				else {
					//$valide = "";
					$valide = '<input type="checkbox" value="" disabled="disabled" /->';
				}
				if ($this->conditionnerHTML($client["newsletter"]) =="1") {
					//$valide = "&bull;";
					$newsletter = '<input type="checkbox" value="" checked="checked" disabled="disabled" />';
				}
				else {
					//$valide = "";
					$newsletter = '<input type="checkbox" value="" disabled="disabled" /->';
				}
				$barDef=array(	"edit"=> array( "text"=>_EDIT,"icon"=>"edit_16x16.png","url"=>"system.php?op=client&onglet=client&".$vars_mod["action"]."=edit&".$vars_mod["id_client"]."=".$client["Id"].$tri.$var_en_plus,"comment"=>_EDIT, "status"=>"ON"),
				"delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png","url"=>"system.php?op=client&onglet=client&".$vars_mod["action"]."=delete&".$vars_mod["id_client"]."=".$client["Id"].$tri.$var_en_plus,"comment"=>_DELETE,"status"=>"ON"));

				if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
				$pos++;

				$liste .= '<tr class="'.$thestyle.'">';
				$liste .= '<td>';
				$liste .= $this->conditionnerHTML($client["nom"]." ".$client["prenom"]);
				$liste .= '</td><td align="center">';
				$liste .= $this->conditionnerHTML($client["societe"]);
				$liste .= '</td><td align="center">';
				$liste .= $this->conditionnerHTML($client["codepostal"]);
				$liste .= '</td><td align="center">';
				$liste .= $this->conditionnerHTML($client["ville"]);
				$liste .= '</td><td align="center">';
				$liste .= $this->conditionnerHTML($client["categorie"]);
				$liste .= '</td><td align="center">';
				$liste .= $this->conditionnerHTML($client["codeclient"]);
				$liste .= '</td><td align="center">';
				$liste .= $valide;
				$liste .= '</td><td align="center">';
				$liste .= $newsletter;
				$liste .= '</td><td align="center">';
				$liste .= displayActionBar("add","Bar d'action",$barDef,"img","",true);
				$liste .= '</td>';
				$liste .= '</tr>';
			}
				
		}
		$liste .= '</table>';
		$liste .= '<script language="Javascript" src="javascripts/control_form.js"></script>
					<SCRIPT language="JavaScript" src="javascripts/lang/lang-'.$currentlang.'.js"></SCRIPT>';
		$liste .= '<form name="export_form" action="modules.php?name='.$module_name.'" method="POST" onsubmit="return submit_form(this)"';
		$liste .= "<p>";
		//$liste .= "<a href=\"modules.php?name=".$module_name."&sop=sendEXCEL\">"._CLIENTDOWNLOADLISTING."</a>";
		$liste .= '<champ lib="Le type d\'export" nom="typexport">';
		$liste .= "<input type=\"submit\" name = \"button\" value=\""._CLIENTDOWNLOADLISTING."\">";
		$liste .= " <input type=\"radio\" name=\"typexport\" value=\"\" checked=\"checked\" id=\"typexport1\"><label for=\"typexport1\">"."Tous"."</label>";
		$liste .= " <input type=\"radio\" name=\"typexport\" value=\"yes\" id=\"typexport2\"><label for=\"typexport2\">"."Clients valides"."</label>";
		$liste .= " <input type=\"radio\" name=\"typexport\" value=\"no\" id=\"typexport3\"><label for=\"typexport3\">"."Clients non valides"."</label>";
		$liste .= "<input type=\"hidden\" name= \"group\" value=\"".$criteres["groupe"]."\">";
		$liste .= "<input type=\"hidden\" name= \"sop\" value=\"sendEXCEL\">";
		$liste .= "</p>";
		$liste .= "</form>";
		return $liste;
	}

	/**
	 * Enregistre le client transmis.
	 *
	 * La fonction renvoie l'identifiant de la fiche du client si l'enregsitrement s'est bien pass, et -1 sinon.
	 * @param array $My_SQL Paramtres de la base de donnes
	 * @param array $leclient Tableau contenant les valeurs du client  enregistrer.
	 * @return integer Identifiant de la fiche enregistre.
	 */
	function save_client ($My_SQL,$leclient) {
		if ($this->sgbd->saveClient($My_SQL,$leclient)) {
			if ($leclient["Id"] == "-1") {
				$savedIndex = $this->sgbd->getLastId($My_SQL);
			}
			else {
				$savedIndex = $leclient["Id"];
			}
		}
		else {
			$savedIndex = "-1";
		}
		return $savedIndex;
	}

	/**
	 * Demande confirmation de la suppression de l'lment dsign.
	 * @param array $My_SQL Paramtres de la base de donnes
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
	 * @param message $message Message affich  l'utilisateur pour confirmer la suppression
	 * @return string Message  afficher en HTML.
	 */
	function confirm_delete($My_SQL,$vars_mod,$message) {
		$sortie = "<p>$message</p>";
		$sortie .= "<p>&nbsp;</p>";
		$sortie .= "<p>";
		if ($vars_mod[$vars_mod["action"]] == "delete") {
			$tri = "";
			if ($vars_mod[$vars_mod["tri"]] != "") {
				$tri = '&'.$vars_mod["tri"].'='.$vars_mod[$vars_mod["tri"]];
			}
			$sortie .= '<a href="system.php?op=client&onglet=client&'.$vars_mod["action"].'='.$vars_mod[$vars_mod["action"]].'&'.$vars_mod["id_client"].'='.$vars_mod[$vars_mod["id_client"]].$tri.'&'.$vars_mod["confirm"].'=y">';

			$sortie .= "["._CLIENTCONFSUPPROUI."]";
			$sortie .= "</a>";
			$sortie .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
			$sortie .= '<a href="javascript:window.history.back()">';
			$sortie .= "["._CLIENTCONFSUPPRNON."]";
			$sortie .= '</a>';
		}
		$sortie .= "</p>";
		return $sortie;
	}
	/**
	 * Supprime le client transmis et renvoie le rsultat de l'opration en HTML.
	 * @param array $My_SQL Paramtres de la base de donnes
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
	 * @return string Rsultat de l'opration en HTML.
	 */
	function delete_client($My_SQL,$vars_mod) {
		if ($this->sgbd->delClient($My_SQL,$vars_mod[$vars_mod["id_client"]])) {
			$sortie = _CLIENTDELOK;
		}
		else {
			$sortie = _CLIENTDELPASOK;
		}
		return $sortie;
	}

	/**
	 * Envoie un message de demande de confirmation de cration d'un compte client par un administrateur.
	 *
	 * Tant que celui-ci n'a pas valid le compte, celui-ci est invalide.
	 * @param array $My_SQL Paramtres de la base de donnes.
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
	 * @param string $subject Sujet du message expdi.
	 * @param string $message Corps du message expdi.
	 * @return string Vide si le message a t expdi, message d'erreur sinon.
	 */
	function send_confirm_client($My_SQL,$vars_mod,$subject,$message) {
		global $nukeurl;
		global $vars_mail;

		$clef = array("Id"=>$vars_mod[$vars_mod["id_client"]],"codeclient"=>"","passwd"=>"");
		$clients = $this->sgbd->getClients($My_SQL,$clef);
		$client = $clients[0];

		$tab_serveur = parse_url($nukeurl);
		$racine = $tab_serveur["scheme"]."://";
		if ($tab_serveur["user"] != "") {
			$racine .= $tab_serveur["user"];
		}
		if ($tab_serveur["pass"] != "") {
			$racine .= ":".$tab_serveur["pass"];
		}
		if ($tab_serveur["pass"] != "" || $tab_serveur["user"] != "") {
			$racine .= "@";
		}
		$racine .= $tab_serveur["host"];
		if ($tab_serveur["port"] != "") {
			$racine .= ":".$tab_serveur["port"];
		}
		$lien = $racine."/modules.php?name=SimpleClient&sop=validclient&".$vars_mod["code_confirm"]."=".$client["codeconfirm"];

		$message = str_replace("<!--nom-->",$client["nom"],$message);
		$message = str_replace("<!--prenom-->",$client["prenom"],$message);
		$message = str_replace("<!--codeclient-->",$client["codeclient"],$message);
		$message = str_replace("<!--passwd-->",$client["passwd"],$message);
		$message = str_replace("<!--codeconfirm-->",$client["codeconfirm"],$message);
		$message = str_replace("<!--link-->",$lien,$message);

		$email = $client["prenom"]." ".$client["nom"]." <".$client["email"].">";
		if ($this->send_email($email, $subject, $message,$vars_mod["vars_mail"])) {
			return "";
		}
		else {
			return '<p class="alerte">'._CLIENTMESSAGEERROR.'</p>';
		}
	}
	
	function send_modif_client($My_SQL,$vars_mod,$subject,$message) {
		global $vars_mail, $nukeurl;

		$clef = array("Id"=>$vars_mod[$vars_mod["id_client"]],"codeclient"=>"","passwd"=>"");
		$clients = $this->sgbd->getClients($My_SQL,$clef);
		$client = $clients[0];
		
		$tab_serveur = parse_url($nukeurl);
		$racine = $tab_serveur["scheme"]."://";
		if ($tab_serveur["user"] != "") {
			$racine .= $tab_serveur["user"];
		}
		if ($tab_serveur["pass"] != "") {
			$racine .= ":".$tab_serveur["pass"];
		}
		if ($tab_serveur["pass"] != "" || $tab_serveur["user"] != "") {
			$racine .= "@";
		}
		$racine .= $tab_serveur["host"];
		if ($tab_serveur["port"] != "") {
			$racine .= ":".$tab_serveur["port"];
		}
		$lien = $racine."/index.php";
		
		$message = str_replace("<!--nom-->",$client["nom"],$message);
		$message = str_replace("<!--prenom-->",$client["prenom"],$message);
		$message = str_replace("<!--codeclient-->",$client["codeclient"],$message);
		$message = str_replace("<!--passwd-->",$client["passwd"],$message);
		$message = str_replace("<!--link-->",$lien,$message);

		$email = $client["prenom"]." ".$client["nom"]." <".$client["email"].">";
		$this->send_email($email, $subject, $message,$vars_mod["vars_mail"]);
		return "";
	}
	
	/**
	 * Expdition d'un e-mail.
	 * @param string $email Adresse d'expdition de l'e-mail.
	 * @param string $subject Sujet de l'e-mail.
	 * @param string $message Corps du massage  expdier.
	 * @return boolean True si le message a t expdi, false sinon.
	 */
	function send_email($email, $subject, $message, $from){
		$vars_mail = $from;
		// En-ttes
		$headers = "From: ".$vars_mail["from"]."\n";
		$headers .= "X-Sender: ".$vars_mail["from"]."\n";
		$headers .= "X-Mailer: PHP\n";
		$headers .= "X-Priority: 1\n";
		$headers .= "Return-Path: ".$vars_mail["from"]."\n";
		$headers .= "Reply-To: ".$vars_mail["nom"]." <".$vars_mail["from"].">\n";
		$headers .= "Content-Type: text/plain; charset=iso-8859-1\n"; // Type MIME
		return mail($email, $subject, $message, $headers);
	}

	/**
	 * Rcupre la valeur de l'indentifiant du dernier enregistrement cr.
	 * @param array $My_SQL Paramtres de la base de donnes
	 * @return integer Identifiant
	 */
	function getLastId($My_SQL) {
		return $this->sgbd->getLastId($My_SQL);
	}

	/**
	 * Prpare les donnes  tre enregistres dans la base de donnes en codant les apostrophes.
	 * @param string $texte Texte  prparer
	 * @return string Texte encod.
	 */
	function conditionnertodb($texte) {
		//$texte = utf8_encode($texte);
		return (str_replace("'","''",stripslashes($texte)));
	}

	/**
	 * Prpare les donnes  tre affiches en HTML.
	 * @param string $texte Texte  prparer
	 * @return string Texte encod.
	 */
	function conditionnerHTML($texte) {
		//return (htmlentities($texte,ENT_QUOTES,UTF-8));
		return $texte;
	}

	/**
	 * Prpare les donnes  tre envoyes aux procdures Javascript.
	 * @param string $texte Texte  prparer
	 * @return string Texte encod.
	 */
	function conditionnerJS($texte, $doubleSlash=false) {
		if ($doubleSlash) {
			$texte = str_replace('"','\\\\"',$texte);
		}
		else {
			$texte = str_replace('"','\"',$texte);
		}
		$texte = str_replace("\n",'\n',$texte);
		$texte = str_replace("\r","",$texte);
		return $texte;
	}

	/**
	 * Prpare les donnes  tre incluses dans les formulaires.
	 * @param string $texte Texte  prparer
	 * @return string texte encod.
	 */
	function conditionnerFORM($texte) {
		return (str_replace('"','&quot;',$texte));
	}

	/**
	 * Remplace une donne nulle ou vide par zero.
	 * @param string $valeur Valeur  tester.
	 * @return integer Valeur ou zero.
	 */
	function notVide($valeur) {
		if ($valeur == "") {
			return 0;
		}
		else {
			return $valeur;
		}
	}
	/**
	 * Prpare les donnes  tre exportes en XML.
	 * @param string $texte Texte  prparer
	 * @return string Texte encod.
	 */
	function conditionnerXML($texte) {
		//$texte = str_replace("\n",'\n',$texte);
		//$texte = str_replace("\r","",$texte);
		$texte = utf8_encode($texte);
		return $texte;
	}

	/**
	 * Convertit une date du format Anne-Mois-Jour (SQL) au format Jour/Mois/Anne (Franais).
	 * @param string $ladate Date  convertir.
	 * @return string Date convertie.
	 */
	function date2JMA($ladate){
		if ($ladate == "0000-00-00" || $ladate == "") {
			return "";
		}
		else {
			list($an,$mois,$jour) = explode("-",$ladate);
			return $jour."/".$mois."/".$an;
		}
	}

	/**
	 * Convertit une date du format Jour/Mois/Anne (Franais) au format Anne-Mois-Jour (SQL).
	 * @param string $ladate Date  convertir.
	 * @return string Date convertie.
	 */
	function date2AMJ($ladate){
		if ($ladate == "") {
			return "0000-00-00";
		}
		else {
			list($jour,$mois,$annee) = explode("/",$ladate);
			$jour = str_pad($jour, 2, "0",STR_PAD_LEFT);
			$mois = str_pad($mois, 2, "0",STR_PAD_LEFT);
			if (strlen($annee) == 2) {
				$annee = "20".$annee;
			}
			elseif (strlen($annee) == 1) {
				$annee = "200".$annee;
			}
		}
		return "$annee-$mois-$jour";
	}
} 
?>