<?php
/**
 * Classes des fonctions pour afficher les clients.
 *
 * Elles sont dans une classe pour les isoler des autres fonctions.
 * @package becmsSimpleClient
 * @version 0.1
 * @author Vincent RUIZ <webmaster@arobase.fr>
 * @copyright Copyright  2007, Vincent RUIZ
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 */

require_once("ba_adminclient.php");

/**
 * Classe des fonctions.
 *
 * @package becmsSimpleClient
 */
class displayClients {

	/**
	 * @var object Classe qui donne accs au fonctions de manipulation des clients.
	 */
	var $sgbd;
	/**
	 * Initialise $sgbd avec la classe des fonctions d'accs  la base de donnes des clients.
	 */
	function displayClients() {
		$this->sgbd = new BD_Clients();
	}

	/**
	 * Construit la liste des clients retrouvs.
	 *
	 * Renvoie le code HTML de la liste des clients.
	 * @param array $My_SQL Paramtres de la base de donnes
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
	 * @return string Liste HTML des clients.
	 */
	function get_list_clients($My_SQL,$vars_mod) {
		global $module_name;
		if (file_exists("themes/".get_theme()."/style/".$module_name.".css")) {
			$stylecatalog = "";
		}
		else {
			$stylecatalog = '		<link href="'.$vars_mod["cheminModule"].'lib/style-client.css" rel="stylesheet" type="text/css" media="all"/>
		';
		}
		$admin = new adminClients();
		$clef = array("Id"=>"","codeclient"=>"","passwd"=>"");
		$clients = $this->sgbd->getClients($My_SQL,$clef,"nom");
		if (count($clients) != 0) {
			$listclients = "<ul>";
			foreach ($clients as $client) {
				$civilites = explode("//",_CLIENTCIVILITES);
				if ($client["civilite"] != 0) {
					$civilite = $civilites[$client["civilite"]]." ";
				}
				else {
					$civilite = "";
				}
				$client_ligne = $civilite.$client["prenom"]." ".$client["nom"];
				if ($client["adresse"] != "") {
					$client_ligne .= " - ".str_replace("\n",", ", $client["adresse"]);
				}
				if ($client["codepostal"] != "") {
					$client_ligne .= " - ".$client["codepostal"];
				}
				if ($client["ville"] != "") {
					$client_ligne .= " - ".$client["ville"];
				}
				if ($client["pays"] != "") {
					$client_ligne .= " - ".$client["ville"];
				}
				if ($client["ville"] != "") {
					$client_ligne .= " - ".$client["ville"];
				}
				$listclients .= "<li><a href=\"modules.php?name=SimpleClient&sop=display&".$vars_mod["id_client"]."=".$client["Id"]."\">".$admin->conditionnerHTML($client_ligne)."</a></li>";
			}
			$listclients .= "</ul>";
		}
		else {
			$listclients = "";
		}
		$contenu = '
		<div class="clients">
			<h1>'._AVAILABLECLIENTS.'</h1>
			'.$listclients.'
		</div>';
			
		return $contenu;
	}

	/**
	 * Construit la fiche du client dsign.
	 *
	 * Renvoie le code HTML de la fiche client.
	 * @param array $My_SQL Paramtres de la base de donnes
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
	 * @return string Fiche HTML du client.
	 */
	function get_one_client($My_SQL,$vars_mod) {
		global $module_name;
		if (file_exists("themes/".get_theme()."/style/".$module_name.".css")) {
			$stylecatalog = "";
		}
		else {
			$stylecatalog = '		<link href="'.$vars_mod["cheminModule"].'lib/style-client.css" rel="stylesheet" type="text/css" media="all"/>
		';
		}
		$admin = new adminClients();
		$clef = array("Id"=>$vars_mod[$vars_mod["id_client"]],"codeclient"=>"","passwd"=>"");
		$clients = $this->sgbd->getClients($My_SQL,$clef,"");
		if (count($clients) != 0) {
			$client = $clients[0];

			$civilites = explode("//",_CLIENTCIVILITES);

			if ($client["civilite"] != 0) {
				$civilite = $civilites[$client["civilite"]]." ";
			}
			else {
				$civilite = "";
			}

			$coords_client = $civilite.$client["prenom"]." ".$client["nom"];
			if ($client["societe"] != "") {
				$coords_client .= "<br />".$client["societe"];
			}
			if ($client["adresse"] != "") {
				$coords_client .= "<br />".$client["adresse"];
			}
			$coords_client .= "<br />".$client["codepostal"]." ".$client["ville"];
			if ($client["pays"] != "") {
				$coords_client .= "<br />".$client["pays"];
			}
			$contacts_client = "";
			if ($client["tel"] != "") {
				$contacts_client .= _CLIENTTEL.$client["tel"];
			}
			if ($client["fax"] != "") {
				$contacts_client .= "<br />"._CLIENTFAX.$client["fax"];
			}
			if ($client["portable"] != "") {
				$contacts_client .= "<br />"._CLIENTPORTABLE.$client["portable"];
			}
			if ($client["email"] != "") {
				$contacts_client .= "<br />"._CLIENTEMAIL.$client["email"];
			}
			$sortie = '<center><table border="0" cellpadding="0" cellspacing="0" class="setclient">';
			$sortie .= '<tr><td valign="top">';
			$sortie .= $coords_client;
			$sortie .= '</td><td width="20">';
			$sortie .= '</td><td valign="top">';
			$sortie .= $contacts_client;
			$sortie .= '</td></tr>';
			$sortie .= '<tr><td valign="top">';
			$sortie .= '&nbsp;';
			$sortie .= '</td><td width="20">';
			$sortie .= '</td><td valign="top">';
			$sortie .= '&nbsp;';
			$sortie .= '</td></tr>';
			$sortie .= '<tr><td valign="top">';
			$sortie .= _CLIENTCODECLIENT.$client["codeclient"];
			$sortie .= '</td><td width="20">';
			$sortie .= '</td><td valign="top">';
			$sortie .= _CLIENTMOTPASE.$client["passwd"];
			$sortie .= '</td></tr>';

			$sortie .= '<tr><td valign="top">';
			$sortie .= '&nbsp;';
			$sortie .= '</td><td width="20">';
			$sortie .= '</td><td valign="top">';
			$sortie .= '&nbsp;';
			$sortie .= '</td></tr>';
			$sortie .= '<tr><td valign="top">';
			$sortie .= _CLIENTANNIVERSAIRE.adminClients::date2JMA($client["datenaissance"]);
			$sortie .= '</td><td width="20">';
			$sortie .= '</td><td valign="top">';
			if ($client["valide"]){
				$sortie .= _CLIENTVALIDE;
			}
			else {
				$sortie .= _CLIENTNOTVALIDE;
			}
			$sortie .= '</td></tr>';

			$sortie .= '<tr><td valign="top">';
			$sortie .= '&nbsp;';
			$sortie .= '</td><td width="20">';
			$sortie .= '</td><td valign="top">';
			$sortie .= '&nbsp;';
			$sortie .= '</td></tr>';
			$sortie .= '<tr><td valign="top">';
			if ($client["services"] != "") {
				$sortie .= _CLIENTSERVICES.$client["services"];
			}
			$sortie .= '</td><td width="20">';
			$sortie .= '</td><td valign="top">';
			if ($client["divers"] != "") {
				$sortie .= _CLIENTDIVERS.$client["divers"];
			}
			$sortie .= '</td></tr>';
			$sortie .= '</table></center>';
		}
		$contenu = '
		<div class="clients">
			<h1>'._ONECLIENT.'</h1>
			'.$sortie.'
		</div>';
			
		return $contenu;
	}

	/**
	 * Renvoie un formulaire permettant de crer ou modifier le compte client.
	 * @param array $My_SQL Paramtres de la base de donnes.
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
	 * @param array $new_client Tableau contenant le compte client.
	 * @param string $erreur Erreur ayant empch l'ergistrement prcdent.
	 * @param string $alerte_code Erreur ayant empch l'enregistrement prcdent.
	 * @param string $operation Code permettant de dterminer l'opration dclenche lors de la validation du formulaire.
	 * @return string Formulaire HTML permettant de modifier le compte client.
	 */
	function edit_client($My_SQL,$vars_mod,$new_client,$erreur="",$alerte_code="",$operation="save_new_client") {
		global $module_name, $currentlang, $seps;
		if (file_exists("themes/".get_theme()."/style/".$module_name.".css")) {
			$stylecatalog = "";
		}
		else {
			$stylecatalog = '		<link href="'.$vars_mod["cheminModule"].'lib/style-client.css" rel="stylesheet" type="text/css" media="all"/>
		';
		}
		
		switch ($currentlang) {
			case "italian" :
				$suffixe = "_I";
				break;
			case "french" :
				$suffixe = "_F";
				break;
			case "spanish" :
				$suffixe = "_S";
				break;
			case "english" :
				$suffixe = "_E";
				break;
			case "german" :
				$suffixe = "_A";
				break;
		}
		$contenu = "";
		if ($erreur != "") {
			$contenu .= '<p class="alerte">'.$erreur.'<br />&nbsp;</p>';
		}
		if ($alerte_code != "") {
			$alerte_code = '<p class="alerte">'.$alerte_code.'</p>';
		}

		$pays = $this->sgbd->getPays($My_SQL,$suffixe);
		$menuPays = '<select name="pays" size="1" class="saisie_petit">
					<option value=""></option>';
		foreach($pays as $unpays) {
			if ($unpays["code"] == $new_client["pays"]){
				$selected = ' selected="selected"';
			}
			else {
				$selected = "";
			}
			$menuPays .= '<option value="'.$unpays["code"].'"'.$selected.'>'.$unpays["pays".$suffixe].'</option>';
		}
		$menuPays .= '</select>';

		$new_client["datenaissance"] = adminClients::date2JMA($new_client["datenaissance"]);
		$civilites = explode("//",_CLIENTCIVILITES);
		$menuCivilite = '<select name="civilite" size="1">';
		for ($i=0;$i<count($civilites);$i++) {
			if ($new_client["civilite"] == $i) {
				$selected = ' selected="selected"';
			}
			else {
				$selected = "";
			}
			$menuCivilite .= '<option value="'.$i.'"'.$selected.'>'.$civilites[$i].'</option>';
		}
		$menuCivilite .= '</select>';

		if ($new_client["newsletter"] == "1" || $new_client["Id"] == "-1") {
			$checked2 = ' checked="checked"';
		}
		else {
			$checked2 = '';
		}

		$contenu .= '<div align="center">
				<table border="0" cellpadding="0" cellspacing="0" class="setclient" id="left">
			      <tr>
			        <td style="vertical-align: top;">
			        <table style="text-align: left;" border="0" cellpadding="0" cellspacing="2" class="saisie">
			        	<tr>
			              <td style="width: 80px;">'._CLIENTCIVILITE.'</td>
			              <td>'.$menuCivilite.'</td>
			            </tr>
						<tr>
			              <td style="width: 80px;">'._CLIENTNOMEDIT.'</td>
			              <td><input type="text" name="nom" class="saisie_petit" value="'.adminClients::conditionnerFORM($new_client["nom"]).'" /></td>
			            </tr>
			            <tr>
			              <td>'._CLIENTPRENOMEDIT.'</td>
			              <td><input type="text" name="prenom" class="saisie_petit" value="'.adminClients::conditionnerFORM($new_client["prenom"]).'" /></td>
			            </tr>
						<tr>
			              <td>'._CLIENTSOCIETEEDIT.'</td>
			              <td><input type="text" name="societe" class="saisie_petit" value="'.adminClients::conditionnerFORM($new_client["societe"]).'" /></td>
			            </tr>
			            <tr>
			              <td>'._CLIENTADRESSEEDIT.'</td>
			              <td><textarea cols="20" rows="3" name="adresse" class="saisie_petit">'.adminClients::conditionnerFORM($new_client["adresse"]).'</textarea></td>
			            </tr>
			            <tr>
			              <td>'._CLIENTCODEPOSTALEDIT.'</td>
			              <td><input type="text" name="codepostal" class="saisie_petit" value="'.adminClients::conditionnerFORM($new_client["codepostal"]).'" /></td>
			            </tr>
			            <tr>
			              <td>'._CLIENTVILLEEDIT.'</td>
			              <td><input type="text" name="ville" class="saisie_petit" value="'.adminClients::conditionnerFORM($new_client["ville"]).'" /></td>
			            </tr>
			            <tr>
			              <td>'._CLIENTPAYSEDIT.'</td>
			              <td><!--<input type="text" name="pays" class="saisie_petit" value="'.adminClients::conditionnerFORM($new_client["pays"]).'" />-->'.$menuPays.'</td>
			            </tr>
			            <!--<tr>
			              <td>'._CLIENTDIVERSEDIT.'</td>
			              <td></td>
			            </tr>-->
			        </table>
			        </td>
			        <td style="width: 30px;">&nbsp;</td>
			        <td style="vertical-align: top;">
			        <table border="0" cellpadding="0" cellspacing="2" class="saisie">
			            <tr>
			              <td style="width: 80px;">'._CLIENTTELEDIT.'</td>
			              <td><input type="text" name="tel" class="saisie_petit" value="'.adminClients::conditionnerFORM($new_client["tel"]).'" /></td>
			            </tr>
			            <tr>
			              <td>'._CLIENTFAXEDIT.'</td>
			              <td><input type="text" name="fax" class="saisie_petit" value="'.adminClients::conditionnerFORM($new_client["fax"]).'" /></td>
			            </tr>
			            <tr>
			              <td>'._CLIENTPORTABLEEDIT.'</td>
			              <td><input type="text" name="portable" class="saisie_petit" value="'.adminClients::conditionnerFORM($new_client["portable"]).'" /></td>
			            </tr>
			            <tr>
			              <td>'._CLIENTEMAILEDIT.'</td>
			              <td><input type="text" name="email" class="saisie_petit" value="'.adminClients::conditionnerFORM($new_client["email"]).'" onchange="this.form.codeclient.value=this.value" /></td>
			            </tr>
			            <!--<tr>
			              <td>'._CLIENTSERVICESEDIT.'</td>
			              <td><input type="text" name="services" class="saisie_petit" value="'.adminClients::conditionnerFORM($new_client["services"]).'" /></td>
			            </tr>-->
						<tr>
			              <td colspan="2">'.'&nbsp;</td>
			            </tr>
			            <tr>
			              <td>'._CLIENTANIVERSAIREEDIT.'</td>
			              <td><input type="text" name="datenaissance" class="saisie_petit" value="'.$new_client["datenaissance"].'" /></td>
			            </tr>
						<tr>
			              <td colspan="2">'.$alerte_code.'&nbsp;</td>
			            </tr>
			            <tr>
			              <td>'._CLIENTCODECLIENTEDIT.'</td>
			              <td><input type="text" name="codeclient" class="saisie_petit" value="'.adminClients::conditionnerFORM($new_client["codeclient"]).'" readonly="readonly" /></td>
			            </tr>
						<tr>
			              <td>'._CLIENTPASSCLIENTEDIT.'</td>
			              <td><input type="password" name="passwd" class="saisie_petit" value="'.adminClients::conditionnerFORM($new_client["passwd"]).'" /></td>
			            </tr>
						<tr>
			              <td>'._CLIENTPASS2CLIENTEDIT.'</td>
			              <td><input type="password" name="passwd2" class="saisie_petit" value="'.adminClients::conditionnerFORM($new_client["passwd"]).'" /></td>
			            </tr>
			            <tr>
			              <td>'._CLIENTNEWSLETTEREDIT.'</td>
			              <td><input name="newsletter" value="1" type="checkbox"'.$checked2.' /></td>
			            </tr>
						<!--<tr>
			              <td>'._CLIENTVALIDEEDIT.'</td>
			              <td><input type="text" name="valide" value="1" type="checkbox"'.$checked.' /></td>
			            </tr>-->
			        </table>
			        </td>
			      </tr>
			      <tr>
			        <td colspan="3" style="text-align: center">&nbsp;<br />'._CLIENTREQUIREDEDIT.'<br />&nbsp;<br /><input type="hidden" value="'.$new_client["Id"].'" name="Id"><input name="validform" value="'._CLIENTSAVEEDIT.'" type="submit"></td>
			      </tr>
			  </table>
			</div>';
		$sortie = $stylecatalog.
		'<div class="clients">
			<h1>'._CATALOGClIENTCOORDS.'</h1>';
		$sortie .= '
			<form method="post" action="modules.php?name='.$module_name.'&sop='.$operation.'" onsubmit="return valid(this);" name="f_client">
			'.$contenu.'
			</form>
		</div>
<script type="text/javascript">
	function validMail(email) {
		if (email == "") {
			return(true);
		}
		else {
			if ((email.indexOf("@") == -1) || (email.indexOf("@") == 0) || (email.indexOf("@") != email.lastIndexOf("@")) || (email.indexOf(".") == email.indexOf("@")-1) || (email.indexOf(".") == email.indexOf("@") + 1) || (email.indexOf("@") == email.length -1) || (email.indexOf (".") == -1) || (email.lastIndexOf (".") == email.length -1) || (email.indexOf (";") != -1) || (email.indexOf (" ") != -1)) {
				return(false);
			}
			else return(true);
		}
	}
	function valid(formulaire) {
		var ok = true;
		var compteur=0;
		
		if (formulaire.nom.value == "") {
			alert("'._CLIENTVERIFNOM.'");
			return false;
		}
		if (formulaire.prenom.value == "") {
			alert("'._CLIENTVERIFPRENOM.'");
			return false;
		}
		if (formulaire.codepostal.value == "") {
			alert("'._CLIENTVERIFCODEPOSTAL.'");
			return false;
		}
		if (formulaire.adresse.value == "") {
			alert("'._CLIENTVERIFADRESSE.'");
			return false;
		}
		if (formulaire.ville.value == "") {
			alert("'._CLIENTVERIFVILLE.'");
			return false;
		}
		if (formulaire.email.value =="") {
			alert("'._CLIENTVERIFEMAILEMPTY.'");
			return false;
		}
		/*if ((formulaire.tel.value+formulaire.fax.value+formulaire.portable.value+formulaire.email.value) == "") {
			alert("'._CLIENTVERIFCONTACT.'");
			return false;
		}*/
		if (!validMail(formulaire.email.value)) {
			alert("'._CLIENTVERIFEMAIL.'");
			return false;
		}
		if (formulaire.pays.value =="") {
			alert("'._CLIENTVERIFPAYS.'");
			return false;
		}
		if (formulaire.codeclient.value != formulaire.email.value) {
			formulaire.codeclient.value = formulaire.email.value;
		}
		if (formulaire.passwd.value == "") {
			alert("'._CLIENTVERIFPASS.'");
			return false;
		}
		if (formulaire.passwd.value != formulaire.passwd2.value) {
			alert("'._CLIENTVERIF2PASS.'");
			return false;
		}
		return ok;
	}
</script>';
		return $sortie;
	}
	
	/**
	 * Enregistre la fiche du client envoy. Si ce client n'existe pas au pralable, aucune nouvelle fiche n'est cre.
	 *
	 * Renvoie le rsultat de l'opration.
	 * @param array $My_SQL Paramtres de la base de donnes
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
	 * @param array $new_client Tableau contenant le compte client.
	 * @return string Fiche HTML du client.
	 */
	function save_client($My_SQL,$vars_mod,$new_client) {
		$sortie = "";
		if ($new_client["Id"] != "" && $new_client["Id"] != "-1") {
			$clef = array();
			$clef["codeclient"] = "";
			$clef["passwd"] = "";
			$clef["Id"] = $new_client["Id"];
			$clients = $this->sgbd->getClients($My_SQL,$clef);
			$client = $clients[0];
			$new_client["valide"] = $client["valide"];
			$new_client["divers"] = $client["divers"];
			$new_client["categorie"] = $client["categorie"];
			$new_client["codeconfirm"] = $client["codeconfirm"];
			$new_client["pageperso"] = $client["pageperso"];
			if ($this->sgbd->saveClient($My_SQL,$new_client)) {
				$clef = array();
				$clef["codeclient"] = "";
				$clef["passwd"] = "";
				if ($_SESSION["id_client"] != "") { // ce test ne sert  rien mais je le garde pour plus tard, on ne sait jamais
					$clef["Id"] = $_SESSION["id_client"];
					$objetClient = new adminClients();
					$sortie .= $objetClient->send_confirm_client($My_SQL,$vars_mod,_CATALOGMESSAGESUBJECTCHANGEDCLIENT,_CATALOGMESSAGECHANGEDCLIENT);
				}
				else {
					$clef["Id"] = $this->sgbd->getLastId($My_SQL);
					$objetClient = new adminClients();
					$sortie .= $objetClient->send_confirm_client($My_SQL,$vars_mod,_CATALOGMESSAGESUBJECTNEWCLIENT,_CATALOGMESSAGENEWCLIENT);
				}
				$_SESSION["id_client"] = $clef["Id"];
				$_SESSION["nom_client"] = $this->sgbd->get_client_identity($My_SQL,$_SESSION["id_client"]);
				$sortie .= "<p>"._CLIENTACCOUNTSAVED."</p>";
			}
			else {
				//erreur : client non enregistr
				$erreur = _CATALOGClIENTBADSAVE;
				if ($this->sgbd->exists_code($My_SQL,$new_client["codeclient"])) {
					$alertecode = _CATALOGClIENTBADCODE;
				}
				$sortie .= $this->edit_client($My_SQL,$vars_mod,$new_client,$erreur,$alertecode,"save_client");
			}
			$sortie = $stylecatalog.
			'<div class="clients">
				<h1>'._CLIENTMONCOMPTE.'</h1>
				'.$sortie.'
			</div>';
			return $sortie;
		}
	}
	
	/**
	 * Valide la fiche du client dsign.
	 *
	 * Renvoie le rsultat de l'opration.
	 * @param array $My_SQL Paramtres de la base de donnes
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
	 * @return string Fiche HTML du client.
	 */
	function valid_one_client($My_SQL,$vars_mod) {
		global $module_name;
		if (file_exists("themes/".get_theme()."/style/".$module_name.".css")) {
			$stylecatalog = "";
		}
		else {
			$stylecatalog = '		<link href="'.$vars_mod["cheminModule"].'lib/style-client.css" rel="stylesheet" type="text/css" media="all"/>
		';
		}
		$clef = array("Id"=>"","codeclient"=>"","passwd"=>"");
		$clients = $this->sgbd->getClients($My_SQL,$clef,"","",$vars_mod[$vars_mod["code_confirm"]]);
		$sortie = "";
		if (count($clients) == 1) {
			$client = $clients[0];
			$client["valide"] = "1";
			$client["codeconfirm"] = "";
			$vars_mod[$vars_mod["id_client"]] = $client["Id"];
			if ($this->sgbd->saveClient($My_SQL,$client)) {
				$sortie = '<p class="alerte">'._CLIENTVALIDATED.'</p>';
				$objetClient = new adminClients();
				$sortie .= $objetClient->send_confirm_client($My_SQL,$vars_mod,_CLIENTMESSAGESUBJECTNEWCLIENT,_CLIENTMESSAGENEWCLIENT);
			}
			else {
				$sortie .= '<p class="alerte">'._CLIENTNOSAVED.'</p>';
			}
		}
		else {
			$sortie = '<p class="alerte">'._CLIENTNOTVALIDATED.'</p>';
		}
		$sortie = $stylecatalog.
		'<div class="clients">
			<h1>'._CLIENTMONCOMPTE.'</h1>
			'.$sortie.'
		</div>';
		return $sortie;
	}
	
	/**
	 * Affiche la page d'accueil du client dsign.
	 *
	 * Si c'est un client normal (sans catgorie ni page d'accueil), un message d'alerte lui est affich.
	 * @param array $My_SQL Paramtres de la base de donnes
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
	 * @param array $clef Tableau contennant les identifiants du client en cours.
	 * @return string Fiche HTML du client.
	 */
	function affiche_accueil_client($My_SQL,$vars_mod,$clef) {
		global $nukeurl;
		$clients = $clients = $this->sgbd->getClients($My_SQL,$clef);
		$client = $clients[0];
		if ($client["pageperso"] != "") {
			$_SESSION["id_client"] = $client["Id"];
			$_SESSION["nom_client"] = array("civilite" => $client["civilite"], "prenom" => $client["prenom"],"nom" => $client["nom"]);
			$tab_serveur = parse_url($nukeurl);
			$racine = $tab_serveur["scheme"]."://";
			if ($tab_serveur["user"] != "") {
				$racine .= $tab_serveur["user"];
			}
			if ($tab_serveur["pass"] != "") {
				$racine .= ":".$tab_serveur["pass"];
			}
			if ($tab_serveur["pass"] != "" || $tab_serveur["user"] != "") {
				$racine .= "@";
			}
			$racine .= $tab_serveur["host"];
			if ($tab_serveur["port"] != "") {
				$racine .= ":".$tab_serveur["port"];
			}
			$lien = $racine."/".$client["pageperso"];
			Header("Location: ".$lien);
			$link = '<a href="'.$lien.'">GO</a>';
			return "<h1>"._CLIENTMONCOMPTE."</h1><p>".str_replace("<!--link-->",$link,_CLIENTLOGPARTOK)."</p>";
		}
		else {
			$_SESSION["id_client"] = "";
			$_SESSION["nom_client"] = array();
			return "<h1>"._CLIENTMONCOMPTE."</h1><p>"._CLIENTLOGPARTPASOK."</p>";
		}
	}
	
	/**
	 * Affiche le contenu d'une page en camouflant l'usage du module section.
	 *
	 * Si le client n'est pas logg, un message d'alerte lui est affich.
	 * @param array $My_SQL Paramtres de la base de donnes
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
	 * @param integer $art Indentifiant de la page  afficher.
	 * @return string Fiche HTML du client.
	 */
	function affiche_page_client($My_SQL,$vars_mod) {
		global $module_name;
		if (file_exists("themes/".get_theme()."/style/".$module_name.".css")) {
			$stylecatalog = "";
		}
		else {
			$stylecatalog = '		<link href="'.$vars_mod["cheminModule"].'lib/style-client.css" rel="stylesheet" type="text/css" media="all"/>
		';
		}
		if ($_SESSION["id_client"] != "" && $_SESSION["id_client"]!= "-1") {
			$clef =array("Id"=>$_SESSION["id_client"]);
			//$clients = $clients = $this->sgbd->getClients($My_SQL,$clef);
			//$client = $clients[0];
			$lien_edit_account = '<a href=';
			require_once("modules/Sections/connector_class.php");
			$sectmodule = new pageconnector();
			return $stylecatalog."\n".$sectmodule->getPageContent($vars_mod[$vars_mod["article_client"]])."\n".$this->client_bar();
		}
		else {
			$_SESSION["id_client"] = "";
			$_SESSION["nom_client"] = array();
			return "<h1>"._CLIENTMONCOMPTE."</h1><p>"._CLIENTLOGPARTPASOK."</p>";
		}
	}
	
	/**
	 * Renvoie le menu permettant d'excuter des actions lies aux comptes clients.
	 *
	 * Son contenu dpend de l'tat de l'identification du client
	 * @param array $My_SQL Paramtres de la base de donnes.
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
	 * @return string Barre des actions.
	 */
	function client_bar() {
		global $module_name;

		$barre .= '&nbsp;<br /><table cellpadding="0" cellspacing="0" border="0" class="clientbar" align="center"><tr>';
		$barre .= '<td>';
		if ($_SESSION["id_client"] != "") {
			$barre .= '<a href="modules.php?name='.$module_name.'&sop=close_client">'._CLIENTBARACCOUNTCLOSE.'</a>';
			$barre .= '</td><td>';
			$barre .= '&nbsp;|&nbsp;';
			$barre .= '</td><td>';
			$barre .= '<a href="modules.php?name='.$module_name.'&sop=edit_client">'._CLIENTBARACCOUNTCHANGE.'</a>';
			$barre .= '</td><td>';
		}
		$barre .= '</td>';
		$barre .= '</tr></table>&nbsp;<br />';

		return $barre;
	}

	/**
	 * Renvoie l'URL d'un picto.
	 *
	 * La fonction vrifie l'existance du picto dans le thme. S'il existe, son URL est envoy, sinon c'est l'URL du picto par dfaut qui est renvoy.
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
	 * @param string $picto Nom du picto  renvoyer.
	 * @return string URL du picto  afficher.
	 */
	function get_picto_url($vars_mod,$picto) {
		global $module_name;
		if (file_exists("themes/".get_theme()."/images/".$picto)) {
			$url = "themes/".get_theme()."/images/".$picto;
		}
		else {
			$url = $vars_mod["cheminModule"].'lib/icns/'.$picto;
		}
		return $url;
	}

	/**
	 * Renvoie un formulaire permettant de s'identifier si un compte client existe ou d'ouvrir le formulaire de cration de compte.
	 * @param array $My_SQL Paramtres de la base de donnes.
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
	 * @param string $erreur Erreur ayant empch l'identification.
	 * @return string Formulaire HTML permettant de choisir le compte client.
	 */
	function set_client($My_SQL,$vars_mod,$erreur="") {
		global $module_name, $currentlang, $seps;
		if (file_exists("themes/".get_theme()."/style/".$module_name.".css")) {
			$stylecatalog = "";
		}
		else {
			$stylecatalog = '		<link href="'.$vars_mod["cheminModule"].'lib/style-client.css" rel="stylesheet" type="text/css" media="all"/>
		';
		}

		$contenu = '<div align="center">';
		$contenu .= '<form action="modules.php?name='.$module_name.'&sop=get_client" method="POST" name="compteclient">';
		$contenu .= '<table border="0" cellpadding="0" cellspacing="0" class="setclient">';
		if (_CLIENTMESSIDENTIF != "") {
			$contenu .= "<tr><td colspan=\"5\" style=\"padding: 10px\"><p>"._CLIENTMESSIDENTIF."</p></td></tr>";
		}
		$contenu .= '<tr><td class="titre">';
		$contenu .= _CLIENTClIENTCHOOSE;
		$contenu .= '</td><td width="20">';
		$contenu .= '</td><td width="1">';
		$contenu .= '</td><td width="20">';
		$contenu .= '</td><td  class="titre">';
		$contenu .= _CLIENTClIENTNEW;
		$contenu .= '</td></tr>';
		$contenu .= '<tr><td valign="top">';
		$contenu .= '<table border="0" cellpadding="2" cellspacing="0">';
		$contenu .= '<tr><td class="separation"></td></tr>';
		if ($erreur !="") {
			$contenu .= '<tr><td class="titre">'.$erreur.'</td></tr>';
		}
		$contenu .= '<tr><td>';
		$contenu .= _CLIENTClIENTID.'<br />';
		$contenu .= '<input type ="text" value="" name="codeclient" class="saisie_petit">';
		$contenu .= '</td></tr>';
		$contenu .= '<tr><td>';
		$contenu .= _CLIENTClIENTPASSWD.'<br />';
		$contenu .= '<input type ="password" value="" name="passwd" class="saisie_petit">';
		$contenu .= '</td></tr>';
		$contenu .= '<tr><td class="separation"></td></tr>';
		//$contenu .= '<tr><td align="center">';
		//$contenu .= '<input type="submit" name="validb" value="'._CATALOGClIENTVALIDATE.'">';
		//$contenu .= '</td></tr>';
		$contenu .= '</table>';
		$contenu .= '</td><td width="20" rowspan="2">';
		$contenu .= '</td><td width="1" rowspan="2" background="'.$this->get_picto_url($vars_mod,"sepvert.gif").'">';
		$contenu .= '</td><td width="20" rowspan="2">';
		$contenu .= '</td><td valign="top">';
		$contenu .= '<table border="0" cellpadding="2" cellspacing="0">';
		$contenu .= '<tr><td class="separation"></td></tr>';
		$contenu .= '<tr><td>';
		$contenu .= _CLIENTClIENTARGUE;
		$contenu .= '<tr><td class="separation"></td></tr>';
		//$contenu .= '<tr><td align="center">';
		//$contenu .= '<input type="button" name="vnewc" value="'._CATALOGClIENTJOIN.'" onclick="window.location.href=\'modules.php?name='.$module_name.'&sop=new_client\'">';
		//$contenu .= '</td></tr>';
		$contenu .= '</table>';
		$contenu .= '</td></tr>';
		$contenu .= '<tr><td align="center">';
		$contenu .= '<input type="submit" name="validb" value="'._CLIENTClIENTVALIDATE.'">';
		$contenu .= '</td><td align="center">';
		$contenu .= '<input type="button" name="vnewc" value="'._CLIENTClIENTJOIN.'" onclick="window.location.href=\''.$vars_mod["lien_inscription"].'\'">';
		$contenu .= '</td></tr>';
		$contenu .= '<tr><td colspan="5" height="20"></td></tr>';
		$contenu .= '<tr><td colspan="5" height="1" background="'.$this->get_picto_url($vars_mod,"sephor.gif").'"></td></tr>';
		$contenu .= '<tr><td colspan="5" height="10"></td></tr>';
		$contenu .= '<tr><td align="center" colspan="5" class="titre">'._CLIENTClIENTFORGET.'</td></tr>';
		$contenu .= '<tr><td colspan="5" height="5"></td></tr>';
		$contenu .= '<tr><td align="center" colspan="5" class="titre"><input type="button" value="'._CLIENTClIENTFIND.'" onclick="window.location.href=\'modules.php?name='.$module_name.'&sop=get_ids\'"></td></tr>';
		$contenu .= '</table>';
		$contenu .= '</form>';
		$contenu .= '</div>';

		$sortie = $stylecatalog.
		'<div class="clients">
			<h1>'._CLIENTMONCOMPTE.'</h1>
			'.$contenu.'
		</div>';
		return $sortie;
	}
	
	/**
	 * Renvoie un formulaire permettant de rcuprer ses identifiants sur sa messagerie.
	 * @param array $My_SQL Paramtres de la base de donnes.
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
	 * @param string $erreur Erreur ayant empch l'expdition de l'e-mail.
	 * @return string Formulaire HTML permettant de choisir le compte client.
	 */
	function get_ids($My_SQL,$vars_mod,$erreur="") {
		global $module_name, $currentlang, $seps;
		if (file_exists("themes/".get_theme()."/style/".$module_name.".css")) {
			$stylecatalog = "";
		}
		else {
			$stylecatalog = '		<link href="'.$vars_mod["cheminModule"].'lib/style-client.css" rel="stylesheet" type="text/css" media="all"/>
		';
		}

		$contenu = '<div align="center">';
		$contenu .= '<form action="modules.php?name='.$module_name.'&sop=send_ids" method="POST" name="compteclient">';
		$contenu .= '<table border="0" cellpadding="0" cellspacing="0" class="setclient">';
		$contenu .= '<tr><td class="titre">';
		$contenu .= _CLIENTClIENTFORGETIDENT;
		$contenu .= '</td></tr>';
		if ($erreur !="") {
			$contenu .= '<tr><td class="titre">'.$erreur.'</td></tr>';
		}
		$contenu .= '<tr><td height="10"></td></tr>';
		$contenu .= '<tr><td>';
		$contenu .= _CLIENTClIENTMAILIDENT.'<br />';
		$contenu .= '<input type ="text" value="'.adminClients::conditionnerFORM($vars_mod[$vars_mod["mailclient"]]).'" name="'.$vars_mod["mailclient"].'" class="saisie_petit">';
		$contenu .= '</td></tr>';
		$contenu .= '<tr><td height="10"></td></tr>';
		$contenu .= '<tr><td align="center">';
		$contenu .= '<input type="submit" name="validb" value="'._CLIENTClIENTVALIDATE.'">';
		$contenu .= '</td></tr>';
		$contenu .= '</table>';
		$contenu .= '</form>';
		$contenu .= '</div>';

		$sortie = $stylecatalog.
		'<div class="clients">
			<h1>'._CLIENTClIENTIDENTS.'</h1>
			'.$contenu.'
		</div>';
		return $sortie;
	}
	
	/**
	 * Vrification de la syntaxe d'un e-mail.
	 * @param string $adresse Adresse d'expdition de l'e-mail.
	 * @return boolean True si la syntaxe est correcte, false sinon.
	 */
	function check_email($adresse) {
		$Syntaxe='^[a-z0-9]+[a-z0-9?.+-_\']*@[a-z0-9_-]+(\.[a-z0-9_-]+)*\.[a-z]{2,25}$';
		if(preg_match("#$Syntaxe#i",$adresse)) {
			return true;
		}
		else {
			return false;
		}
	}
	
	/**
	 * Envoie les identifiants retrouvs ou un formulaire permettant de ressaisir son email.
	 * @param array $My_SQL Paramtres de la base de donnes.
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
	 * @return string Formulaire HTML permettant de choisir le compte client.
	 */
	function send_ids($My_SQL,$vars_mod) {
		global $module_name, $currentlang, $seps;
		if ($vars_mod[$vars_mod["mailclient"]] != "") {
			if ($this->check_email($vars_mod[$vars_mod["mailclient"]])) {
				$ids = $this->sgbd->get_client_ids($My_SQL,$vars_mod[$vars_mod["mailclient"]]);
				if (count($ids) != 0) {
					if (file_exists("themes/".get_theme()."/style/".$module_name.".css")) {
						$stylecatalog = "";
					}
					else {
						$stylecatalog = '		<link href="'.$vars_mod["cheminModule"].'lib/style-client.css" rel="stylesheet" type="text/css" media="all"/>
					';
					}
					$message = "";
					foreach ($ids as $clientids) {
						$messagetemp = _CLIENTMESSAGEGETCLIENTIDS;
						$messagetemp = str_replace("<!--nom-->",$clientids["nom"],$messagetemp);
						$messagetemp = str_replace("<!--prenom-->",$clientids["prenom"],$messagetemp);
						$messagetemp = str_replace("<!--codeclient-->",$clientids["codeclient"],$messagetemp);
						$messagetemp = str_replace("<!--passwd-->",$clientids["passwd"],$messagetemp);
						$message .= $messagetemp."\n\n";
					}
					$sujet = _CLIENTMESSAGESUBJECTCLIENTIDS;
					if ($this->send_email($vars_mod[$vars_mod["mailclient"]],$sujet,$message,$vars_mod["vars_mail"])) {
						//ok
						$contenu = '<div align="center">';
						$contenu .= '<table border="0" cellpadding="0" cellspacing="0" class="setclient">';
						$contenu .= '<tr><td>'._CLIENTMESSAGEGETIDSOK.'</td></tr>';
						$contenu .= '</table>';
						$contenu .= '</div>';
						$sortie = $stylecatalog.
						'<div class="clients">
							<h1>'._CLIENTClIENTIDENTS.'</h1>
							'.$contenu.'
						</div>';
						return $sortie;
					}
					else {
						//pas ok
						$contenu = '<div align="center">';
						$contenu .= '<table border="0" cellpadding="0" cellspacing="0" class="setclient">';
						$contenu .= '<tr><td>'._CLIENTMESSAGEGETIDSERROR.'</td></tr>';
						$contenu .= '</table>';
						$contenu .= '</div>';
						$sortie = $stylecatalog.
						'<div class="clients">
							<h1>'._CLIENTClIENTIDENTS.'</h1>
							'.$contenu.'
						</div>';
						return $sortie;
					}
				}
				else {
					$erreur = _CLIENTMESSAGEGETIDSERROR2;
					return $this->get_ids($My_SQL,$vars_mod,$erreur);
				}
			}
			else {
				$erreur = _CLIENTMESSAGEGETIDSERROR3;
				return $this->get_ids($My_SQL,$vars_mod,$erreur);
			}
		}
		else {
			$erreur = _CLIENTMESSAGEGETIDSERROR3;
			return $this->get_ids($My_SQL,$vars_mod,$erreur);
		}
	}
	
	/**
	 * Expdition d'un e-mail.
	 * @param string $email Adresse d'expdition de l'e-mail.
	 * @param string $subject Sujet de l'e-mail.
	 * @param string $message Corps du massage  expdier.
	 * @return boolean True si le message a t expdi, false sinon.
	 */
	function send_email($email, $subject, $message, $from){
		$vars_mail = $from;
		// En-ttes
		$headers = "From: ".$vars_mail["from"]."\n";
		$headers .= "X-Sender: ".$vars_mail["from"]."\n";
		$headers .= "X-Mailer: PHP\n";
		$headers .= "X-Priority: 1\n";
		$headers .= "Return-Path: ".$vars_mail["from"]."\n";
		$headers .= "Reply-To: ".$vars_mail["nom"]." <".$vars_mail["from"].">\n";
		$headers .= "Content-Type: text/plain; charset=iso-8859-1\n"; // Type MIME
		return mail($email, $subject, $message, $headers);
	}

	/**
	 * Rcupre les variables envoyes par GET ou POST.
	 *
	 * Renvoie ces variables sous la forme de paramtres d'URL.
	 * @param string $sauf Liste des paramtres  ne pas rcuprer.
	 * @return string Liste des variables rcupres.
	 */
	function getVars($sauf) {
		//global $_GET;

		$elimines = explode("|", $sauf);
		$args = "";
		$elts = array_merge($_GET,$_POST);
		if (count($elts) != 0) {
			while (list ($key, $val) = each($elts)) {
				$ok = true;
				foreach ($elimines as $elimine) {
					if ($elimine == $key) {
						$ok = false;
					}
				}
				if ($ok) {
					if ($args != "") {
						$args .= "&";
					}
					$args .= $key . "=" . stripslashes($val);
				}
			}
		}
		else {
			$args = "";
		}
		return $args;
	}
}
?>