<?php

if (!preg_match("#modules.php#i", $_SERVER['PHP_SELF'])) {
	die ("You can't access this file directly...");
}

$module_name = basename(dirname(__FILE__));
get_lang($module_name);

require_once("core/becms_mainlib_lib.php");
require_once("modules/$module_name/params.php");
require_once("modules/$module_name/lib_db.php");
require_once("modules/$module_name/utils.php");

function list_index($nbreFiches, $page, $ligne_par_page) {
	global $module_name;

	$nboites = 5;
	$liminf = $page - floor($nboites/2);
	$limsup = $page + floor($nboites/2);
	if ($liminf < 1) {
		$liminf = 1;
		$limsup = $nboites;
		if ($limsup > ceil($nbreFiches/$ligne_par_page)) {
			$limsup = ceil($nbreFiches/$ligne_par_page);
		}
	}
	if ($limsup > ceil($nbreFiches/$ligne_par_page)) {
		$limsup = ceil($nbreFiches/$ligne_par_page);
		$liminf = $limsup - $nboites;
		if ($liminf < 1) {
			$liminf = 1;
		}
	}
	$min = 1;
	$max = ceil($nbreFiches/$ligne_par_page);


	$repParPage = $ligne_par_page;
	$p = $page;
	$nbrepages = ceil($nbreFiches/$repParPage);
	if ($p>$nbrepages) {
		$p = $nbrepages;
	}
	$indexPages .= "<div class=\"pages\">";
	if ($nbreFiches != 0) {
		$indexPages .= $nbreFiches._FAQFOUND;
		$indexPages .= _FAQPAGES;
		if ($min < $liminf) {
			if ($min == $p ) {
				$indexPages .= "<div class=\"pagevide\">";
				$indexPages .= "$min";
				$indexPages .= "</div>";
			}
			else {
				$indexPages .= "<div class=\"page\">";
				$indexPages .= "<a href=\"?name=".$module_name."&sop=list&page=$min\">$min</a>";
				$indexPages .= "</div>";
			}
			if ($min < $liminf - 1) {
				$indexPages .= "...";
			}
		}
		for ($i=$liminf;$i<=$limsup;$i++) {
			if ($i == $p ) {
				$indexPages .= "<div class=\"pagevide\">";
				$indexPages .= "$i";
				$indexPages .= "</div>";
			}
			else {
				$indexPages .= "<div class=\"page\">";
				$indexPages .= "<a href=\"?name=".$module_name."&sop=list&page=$i\">$i</a>";
				$indexPages .= "</div>";
			}
		}
		if ($max > $limsup) {
			if ($max > $limsup + 1) {
				$indexPages .= "...";
			}
			if ($max == $p ) {
				$indexPages .= "<div class=\"pagevide\">";
				$indexPages .= "$max";
				$indexPages .= "</div>";
			}
			else {
				$indexPages .= "<div class=\"page\">";
				$indexPages .= "<a href=\"?name=".$module_name."&sop=list&page=$max\">$max</a>";
				$indexPages .= "</div>";
			}
	
		}
	}
	else {
		$indexPages .= _FAQNOTFOUND;
	}
	$indexPages .= "</div>";
	return $indexPages;
}

function list_faq($page,$message="") {
	global $module_name,$faqlinesperpage;

	$ligne_par_page = $faqlinesperpage;

	$obj_comm = new BD_FAQ();
	$sortie = "<h1>"._FAQTITLE."</h1>";
	$sortie .= '&nbsp;<br />';
	$sortie .= "<p>"._FAQINTRO."</p>";
	if ($message != "") {
		$sortie.= "<p class=\"warning\"><br />";
		$sortie .= $message;
		$sortie .= "</p>";
	}
	if ($page=="-1") {
		$page = ceil($nbrefiches/$ligne_par_page);
	}
	$sortie .= "</p>&nbsp;</p>";
	$nbreFiches = $obj_comm->getFaq("count","","","1");
	$indexlist = list_index($nbreFiches, $page, $ligne_par_page);

	$sortie .= "<hr class=\"pages\">".$indexlist."<hr class=\"pages\">";

	//$sortie .= '&nbsp;<br />';
	$limit = (($ligne_par_page*($page-1))).",".$ligne_par_page;
	$result2 = $obj_comm->getFaq("files","","","1","",$limit);
	//print_r($_SERVER);
	
	if (count($result2) != 0) {
		$num = 1;
		$sortie .= "<ul class=\"faq\">";
		foreach($result2 as $result2) {
			$sortie .= "<li>";
			$sortie .= "<div class=\"faq\">";
			$sortie .= "<a href=\"#\" onclick=\"showFaq('faqrep', ".$num.");return false\">";
			$sortie .= utilFuncs_SimpleFAQ::conditionnerHTML($result2["commentaire"]);
			$sortie .= "</a>";
			$sortie .= "</div>";
			if ($result2["reponse"] !="") {
				$sortie .= "<div class=\"reponse\" id=\"faqrep".$num."\">";
				$sortie .= "<div class=\"reponsetop\">";
				$sortie .= "<div class=\"reponsebottom\">";
				$sortie .= utilFuncs_SimpleFAQ::conditionnerHTML($result2["reponse"]);
				$sortie .= "</div>";
				$sortie .= "</div>";
				$sortie .= "</div>";
			}
			$sortie .= "</li>";
			$num++;
		}
		$sortie .= "</ul>";
	}
	$sortie .= "<hr class=\"pages\">".$indexlist."<hr class=\"pages\">";
	$sortie .= '&nbsp;<br />';
	//$sortie .= '<hr  class="board" />';
	$sortie .= '<p class="actions">';
	$sortie .= '<a href="modules.php?name='.$module_name.'&sop=new_faq">'._FAQNEWONE.'</a>';
	$sortie .= '</p>';
	$sortie .= '&nbsp;<br />';
	//$sortie .= "<hr class=\"pages\">".$indexlist."<hr class=\"pages\">";
	
	$script = '
<script type="text/javascript" src="modules/'.$module_name.'/lib_interface.js"></script>
<script type="text/javascript">
function showFaq(radical, num) {
	var elements = getTypeElements("div");
	var reg = new RegExp("^" + radical + "[0-9]+$","g");
	for (var i=0; i<elements.length;i++) {
		if (elements[i].id.match(reg)) {
			elements[i].style.display = "none";
		}
	}
	element = getTheElement(radical + num);
	if (element != null) {
		element.style.display = "block";
	}
}
</script>
';


	return $script.$sortie;
}

function edit_faq($newcomm) {
	global $module_name, $user, $sti;
		
	$obj_cat = new BD_FAQ();
	$results = array();

	$sortie = '<h1>'._FAQEDIT.'</h1>';
	$sortie .= '<p>'._FAQPOLICY.'</p>';
	$sortie .= '<p><br />'._FAQWITHCAPTCHA.'</p>';
	$sortie .= '<form name="editboard" action="modules.php?name='.$module_name.'&sop=save_faq" method="POST" onsubmit="return validform(this)">';
	$sortie .= '<div align="center">';
	$sortie .= '<fieldset><legend>'._FAQCOMMEDIT.'</legend>';
	$sortie .= '<table border="0" cellpadding="0" cellspacing="0" class="formulaire">';
	
	$sortie .= '<tr><td>';
	$sortie .= _FAQQUESTIONEDIT;
	$sortie .= '</td><td>';
	$sortie .= '<textarea name="commentaire" cols="50" rows="5" class="saisie">'.$newcomm["commentaire"].'</textarea>';
	$sortie .= '</td></tr>';
	
	if ($newcomm["commentaire"] != "") {
		$sortie .= '<tr><td colspan="2" class="alert">';
		$sortie .= _FAQCODEERROR;
		$sortie .= '</td></tr>';
	}
	
	$sortie .= '<tr><td>';
	$sortie .= _FAQCODEVALID;
	$sortie .= '</td><td>';
	$sortie .= '<table border="0" cellpadding="0" cellspacing="0"><tr><td style="padding: 0">';
	$sortie .= '<img src="modules/'.$module_name.'/image.php" border="0" class="turing">';
	$sortie .= '</td><td style="padding: 0; width: 10px">&nbsp;</td><td style="padding: 0">';
	$sortie .=  $sti->parseStringInput();
	$sortie .= '</td></tr></table>';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td colspan="2" style="text-align: center">';
	$sortie .= _FAQREQUIREDEDIT;
	$sortie .= '</td></tr>';
	
	$sortie .= '</table>';
	
	$sortie .= '<br />';
	$sortie .= '<input type="submit" value="'._FAQSAVEBTN.'" name="valid">';
	$sortie .= '<input type="hidden" value="-1" name="Id">';
	$sortie .= '<br />&nbsp;';
	$sortie .= '</fieldset>';
	$sortie .= '</div>';
	$sortie .= "</form>";
	
	
	$sortie .= '
<script type="text/javascript">
	function validform(formulaire) {
		var ok = true;
		if (formulaire.commentaire.value == "") {
			alert("'._FAQVERIFQUEST.'");
			return false;
		}
		return ok;
	}
</script>';
	return $sortie;
}

function save_faq($newfaq) {
	global $module_name,$nukeurl,$faqadminmail;
	
	$obj_comm = new BD_FAQ();
	$newcomm["dateajout"] = utilFuncs_SimpleFAQ::date2AMJ($newcomm["dateajout"]);
	if ($obj_comm->saveFaq($newfaq)) {
		$message = _FAQSAVED;
		$Id = $obj_comm->lastSaved();
		echo list_faq(1,$message);
		//e-mail adminstrateur
		$tab_serveur = parse_url($nukeurl);
		$racine = $tab_serveur["scheme"]."://";
		if ($tab_serveur["user"] != "") {
			$racine .= $tab_serveur["user"];
		}
		if ($tab_serveur["pass"] != "") {
			$racine .= ":".$tab_serveur["pass"];
		}
		if ($tab_serveur["pass"] != "" || $tab_serveur["user"] != "") {
			$racine .= "@";
		}
		$racine .= $tab_serveur["host"];
		if ($tab_serveur["port"] != "") {
			$racine .= ":".$tab_serveur["port"];
		}
		$racine .= "/system.php?op=faq&action=edit_faq&onglet=faqno&Id=$Id";	
		$commentaire = "\n\n".str_pad("",50,"-")."\n\n".$newfaq["commentaire"]."\n.\n";	
		utilFuncs_SimpleFAQ::send_email($faqadminmail, $faqadminmail, _FAQSUBJECTMAILADMIN, str_replace("<!--lien-->",$racine,_FAQMESSAGEMAILADMIN).$commentaire);
	}
	else {
		$sortie .= "<p>"._FAQNOTSAVED."</p>";
	}
	return $sortie;
}




function displayListFaq($page="1") {
	global $module_name;
	include ('header.php');
	echo list_faq($page);;
	$bardef=array(//"print"=>"modules.php?name=".$module_name."&sop=print",
			//"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
			"back"=>"modules.php?name=$module_name",
            "top"=>"#top" );
	buttonBar($bardef, "align");
	include ('footer.php');
}

function addNewFaq($newfaq = array()) {
	global $module_name;
	include ('header.php');
	echo edit_faq($newfaq);
	$bardef=array(//"print"=>"modules.php?name=".$module_name."&sop=print",
	//"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
				"back"=>"javascript:window.history.back()",
                "top"=>"#top" );
	buttonBar($bardef, "align");
	include ('footer.php');
}

function saveFaq($newfaq) {
	global $module_name;
	include ('header.php');
	echo save_faq($newfaq);
	$bardef=array(//"print"=>"modules.php?name=".$module_name."&sop=print",
	//"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
				"back"=>"modules.php?name=$module_name",
                "top"=>"#top" );
	buttonBar($bardef, "align");
	include ('footer.php');
}


function print_facts($page) {
	global $site_logo,$Default_Theme, $nukeurl, $sitename, $datetime, $prefix, $db;

	if (file_exists("themes/$Default_Theme/style/Sections.css")){
		$moduleStyle= "<LINK REL=\"stylesheet\" HREF=\"themes/$Default_Theme/style/Chuck_Norris_Facts.css\" TYPE=\"text/css\">\n";
	} else if (file_exists("modules/Sections/css/default.css")) {
		$moduleStyle= "<LINK REL=\"StyleSheet\" HREF=\"modules/Chuck_Norris_Facts/css/default.css\" TYPE=\"text/css\">\n";
	} else $moduleStyle="";

	echo "
	<html>
	<head>
	<title>$sitename</title>
	<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=ISO-8859-1\">\n
	<LINK REL=\"StyleSheet\" HREF=\"themes/$Default_Theme/style/style.css\" TYPE=\"text/css\">\n
	$moduleStyle
	</head>
	<body bgcolor=\"#FFFFFF\" text=\"#000000\">
	<table border=\"0\"><tr><td>
	<table border=\"0\" width=\"650\" cellpadding=\"0\" cellspacing=\"1\" bgcolor=\"#000000\"><tr><td>
	<table border=\"0\" width=\"650\" cellpadding=\"20\" cellspacing=\"1\" bgcolor=\"#FFFFFF\"><tr><td>
	<div class=\"printHeader\"><img src=\"images/$site_logo\" border=\"0\" alt=\"\"></div>
	<div class=\"zprint\">"
	.list_citations($page)
	."</div>
		</td></tr></table></td></tr></table>

		<div class=\"printFooter\">
		<div class=\"siteName\">
    "._COMESFROM." $sitename<br>
	<a href=\"$nukeurl\">$nukeurl</a>
	</div>
	<div class=\"pageURL\">
    "._THEURL."<br>
	<a href=\"$nukeurl/modules.php?name=Chuck_Norris_Facts&sop=list&page=$page\">$nukeurl/modules.php?name=Chuck_Norris_Facts&sop=list&page=$page</a>
	</div>
	</div>
	</td></tr></table>
	</body>
	</html>
    ";

}

if (!isset($page)) {
	$page = "1";
}
if ($page == "") {
	$page = "1";
}

$newfaq = array(
	"Id"=>(!isset($Id))?"-1":$Id,
	"commentaire"=>(!isset($commentaire))?"":$commentaire,
	"dateajout"=>date("Y-m-d H:i:s"),
	"reponse"=>"",
	"visible"=>"0"
);

require_once("modules/$module_name/submitTroughImage.class.php");
$sti = new submitTroughImage();
if ($sti->checkPost() === true) {
	$ok = true;
}
elseif ($sti->checkPost() === false) {
	$ok = false;
}
$sti->setFont("modules/$module_name/fonts/DESTROY_.TTF");
$sti->createImage();

switch($sop) {
	case "list":
		displayListFaq($page);
		break;
	case "new_faq":
		addNewFaq();
		break;
	case "save_faq":
		if ($ok) {
			saveFaq($newfaq);
		}
		else {
			addNewFaq($newfaq);
		}
		break;
	case "print":
		print_facts($page);
		break;
	default:
		displayListFaq();
		break;
}
?>