<?php
/**
* Classes d'accs  la base de donnes pour la gestion du Livre d'Or.
* 
* Toutes les fonctions utilisent l'API de la plateforme pour tre indpendante de la base de donnes utilise
* @package becmsSimpleBoard
* @version 0.1
* @author Vincent RUIZ <webmaster@arobase.fr>
* @copyright Copyright  2008, Vincent RUIZ
* @license http://opensource.org/licenses/gpl-license.php GNU Public License 
*/

require_once("utils.php");

/**
* Classe d'accs  la base de donnes petites annonces pour isoler les fonctions.
* 
* @package becmsSimpleFAQ
*/
class BD_FAQ {
	var $My_SQL = array();
	
	function BD_FAQ() {
		global $db,$prefix;
		$this->My_SQL["maBase"] = $db;
		$this->My_SQL["faq"] = $prefix."_faq";
	}
	
/**
* Efface la fiche du commentaire dsigne
* @param integer $Id Identifiant ddu commentaire  supprimer
* @return boolean Retourne true si l'opration s'est bien passe, false sinon
*/		
	function delFaq($Id) {
		$db=$this->My_SQL["maBase"];
		
		if ($Id != "") {
			$cond = "";
			if ($Id != "-1" && $Id != "") {
				if ($cond == "") {
					$cond .= " WHERE ";
				}
				else {
					$cond .= " AND ";
				}
				$cond .= "`Id`='".$Id."'";
			}
			$sql = "DELETE FROM `".$this->My_SQL["faq"]."`".$cond.";";
			return $db->sql_query($sql);
		}
		else {
			return false;
		}
	}
	
/**
* Enregistre un commentaire
* 
* Si le commentaire existe dj, il est simplement modifi, sinon il est cr.
* @param array $commentaire Tableau contenant tous les champs du commentaire  enregistrer
* @return boolean Retourne true si l'opration s'est bien passe, false sinon
*/	
	function saveFaq($faq) {
		$db=$this->My_SQL["maBase"];
		$faq = array_map(array('utilFuncs_SimpleFAQ', 'conditionnertodb'), $faq);
		$list_champs = "";
		$list_valeurs = "";
		if ($faq["Id"] == "-1") {
			foreach($faq as $key => $value) {
				if ($key != "Id") {
					$list_champs .= ($list_champs == "") ? "" : ", ";
					$list_champs .= "`".$key."`";
					$list_valeurs .= ($list_valeurs == "") ? "" : ", ";
					$list_valeurs .= "'".$value."'";
				}
			}
			$sql = "INSERT INTO `".$this->My_SQL["faq"]."` (".$list_champs.")";
			$sql .= " VALUES (".$list_valeurs.");";
		}
		else {
			foreach($faq as $key => $value) {
				if ($key != "Id") {
					$list_champs .= ($list_champs == "") ? "" : ", ";
					$list_champs .= "`".$key."` = '".$value."'";
				}
			}
			$sql = "UPDATE `".$this->My_SQL["faq"]."` SET ".$list_champs." WHERE `Id` = '".$faq["Id"]."';";
		}
		return $db->sql_query($sql);
	}
/**
* Renvoie la liste des commentaires correspondants  la demande
* 
* Un tableau vide est renvoy si aucun commentaire n'est trouv.
* Si tous les critres sont vides,tous les commentairess sont renvoys.
* @param string $the_type Type de recherche (fiches/nbre de fiches) dont les valeurs sont "files" ou "count"
* @param integer $Id Identifiant du commentaire  retrouver
* @param string $redacteur Nom de la personne ayant ajout le commentaire.
* @param string $content Contenu  rechercher.
* @param integer $valid tat du commentaire : valide ou pas.
* @param string $du Date de dbut de recherche.
* @param string $au Date de fin de recherche.
* @param string $tri_par Ordre de tri des fiches renvoyes.
* @param string $limit Indication des enregistrements  retourner (index et nombre).
* @return array Retourne la liste des commentaires retrouvs
*/	
	function getFaq($the_type="files", $Id="", $content="", $valid="", $tri_par="",$limit="") {
		$db=$this->My_SQL["maBase"];
		
		$faq = array();
		$cond = "";
		if ($Id != "-1" && $Id != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$this->My_SQL["faq"]."`.`Id`='".$Id."'";
		}
		if ($content != "") {
			$content = utilFuncs_SimpleFAQ::conditionnertodb($content);
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "(";
			$cond .= "`".$this->My_SQL["faq"]."`.`commentaire` LIKE '%".$content."%'";
			$cond .= " OR ";
			$cond .= "`".$this->My_SQL["faq"]."`.`reponse` LIKE '%".$content."%'";
			$cond .= ")";
		}
		if ($valid !== "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			switch ($valid) {
				case true :
					$valid = "1";
					break;
				case false :
					$valid = "0";
					break;
			}
			$cond .= "`".$this->My_SQL["faq"]."`.`visible` = '".$valid."'";
		}
		//echo  "//$cond//";
		if ($the_type == "files") {
			$oderby = "";
			if ($tri_par =="" || $tri_par =="date") {
				$oderby = " ORDER BY `".$this->My_SQL["faq"]."`.`dateajout` DESC";
			}
			if ($limit != "") {
				$limit = " LIMIT ".trim($limit);
			}
			$resultatRecherche = $db->sql_query("SELECT `Id`,`commentaire`,`dateajout`,`reponse`,`visible` FROM `".$this->My_SQL["faq"]."` ".$cond.$oderby.$limit.";");
			if ($db->sql_numrows($resultatRecherche) != 0) {
				while ($ligneCourante = $db->sql_fetchrow($resultatRecherche)) {
					array_push($faq, $ligneCourante);
				}
			}
			return $faq;
		}
		if ($the_type == "count") {
			$sql = "SELECT count(Id) AS nbre FROM `".$this->My_SQL["faq"]."` ".$cond.";";
			$result = $db->sql_query($sql);
			list($nbrefiches) = $db->sql_fetchrow($result);
			return $nbrefiches;
		}
	}
	
	function lastSaved() {
		$db=$this->My_SQL["maBase"];
		return $db->sql_nextid();
	}
}
?>