<?php
/************************************************************************/
/* BALISTE ECMS                                                         */
/* ===========================                                          */
/* Copyright (c) 2004 by Stephan Acquatella (stephan@balistis.com)      */
/* http://www.baliste.org                                               */
/*                                                                      */
/* Enhanced with PHP-NUKE                                               */
/* =======================                                              */
/* Copyright (c) 2005 by Francisco Burzi (fbc@mandrakesoft.com)         */
/* http://phpnuke.org                                                   */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

//if (!defined('MODULE_FILE')) {
//	die ("You can't access this file directly...");
//}
if (!preg_match("#modules.php#i", $_SERVER['PHP_SELF'])) {
	die ("You can't access this file directly...");
}
require_once("core/becms_mainlib_lib.php");
require_once("core/becms_ui_component.php");
require_once("images/filetypes/filetypes.php");
require_once("includes/truncate_string.php");

$module_name = basename(dirname(__FILE__));
get_lang($module_name);
$userpage = 1;

//require_once("modules/$module_name/lib_db.php");
require_once("modules/$module_name/utils.php");

function format_nuke_url($nukeurl) {
	$tab_serveur = parse_url($nukeurl);
	$racine = $tab_serveur["scheme"]."://";
	if ($tab_serveur["user"] != "") {
		$racine .= $tab_serveur["user"];
	}
	if ($tab_serveur["pass"] != "") {
		$racine .= ":".$tab_serveur["pass"];
	}
	if ($tab_serveur["pass"] != "" || $tab_serveur["user"] != "") {
		$racine .= "@";
	}
	$racine .= $tab_serveur["host"];
	if ($tab_serveur["port"] != "") {
		$racine .= ":".$tab_serveur["port"];
	}
	return $racine;	
}

function list_index($nbreFiches, $page, $ligne_par_page,$url, $txtfound=_BP_ELTS_FOUND, $txtnotfound = _BP_ELTS_NOTFOUND, $txtpage = _BP_ELTS_PAGES, $extraurl="") {
	$nboites = 5;
	$liminf = $page - floor($nboites/2);
	$limsup = $page + floor($nboites/2);
	if ($liminf < 1) {
		$liminf = 1;
		$limsup = $nboites;
		if ($limsup > ceil($nbreFiches/$ligne_par_page)) {
			$limsup = ceil($nbreFiches/$ligne_par_page);
		}
	}
	if ($limsup > ceil($nbreFiches/$ligne_par_page)) {
		$limsup = ceil($nbreFiches/$ligne_par_page);
		$liminf = $limsup - $nboites;
		if ($liminf < 1) {
			$liminf = 1;
		}
	}
	$min = 1;
	$max = ceil($nbreFiches/$ligne_par_page);

	$repParPage = $ligne_par_page;
	$p = $page;
	$nbrepages = ceil($nbreFiches/$repParPage);
	if ($p>$nbrepages) {
		$p = $nbrepages;
	}
	$indexPages .= "<div class=\"pages\">";
	if ($nbreFiches != 0) {
		$indexPages .= $nbreFiches.$txtfound;
		$indexPages .= $txtpage;
		if ($min < $liminf) {
			if ($min == $p ) {
				$indexPages .= "<div class=\"pagevide\">";
				$indexPages .= "$min";
				$indexPages .= "</div>";
			}
			else {
				$indexPages .= "<div class=\"page\">";
				$extraurl = str_replace("<!--page-->",$min,$extraurl);
				if ($url != "") {
					$indexPages .= "<a href=\"$url&page=$min"."\"$extraurl)>$min</a>";
				}
				else {
					$indexPages .= "<a href=\"#\"".$extraurl.")>$min</a>";
				}
				$indexPages .= "</div>";
			}
			if ($min < $liminf - 1) {
				$indexPages .= "...";
			}
		}
		for ($i=$liminf;$i<=$limsup;$i++) {
			if ($i == $p ) {
				$indexPages .= "<div class=\"pagevide\">";
				$indexPages .= "$i";
				$indexPages .= "</div>";
			}
			else {
				$indexPages .= "<div class=\"page\">";
				$extraurl = str_replace("<!--page-->",$i,$extraurl);
				if ($url != "") {
					$indexPages .= "<a href=\"$url&page=$i"."\"$extraurl>$i</a>";
				}
				else {
					$indexPages .= "<a href=\"#\"".$extraurl.")>$i</a>";
				}
				$indexPages .= "</div>";
			}
		}
		if ($max > $limsup) {
			if ($max > $limsup + 1) {
				$indexPages .= "...";
			}
			if ($max == $p ) {
				$indexPages .= "<div class=\"pagevide\">";
				$indexPages .= "$max";
				$indexPages .= "</div>";
			}
			else {
				$indexPages .= "<div class=\"page\">";
				$extraurl = str_replace("<!--page-->",$max,$extraurl);
				if ($url != "") {
					$indexPages .= "<a href=\"$url&page=$max"."\"$extraurl>$max</a>";
				}
				else {
					$indexPages .= "<a href=\"#\"".$extraurl.")>$max</a>";
				}	
				$indexPages .= "</div>";
			}
		}
	}
	else {
		$indexPages .= $txtnotfound;
	}
	$indexPages .= "</div>";
	return $indexPages;
}

function showadhs($metacat, $cat, $village="", $idpage="") {
	global $module_name, $db, $user_prefix, $Default_Theme,$currentlang;
	global $mmg, $op, $page;
	global $pagetitle;
	
	$pagetitle = _ADHS_PAGETITLELIST;

	if ($idpage == "") {
		//recup menu en cours
		require_once("modules/becmsDynMenu/connector_lib.php");
		list($menu,$lignemenu) = explode(",",$mmg);
		$pageheadercontent = "<h1>".getmenulabel($menu,$lignemenu)."</h1>";
	}
	else {
		require_once("modules/Sections/connector_class.php");
		$sectmodule = new pageconnector();
		$pageheadercontent = $sectmodule->getPageContent($idpage,"", true);
	}
	//critre de selection
	$where = "";
	$having = "";
	if ($cat != "") {
		$tabcats = explode(",",$cat);
		$tabcats = array_map(array('utilFuncs_adherents', 'trimtodb'), $tabcats);
		$tabcats = array_unique($tabcats);
		$nbrecats = count($tabcats);
		$where .= ($where == "" && $nbrecats > 0) ? " WHERE " : " AND "; 
		$where2 = "";
		foreach ($tabcats as $tabcat) {
			$where2 .= ($where2 != "") ? " OR " : "";
			$where2 .= "".$user_prefix."_adherents_link_cat.id_cat='".$tabcat."'";
		}
		if ($where2 != "") {
			$where .= "($where2)";
			$having .= ($having == "") ? " HAVING " : " AND "; 
			$having .= "nbrefiche='".count($tabcats)."'";
		}
	}
	if ($metacat != "") {
		$where .= ($where == "") ? " WHERE " : " AND ";
		$where .= "".$user_prefix."_adherents.metacat='".$metacat."'";
	}
	$where .= ($where == "") ? " WHERE " : " AND ";
	$where .= "".$user_prefix."_adherents.valide='1'";
	$whereVillage = $where; //pour be pas tenir compte du choix du village !!
	if ($village != "") {
		$where .= ($where == "") ? " WHERE " : " AND ";
		$where .= "".$user_prefix."_adherents.commune='".$village."'";
	}
	//menu villages concernes par fiches trouves (catgorie)
	//$sql = "SELECT DISTINCT commune FROM ".$user_prefix."_adherents INNER JOIN ".$user_prefix."_adherents_link_cat ON ".$user_prefix."_adherents.id=".$user_prefix."_adherents_link_cat.id_adh".$whereVillage." ORDER BY commune ASC";
	$sql = "SELECT count(".$user_prefix."_adherents.id) as nbrefiche, ".$user_prefix."_adherents.id, `commune` ";
   	$sql .= " FROM ".$user_prefix."_adherents";
   	$sql .= " INNER JOIN ".$user_prefix."_adherents_link_cat ON ".$user_prefix."_adherents.id=".$user_prefix."_adherents_link_cat.id_adh";
   	$sql .= $whereVillage."";
   	$sql .= " GROUP BY ".$user_prefix."_adherents.id";
   	$sql .= $having;
   	$sql .= " ORDER BY commune ASC";
   	//echo $sql;
	$result3 = $db->sql_query($sql);
	$communes = array();
	if ($db->sql_numrows($result3) > 0) {
		while ($ligne3 = $db->sql_fetchrow($result3)) {
			$communes[$ligne3["commune"]] += 1;//$ligne3["nbrefiche"];
		}
	}
	if (count($communes) > 0) {
		$menuVillages = '<select onchange="this.form.submit()" size="1" name="village">';
		$menuVillages .= '<option value="">'._ADHS_CHOOSEVILLAGE.'</option>';
		foreach($communes as $commune=>$valeur) {
			if ($commune != "") {
				$selected = "";
				if ($village == $commune) {
					$selected = " selected=\"selected\"";
				}
				$menuVillages .= "<option value=\"".$commune."\"".$selected.">".$commune." (".$valeur.")"."</option>";
			}
		}
		$menuVillages .= "</select>";
	}
	
	/*$sql = "SELECT commune, COUNT(".$user_prefix."_adherents.id) as nbre FROM ".$user_prefix."_adherents INNER JOIN ".$user_prefix."_adherents_link_cat ON ".$user_prefix."_adherents.id=".$user_prefix."_adherents_link_cat.id_adh".$whereVillage." GROUP BY commune ORDER BY commune ASC";
	$result = $db->sql_query($sql);
	if ($db->sql_numrows($result) > 0) {
		$menuVillages = '<select onchange="this.form.submit()" size="1" name="village">';
		$menuVillages .= '<option value="">'._ADHS_CHOOSEVILLAGE.'</option>';
		while ($ligne = $db->sql_fetchrow($result)) {
			$selected = "";
			if ($village == $ligne["commune"]) {
				$selected = " selected=\"selected\"";
			}
			//$menuVillages .= "<option value=\"".$ligne["commune"]."\"".$selected.">".$ligne["commune"]."</option>";
			$menuVillages .= "<option value=\"".$ligne["commune"]."\"".$selected.">".$ligne["commune"]." (".$ligne["nbre"].")"."</option>";
		}
		$menuVillages .= "</select>";
	}*/
	

	/*
	if (file_exists('themes/'.$Default_Theme.'/images/deletesmall.gif')) {
		$icn = 'themes/'.$Default_Theme.'/images/deletesmall.gif';
	}
	else {
		$icn = 'images/deletesmall.gif';
	}
	if (file_exists('themes/'.$Default_Theme.'/images/edit.gif')) {
		$icn2 = 'themes/'.$Default_Theme.'/images/edit.gif';
	}
	else {
		$icn2 = 'images/edit22.gif';
	}
	*/
	if (file_exists("themes/".$Default_Theme."/pattern_adh_item.php")) {
		include("header.php");
		require_once("themes/".$Default_Theme."/pattern_adh_item.php");
	   
	    echo $sortie;
		$bardef=array("back"=>"javascript:window.history.back()",
			/*"print"=>"modules.php?name=News&amp;file=print&amp;sid=$sid",*/
			"mailto"=>"#",
			"top"=>"#top" ,
			"carnetvoyage"=>"@");
		buttonBar($bardef, "align");
		include("footer.php");	    		    
	}
	else {
	
		include("header.php");
		$sortie = "";
		$sortie .= $pageheadercontent;
		$sortie .= '<form action="modules.php" method="post" name="recadherents">';
		$sortie .= '<h3>'.$menuVillages.'</h3>';
		$sortie .= '<input type="hidden" name="op" value="'.$op.'" />';
		$sortie .= '<input type="hidden" name="name" value="'.$module_name.'" />';
		$sortie .= '<input type="hidden" name="cat" value="'.$cat.'" />';
		$sortie .= '<input type="hidden" name="mmg" value="'.$mmg.'" />';
		$sortie .= '<input type="hidden" name="idpage" value="'.$idpage.'" />';
		$sortie .= '</form>';
		//pagination
		if (!isset($page) || $page == "") {
			$page = 1;
		}
		$pagesize = 10;
		$min = $pagesize * ($page - 1);
		$max = $pagesize;
		$limit = " LIMIT ".$min.", ".$max;
		
		/*$sql = "SELECT DISTINCT ".$user_prefix."_adherents.id";
		$sql .= " FROM ".$user_prefix."_adherents";
		$sql .= " INNER JOIN ".$user_prefix."_adherents_link_cat ON ".$user_prefix."_adherents.id=".$user_prefix."_adherents_link_cat.id_adh";
		$sql .= $where.";";*/
		
		$sql = "SELECT count(".$user_prefix."_adherents.id) as nbrefiche, ".$user_prefix."_adherents.id";
		$sql .= " FROM ".$user_prefix."_adherents";
		$sql .= " INNER JOIN ".$user_prefix."_adherents_link_cat ON ".$user_prefix."_adherents.id=".$user_prefix."_adherents_link_cat.id_adh";
		$sql .= $where."";
		$sql .= " GROUP BY ".$user_prefix."_adherents.id";
	   	$sql .= $having;
		
		$result = $db->sql_query($sql);
		$nbre = $db->sql_numrows($result);
		
		$indexpages = list_index($nbre, $page, $pagesize, "modules.php?name=".$module_name."&op=showadhs&mmg=".$mmg."&village=".urlencode($village)."&metacat=".$metacat."&cat=".$cat, _ADHS_FILES_FOUND, _ADHS_FILES_NOTFOUND, _ADHS_FILES_PAGES);
	
		//affichage des publis
		$sortiepub = $indexpages;
	   	$sortieliste = "";
	   	/*
	   	$sql = "SELECT DISTINCT ".$user_prefix."_adherents.id,`societe` , `responsable` , `adresse` , `tel` , `fax` , `mobile` , `email` , `web` , `commune` , `description_french` , `description_english` , `description_italian` , `description_german` , `description_spanish` , `tarifs_french` , `tarifs_english` , `tarifs_italian` , `tarifs_german` , `tarifs_spanish` , `periodeouverture_french` , `periodeouverture_italian` , `periodeouverture_english` , `periodeouverture_german` , `periodeouverture_spanish` , `services_french` , `services_italian` , `services_english` , `services_german` , `services_spanish` , `activites_french` , `activites_italian` , `activites_english` , `activites_german` , `activite_spanish` , `metacat` , `classe` , `unite` , `latitude` , `longitude` , `photo` , `dateimport` ";
	   	$sql .= " FROM ".$user_prefix."_adherents";
	   	$sql .= " INNER JOIN ".$user_prefix."_adherents_link_cat ON ".$user_prefix."_adherents.id=".$user_prefix."_adherents_link_cat.id_adh";
	   	$sql .= $where."";
		$sql .= " ORDER BY classe DESC, societe ASC".$limit;
		*/
		
		$sql = "SELECT count(".$user_prefix."_adherents.id) as nbrefiche, ".$user_prefix."_adherents.id,`societe` , `responsable` , `adresse` , `tel` , `fax` , `mobile` , `email` , `web` , `commune` , `description_french` , `description_english` , `description_italian` , `description_german` , `description_spanish` , `tarifs_french` , `tarifs_english` , `tarifs_italian` , `tarifs_german` , `tarifs_spanish` , `periodeouverture_french` , `periodeouverture_italian` , `periodeouverture_english` , `periodeouverture_german` , `periodeouverture_spanish` , `services_french` , `services_italian` , `services_english` , `services_german` , `services_spanish` , `activites_french` , `activites_italian` , `activites_english` , `activites_german` , `activite_spanish` , `metacat` , `classe` , `unite` , `latitude` , `longitude` , `photo` , `dateimport` ";
	   	$sql .= " FROM ".$user_prefix."_adherents";
	   	$sql .= " INNER JOIN ".$user_prefix."_adherents_link_cat ON ".$user_prefix."_adherents.id=".$user_prefix."_adherents_link_cat.id_adh";
	   	$sql .= $where."";
	   	$sql .= " GROUP BY ".$user_prefix."_adherents.id";
	   	$sql .= $having;
		$sql .= " ORDER BY classe DESC, societe ASC".$limit;
		
	  	$result = $db->sql_query($sql);
	  	if ($db->sql_numrows($result) > 0) {
	  		$sortie .= '<div id="listingHebergement">';
	  		while($ligne = $db->sql_fetchrow($result)) {
	  			/*if ($ligne["user_id"] == $userdata[0] || is_admin($admin)) {
					$deletebutton = '<a href="modules.php?name='.$module_name.'&op=delpratique&id='.$ligne["id"].'&page='.$page.'" title="'._BP_DELFILE.'"><img src="'.$icn.'" border="0"></a>'; 
					$editbutton = '<a href="modules.php?name='.$module_name.'&op=editpratique&id='.$ligne["id"].'&page='.$page.'" title="'._BP_EDITFILE.'"><img src="'.$icn2.'" border="0"></a>';
					$actions = '<span class="actions">&nbsp;'.$editbutton.'&nbsp;'.$deletebutton.'</span>';
				}
				else {
					$actions = "";			
				}
	   				$story_link = "<a href=\"modules.php?name=".$module_name."&op=showpratique&id=".$ligne["id"]."&page=".$page."\">";
	   				$sortieliste .= '<li><span class="titre">'.$actions.$story_link.$ligne["titre"].'<span class="sstitle">'.truncate_string($ligne["resume"],"200").'</span></a></span><span class="auteur">'.$ligne["uname"]." - ".utilFuncs_adherents::date2JMA($ligne["date"],$formatdatebp).'</span>'.'</li>';
	   			}
	   			$sortiepub .= "<ul class=\"listpubli\">".$sortieliste."</ul>";*/
	   			
	   			$classe = '';
	   			if (preg_match("#^toile#",$ligne["unite"]) && $ligne["classe"] > 0) {
	   				for ($i=0;$i<$ligne["classe"]; $i++) {
	   					$classe .= '<img src="themes/'.$Default_Theme.'/images/etoile.gif" width="12" height="12" alt="*">';
	   				}
	   			}
	  			if (preg_match("#^pi#",$ligne["unite"]) && $ligne["classe"] > 0) {
	   				for ($i=0;$i<$ligne["classe"]; $i++) {
	   					$classe .= '<img src="themes/'.$Default_Theme.'/images/epi.gif" width="12" height="12" alt="*">';
	   				}
	   			}
	   			if (preg_match("#^clef#",$ligne["unite"]) && $ligne["classe"] > 0) {
	   				for ($i=0;$i<$ligne["classe"]; $i++) {
	   					$classe .= '<img src="themes/'.$Default_Theme.'/images/clevacance.gif" width="12" height="12" alt="*">';
	   				}
	   			}
	   			if ($ligne["photo"] != "") {
	   				$lesphotos = explode(",",$ligne["photo"]);
	   				$laphoto = trim($lesphotos[0]);
	   				$vignette = '<img src="modules/'.$module_name.'/resizer.php?imgfile=../../'.$laphoto.'&max_width=66&max_height=66" class="photo" />';
	   			}
	   			else {
		   			if (file_exists("themes/$Default_Theme/images/nopict.gif")) {
						$urlvignetteredim = "modules/".$module_name."/resizer.php?imgfile=../../themes/$Default_Theme/images/nopict.gif&max_width=66&max_height=66";
					}
					else {
						$urlvignetteredim = "modules/".$module_name."/resizer.php?imgfile=images/nopict.gif&max_width=66&max_height=66";
					}
	   				$vignette = '<img src="'.$urlvignetteredim.'" class="photo" />';
	   			}
	   			$paramsurl = "&mmg=$mmg&page=$page&metacat=$metacat&cat=$cat&village=".urlencode($village);
	   			$urlfiche = "modules.php?name=$module_name&op=showoneadh".$paramsurl."&id=".$ligne["id"];
	  			if ($nbre == 1) {
					Header("Location: $urlfiche");
					die();	
				}
	   			$sortie .= '
	<div class="entreeListing">
	    <div>
	    	<div class="contentHotel">
				<a class="lienVillage" href="#" onclick="document.forms[\'recadherents\'].elements[\'village\'].value=\''.addslashes($ligne["commune"]).'\';document.forms[\'recadherents\'].submit();return false">'.$ligne["commune"].'</a>
	    		<h3 class="titreListing"><a href="'.$urlfiche.'">'.$ligne["societe"].'</a><span class="classement">'.$classe.'</span></h3>
	            <p>'.truncate_string($ligne["description_".$currentlang],"300").'</p>
	            <div align="right"><a class="plusdinfo" href="'.$urlfiche.'">'._ADHS_SEEFILE.'</a></div>
	    	</div>
	    	<a href="'.$urlfiche.'">'.$vignette.'</a>
	    </div>
	</div>
	<div class="separateurHotel"></div>';	
	   		}
	   		$sortie .= '</div>';
	  	}
	  	else {
	  		$sortiepub .= "Pas de fiche trouve !!";
	  	}
		$sortie .= $indexpages;
	  		
		//$sortie .= $sortiepub;
	 		
		echo $sortie;
		$bardef=array("back"=>"javascript:window.history.back()",
			/*"print"=>"modules.php?name=News&amp;file=print&amp;sid=$sid",*/
			"mailto"=>"#",
			"top"=>"#top" ,
			"carnetvoyage"=>"@");
		buttonBar($bardef, "align");
		include("footer.php");
	}
}

function showoneadh($id) {
	global $module_name, $db, $user_prefix, $Default_Theme,$currentlang;
	global $mmg, $op, $page, $metacat, $cat, $village;
	global $_headerContent, $cartobuttons, $minicarteadhs;
	global $pagetitle;
	
	require_once("modules/SimpleCarto/lib/g_params.php");
	
	$where = "";
	if ($id != "") {
		$where .= ($where == "") ? " WHERE " : " AND ";
		$where .= "".$user_prefix."_adherents.id='".$id."'";
	}
	else {
		Header("Location: index.php");
		die();
	}
	$sql = "SELECT ".$user_prefix."_adherents.id,`societe` , `responsable` , `adresse` , `tel` , `fax` , `mobile` , `email` , `web` , `commune` , `description_french` , `description_english` , `description_italian` , `description_german` , `description_spanish` , `tarifs_french` , `tarifs_english` , `tarifs_italian` , `tarifs_german` , `tarifs_spanish` , `periodeouverture_french` , `periodeouverture_italian` , `periodeouverture_english` , `periodeouverture_german` , `periodeouverture_spanish` , `services_french` , `services_italian` , `services_english` , `services_german` , `services_spanish` , `activites_french` , `activites_italian` , `activites_english` , `activites_german` , `activite_spanish`, `distance_french` , `distance_italian` , `distance_english` , `distance_german` , `distance_spanish` , `metacat` , `classe` , `unite` , `latitude` , `longitude` , `photo`, `legende` , `dateimport`,`lienlocalite` ";
   	$sql .= " FROM ".$user_prefix."_adherents".$where.";";
	$result = $db->sql_query($sql);
	if ($db->sql_numrows($result) == 1) {
		if ($ligne = $db->sql_fetchrow($result)) {
			$pagetitle = " - ".$ligne["societe"];
			
			$pictos = get_pictos_adh($id);
			
			$btns = "";
			foreach ($cartobuttons as $typedemap) {
				$btns .= ($btns == "") ? "" : ",";
				$btns .= $typedemap;
			}
			if ($ligne["latitude"] == "") {
				$ligne["latitude"] = "0";
			}
			if ($ligne["longitude"] == "") {
				$ligne["longitude"] = "0";
			}
			
			$_headerContent .= '
				<script type="text/javascript" src="http://maps.google.com/maps?file=api&v=2&key='.$keymap.'" charset="UTF-8"></script>
				<script type="text/javascript" src="modules/'.$module_name.'/system/lib_autostart.js"></script>
				<script type="text/javascript" src="modules/'.$module_name.'/system/lib_XML_parser.js" charset="UTF-8"></script>
				<script type="text/javascript" src="modules/'.$module_name.'/system/lib_AJAX.js" charset="UTF-8"></script>
		
				<script type="text/javascript" src="modules/'.$module_name.'/language/lang-'.$currentlang.'.js" charset="UTF-8"></script>
				<script type="text/javascript" src="modules/'.$module_name.'/system/lib_carto_adh.js" charset="UTF-8"></script>
		
				<script type="text/javascript">
				//<![CDATA[
				var options = new Array;
				options["btnstypes"] = ['.$btns.'];
				options["centermap"] = new GLatLng(eval('.$ligne["latitude"].'), eval('.$ligne["longitude"].'));
				//options["zoominit"] = 9;
				var racine_lib_module = "modules/SimpleCarto/lib";
			    //]]>
			    </script>
			    <script type="text/javascript">
				// <![CDATA[
					addToStart("GetMap(\''.$minicarteadhs.'\', \''.$id.'\')");
					addToStop(GUnload);
				// ]]>
				</script>
		
			    <link href="themes/oriente/style/SimpleCarto.css" rel="stylesheet" type="text/css" media="all"/>
		';
				
			if (file_exists("themes/".$Default_Theme."/pattern_adh.html") && file_exists("themes/".$Default_Theme."/pattern_adh.php")) {
				include("header.php");
			
				//recup menu en cours
				require_once("modules/becmsDynMenu/connector_lib.php");
				list($menu,$lignemenu) = explode(",",$mmg);
				$menuLabel = getmenulabel($menu,$lignemenu);
				str_replace("http://", "", $ligne["web"]);
				if ($ligne["web"] != "") {
					$ligne["web"] = str_replace("http://", "", $ligne["web"]);
					$ligne["web"] = "http://".$ligne["web"];
				}
				$fiche = array();
				$fiche["module_name"] = $module_name;
				$fiche["default_theme"] = $Default_Theme;
				$fiche["menu_label"] = $menuLabel;
				$fiche["commune"] = $ligne["commune"];
				$fiche["unite"] = $ligne["unite"];
				$fiche["classe"] = $ligne["classe"];
				$fiche["photo"] = $ligne["photo"];
				$fiche["legende"] = $ligne["legende"];
				$fiche["periodeouverture"] = $ligne["periodeouverture_".$currentlang];
				$fiche["services"] = $ligne["services_".$currentlang];
				$fiche["actvites"] = $ligne["activites_".$currentlang];
				$fiche["distance"] = $ligne["distance_".$currentlang];
				$fiche["societe"] = $ligne["societe"];
				$fiche["adresse"] = $ligne["adresse"];
				$fiche["tel"] = $ligne["tel"];
				$fiche["fax"] = $ligne["fax"];
				$fiche["mobile"] = $ligne["mobile"];
				$fiche["web"] = $ligne["web"];
				$fiche["email"] = $ligne["email"];
				$fiche["description"] = $ligne["description_".$currentlang];
				$fiche["tarifs"] = $ligne["tarifs_".$currentlang];
				$fiche["lienlocalite"] = $ligne["lienlocalite"];
				$fiche["pictos"] = $pictos;
				$fiche["metacat"] = $ligne["metacat"];
				
				require_once("themes/".$Default_Theme."/pattern_adh.php");
				
				$modele = implode("", file("themes/".$Default_Theme."/pattern_adh.html"));
			    $modele = addslashes($modele);
			    $modele = "\$sortie=\"".$modele."\";";
			    eval($modele);
			    $sortie = stripslashes($sortie);
			    
			    echo $sortie;
				
				adminEditButton("system.php?op=adherents&action=edit_adh&onglet=adhs&id=$id");
				
				$bardef=array("back"=>"javascript:window.history.back()",
					/*"print"=>"modules.php?name=News&amp;file=print&amp;sid=$sid",*/
					"mailto"=>"#",
					"top"=>"#top" ,
					"carnetvoyage"=>"@");
				buttonBar($bardef, "align");
				include("footer.php");
			}
			else {	
				//recup menu en cours
				require_once("modules/becmsDynMenu/connector_lib.php");
				list($menu,$lignemenu) = explode(",",$mmg);
				$menuLabel = getmenulabel($menu,$lignemenu);
				
				$classe = '';
	   			if (preg_match("#^toile#",$ligne["unite"]) && $ligne["classe"] > 0) {
	   				for ($i=0;$i<$ligne["classe"]; $i++) {
	   					$classe .= '<img src="themes/'.$Default_Theme.'/images/etoile.gif" width="12" height="12" alt="*">';
	   				}
	   			}
	  			if (preg_match("#^pi#",$ligne["unite"]) && $ligne["classe"] > 0) {
	   				for ($i=0;$i<$ligne["classe"]; $i++) {
	   					$classe .= '<img src="themes/'.$Default_Theme.'/images/epi.gif" width="12" height="12" alt="*">';
	   				}
	   			}
				if (preg_match("#^clef#",$ligne["unite"]) && $ligne["classe"] > 0) {
	   				for ($i=0;$i<$ligne["classe"]; $i++) {
	   					$classe .= '<img src="themes/'.$Default_Theme.'/images/clevacance.gif" width="12" height="12" alt="*">';
	   				}
	   			}
				if ($ligne["photo"] != "") {
					$lesphotos = explode(",",$ligne["photo"]);
	   				$laphoto = trim($lesphotos[0]);
	   				$photo = '<img src="modules/'.$module_name.'/resizer.php?imgfile=../../'.$laphoto.'&max_width=300&max_height=200" class="photo" />';
	   			}
	   			else {
		   			if (file_exists("themes/$Default_Theme/images/nopict.gif")) {
						$urlphotoredim = "modules/".$module_name."/resizer.php?imgfile=../../themes/$Default_Theme/images/nopict.gif&max_width=300&max_height=200";
					}
					else {
						$urlphotoredim = "modules/".$module_name."/resizer.php?imgfile=images/nopict.gif&max_width=300&max_height=200";
					}
	   				$photo = '<img src="'.$urlphotoredim.'" class="photo" />';
	   			}
	   			$periode = "";
	   			if ($ligne["periodeouverture_".$currentlang] != "") {
	   				$periode = '<h3>'._ADHS_OPENDATES.'</h3>
	    				<div>'.$ligne["periodeouverture_".$currentlang].'</div>';
	   			}
	   			$services = "";
				if (trim($ligne["services_".$currentlang] != "")) {
	   				$servicestab = explode(",", trim($ligne["services_".$currentlang]));
					$services = join("</li><li>",$servicestab);
					$services = '<h3>'._ADHS_SERVICES.'</h3>'."<ul><li>".$services."</li></ul>";
	   			}
				$activites = "";
				if (trim($ligne["activites_".$currentlang]) != "") {
	   				$activitestab = explode(",", trim($ligne["activites_".$currentlang]));
					$activites = join("</li><li>",$activitestab);
					$activites = '<h3>'._ADHS_ACTIVITES.'</h3>'."<ul><li>".$activites."</li></ul>";
	   			}
	   			$info_pratiques = "";
	   			//societe `adresse` , `tel` , `fax` , `mobile` , `email` , `web`
				$info_pratiques .= ($ligne["societe"] != "") ? "<strong>".$ligne["societe"]."</strong><br />" : "";
				
				
				/* adresse !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
				$info_pratiques .= ($ligne["societe"] != "") ? "<strong>".$ligne["societe"]."</strong><br />" : "";*/
				if (trim($ligne["adresse"]) != "") {
					$ligne["adresse"] = trim($ligne["adresse"]);
					$ligne["adresse"] = preg_replace("#([0-9]{5})#","<br />\\1",$ligne["adresse"]);
				}
				$info_pratiques .= ($ligne["adresse"] != "") ? $ligne["adresse"]."<br />" : "";
				
				$info_pratiques .= ($ligne["tel"] != "") ? _ADHS_SERVICES_TEL.$ligne["tel"]."<br />" : "";
				$info_pratiques .= ($ligne["fax"] != "") ? _ADHS_SERVICES_FAX.$ligne["fax"]."<br />" : "";
				$info_pratiques .= ($ligne["mobile"] != "") ? _ADHS_SERVICES_MOB.$ligne["mobile"]."<br />" : "";
				$info_pratiques .= ($ligne["web"] != "") ? _ADHS_SERVICES_WEB.'<span style="word-wrap: break-word"><a href="'.$ligne["web"].'" target="_blank">'.$ligne["web"]."</a></span><br />" : "";
				$info_pratiques .= ($ligne["email"] != "") ? _ADHS_SERVICES_EMAIL.'<a href="mailto:'.$ligne["email"].'">'.$ligne["email"]."</a><br />" : "";
	   			
				$lienvillage = "";
				if ($ligne["lienlocalite"] != "") {
					$lienvillage = '<a href="'.$ligne["lienlocalite"].'" id="lieninfoVillage">'._ADHS_GOTOVILLAGE.' >></a>';
				}
			
				include("header.php");
				$sortie = "";
		
				$sortie='
<h1>'.$ligne["societe"].'</h1>
<div>
<table cellpadding="0" cellspacing="0" border="0" style="width: 720px">
<!--- Bloc introduction --->
<tr>
<td valign="top" style="width: 314px">'.$photo.'</td>
<td width="10"></td>
<td valign="top">
    <h4><div class="classement" style="float:right;margin-right:10px">'.$classe.'</div>'.$menuLabel._ADHS_CATINCOMM.$ligne["commune"].'</h4>
    <br><div class="chapeauFiche">'.$ligne["description_".$currentlang].'</div>
    <br>
    '.$periode.'
</td>
</tr>';
			
//<!---  Bloc TARIFS --->
if ($ligne["tarifs_".$currentlang] != "") {
	//$ligne["tarifs_".$currentlang] = "<p>Tarifs non disponibles</p>";
	/*$ligne["tarifs_".$currentlang] = '
<table class="result" border="0" cellspacing="0" cellpadding="0"  width="694">
    		<caption>Camping</caption>
                <tr>
                    <th width="144" class="hidden"></th>
                    <th width="270">1 personne + Emplacement</th>
                    <th width="270">Par personnes</th>
                </tr>
                <tr>
                    <th width="144" class="ligne">Basse saison</th>
                    <td width="270">15 </td>
                    <td width="270">5 </td>
                </tr>
                <tr>
                    <th width="144" class="ligne">Moyenne saison</th>
                    <td width="270">20 </td>
                    <td width="270">8 </td>
                </tr>
                <tr>
                    <th width="144" class="ligne">Haute saison</th>
                    <td width="270">28 </td>
                    <td width="270">10 </td>
                </tr>
            </table>
            <table class="result" border="0" cellspacing="0" cellpadding="0" width="694">
    		<caption>Locations</caption>
                <tr>
                    <th width="144" class="hidden"></th>
                    <th width="135">Vranda 2 pers.</th>
                    <th width="135">Mini Villa 2 pers.</th>
                    <th width="135">Bungalow 2  7 pers.</th>
                    <th width="135">Bengali 4 pers.</th>
                </tr>
                <tr>
                    <th width="144" class="ligne">Basse saison</th>
                    <td width="135">623   693 </td>
                    <td width="135">875 </td>
                    <td width="135">483   1106 </td>
                    <td width="135">364 </td>
                </tr>
                <tr>
                    <th width="144" class="ligne">Moyenne saison</th>
                    <td width="135">651   924 </td>
                    <td width="135">1022   1134 </td>
                    <td width="135">623   1365 </td>
                    <td width="135">483   525 </td>
                </tr>
                <tr>
                    <th width="144" class="ligne">Haute saison</th>
                    <td width="135">805   833 </td>
                    <td width="135">1 253 </td>
                    <td width="135">763   1505 </td>
                    <td width="135">623 </td>
                </tr>
            </table>
            <h3>Suplments</h3>
            <ul class="listinfoFiche" style="float:left">
                <li><strong>Location consigne frigo : </strong>5 /jour - 30 /semaine</li>
                <li><strong>Location frigo sur emplacement : </strong>50 /semaine</li>
                <li><strong>Location coffre : </strong>2 /jour - 12 /semaine</li>
            </ul>
            <ul class="listinfoFiche" style="float:left">
                <li><strong>Lave-linge : </strong>6 </li>
                <li><strong>Sche-linge : </strong>63 </li>
            </ul>';*/
	
	$sortie .= '
<tr>
	<td colspan="3">
    <div class="blocdiv" style="margin-top:20px">
		<div class="blocdivmarge">
            <h2>Les tarifs</h2>
            '.$ligne["tarifs_".$currentlang].'
            <div style="clear:both;"></div>
		</div>
	</div>
    </td>
</tr>
</table>';
}

//<!--- Colonne GAUCHE --->
$sortie .= '
<table cellpadding="0" cellspacing="0" border="0" style="width: 720px;margin-top:-10px;">
<tr>
<td style="width: 190px" valign="top">
	<!--- Bloc infos pratiques --->
	<div class="blocdiv" style="margin-top:20px">
		<div class="blocdivmarge">
            <h2>'._ADHS_PRESTATION.'</h2>
           	'.$services.'
            '.$activites.'
		</div>
	</div>
</td>
<td width="10"></td>
<!--- Colonne DROITE --->
<td valign="top">
	<!--- Bloc infos  ne pas manquer --->
	<div class="blocdiv" style="margin-top:20px">
		<div class="blocdivmarge">
        	<div id="gmapAdherant">
            	<!--<img src="themes/'.$Default_Theme.'/images/cartoadhs.jpg" width="280" height="250" alt=""/>-->
			<div id="map" style="width: 280px; height: 250px"></div>
                <!-- div de remplacement -->
                <!--<div style="display:block;padding:120px 50px;"><strong>Pas de coordonne disponible</strong></div>-->
            </div>
            <div id="infopratiquesAdherent">
                <h2>'._ADHS_INFOSPRAT.'</h2>
                <p style="text-align: left">'.$info_pratiques.'</p>
    		</div>
            '.$lienvillage.'
            <div style="clear:both;"></div>
		</div>
	</div>
</td>
</tr>
</table>
</div>';
			
				echo $sortie;
				
				adminEditButton("system.php?op=adherents&action=edit_adh&onglet=adhs&id=$id");				
				$bardef=array("back"=>"javascript:window.history.back()",
					/*"print"=>"modules.php?name=News&amp;file=print&amp;sid=$sid",*/
					"mailto"=>"#",
					"top"=>"#top" ,
					"carnetvoyage"=>"@");
				buttonBar($bardef, "align");
				include("footer.php");
			}
		}
  	}
}

function get_pictos_adh($id) {
	global $db, $user_prefix,$currentlang;
	
	$sortie = array();
	
	$sql = "select label_".$currentlang." as label, picto from ".$user_prefix."_adherents_picto";
	$sql .= " inner join ".$user_prefix."_adherents_link_picto on ".$user_prefix."_adherents_link_picto.id_picto=".$user_prefix."_adherents_picto.id";
	$sql .= " where ".$user_prefix."_adherents_link_picto.id_adh='".$id."'";
	$sql .= " order by label_french asc";
	$result = $db->sql_query($sql);
  	if ($db->sql_numrows($result) > 0) {
		while ($ligne = $db->sql_fetchrow($result)) {
			$sortie[] = array("legende"=>$ligne["label"], "picto"=>$ligne["picto"]);
		}
  	}
  	return $sortie;
}

function unsubscribe_newsletter() {
	global $module_name, $currentlang;
	include("header.php");
	echo "<h1>"._UNSUBSIMPLEADHS."</h1>";
	echo "<p>".nl2br(_SNLUNSUB)."<br /></p>\n";
	$content = '<script type="text/javascript" src="javascripts/lang/lang-'.$currentlang.'.js"></script>
<script type="text/javascript" src="javascripts/control_form.js"></script>';
	$content .= "<form action=\"modules.php?name=$module_name&op=send_unsubscribe_newsletter\" onsubmit=\"return submit_form(this)\" method=\"post\">";
	$content .= "<fieldset class=\"unsub\"><legend>"._SUBNLCOORDS."</legend>";
	$content .= '<table cellpadding="0" cellspacing="0" border="0" align="center">';
	$content .= '<tr><td><p>'._SUBNAMEANDFIRST2.'</p></td><td width="20"></td>';
	$content .= "<td><champ lib=\""._SUBNAMEANDFIRST."\" nom=\"nom\" lim=\"1,100\"></champ><input type=\"text\" name=\"nom\" size=\"15\" class=\"zoneSubscribe2\" value=\"\"></td>";
	$content .= "</tr>";
	$content .= '<tr><td><p>'._SUBMAIL2.'</p></td><td width="20"></td>';
	$content .= "<td><champ ctl=\"email\" lib=\""._SUBMAIL."\" nom=\"email\" lim=\"3,100\"></champ><input type=\"text\" name=\"email\" size=\"15\" class=\"zoneSubscribe2\" value=\"\"></td>";
	$content .= "</tr>";
	$content .= '<tr><td colspan="3" align="center">';
	$content .= "<br/><input type=\"submit\" value=\""._SUBSEND."\" name=\"validsub\" id =\"validsub\"><br />";
	$content .= "</td></tr></table>";
	$content .= "</fieldset>";
	$content .= "</form>";
	echo $content;
	include("footer.php");
}

function send_unsubscribe_newsletter($nom, $email) {
	global $simplenewsletteradminmail;
	$nukeurl = "http://".$_SERVER["HTTP_HOST"].($_SERVER["SERVER_PORT"]!="80" ? ":".$_SERVER["SERVER_PORT"] : "");
	
	$nukeurl = format_nuke_url($nukeurl);
	$viewlink = "$nukeurl/system.php?op=adherents";
	$subject = ""._UNSUBSUBJECT."";
	$message = str_replace("<!--nom-->", $nom, _UNSUBMESSAGE);
	$message = str_replace("<!--email-->", $email, $message);
	$message = str_replace("<!--lien-->", $viewlink, $message);
	utilFuncs_adherents::send_email($simplenewsletteradminmail, $simplenewsletteradminmail,$subject,$message);
	include("header.php");
	echo "<h1>"._UNSUBSIMPLENEWSLETTER."</h1>";
	echo "<p>".nl2br(_UNSUBSENT)."</p>\n";
	include("footer.php");
}

function get_map_adh_XML() {
	global $module_name;
	
	require_once("modules/".$module_name."/system/getXMLcarto_adh.php");
	$sortie = getXMLcarto();
	header("Content-Type: text/xml; charset=UTF-8");
	echo $sortie;
}


function profil() {
	global $module_name, $db, $user_prefix, $Default_Theme,$currentlang;
	global $pagetitle;
	global $simpleprofilmenu, $simpleprofilpageaccueil;
	
	$pagetitle = _PROFIL;
	
	include("header.php");
	$sortie = "";
	if ($simpleprofilpageaccueil == "") {
		$sortie .= "<h1>"._PROFIL."</h1>";
	}
	else {
		require_once("modules/Sections/connector_class.php");
		$sectmodule = new pageconnector();
		$sortie .= $sectmodule->getPageContent($simpleprofilpageaccueil,"", true);
	}
	require_once("modules/becmsDynMenu/connector_lib.php");
	$menu_principal = getmenuatom($simpleprofilmenu);
	foreach ($menu_principal["lignemenu"] as $lignemenu) {
		$text = ($lignemenu["url"] == "#") ? $lignemenu["label"] : '<a href="'.$lignemenu["url"].'">'.$lignemenu["label"].'</a>';
		switch ($lignemenu["niveau"]) {
			case "1" :
				$sortie .= '<h2>'.$text.'</h2>';
				break;
			case "2" :
				$sortie .= '<h3>'.$text.'</h3>';
				break;
			case "3" :
				$sortie .= '<p>'.$text.'</p>';
				break;
		}
	}	
	echo $sortie;
	$bardef=array("back"=>"javascript:window.history.back()",
		/*"print"=>"modules.php?name=News&amp;file=print&amp;sid=$sid",*/
		"top"=>"#top");
	buttonBar($bardef, "align");
	include("footer.php");
}

function showonedoc($id, $millesime) {
	global $module_name, $db, $user_prefix, $Default_Theme,$currentlang;
	global $pagetitle, $op;
	global $simpleprofilmenu, $simpleprofilpageaccueil;
	global $admin;
	global $nivtxtreg;
	global $page;
	
	$pagetitle = _PROFIL;
	
	include("header.php");
	
	$menumillesime = "";
	$sql = "SELECT ".$user_prefix."_profil_docs.titre, ".$user_prefix."_profil_millesime.id_page, ".$user_prefix."_profil_millesime.id, ".$user_prefix."_profil_millesime.millesime, ".$user_prefix."_seccont.status ";
	$sql .= " FROM ".$user_prefix."_profil_millesime";
	$sql .= " INNER JOIN ".$user_prefix."_profil_docs ON ".$user_prefix."_profil_docs.id=".$user_prefix."_profil_millesime.id_doc";
	$sql .= " INNER JOIN ".$user_prefix."_seccont ON ".$user_prefix."_seccont.artid=".$user_prefix."_profil_millesime.id_page";
	$sql .= " WHERE ".$user_prefix."_profil_docs.id='".$id."'";
	if (!is_admin($admin)) {
		$sql .= " AND ".$user_prefix."_seccont.status='P'";
	}
	$sql2 = $sql;
	if ($millesime != "") {
		$sql .= " AND ".$user_prefix."_profil_millesime.id='".$millesime."'";
	}
	$orderby .= " ORDER BY ".$user_prefix."_profil_millesime.millesime DESC";
	$sql .= $orderby;
	$sql2 .= $orderby;
	
	$result = $db->sql_query($sql);
  	if ($db->sql_numrows($result) > 0) {
		list($titre1, $idpage1, $id_millesime1, $titre_millesime1) = $db->sql_fetchrow($result);
  	}
  	
  	$sortie = "";
  	
	$result2 = $db->sql_query($sql2);
  	if ($db->sql_numrows($result2) > 0) {
  		if ($db->sql_numrows($result2) == 1) {
  			list($titre, $idpage, $id_millesime, $titre_millesime, $status) = $db->sql_fetchrow($result2);
  			$menumillesime = '<p class="choixmillesime">Millesime du document : '.$titre_millesime.'</p>';
  		}
  		else {
			$menumillesime = '<p class="choixmillesime">Veuillez choisir le millsime de ce document : <select size="1" name="millesime" onchange="this.form.submit();">';
			while (list($titre, $idpage, $id_millesime, $titre_millesime, $status) = $db->sql_fetchrow($result2)) {
				$selected = ($millesime == $id_millesime) ? ' selected="selected"' : '';
				$puce = ($status != "P") ? "* " : "";
				$menumillesime .= '<option value="'.$id_millesime.'"'.$selected.'>'.$puce.$titre_millesime.'</option>';
			}
			$menumillesime .= '</select></p>';
  		}

	  	$pagedoc = "";
		if ($idpage1 != "" && $idpage1 != "0") {
			require_once("modules/Sections/connector_class.php");
			$sectmodule = new pageconnector();
			$pagedoc = $sectmodule->getPageContent($idpage1,"", true);
			
			$contentpages = preg_split("#((<!--pagebreak-->)|(<div style=\"page-break-after: always(;?)\"><span style=\"display:( ?)none(;?)\">( |&nbsp;)</span></div>))#mi",$pagedoc,-1);
			$pageno = count($contentpages);
			if ( $page=="" || $page < 1 ) {
				$page = 1;
			}
			if ( $page > $pageno ) {
				$page = $pageno;
			}
			$arrayelement = (int)$page;
			$arrayelement --;
			
			//modules.php?name=SimpleProfil&op=showonedoc&id=11&mmg=9,520
			$baseurl="modules.php?name=".$module_name."&op=".$op."&id=".$id;
			if ($millesime != "") {
				$baseurl .= "&millesime=".$millesime;
			}
			if (file_exists("modules/becmsDynMenu/lib/g_params.php")) {
				require("modules/becmsDynMenu/lib/g_params.php");
				if ($GLOBALS[$modmenu["Menu"]] != "") {
					$baseurl .= "&".$modmenu["Menu"]."=".$GLOBALS[$modmenu["Menu"]];
				}
			}
			
			
			if ($pageno > 1) {
				$curpage = ""._PAGE.": $page/$pageno";
			}
			if($page >= $pageno) {
		  		$next_page = "";
			} 
			else {
				$next_pagenumber = $page + 1;
				//$next_page .= "&nbsp;<a href=\"modules.php?name=Sections&sop=viewarticle&amp;artid=$artid&amp;page=$next_pagenumber\">"._NEXT." ($next_pagenumber/$pageno)</a> <a href=\"modules.php?name=Sections&sop=viewarticle&artid=$artid&page=$next_pagenumber\"><img src=\"images/download/right.gif\" border=\"0\" alt=\""._NEXT."\"></a><br>";
				//$next_page .= "<a href=\"modules.php?name=Sections&sop=viewarticle&amp;artid=$artid&amp;page=$next_pagenumber$menu_en_cours\">"._NEXT."</a>";
				$next_page .= "<a href=\"$baseurl&page=$next_pagenumber\">"._NEXT."</a>";
			}
			if($page <= 1) {
				$previous_page = "";
			}
			else {
				$previous_pagenumber = $page - 1;
				//$previous_page = "<a href=\"modules.php?name=Sections&sop=viewarticle&amp;artid=$artid&amp;page=$previous_pagenumber\"><img src=\"images/download/left.gif\" border=\"0\" alt=\""._PREVIOUS."\"></a> <a href=\"modules.php?name=Sections&sop=viewarticle&artid=$artid&page=$previous_pagenumber\">"._PREVIOUS." ($previous_pagenumber/$pageno)</a>&nbsp;";
				//$previous_page = "<a href=\"modules.php?name=Sections&sop=viewarticle&artid=$artid&page=$previous_pagenumber$menu_en_cours\">"._PREVIOUS."</a>&nbsp;&nbsp;";
				$previous_page = "<a href=\"$baseurl&page=$previous_pagenumber\">"._PREVIOUS."</a>&nbsp;&nbsp;";
			}
			$prevnext = "";
			if ($curpage != "") {
				$prevnext =  "<div class=\"prevnext\">"
				."$curpage  - $previous_page $next_page"
				."</div>";
			}
			
			$pagedoc = $contentpages[$arrayelement];
		}
		$formmillesime = "";
		if ($menumillesime != "") {
			$formmillesime = '<form name="formmillesime" action="modules.php" method="GET">
			'.$menumillesime.'
			<input type="hidden" name="name" value="'.$module_name.'">
			<input type="hidden" name="op" value="'.$op.'">
			<input type="hidden" name="id" value="'.$id.'">
			</form>
			';
			
		}
		
		$textreg = "";
		if ($prevnext == "" || ($prevnext != "" && $page == $pageno)) {
			$sql = "SELECT titre, niveau, url FROM ".$user_prefix."_profil_txtreg";
			$sql .= " INNER JOIN ".$user_prefix."_profil_link_millesime_txtreg ON ".$user_prefix."_profil_link_millesime_txtreg.id_txtreg=".$user_prefix."_profil_txtreg.id";
			$sql .= " WHERE ".$user_prefix."_profil_link_millesime_txtreg.id_millesime='".$id_millesime1."'";
			$sql .= " ORDER BY niveau ASC, titre ASC;";
			$result = $db->sql_query($sql);
			if ($db->sql_numrows($result) > 0) {
		  		$textreg = '<p>&nbsp;</p><table cellpadding="0" cellspacing="0" border="0" class="txtreg" align="center">';
		  		$textreg .= '<tr class="lignetitres"><td>Objectifs de rfrence</td></tr>';
		  		$indextab = 0;
		  		$niveaucourant = "";
		  		while (list($titretxtreg, $niveautxtreg, $urltxtreg) = $db->sql_fetchrow($result)) {
		  			if ($niveaucourant != $niveautxtreg) {
		  				$textreg .= '<tr class="niveau"><td>'.$nivtxtreg[$niveautxtreg].'</td></tr>';
		  				$niveaucourant = $niveautxtreg;
		  				$indextab = 0;
		  			}
		  			$style = ($indextab % 2 == 0) ?' class="lignepaire"' : ' class="ligneimpaire"';
		  			$urlcourant = '';
		  			if ($urltxtreg != "") {
		  				$titretxtreg = '<a href="'.$urltxtreg.'" target="_blank">'.$titretxtreg.'</a>';
		  			}
					$textreg .= '<tr'.$style.'><td>'.$titretxtreg.'</td></tr>';
					$indextab++;
				}
				$textreg .= "</table>";
		  	}
		}
		
		$sortie .= "<h1>".$titre1."</h1>";
		$sortie .= $formmillesime;
		$sortie .= $pagedoc;
		$sortie .= $textreg;
		$sortie .= $prevnext;
  	}
  	else {
  		$sortie .= "<h1>Profil Environnemental</h1>";
		$sortie .= "<p>&nbsp;</p>";
		$sortie .= "<p>Ce document n'est pas disponible. Il est en cours d'laboration et sera publi trs prochainement</p>";
		$sortie .= "<p>&nbsp;</p>";
  	}
	
	echo $sortie;
	$bardef=array("back"=>"javascript:window.history.back()",
		/*"print"=>"modules.php?name=News&amp;file=print&amp;sid=$sid",*/
		"top"=>"#top");
	buttonBar($bardef, "align");
	include("footer.php");
}

function searchdoc($query="") {
	global $module_name, $db, $user_prefix, $Default_Theme,$currentlang;
	global $pagetitle, $op;
	global $simpleprofilmenu, $simpleprofilpageaccueil;
	global $admin;
	global $nivtxtreg;
	global $page;
	
	$pagetitle = _PROFIL;
	
	include("header.php");
	$sortie = "";
	$sortie .= "<h1>Profil Environnemental</h1>";
	$sortie .= '<fieldset><legend>Critres de recherche</legend>
				<div class="search_search">
				<form action="modules.php?name=Search" method="post">
				<input name="type" value="profil" type="hidden">Mot  chercher :  <input name="query" size="30" type="name">&nbsp;&nbsp;<input value="Recherche" type="submit">
				</form>
				<div><br>[ <a href="modules.php?name=SimpleProfil">Accs par le sommaire</a> ]</div>
				</div>
				</fieldset>';

	echo $sortie;
	$bardef=array("back"=>"javascript:window.history.back()",
		/*"print"=>"modules.php?name=News&amp;file=print&amp;sid=$sid",*/
		"top"=>"#top");
	buttonBar($bardef, "align");
	include("footer.php");
}


if (! isset($id)) {
	$id = "";
}

// -------------------------------- SWITCH PART --------------------------------
switch($op) {
	case "map_adh_XML":
		get_map_adh_XML();
		break;
	case "showoneadh":
		showoneadh($id);
		break;
	case "unsubscribe_nl":
		unsubscribe_newsletter();
		break;
	case "send_unsubscribe_newsletter":
		send_unsubscribe_newsletter($nom,$email);
		break;
	case "showadhs":
		showadhs($metacat,$cat,$village,$idpage);
		break;
	case "showonedoc":
		showonedoc($id, $millesime);
		break;
	case "search":
		searchdoc($query);
		break;
	case "profil":
	default:
		profil();
		break;
}

?>