<?php
if (!preg_match("#mobiles.php#i", $_SERVER['PHP_SELF'])) {
	die ("You can't access this file directly...");
}

$module_name = basename(dirname(__FILE__));
get_lang($module_name);

require_once("core/becms_mainlib_lib.php");
require_once("core/becms_ui_component.php");
require_once("modules/$module_name/utils.php");

if (file_exists("modules/SimpleUsersStats/stats.php")) {
	require_once("modules/SimpleUsersStats/stats.php");
	$stat_membre = new membersStats();
}
function ajoutStat($action) {
	global $stat_membre;
	if (isset($stat_membre)) {
		$stat_membre->add_action($action);
	}
}
/*ajoutStat("500 : consultation accueil espace collaboratif");*/

function getCatContent($id) {
	global $db, $prefix;

	$cat = array();
	$result = $db->sql_query("select `Id`, `cat_fr`, `desc_fr`, `cat_uk`, `desc_uk`, `cat_de`, `desc_de`, `cat_sp`, `desc_sp`, `cat_it`, `desc_it`, `photo`, `position` from ".$prefix."_resto_categorie where Id='".$id."' and valide='1';");
	if (list($Id, $cat_fr, $desc_fr, $cat_uk, $desc_uk, $cat_de, $desc_de, $cat_sp, $desc_sp, $cat_it, $desc_it, $photo, $position) = $db->sql_fetchrow($result)) {
		$cat= array(
				"Id" => $Id,
				"cat_fr" => $cat_fr,
				"desc_fr" => $desc_fr,
				"cat_uk" => $cat_uk,
				"desc_uk" => $desc_uk,
				"cat_de" => $cat_de,
				"desc_de" => $desc_de,
				"cat_sp" => $cat_sp,
				"desc_sp" => $desc_sp,
				"cat_it" => $cat_it,
				"desc_it" => $desc_it,
				"photo" => $photo,
				"position" => $position
		);
	}
	$db->sql_freeresult($result);
	return $cat;
}

function getCatList() {
	global $db, $prefix;

	$catList = array();
	$result = $db->sql_query("select `Id`, `cat_fr`, `desc_fr`, `cat_uk`, `desc_uk`, `cat_de`, `desc_de`, `cat_sp`, `desc_sp`, `cat_it`, `desc_it`, `photo`, `position` from ".$prefix."_resto_categorie where valide='1' order by position ASC;");
	while (list($Id, $cat_fr, $desc_fr, $cat_uk, $desc_uk, $cat_de, $desc_de, $cat_sp, $desc_sp, $cat_it, $desc_it, $photo, $position) = $db->sql_fetchrow($result)) {
		$catList[$Id]= array(
				"Id" => $Id,
				"cat_fr" => $cat_fr,
				"desc_fr" => $desc_fr,
				"cat_uk" => $cat_uk,
				"desc_uk" => $desc_uk,
				"cat_de" => $cat_de,
				"desc_de" => $desc_de,
				"cat_sp" => $cat_sp,
				"desc_sp" => $desc_sp,
				"cat_it" => $cat_it,
				"desc_it" => $desc_it,
				"photo" => $photo,
				"position" => $position
		);
	}
	$db->sql_freeresult($result);
	return $catList;
}

function getPlatList($catid, $formid = ""){
	global $db, $prefix, $multilingual;

	$platList = array();
	$cond = " WHERE ".$prefix."_resto_plat.`valide`=1";
	$join = "";
	$orderplus = "";
	if ($catid !="") {
		$cond .= ($cond == "" ) ? " WHERE " : " AND ";
		$cond .= "catid=$catid";
	}
	if ($formid !="") {
		$cond .= ($cond == "" ) ? " WHERE " : " AND ";
		$cond .= "id_formule=$formid";
		$join = " inner join ".$prefix."_resto_link_plat_formule on ".$prefix."_resto_link_plat_formule.id_plat=".$prefix."_resto_plat.Id ";
		$join .= " inner join ".$prefix."_resto_categorie on ".$prefix."_resto_categorie.Id=".$prefix."_resto_plat.catid ";
		$orderplus = " ".$prefix."_resto_categorie.`position` ASC,";
	}

	$sql = "select ".$prefix."_resto_plat.`Id`, ".$prefix."_resto_plat.`position`, ".$prefix."_resto_plat.`catid`, ".$prefix."_resto_plat.`nom_fr`, ".$prefix."_resto_plat.`com_fr`, ".$prefix."_resto_plat.`desc_fr`, ".$prefix."_resto_plat.`nom_uk`, ".$prefix."_resto_plat.`com_uk`, ".$prefix."_resto_plat.`desc_uk`, ".$prefix."_resto_plat.`nom_de`, ".$prefix."_resto_plat.`com_de`, ".$prefix."_resto_plat.`desc_de`, ".$prefix."_resto_plat.`nom_sp`, ".$prefix."_resto_plat.`com_sp`, ".$prefix."_resto_plat.`desc_sp`, ".$prefix."_resto_plat.`nom_it`, ".$prefix."_resto_plat.`com_it`, ".$prefix."_resto_plat.`desc_it`, ".$prefix."_resto_plat.`gluten`, ".$prefix."_resto_plat.`crustace`, ".$prefix."_resto_plat.`oeuf`, ".$prefix."_resto_plat.`poisson`, ".$prefix."_resto_plat.`arachide`, ".$prefix."_resto_plat.`soja`, ".$prefix."_resto_plat.`lait`, ".$prefix."_resto_plat.`fruitacoque`, ".$prefix."_resto_plat.`celeri`, ".$prefix."_resto_plat.`moutarde`, ".$prefix."_resto_plat.`sesame`, ".$prefix."_resto_plat.`sulfite`, ".$prefix."_resto_plat.`lupin`, ".$prefix."_resto_plat.`mollusque`,".$prefix."_resto_plat.`prix`, ".$prefix."_resto_plat.`photo`";
	$sql .= " from ".$prefix."_resto_plat";
	$sql .= " $join";
	$sql .= " $cond order by".$orderplus." ".$prefix."_resto_plat.`position` ASC, `nom_fr`ASC;";
	$result = $db->sql_query($sql);

	while ($ligne = $db->sql_fetchrow($result)) {
		$platList[$ligne["Id"]]= array(
				"Id" => $ligne["Id"],
				"position" => $ligne["position"],
				"catid" => $ligne["catid"],
				"nom_fr" => $ligne["nom_fr"],
				"com_fr" => $ligne["com_fr"],
				"desc_fr" => $ligne["desc_fr"],
				"nom_uk" => $ligne["nom_uk"],
				"com_uk" => $ligne["com_uk"],
				"desc_uk" => $ligne["desc_uk"],
				"nom_de" => $ligne["nom_de"],
				"com_de" => $ligne["com_de"],
				"desc_de" => $ligne["desc_de"],
				"nom_sp" => $ligne["nom_sp"],
				"com_sp" => $ligne["com_sp"],
				"desc_sp" => $ligne["desc_sp"],
				"nom_it" => $ligne["nom_it"],
				"com_it" => $ligne["com_it"],
				"desc_it" => $ligne["desc_it"],
				"gluten" => $ligne["gluten"],
				"crustace" => $ligne["crustace"],
				"oeuf" => $ligne["oeuf"],
				"poisson" => $ligne["poisson"],
				"arachide" => $ligne["arachide"],
				"soja" => $ligne["soja"],
				"lait" => $ligne["lait"],
				"fruitacoque" => $ligne["fruitacoque"],
				"celeri" => $ligne["celeri"],
				"moutarde" => $ligne["moutarde"],
				"sesame" => $ligne["sesame"],
				"sulfite" => $ligne["sulfite"],
				"lupin" => $ligne["lupin"],
				"mollusque" => $ligne["mollusque"],
				"prix" => $ligne["prix"],
				"photo" => $ligne["photo"]
		);
	}
	$db->sql_freeresult($result);
	return $platList;
}

function getPlatContent($id){
	global $db,$prefix;

	if ($id =="") {
		return "";
	}
	else {
		$cond = "";
		if ($id !="") {
			$cond .= ($cond == "" ) ? " WHERE " : " AND ";
			$cond .= "Id=$id";
		}
			
		$result = $db->sql_query("select `Id`, `position`, `catid`, `nom_fr`, `com_fr`, `desc_fr`, `nom_uk`, `com_uk`, `desc_uk`, `nom_de`, `com_de`, `desc_de`, `nom_sp`, `com_sp`, `desc_sp`, `nom_it`, `com_it`, `desc_it`, `gluten`, `crustace`, `oeuf`, `poisson`, `arachide`, `soja`, `lait`, `fruitacoque`, `celeri`, `moutarde`, `sesame`, `sulfite`, `lupin`, `mollusque`, `prix`, `photo`, `valide` from ".$prefix."_resto_plat  $cond");
		if ($ligne = $db->sql_fetchrow($result)) {
			$sortie= array(
					"Id" => $ligne["Id"],
					"position" => $ligne["position"],
					"catid" => $ligne["catid"],
					"nom_fr" => $ligne["nom_fr"],
					"com_fr" => $ligne["com_fr"],
					"desc_fr" => $ligne["desc_fr"],
					"nom_uk" => $ligne["nom_uk"],
					"com_uk" => $ligne["com_uk"],
					"desc_uk" => $ligne["desc_uk"],
					"nom_de" => $ligne["nom_de"],
					"com_de" => $ligne["com_de"],
					"desc_de" => $ligne["desc_de"],
					"nom_sp" => $ligne["nom_sp"],
					"com_sp" => $ligne["com_sp"],
					"desc_sp" => $ligne["desc_sp"],
					"nom_it" => $ligne["nom_it"],
					"com_it" => $ligne["com_it"],
					"desc_it" => $ligne["desc_it"],
					"gluten" => $ligne["gluten"],
					"crustace" => $ligne["crustace"],
					"oeuf" => $ligne["oeuf"],
					"poisson" => $ligne["poisson"],
					"arachide" => $ligne["arachide"],
					"soja" => $ligne["soja"],
					"lait" => $ligne["lait"],
					"fruitacoque" => $ligne["fruitacoque"],
					"celeri" => $ligne["celeri"],
					"moutarde" => $ligne["moutarde"],
					"sesame" => $ligne["sesame"],
					"sulfite" => $ligne["sulfite"],
					"lupin" => $ligne["lupin"],
					"mollusque" => $ligne["mollusque"],
					"prix" => $ligne["prix"],
					"photo" => $ligne["photo"],
					"valide" => $ligne["valide"]
			);
		}
		$db->sql_freeresult($result);
		return $sortie;
	}
}

function getSupplements($id_plat) {
	global $db, $prefix;
	
	$accompList = array();
	$cond = "";
	if ($id_plat != "") {
		$cond .= ($cond == "" ) ? " WHERE " : " AND ";
		$cond .= "id_plat='".$id_plat."'";
	}
	$cond .= ($cond == "" ) ? " WHERE " : " AND ";
	$cond .= "valide='1'";
	
	$sql = "select ".$prefix."_resto_accompagnement.`Id`, `position`, `catid`, `nom_fr`, `com_fr`, `desc_fr`, `nom_uk`, `com_uk`, `desc_uk`, `nom_de`, `com_de`, `desc_de`, `nom_sp`, `com_sp`, `desc_sp`, `nom_it`, `com_it`, `desc_it`, `gluten`, `crustace`, `oeuf`, `poisson`, `arachide`, `soja`, `lait`, `fruitacoque`, `celeri`, `moutarde`, `sesame`, `sulfite`, `lupin`, `mollusque`,`prix`, `photo`, `valide`";
	$sql .= " from ".$prefix."_resto_accompagnement";
	$sql .= " inner join ".$prefix."_resto_link_plat_accompagnement on ".$prefix."_resto_accompagnement.Id=".$prefix."_resto_link_plat_accompagnement.id_accompagnement";
	$sql .= "  $cond  order by `position` ASC, `nom_fr`ASC;";
	$result = $db->sql_query($sql);
	
	while ($ligne = $db->sql_fetchrow($result)) {
		$accompList[]= array(
				"Id" => $ligne["Id"],
				"position" => $ligne["position"],
				"catid" => $ligne["catid"],
				"nom_fr" => $ligne["nom_fr"],
				"com_fr" => $ligne["com_fr"],
				"desc_fr" => $ligne["desc_fr"],
				"nom_uk" => $ligne["nom_uk"],
				"com_uk" => $ligne["com_uk"],
				"desc_uk" => $ligne["desc_uk"],
				"nom_de" => $ligne["nom_de"],
				"com_de" => $ligne["com_de"],
				"desc_de" => $ligne["desc_de"],
				"nom_sp" => $ligne["nom_sp"],
				"com_sp" => $ligne["com_sp"],
				"desc_sp" => $ligne["desc_sp"],
				"nom_it" => $ligne["nom_it"],
				"com_it" => $ligne["com_it"],
				"desc_it" => $ligne["desc_it"],
				"gluten" => $ligne["gluten"],
				"crustace" => $ligne["crustace"],
				"oeuf" => $ligne["oeuf"],
				"poisson" => $ligne["poisson"],
				"arachide" => $ligne["arachide"],
				"soja" => $ligne["soja"],
				"lait" => $ligne["lait"],
				"fruitacoque" => $ligne["fruitacoque"],
				"celeri" => $ligne["celeri"],
				"moutarde" => $ligne["moutarde"],
				"sesame" => $ligne["sesame"],
				"sulfite" => $ligne["sulfite"],
				"lupin" => $ligne["lupin"],
				"mollusque" => $ligne["mollusque"],
				"prix" => $ligne["prix"],
				"photo" => $ligne["photo"],
				"valide" => $ligne["valide"]
		);
	}
	$db->sql_freeresult($result);
	return $accompList;
}

function getSupplementContent($id){
	global $db,$prefix;

	if ($id =="") {
		return "";
	}
	else {
		$cond = "";
		if ($id !="") {
			$cond .= ($cond == "" ) ? " WHERE " : " AND ";
			$cond .= "Id=$id";
		}
			
		$result = $db->sql_query("select `Id`, `position`, `catid`, `nom_fr`, `com_fr`, `desc_fr`, `nom_uk`, `com_uk`, `desc_uk`, `nom_de`, `com_de`, `desc_de`, `nom_sp`, `com_sp`, `desc_sp`, `nom_it`, `com_it`, `desc_it`, `gluten`, `crustace`, `oeuf`, `poisson`, `arachide`, `soja`, `lait`, `fruitacoque`, `celeri`, `moutarde`, `sesame`, `sulfite`, `lupin`, `mollusque`, `prix`, `photo`, `valide` from ".$prefix."_resto_accompagnement  $cond");
		if ($ligne = $db->sql_fetchrow($result)) {
			$sortie= array(
					"Id" => $ligne["Id"],
					"position" => $ligne["position"],
					"catid" => $ligne["catid"],
					"nom_fr" => $ligne["nom_fr"],
					"com_fr" => $ligne["com_fr"],
					"desc_fr" => $ligne["desc_fr"],
					"nom_uk" => $ligne["nom_uk"],
					"com_uk" => $ligne["com_uk"],
					"desc_uk" => $ligne["desc_uk"],
					"nom_de" => $ligne["nom_de"],
					"com_de" => $ligne["com_de"],
					"desc_de" => $ligne["desc_de"],
					"nom_sp" => $ligne["nom_sp"],
					"com_sp" => $ligne["com_sp"],
					"desc_sp" => $ligne["desc_sp"],
					"nom_it" => $ligne["nom_it"],
					"com_it" => $ligne["com_it"],
					"desc_it" => $ligne["desc_it"],
					"gluten" => $ligne["gluten"],
					"crustace" => $ligne["crustace"],
					"oeuf" => $ligne["oeuf"],
					"poisson" => $ligne["poisson"],
					"arachide" => $ligne["arachide"],
					"soja" => $ligne["soja"],
					"lait" => $ligne["lait"],
					"fruitacoque" => $ligne["fruitacoque"],
					"celeri" => $ligne["celeri"],
					"moutarde" => $ligne["moutarde"],
					"sesame" => $ligne["sesame"],
					"sulfite" => $ligne["sulfite"],
					"lupin" => $ligne["lupin"],
					"mollusque" => $ligne["mollusque"],
					"prix" => $ligne["prix"],
					"photo" => $ligne["photo"],
					"valide" => $ligne["valide"]
			);
		}
		$db->sql_freeresult($result);
		return $sortie;
	}
}

function getFormContent($id) {
	global $db, $prefix;

	$form = array();
	$result = $db->sql_query("select `Id`, `form_fr`, `form_uk`, `form_de`, `form_sp`, `form_it`, `prix`, `photo`, `position` from ".$prefix."_resto_formule where Id='".$id."' and valide='1';");
	if (list($Id, $cat_fr, $desc_fr, $cat_uk, $desc_uk, $cat_de, $desc_de, $cat_sp, $desc_sp, $cat_it, $desc_it, $prix, $photo, $position) = $db->sql_fetchrow($result)) {
		$form= array(
				"Id" => $Id,
				"form_fr" => $form_fr,
				"form_uk" => $form_uk,
				"form_de" => $form_de,
				"form_sp" => $form_sp,
				"form_it" => $form_it,
				"prix" => $prix,
				"photo" => $photo,
				"position" => $position
		);
	}
	$db->sql_freeresult($result);
	return $form;
}

function getFormList() {
	global $db, $prefix;

	$catList = array();
	$result = $db->sql_query("select `Id`, `form_fr`, `form_uk`, `form_de`, `form_sp`, `form_it`, `prix`, `photo`, `position` from ".$prefix."_resto_formule where valide='1' order by position ASC;");
	while (list($Id, $form_fr, $form_uk, $form_de, $form_sp, $form_it, $prix, $photo, $position) = $db->sql_fetchrow($result)) {
		$catList[$Id]= array(
				"Id" => $Id,
				"form_fr" => $form_fr,
				"form_uk" => $form_uk,
				"form_de" => $form_de,
				"form_sp" => $form_sp,
				"form_it" => $form_it,
				"prix" => $prix,
				"photo" => $photo,
				"position" => $position
		);
	}
	$db->sql_freeresult($result);
	return $catList;
}

function list_plats($cat="") {
	global $module_name, $Default_Theme, $pagetitle;
	
	$pagetitle = "La Carte";

	$categories = getCatList();
	if ($cat == "") {
		if (count($categories) > 0) {
			$cat = $categories[key($categories)]["Id"];
		}
	}
	$plats = getPlatList($cat);

	if (file_exists('themes/'.$Default_Theme.'/pattern_resto_plats.php')) {
		require_once('themes/'.$Default_Theme.'/pattern_resto_plats.php');
	}
	else {
		/* crer un code par dfaut */
	}

	$sortie = utilFuncs_simpleResto::conditionnerMobile($sortie);
	
	include("header_mobile.php");
	echo $sortie;
	include("footer_mobile.php");
}

function show_plat($id) {
	global $module_name, $Default_Theme, $pagetitle;

	$pagetitle = "La Carte";

	$plat = getPlatContent($id);
	$plats = getPlatList($plat["catid"]);
	$cat = getCatContent($plat["catid"]);
	$supps = getSupplements($id);
	
	if (file_exists('themes/'.$Default_Theme.'/pattern_resto_plat.php')) {
		require_once('themes/'.$Default_Theme.'/pattern_resto_plat.php');
	}
	else {
		/* crer un code par dfaut */
	}

	$sortie = utilFuncs_simpleResto::conditionnerMobile($sortie);

	include("header_mobile.php");
	echo $sortie;
	include("footer_mobile.php");
}

function show_supplement($id, $id_cat) {
	global $module_name, $Default_Theme, $pagetitle;

	$pagetitle = "La Carte";

	$supplement = getSupplementContent($id);
	
	$plats = getPlatList($id_cat);
	$cat = getCatContent($id_cat);
	$cats = getCatList();

	if (file_exists('themes/'.$Default_Theme.'/pattern_resto_supplement.php')) {
		require_once('themes/'.$Default_Theme.'/pattern_resto_supplement.php');
	}
	else {
		/* crer un code par dfaut */
	}

	$sortie = utilFuncs_simpleResto::conditionnerMobile($sortie);

	include("header_mobile.php");
	echo $sortie;
	include("footer_mobile.php");
}

function show_formule($form) {
	global $module_name, $Default_Theme, $pagetitle;
	
	$pagetitle = "Les formules";
	
	$formules = getFormList();
	if ($form == "") {
		if (count($formules) > 0) {
			$form = $formules[key($formules)]["Id"];
		}
	}
	$formule = getFormContent($form);
	$plats = getPlatList("",$form);
	$cats = getCatList();
	
	if (file_exists('themes/'.$Default_Theme.'/pattern_resto_formule.php')) {
		require_once('themes/'.$Default_Theme.'/pattern_resto_formule.php');
	}
	else {
		/* crer un code par dfaut */
	}
	
	$sortie = utilFuncs_simpleResto::conditionnerMobile($sortie);

	include("header_mobile.php");
	echo $sortie;
	include("footer_mobile.php");
}

switch($op) {
	case "showform" :
		show_formule($id);
		break;
	case "showsupp" :
		show_supplement($id, $id_cat);
		break;
	case "showplat" :
		show_plat($id);
		break;
	case "listplats" :
	default:
		list_plats($cat);
		break;
}


?>