<?php
/**
 * Classes des fonctions utiles.
 *
 * Elles sont dans une classe pour les isoler des autres fonctions.
 * @package becmsSimpleAnnonce
 * @version 0.1
 * @author Vincent RUIZ <webmaster@arobase.fr>
 * @copyright Copyright  2007, Vincent RUIZ
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 */

/**
 * Classe des fonctions.
 *
 * Cette clase contient galement les fonctions utiles (conversion de date, ...).
 * @package becmsSimpleAnnonce
 */
class utilFuncs_simpleSpace {
	/**
	 * Prpare les donnes  tre enregistres dans la base de donnes en codant les apostrophes.
	 * @param string $texte Texte  prparer
	 * @return string Texte encod.
	 */
	function conditionnertodb($texte) {
		//$texte = utf8_encode($texte);
		return (str_replace("'","''",stripslashes($texte)));
	}
	function anti_conditionnertodb($texte) {
		//$texte = utf8_encode($texte);
		return (str_replace("''","'",stripslashes($texte)));
	}

	/**
	 * Prpare les donnes  tre affiches en HTML.
	 * @param string $texte Texte  prparer
	 * @return string Texte encod.
	 */
	function conditionnerHTML($texte) {
		//return (htmlentities($texte,ENT_QUOTES,UTF-8));
		return $texte;
	}

	/**
	 * Prpare les donnes  tre envoyes aux procdures Javascript.
	 * @param string $texte Texte  prparer
	 * @return string Texte encod.
	 */
	function conditionnerJS($texte, $doubleSlash=false) {
		if ($doubleSlash) {
			$texte = str_replace('"','\\\\"',$texte);
		}
		else {
			$texte = str_replace('"','\"',$texte);
		}
		$texte = str_replace("\n",'\n',$texte);
		$texte = str_replace("\r","",$texte);
		return $texte;
	}

	/**
	 * Prpare les donnes  tre incluses dans les formulaires.
	 * @param string $texte Texte  prparer
	 * @return string texte encod.
	 */
	function conditionnerFORM($texte) {
		return (str_replace('"','&quot;',$texte));
	}

	/**
	 * Remplace une donne nulle ou vide par zero.
	 * @param string $valeur Valeur  tester.
	 * @return integer Valeur ou zero.
	 */
	function notVide($valeur) {
		if ($valeur == "") {
			return 0;
		}
		else {
			return $valeur;
		}
	}
	/**
	 * Prpare les donnes  tre exportes en XML.
	 * @param string $texte Texte  prparer
	 * @return string Texte encod.
	 */
	function conditionnerXML($texte) {
		//$texte = str_replace("\n",'\n',$texte);
		//$texte = str_replace("\r","",$texte);
		$texte = utf8_encode($texte);
		return $texte;
	}
	
	function conditionnerMobile($texte) {
		//$texte = str_replace("\n",'\n',$texte);
		//$texte = str_replace("\r","",$texte);
		$texte = utf8_encode($texte);
		return $texte;
	}

	/**
	 * Convertit une date du format Anne-Mois-Jour (SQL) au format Jour/Mois/Anne (Franais).
	 * @param string $ladate Date  convertir.
	 * @return string Date convertie.
	 */
	function date2JMA($ladate, $formatdate="d/m/Y H:i:s"){
		if ($ladate == "0000-00-00 00:00:00" || $ladate == "0000-00-00" || $ladate == "") {
			return "";
		}
		else {
			list($lejour,$lemoment) = explode(" ",$ladate);
			list($an,$mois,$jour) = explode("-",$lejour);
			if ($lemoment != "") {
				list($heure, $minute,$seconde) = explode(":", $lemoment);
			}
			else {
				list($heure, $minute,$seconde) = array(0,0,0);
			}
			$ladate = date($formatdate, mktime($heure, $minute,$seconde, $mois,$jour,$an));
			return $ladate;
			//return preg_replace("#([0-9]{4})-([0-9]{2})-([0-9]{2})#i","\\3/\\2/\\1",$ladate);
		}
	}

	/**
	 * Convertit une date du format Jour/Mois/Anne (Franais) au format Anne-Mois-Jour (SQL).
	 * @param string $ladate Date  convertir.
	 * @return string Date convertie.
	 */
	function date2AMJ($ladate){
		if ($ladate == "") {
			return "0000-00-00 00:00:00";
		}
		else {
			list ($ladate,$lheure) = explode(" ",$ladate);
			list($jour,$mois,$annee) = explode("/",$ladate);
			$jour = str_pad($jour, 2, "0",STR_PAD_LEFT);
			$mois = str_pad($mois, 2, "0",STR_PAD_LEFT);
			if (strlen($annee) == 2) {
				$annee = "20".$annee;
			}
			elseif (strlen($annee) == 1) {
				$annee = "200".$annee;
			}
		}
		if ($lheure != "") {
			$lheure = " ".$lheure;
		}
		return "$annee-$mois-$jour$lheure";
	}
	
	function send_email($email, $from, $subject, $message, $return=""){
		global $vars_mail;
		// En-ttes
		$headers = "From: ".$from."\n";
		$headers .= "X-Sender: ".$from."\n";
		$headers .= "X-Mailer: PHP\n";
		$headers .= "X-Priority: 1\n";
		$headers .= "Return-Path: ".($return == "" ? $from : $return)."\n";
		$headers .= "Reply-To: ".($return == "" ? $from : $return)."\n";
		$headers .= "Content-Type: text/plain; charset=iso-8859-1\n"; // Type MIME
		return mail($email, $subject, $message, $headers);
	}
	
	function send_email_cci($email, $from, $subject, $message, $return=""){
		global $vars_mail;
		// En-ttes
		$headers = "From: ".$from."\n";
		$headers .= "Bcc: ".$email."\n";
		$headers .= "X-Sender: ".$from."\n";
		$headers .= "X-Mailer: PHP\n";
		$headers .= "X-Priority: 1\n";
		$headers .= "Return-Path: ".($return == "" ? $from : $return)."\n";
		$headers .= "Reply-To: ".($return == "" ? $from : $return)."\n";
		$headers .= "Content-Type: text/plain; charset=iso-8859-1\n"; // Type MIME
		return mail($from, $subject, $message, $headers);
	}
	
	function normaliser($chaine) {
		$from = ' ';
		$to = 'aaaaaaaaaaaaaacceeeeeeeeiiiiiiiinnoooooooooouuuuuuuuy_';
		return strtr($chaine, $from, $to);
	}
	function coolSize($size) {
	    $mb = 1024*1024;
	    if ( $size > $mb ) {
	        $mysize = sprintf ("%01.2f",$size/$mb) . " MB";
	    } elseif ( $size >= 1024 ) {
	        $mysize = sprintf ("%01.2f",$size/1024) . " KB";
	    } else {
	        $mysize = $size . " bytes";
	    }
	    return $mysize;
	}
	
	function couleur_inverse($c_orig) {
		$prefix = "";
		if (substr($c_orig,0,1) == "#") {
			$c_orig = ltrim($c_orig,"#");
			$prefix = "#";
		}
		$a = substr($c_orig,0,1);
		$b = substr($c_orig,1,1);
		$c = substr($c_orig,2,1);
		if (strlen($c_orig) == 6) {
			$d = substr($c_orig,3,1);
			$e = substr($c_orig,4,1);
			$f = substr($c_orig,5,1);
		}
		
		$ai = DecHex(15-HexDec($a));
		$bi = DecHex(15-HexDec($b));
		$ci = DecHex(15-HexDec($c));
		if (strlen($c_orig) == 6) {
			$di = DecHex(15-HexDec($d));
			$ei = DecHex(15-HexDec($e));
			$fi = DecHex(15-HexDec($f));
		}
		$c_inv = $prefix.$ai.$bi.$ci;
		if (strlen($c_orig) == 6) {
			$c_inv .= $di.$ei.$fi;
		} 
		return $c_inv;
	}
	
	function htm2txt_sf($text) {
		// Cre un tableau contenant les codes ascii des caractres ayant un codage en html
		$ascii_array=array_merge(array(34,38,60,62),range(160,255));
	
		// Cre un tableau contenant les caractres correspondants aux codes ascci prcdents
		$chars_array=array_map("chr", $ascii_array);
	
		// Cre un tableau contenant les mmes caractres au format html
		$html_array=array_map("htmlentities", $chars_array);
	
		// Remplace les codes html par leurs quivalents txt dans le texte
		for($i=0; $i<count($ascii_array); $i++) {
			//$text=preg_replace("#$html_array[$i]#",$chars_array[$i],$text);
			$text=str_replace($html_array[$i],$chars_array[$i],$text);
		}
	
		// Remplace les sauts de ligne html <br> par \n dans le texte
		$text=preg_replace("#<br>#","\n",$text);
	
		// Supprime les ventuelles balises html et php
		$text=strip_tags($text);
	
		// Retourne le texte trait
		return($text);
	}
	
	function reduiretexte_sf($texte,$lim=100) {
		if ($texte == "") return "";
		$texte = $this->htm2txt_sf($texte);
		if (strlen($texte) <= $lim) return $texte;
		$pos = strlen($texte);
		$lastpos = strpos($texte, " ");
		while($lastpos < $lim && $pos != $lastpos && $lastpos !== false) {
			$pos = $lastpos;
			$lastpos = strpos($texte, " ",($lastpos+1));
		}
		return substr($texte, 0, $pos)." ...";
	}
	
	function mon_utf8_encode($valeur) {
		if(is_array($valeur)) {
			foreach ($valeur as $key=>$value) {
				$valeur[$key] = $this->mon_utf8_encode($value);
			}
		}
		else {
			$valeur = utf8_encode($valeur);
		}
		return $valeur;
	}
	function check_email($adresse) {
		$Syntaxe='^[a-z0-9]+[a-z0-9?.+-_\']*@[a-z0-9_-]+(\.[a-z0-9_-]+)*\.[a-z]{2,25}$';
		if(preg_match("#".$Syntaxe."#i",$adresse)) {
			return true;
		}
		else {
			return false;
		}
	}
}
?>