<?php
/************************************************************************/
/* BALISTE ECMS                                                         */
/* ===========================                                          */
/* Copyright (c) 2004 by Stephan Acquatella (stephan@balistis.com)      */
/* http://www.baliste.org                                               */
/*                                                                      */
/* Enhanced with PHP-NUKE                                               */
/* =======================                                              */
/* Copyright (c) 2005 by Francisco Burzi (fbc@mandrakesoft.com)         */
/* http://phpnuke.org                                                   */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

//if (!defined('MODULE_FILE')) {
//	die ("You can't access this file directly...");
//}
if (!preg_match("#modules.php#i", $_SERVER['PHP_SELF'])) {
	die ("You can't access this file directly...");
}
require_once("core/becms_mainlib_lib.php");
require_once("core/becms_ui_component.php");

$module_name = basename(dirname(__FILE__));
get_lang($module_name);
$userpage = 1;

//require_once("modules/$module_name/lib_db.php");
require_once("modules/$module_name/utils.php");

function format_nuke_url($nukeurl) {
	$tab_serveur = parse_url($nukeurl);
	$racine = $tab_serveur["scheme"]."://";
	if ($tab_serveur["user"] != "") {
		$racine .= $tab_serveur["user"];
	}
	if ($tab_serveur["pass"] != "") {
		$racine .= ":".$tab_serveur["pass"];
	}
	if ($tab_serveur["pass"] != "" || $tab_serveur["user"] != "") {
		$racine .= "@";
	}
	$racine .= $tab_serveur["host"];
	if ($tab_serveur["port"] != "") {
		$racine .= ":".$tab_serveur["port"];
	}
	return $racine;	
}

function userCheck($username, $user_email) {
	$username = filter($username, "nohtml", 1);
	$user_email = filter($user_email, "nohtml", 1);
	global $user_prefix, $db;
	$stop = "";
	if ((!$user_email) || (empty($user_email)) || (!preg_match("#^[_\.0-9a-z-]+@([0-9a-z][0-9a-z-]+\.)+[a-z]{2,25}$#i",$user_email))) $stop = "<center>"._ERRORINVEMAIL."</center><br>";
	if (strrpos($user_email,' ') > 0) $stop = "<center>"._ERROREMAILSPACES."</center>";
	if ((!$username) || (empty($username)) || (preg_match("#[^a-zA-Z0-9_-]#",$username))) $stop = "<center>"._ERRORINVNICK."</center><br>";
	if (strlen($username) > 25) $stop = "<center>"._NICK2LONG."</center>";
	if (preg_match("#^((root)|(adm)|(linux)|(webmaster)|(admin)|(god)|(administrator)|(administrador)|(nobody)|(anonymous)|(anonimo)|(annimo)|(operator)|(JackFromWales4u2))$#i",$username)) $stop = "<center>"._NAMERESERVED."</center>";
	if (strrpos($username,' ') > 0) $stop = "<center>"._NICKNOSPACES."</center>";
	if ($db->sql_numrows($db->sql_query("SELECT uname FROM ".$user_prefix."_users WHERE uname='$username'")) > 0) $stop = "<center>"._NICKTAKEN."</center><br>";
	if ($db->sql_numrows($db->sql_query("SELECT username FROM ".$user_prefix."_users_temp WHERE username='$username'")) > 0) $stop = "<center>"._NICKTAKEN."</center><br>";
	if ($db->sql_numrows($db->sql_query("SELECT email FROM ".$user_prefix."_users WHERE email='$user_email'")) > 0) $stop = "<center>"._EMAILREGISTERED."</center><br>";
	if ($db->sql_numrows($db->sql_query("SELECT user_email FROM ".$user_prefix."_users_temp WHERE user_email='$user_email'")) > 0) $stop = "<center>"._EMAILREGISTERED."</center><br>";
	return $stop;
}

function submit_new_user($nom, $prenom, $email, $ville) {
	global $simplenewsletteradminmail, $sitename, $user_prefix, $db, $module_name, $nukeurl,$simplenewslettergroup;
	include("header.php");
	
	$username = $nom." ".$prenom;
	$username = str_replace(" ", "_", $username);
	$username = str_replace("'", "", $username);
	$obj_util = new utilFuncs_simpleUsers();
	$username = $obj_util->normaliser($username);
	$username = substr($username,0,25);
	$stop = userCheck($username, $email);
	$user_regdate = date("M d, Y");
	$user_password = "nopass";
	$categories = explode("\n",str_replace("\r","",_SNLCATEGORIEDEF));
	$othercategorie = $categories[(count($categories)-1)];
	
	if ($stop == "") {
		mt_srand ((double)microtime()*1000000);
		$maxran = 1000000;
		$check_num = mt_rand(0, $maxran);
		$check_num = md5($check_num);
		$time = time();
		$nukeurl = format_nuke_url($nukeurl);
		
		$email = filter($email, "nohtml");
		$nom = filter($nom, "nohtml");
		$prenom = filter($prenom, "nohtml");
		$ville = filter($ville, "nohtml");
		
		$finishlink = "$nukeurl/modules.php?name=$module_name&op=activate&check_num=$check_num";
		$modiflink = "$nukeurl/modules.php?name=$module_name&op=contact";
		$new_password = md5($user_password);
		$new_password = htmlspecialchars(stripslashes($new_password),ENT_QUOTES,'ISO-8859-1',true);
		$username = filter($username, "nohtml");
		
		$result = $db->sql_query("INSERT INTO ".$user_prefix."_users_temp (username, user_password, user_regdate, check_num, time, user_name, user_firstname, user_town, user_email, user_filiere, user_categorie, user_group ) VALUES ('$username', '$new_password', '$user_regdate', '$check_num', '$time', '$nom', '$prenom', '$ville', '$email', '$filiere', '$categorie', '$simplenewslettergroup')");
		if(!$result) {
			print_r($db->sql_error());
			echo "<br>";
		}
		else {
			$nom = str_replace("''", "'",$nom);
			$prenom = str_replace("''", "'",$prenom);
			
			$subject = ""._SUBSNMAILSUBJECT."\"".$sitename."\"";
			$message = str_replace("<!--nom-->", $nom, _SUBSNMAILMESSAGE);
			$message = str_replace("<!--prenom-->", $prenom, $message);
			$message = str_replace("<!--lien-->", $finishlink, $message);
			$objutil = new utilFuncs_simpleUsers();
			$objutil->send_email($email, $simplenewsletteradminmail,$subject,$message);
			/*$message = ""._WELCOMETO." $sitename!\n\n"._YOUUSEDEMAIL." ($user_email) "._TOREGISTER." $sitename.\n\n "._TOFINISHUSER."\n\n $finishlink\n\n "._FOLLOWINGMEM."\n\n"._UNICKNAME." $username\n"._UPASSWORD." $user_password";
			$from = "$adminmail";
			mail($email, $subject, $message, "From: $from\nX-Mailer: PHP/" . phpversion());*/
			$contenu = str_replace("<!--lien-->", $modiflink, _SUBSNREGISTRATION1);
			echo "<h1>"._SUBSIMPLENEWSLETTER."</h1>";
			echo "<p>".nl2br($contenu)."</p>\n";
		}
	}
	else {
		if ($nom.$prenom.$email.$ville.$filiere.$categorie.$autre == "") {
			$stop = "";
		}
		
		$nom = stripslashes($nom);
		$prenom = stripslashes($prenom);
		$ville = stripslashes($ville);
		
		echo "<h1>"._SUBSIMPLENEWSLETTER."</h1>";
		$contenu = str_replace("<!--emailadminnewsletter-->", "<a href=\"mailto:".$simplenewsletteradminmail."\">".$simplenewsletteradminmail."</a>", _SUSERSMESSNEWREG);
		if ($nom.$prenom.$email.$ville != "") {
			$contenu .= str_replace("<!--raison-->", "</p>".$stop."<p>", _SUBSNNOSUBERR);
		}
		echo "<p>".nl2br($contenu)."<br /></p>\n";
		$content = '<script type="text/javascript" src="javascripts/lang/lang-french.js"></script>
<script type="text/javascript" src="javascripts/control_form.js"></script>
';
		$content .= "<form action=\"modules.php?name=$module_name&op=submituser\" onsubmit=\"return submit_form(this)\" method=\"post\">";
		$content .= "<fieldset><legend>"._SUBNLCOORDS."</legend>";
		$content .= '<table cellpadding="0" cellspacing="0" border="0" align="center">';
		$content .= '<tr><td><p>'._SUBNAME2.'</p></td><td width="20"></td><td>';
		$content .= "<champ lib=\""._SUBNAME."\" nom=\"nom\" lim=\"1,100\"></champ><input type=\"text\" name=\"nom\" size=\"15\" class=\"zoneSubscribe2\" value=\"".$nom."\">";
		$content .= "</td></tr>";
		$content .= '<tr><td><p>'._SUBPRENAME2.'</p></td><td width="20"></td><td>';
		$content .= "<champ lib=\""._SUBPRENAME."\" nom=\"prenom\" lim=\"1,100\"></champ><input type=\"text\" name=\"prenom\" size=\"15\" class=\"zoneSubscribe2\" value=\"".$prenom."\">";
		$content .= "</td></tr>";
		$content .= '<tr><td><p>'._SUBTOWN2.'</p></td><td width="20"></td><td>';
		$content .= "<champ lib=\""._SUBTOWN."\" nom=\"ville\" lim=\"1,100\"></champ><input type=\"text\" name=\"ville\" size=\"15\" class=\"zoneSubscribe2\" value=\"".$ville."\">";
		$content .= "</td></tr>";
		$content .= '<tr><td><p>'._SUBMAIL2.'</p></td><td width="20"></td><td>';
		$content .= "<champ ctl=\"email\" lib=\""._SUBMAIL."\" nom=\"email\" lim=\"3,100\"></champ><input type=\"text\" name=\"email\" size=\"15\" class=\"zoneSubscribe2\" value=\"".$email."\">";
		$content .= "</td></tr>";
		$content .= '<tr><td colspan="3" align="center">';
		$content .= "<br /><input type=\"submit\" value=\""._SUBSAVE."\" name=\"validsub\" id =\"validsub\"><br />";
		$content .= "</td></tr></table>";
		$content .= "</fieldset>";
		$content .= "</form>";
		echo $content;
	}
	include("footer.php");
}

function submit_new_userodarc($nom, $prenom, $email, $ville, $filiere, $categorie, $autre) {
	global $simplenewsletteradminmail, $sitename, $user_prefix, $db, $module_name, $nukeurl,$simplenewslettergroup;
	include("header.php");
	
	$username = $nom." ".$prenom;
	$username = str_replace(" ", "_", $username);
	$username = str_replace("'", "", $username);
	$obj_util = new utilFuncs_simpleUsers();
	$username = $obj_util->normaliser($username);
	$username = substr($username,0,25);
	$stop = userCheck($username, $email);
	$user_regdate = date("M d, Y");
	$user_password = "nopass";
	$categories = explode("\n",str_replace("\r","",_SNLCATEGORIEDEF));
	$othercategorie = $categories[(count($categories)-1)];
	
	if ($stop == "") {
		mt_srand ((double)microtime()*1000000);
		$maxran = 1000000;
		$check_num = mt_rand(0, $maxran);
		$check_num = md5($check_num);
		$time = time();
		$nukeurl = format_nuke_url($nukeurl);
		
		if ($othercategorie == $categorie) {
			$categorie = $autre;
		}
		
		$email = filter($email, "nohtml");
		$nom = filter($nom, "nohtml");
		$prenom = filter($prenom, "nohtml");
		$ville = filter($ville, "nohtml");
		$filiere = filter($filiere, "nohtml");
		$categorie = filter($categorie, "nohtml");
		$autre = filter($autre, "nohtml");
		
		$finishlink = "$nukeurl/modules.php?name=$module_name&op=activate&check_num=$check_num";
		$modiflink = "$nukeurl/modules.php?name=$module_name&op=contact";
		$new_password = md5($user_password);
		$new_password = htmlspecialchars(stripslashes($new_password),ENT_QUOTES,'ISO-8859-1',true);
		$username = filter($username, "nohtml");
		
		$result = $db->sql_query("INSERT INTO ".$user_prefix."_users_temp (username, user_password, user_regdate, check_num, time, user_name, user_firstname, user_town, user_email, user_filiere, user_categorie, user_group ) VALUES ('$username', '$new_password', '$user_regdate', '$check_num', '$time', '$nom', '$prenom', '$ville', '$email', '$filiere', '$categorie', '$simplenewslettergroup')");
		if(!$result) {
			print_r($db->sql_error());
			echo "<br>";
		}
		else {
			$nom = str_replace("''", "'",$nom);
			$prenom = str_replace("''", "'",$prenom);
			
			$subject = ""._SUBSNMAILSUBJECT."\"".$sitename."\"";
			$message = str_replace("<!--nom-->", $nom, _SUBSNMAILMESSAGE);
			$message = str_replace("<!--prenom-->", $prenom, $message);
			$message = str_replace("<!--lien-->", $finishlink, $message);
			$objutil = new utilFuncs_simpleUsers();
			$objutil->send_email($email, $simplenewsletteradminmail,$subject,$message);
			/*$message = ""._WELCOMETO." $sitename!\n\n"._YOUUSEDEMAIL." ($user_email) "._TOREGISTER." $sitename.\n\n "._TOFINISHUSER."\n\n $finishlink\n\n "._FOLLOWINGMEM."\n\n"._UNICKNAME." $username\n"._UPASSWORD." $user_password";
			$from = "$adminmail";
			mail($email, $subject, $message, "From: $from\nX-Mailer: PHP/" . phpversion());*/
			$contenu = str_replace("<!--lien-->", $modiflink, _SUBSNREGISTRATION1);
			echo "<h1>"._SUBSIMPLENEWSLETTER."</h1>";
			echo "<p>".nl2br($contenu)."</p>\n";
		}
	}
	else {
		if ($nom.$prenom.$email.$ville.$filiere.$categorie.$autre == "") {
			$stop = "";
		}
		
		$nom = stripslashes($nom);
		$prenom = stripslashes($prenom);
		$ville = stripslashes($ville);
		$filiere = stripslashes($filiere);
		$categorie = stripslashes($categorie);
		$autre = stripslashes($autre);
		
		$filieres = explode("\n",str_replace("\r","",_SNLFILIEREDEF));
		$menufilieres = "<select name=\"filiere\" size=\"1\" class=\"zoneSubscribe2\">";
		foreach ($filieres as $lafiliere) {
			$select = "";
			if ($lafiliere == $filiere) {
				$select = ' selected="selected"';
			}
			$menufilieres .= "<option value=\"$lafiliere\"$select>$lafiliere</option>";
		}
		$menufilieres .= "</select>";
		
		$categories = explode("\n",str_replace("\r","",_SNLCATEGORIEDEF));
		$menucategories = "<select name=\"categorie\" size=\"1\" class=\"zoneSubscribe2\" onchange=\"showautre(this,'".$othercategorie."')\">";
		foreach ($categories as $lacategorie) {
			$select = "";
			if ($lacategorie == $categorie) {
				$select = ' selected="selected"';
			}
			$menucategories .= "<option value=\"$lacategorie\"$select>$lacategorie</option>";
		}
		$menucategories .= "</select>";
		
		if ($othercategorie == $categorie) {
			$styleautre = ' style="display: block"'; 
		}
		else {
			$styleautre = ' style="display: none"';
		}
		
		echo "<h1>"._SUBSIMPLENEWSLETTER."</h1>";
		$contenu = str_replace("<!--raison-->", "</p>".$stop."<p>", _SUBSNNOSUBERR);
		echo "<p>".nl2br($contenu)."<br /></p>\n";
		$content = '<script type="text/javascript" src="javascripts/lang/lang-french.js"></script>
<script type="text/javascript" src="javascripts/control_form.js"></script>
<script type="text/javascript">
// <![CDATA[
function showautre(lemenu,letest) {
	if (document.all) {
		var objSub = document.all["subother"];
	}
	else {
		var objSub = document.getElementById("subother");
	}	
	if (lemenu.value==letest) {
		objSub.style.display="block";
	}
	else {
		objSub.style.display="none";
	}
}
// ]]>
</script>';
		$content .= "<form action=\"modules.php?name=$module_name&op=submituser\" onsubmit=\"return submit_form(this)\" method=\"post\">";
		$content .= "<fieldset><legend>"._SUBNLCOORDS."</legend>";
		$content .= '<table cellpadding="0" cellspacing="0" border="0" align="center">';
		$content .= '<tr><td><p>'._SUBNAME2.'</p></td><td width="20"></td><td>';
		$content .= "<champ lib=\""._SUBNAME."\" nom=\"nom\" lim=\"1,100\"></champ><input type=\"text\" name=\"nom\" size=\"15\" class=\"zoneSubscribe2\" value=\"".$nom."\">";
		$content .= "</td></tr>";
		$content .= '<tr><td><p>'._SUBPRENAME2.'</p></td><td width="20"></td><td>';
		$content .= "<champ lib=\""._SUBPRENAME."\" nom=\"prenom\" lim=\"1,100\"></champ><input type=\"text\" name=\"prenom\" size=\"15\" class=\"zoneSubscribe2\" value=\"".$prenom."\">";
		$content .= "</td></tr>";
		$content .= '<tr><td><p>'._SUBTOWN2.'</p></td><td width="20"></td><td>';
		$content .= "<champ lib=\""._SUBTOWN."\" nom=\"ville\" lim=\"1,100\"></champ><input type=\"text\" name=\"ville\" size=\"15\" class=\"zoneSubscribe2\" value=\"".$ville."\">";
		$content .= "</td></tr>";
		$content .= '<tr><td><p>'._SUBMAIL2.'</p></td><td width="20"></td><td>';
		$content .= "<champ ctl=\"email\" lib=\""._SUBMAIL."\" nom=\"email\" lim=\"3,100\"></champ><input type=\"text\" name=\"email\" size=\"15\" class=\"zoneSubscribe2\" value=\"".$email."\">";
		$content .= "</td></tr>";
		$content .= '<tr><td><p>'._SUBFILIERE2.'</p></td><td width="20"></td><td>';
		$content .= "<champ lib=\""._SUBFILIERE."\" nom=\"filiere\"></champ>";
		$content .= $menufilieres;
		$content .= "</td></tr>";
		$content .= '<tr><td><p>'._SUBCAT2.'</p></td><td width="20"></td><td>';
		$content .= "<champ lib=\""._SUBCAT."\" nom=\"categorie\"></champ>";
		$content .= $menucategories;
		$content .= "<div id=\"subother\"$styleautre>";
		$content .= "<input type=\"text\" name=\"autre\" size=\"15\" class=\"zoneSubscribe2\" value=\"".$autre."\">";
		$content .= "</div>";
		$content .= "</td></tr>";
		$content .= '<tr><td colspan="3" align="center">';
		$content .= "<br /><input type=\"submit\" value=\""._SUBSAVE."\" name=\"validsub\" id =\"validsub\"><br />";
		$content .= "</td></tr></table>";
		$content .= "</fieldset>";
		$content .= "</form>";
		echo $content;
	}
	include("footer.php");
}

function new_pass($longueur=8) {
	$rpass = NULL;
	$chars = array_merge(range('A','Z'),range('a','z'),range('0','9'));
	$cmax = count($chars) -1;
	for ($i = 0;$i <= $len;$i++) $rpass .= $chars[mt_rand(0,$cmax)];
	return $rpass;
}

function submit_new_user_data($nom, $prenom, $email, $username, $user_password) {
	global $simpleusersadminmail, $sitename, $user_prefix, $db, $module_name, $nukeurl,$simplenewslettergroup, $simpleusersleveldataaccess, $simpledatagroup;
	include("header.php");
	
	//$username = $nom." ".$prenom;
	$username = str_replace(" ", "_", $username);
	$username = str_replace("'", "", $username);
	$obj_util = new utilFuncs_simpleUsers();
	$username = $obj_util->normaliser($username);
	$username = substr($username,0,25);
	$stop = userCheck($username, $email);
	$user_regdate = date("M d, Y");
	//$user_password = new_pass();
	
	if ($stop == "") {
		mt_srand ((double)microtime()*1000000);
		$maxran = 1000000;
		$check_num = mt_rand(0, $maxran);
		$check_num = md5($check_num);
		$time = time()+(3600*24*30); //donne 30 jours de dlais avant de supprimer le compte non valid
		$nukeurl = format_nuke_url($nukeurl);
		
		$email = filter($email, "nohtml");
		$nom = filter($nom, "nohtml");
		$prenom = filter($prenom, "nohtml");
		$niveau = $simpleusersleveldataaccess;
		
		$finishlink = "$nukeurl/system.php?action=list_usersno&op=users_data&onglet=users_nodata";
		//$modiflink = "$nukeurl/modules.php?name=$module_name&op=contact";
		$new_password = md5($user_password);
		$new_password = htmlspecialchars(stripslashes($new_password),ENT_QUOTES,'ISO-8859-1',true);
		$username = filter($username, "nohtml");
		
		$result = $db->sql_query("INSERT INTO ".$user_prefix."_users_temp (username, user_password, user_regdate, check_num, time, user_name, user_firstname, user_email, user_level, user_group ) VALUES ('$username', '$new_password', '$user_regdate', '$check_num', '$time', '$nom', '$prenom', '$email', '$simpleusersleveldataaccess', '$simpledatagroup')");
		if(!$result) {
			print_r($db->sql_error());
			echo "<br>";
		}
		else {
			//envoyer un mail  l'admin pour valider le compte 
			$nom = str_replace("''", "'",$nom);
			$prenom = str_replace("''", "'",$prenom);
			
			$subject = ""._SUBSDATASUBSUBJECT." \"".$sitename."\"";
			$message = str_replace("<!--nom-->", $nom, _SUBSDATASUBMAIL);
			$message = str_replace("<!--prenom-->", $prenom, $message);
			$message = str_replace("<!--lien-->", $finishlink, $message);
			$objutil = new utilFuncs_simpleUsers();
			$objutil->send_email($simpleusersadminmail, $simpleusersadminmail,$subject,$message);
			
			$subject = ""._SUBSDATASUBSUBJECT2." \"".$sitename."\"";
			$contenu = _SUBDATAREGISTRATION2;
			$contenu = str_replace("<!--login-->", $username, $contenu);
			$contenu = str_replace("<!--password-->", $user_password, $contenu);
			$objutil->send_email($email, $simpleusersadminmail,$subject,$contenu);
			//$contenu = str_replace("<!--lien-->", $modiflink, _SUBDATAREGISTRATION1);
			$contenu = _SUBDATAREGISTRATION1;
			//$contenu = str_replace("<!--login-->", $username, $contenu);
			//$contenu = str_replace("<!--password-->", $user_password, $contenu);
			echo "<h1>"._SUBSIMPLEDATA."</h1>";
			echo "<p>".nl2br($contenu)."</p>\n";
		}
	}
	else {
		if ($nom.$prenom.$email.$ville.$filiere.$categorie.$autre == "") {
			$stop = "";
		}
		
		$nom = stripslashes($nom);
		$prenom = stripslashes($prenom);
		$ville = stripslashes($ville);
		$user_password = stripslashes($user_password);
		
		echo "<h1>"._SUBSIMPLEDATA."</h1>";
		if ($stop != "") {
			$contenu = str_replace("<!--raison-->", "</p>".$stop."<p>", _SUBSSIMPLEDATANOSUBERR);
		}
		else {
			$contenu = "<p>"._SUBDATAREGISTRATION."</p>";
		}
		echo "<p>".nl2br($contenu)."<br /></p>\n";
		$content = '<script type="text/javascript" src="javascripts/lang/lang-french.js"></script>
<script type="text/javascript" src="javascripts/control_form.js"></script>
';
		$content .= "<form action=\"modules.php?name=$module_name&op=submituserdata\" onsubmit=\"return submit_form(this)\" method=\"post\">";
		$content .= "<fieldset><legend>"._SUBNLCOORDS."</legend>";
		$content .= '<table cellpadding="0" cellspacing="0" border="0" align="center">';
		$content .= '<tr><td><p>'._SUBNAME2.'</p></td><td width="20"></td><td>';
		$content .= "<champ lib=\""._SUBNAME."\" nom=\"nom\" lim=\"1,100\"></champ><input type=\"text\" name=\"nom\" size=\"15\" class=\"zoneSubscribe2\" value=\"".$nom."\">";
		$content .= "</td></tr>";
		$content .= '<tr><td><p>'._SUBPRENAME2.'</p></td><td width="20"></td><td>';
		$content .= "<champ lib=\""._SUBPRENAME."\" nom=\"prenom\" lim=\"1,100\"></champ><input type=\"text\" name=\"prenom\" size=\"15\" class=\"zoneSubscribe2\" value=\"".$prenom."\">";
		$content .= "</td></tr>";
		$content .= '<tr><td><p>'._SUBMAIL2.'</p></td><td width="20"></td><td>';
		$content .= "<champ ctl=\"email\" lib=\""._SUBMAIL."\" nom=\"email\" lim=\"3,100\"></champ><input type=\"text\" name=\"email\" size=\"15\" class=\"zoneSubscribe2\" value=\"".$email."\">";
		$content .= "</td></tr>";
		$content .= '<tr><td><p>'._SUBNICKNAME2.'</p></td><td width="20"></td><td>';
		$content .= "<champ lib=\""._SUBNICKNAME."\" nom=\"username\" lim=\"1,100\"></champ><input type=\"text\" name=\"username\" size=\"15\" class=\"zoneSubscribe2\" value=\"".$username."\">";
		$content .= "</td></tr>";
		$content .= '<tr><td><p>'._SUBPASS2.'</p></td><td width="20"></td><td>';
		$content .= "<champ lib=\""._SUBPASS."\" nom=\"user_password\" lim=\"1,100\"></champ><input type=\"password\" name=\"user_password\" size=\"15\" class=\"zoneSubscribe2\" value=\"".$user_password."\">";
		$content .= "</td></tr>";
		$content .= '<tr><td colspan="3" align="center">';
		$content .= "<br /><input type=\"submit\" value=\""._SUBSAVE."\" name=\"validsub\" id =\"validsub\"><br />";
		$content .= "</td></tr></table>";
		$content .= "</fieldset>";
		$content .= "</form>";
		echo $content;
	}
	include("footer.php");
}

function submit_new_user_private($nom, $prenom, $email, $username, $user_password, $adh_entreprise, $adh_tel, $groups=array()) {
	global $simpleusersprivateadminmail, $sitename, $user_prefix, $db, $module_name, $simpleusersprivateprivgroups;
	global $currentlang;
	$nukeurl = "http://".$_SERVER["HTTP_HOST"].($_SERVER["SERVER_PORT"]!="80" ? ":".$_SERVER["SERVER_PORT"] : "");
	
	include("header.php");
	
	//$username = $nom." ".$prenom;
	$username = str_replace(" ", "_", $username);
	$username = str_replace("'", "", $username);
	$obj_util = new utilFuncs_simpleUsers();
	$username = $obj_util->normaliser($username);
	$username = substr($username,0,25);
	$stop = userCheck($username, $email);
	$user_regdate = date("M d, Y");
	//$user_password = new_pass();
	
	if ($stop == "") {
		mt_srand ((double)microtime()*1000000);
		$maxran = 1000000;
		$check_num = mt_rand(0, $maxran);
		$check_num = md5($check_num);
		$time = time()+(3600*24*30); //donne 30 jours de dlais avant de supprimer le compte non valid
		$nukeurl = format_nuke_url($nukeurl);
		
		$email = filter($email, "nohtml");
		$nom = filter($nom, "nohtml");
		$prenom = filter($prenom, "nohtml");
		
		$finishlink = "$nukeurl/system.php?action=list_usersno&op=users_privatespace&onglet=users_notvalid";
		$new_password = md5($user_password);
		$new_password = htmlspecialchars(stripslashes($new_password),ENT_QUOTES,'ISO-8859-1',true);
		$username = filter($username, "nohtml");
		
		$result = $db->sql_query("INSERT INTO ".$user_prefix."_users_temp (username, user_password, user_regdate, check_num, time, user_name, user_firstname, user_email, user_level, adh_entreprise, adh_tel, user_language, user_domain_reg ) VALUES ('$username', '$new_password', '$user_regdate', '$check_num', '$time', '$nom', '$prenom', '$email', '$simpleusersleveldataaccess', '$adh_entreprise', '$adh_tel', '$currentlang', '$nukeurl')");
		if(!$result) {
			print_r($db->sql_error());
			echo "<br>";
		}
		else {
			//enregistrement des groupes
			$id_user_no = $db->sql_nextid();
			foreach ($groups as $groupencours) {
				$result = $result && $db->sql_query("INSERT INTO ".$user_prefix."_users_temp_groups (user_id, group_id) VALUES ('".$id_user_no."','".$groupencours."')");
			}
			
			//envoyer un mail  l'admin pour valider le compte 
			$nom = str_replace("''", "'",$nom);
			$prenom = str_replace("''", "'",$prenom);
			
			$subject = ""._SUBSPRIVATESPACESUBJECT." \"".$sitename."\"";
			$message = str_replace("<!--nom-->", $nom, _SUBSPRIVATESPACEMAIL);
			$message = str_replace("<!--prenom-->", $prenom, $message);
			$message = str_replace("<!--lien-->", $finishlink, $message);
			$objutil = new utilFuncs_simpleUsers();
			$objutil->send_email($simpleusersprivateadminmail, $simpleusersprivateadminmail,$subject,$message);
			
			$subject = ""._SUBPRIVATESPACESUBJECT2." \"".$sitename."\"";
			$contenu = _SUBPRIVATESPACEREGISTRATION2;
			$contenu = str_replace("<!--login-->", $username, $contenu);
			$contenu = str_replace("<!--password-->", $user_password, $contenu);
			$objutil->send_email($email, $simpleusersprivateadminmail,$subject,$contenu);
			//$contenu = str_replace("<!--lien-->", $modiflink, _SUBDATAREGISTRATION1);
			$contenu = _SUBPRIVATESPACEREGISTRATION1;
			//$contenu = str_replace("<!--login-->", $username, $contenu);
			//$contenu = str_replace("<!--password-->", $user_password, $contenu);
			echo "<h1>"._SUBPRIVATESPACE."</h1>";
			echo "<p>".nl2br($contenu)."</p>\n";
		}
	}
	else {
		if ($nom.$prenom.$email.$username.$user_password == "") {
			$stop = "";
		}
		
		$groupesbox = "";
		$result = $db->sql_query("SELECT id, name FROM ".$user_prefix."_groups ORDER BY name ASC");//$_SERVER[HTTP_HOST]
		if ($db->sql_numrows($result) != 0) {
			while ($ligneencours = $db->sql_fetchrow($result)) {
				$ok = true;
				$sql = "SELECT group_id FROM ".$user_prefix."_domain_name_groups INNER JOIN ".$user_prefix."_domain_name ON domain_id=".$user_prefix."_domain_name.id WHERE name='".$_SERVER[HTTP_HOST]."' AND group_id='".$ligneencours["id"]."'";
				$result2 = $db->sql_query($sql);
				$sql = "SELECT domain_id FROM ".$user_prefix."_domain_name_groups WHERE group_id='".$ligneencours["id"]."'";
				$result3 = $db->sql_query($sql);
				if ($db->sql_numrows($result2) == 0 && $db->sql_numrows($result3) != 0) {
					$ok = false;
				}
				if (in_array($ligneencours["id"],$simpleusersprivateprivgroups)) {
					$ok = false;
				}
				if ($ok) {
					$groupesbox .= '<input name="groups[]" type="checkbox" id="'.$ligneencours["id"].'" value="'.$ligneencours["id"].'">';
					$groupesbox .= '<label for="'.$ligneencours["id"].'">'.$ligneencours["name"].'</label><br />';
				}
			}
		}
		
		$nom = stripslashes($nom);
		$prenom = stripslashes($prenom);
		$email = stripslashes($email);
		$username = stripslashes($username);
		$user_password = stripslashes($user_password);
		
		echo "<h1>"._SUBPRIVATESPACE."</h1>";
		if ($stop != "") {
			$contenu = str_replace("<!--raison-->", "</p>".$stop."<p>", _SUBSPRIVATESPACENOSUBERR);
		}
		else {
			$contenu = "<p>"._SUBPRIVATEREGISTRATION."</p>";
		}
		echo "<p>".nl2br($contenu)."<br /></p>\n";
		$content = '<script type="text/javascript" src="javascripts/lang/lang-french.js"></script>
<script type="text/javascript" src="javascripts/control_form.js"></script>
';
		$content .= "<form action=\"modules.php?name=$module_name&op=submituserprivate\" onsubmit=\"return submit_form(this)\" method=\"post\">";
		$content .= "<fieldset><legend>"._SUBNLCOORDS."</legend>";
		$content .= '<table cellpadding="0" cellspacing="0" border="0" align="center" class="formulaire">';
		
		$content .= '<tr><td colspan="3" class="legende">';
		$content .= ''._SUBRUBREQUIRED.'';
		$content .= "</td></tr>";
		
		$content .= '<tr><td>'._SUBNAME2.'</td><td width="20"></td><td>';
		$content .= "<champ lib=\""._SUBNAME."\" nom=\"nom\" lim=\"1,100\"></champ><input type=\"text\" name=\"nom\" size=\"15\" class=\"zoneSubscribe2\" value=\"".$nom."\">";
		$content .= "</td></tr>";
		$content .= '<tr><td>'._SUBPRENAME2.'</td><td width="20"></td><td>';
		$content .= "<champ lib=\""._SUBPRENAME."\" nom=\"prenom\" lim=\"1,100\"></champ><input type=\"text\" name=\"prenom\" size=\"15\" class=\"zoneSubscribe2\" value=\"".$prenom."\">";
		$content .= "</td></tr>";
		
		$content .= '<tr><td>&nbsp;</td><td></td></tr>';
		
		$content .= '<tr><td>'._SUBORGANISME2.'</td><td width="20"></td><td>';
		$content .= "<champ lib=\""._SUBORGNANISME."\" nom=\"adh_entreprise\" lim=\"1,100\"></champ><input type=\"text\" name=\"adh_entreprise\" size=\"15\" class=\"zoneSubscribe2\" value=\"".$adh_entreprise."\">";
		$content .= "</td></tr>";
		$content .= '<tr><td>'._SUBTELEPHONE2.'</td><td width="20"></td><td>';
		$content .= "<champ lib=\""._SUBTELEPHONE."\" nom=\"adh_tel\" lim=\"1,100\"></champ><input type=\"text\" name=\"adh_tel\" size=\"15\" class=\"zoneSubscribe2\" value=\"".$adh_tel."\">";
		$content .= "</td></tr>";
		
		$content .= '<tr><td>'._SUBMAIL2.'</td><td width="20"></td><td>';
		$content .= "<champ ctl=\"email\" lib=\""._SUBMAIL."\" nom=\"email\" lim=\"3,100\"></champ><input type=\"text\" name=\"email\" size=\"15\" class=\"zoneSubscribe2\" value=\"".$email."\">";
		$content .= "</td></tr>";
		
		$content .= '<tr><td>&nbsp;</td><td></td></tr>';
		$content .= '<tr><td colspan="3" class="legende"><span class="legende">'._SUBNICKUSE.'</span></td></tr>';
		
		$content .= '<tr><td>'._SUBNICKNAME2.'</td><td width="20"></td><td>';
		$content .= "<champ lib=\""._SUBNICKNAME."\" nom=\"username\" lim=\"1,100\"></champ><input type=\"text\" name=\"username\" size=\"15\" class=\"zoneSubscribe2\" value=\"".$username."\">";
		$content .= "</td></tr>";
		$content .= '<tr><td>'._SUBPASS2.'</td><td width="20"></td><td>';
		$content .= "<champ lib=\""._SUBPASS."\" nom=\"user_password\" lim=\"1,100\"></champ><input type=\"password\" name=\"user_password\" size=\"15\" class=\"zoneSubscribe2\" value=\"".$user_password."\">";
		$content .= '</td></tr>';
		
		$content .= '<tr><td>&nbsp;</td><td></td></tr>';
		$content .= '<tr><td colspan="3" class="legende"><span class="legende">'._SUBGROUPCHOOSE.'</span></td></tr>';
		
		$content .= '<tr><td colspan="3">';
		$content .= '<div align="center"><table border="0" cellpadding="0" cellspacing"0"><tr><td>'.$groupesbox.'</td></tr></table></div>';
		$content .= '</td></tr>';
		
		$content .= '<tr><td colspan="3" class="legende">';
		$content .= "<input type=\"submit\" value=\""._SUBSAVE."\" name=\"validsub\" id =\"validsub\">";
		$content .= "</td></tr></table>";
		$content .= "</fieldset>";
		$content .= "</form>";
		echo $content;
	}
	include("footer.php");
}

//bpusersgroups

function submit_new_user_general($nom, $prenom, $email, $username, $user_password, $adh_entreprise, $adh_tel, $user_func, $adh_adresse, $adh_web, $thegroup="") {
	global $simpleusersgenadminmail, $sitename, $user_prefix, $db, $module_name, $simpleusersprivateprivgroups;
	$nukeurl = "http://".$_SERVER["HTTP_HOST"].($_SERVER["SERVER_PORT"]!="80" ? ":".$_SERVER["SERVER_PORT"] : "");
	
	include("header.php");
	
	//$username = $nom." ".$prenom;
	$username = str_replace(" ", "_", $username);
	$username = str_replace("'", "", $username);
	$obj_util = new utilFuncs_simpleUsers();
	$username = $obj_util->normaliser($username);
	$username = substr($username,0,25);
	$stop = userCheck($username, $email);
	$user_regdate = date("M d, Y");
	//$user_password = new_pass();
	
	if ($stop == "") {
		mt_srand ((double)microtime()*1000000);
		$maxran = 1000000;
		$check_num = mt_rand(0, $maxran);
		$check_num = md5($check_num);
		$time = time()+(3600*24*30); //donne 30 jours de dlais avant de supprimer le compte non valid
		$nukeurl = format_nuke_url($nukeurl);
		
		$email = filter($email, "nohtml");
		$nom = filter($nom, "nohtml");
		$prenom = filter($prenom, "nohtml");
		
		$finishlink = "$nukeurl/system.php?action=list_usersno&op=users_general&onglet=users_notvalid";
		$new_password = md5($user_password);
		$new_password = htmlspecialchars(stripslashes($new_password),ENT_QUOTES,'ISO-8859-1',true);
		$username = filter($username, "nohtml");
		$user_func = filter($user_func, "nohtml");
		$adh_adresse = filter($adh_adresse, "nohtml");
		$adh_web = filter($adh_web, "nohtml");
		
		$result = $db->sql_query("INSERT INTO ".$user_prefix."_users_temp (username, user_password, user_regdate, check_num, time, user_name, user_firstname, user_email, adh_entreprise, adh_tel, user_func, adh_adresse, adh_web ) VALUES ('$username', '$new_password', '$user_regdate', '$check_num', '$time', '$nom', '$prenom', '$email', '$adh_entreprise', '$adh_tel', '$user_func', '$adh_adresse', '$adh_web')");
		if(!$result) {
			print_r($db->sql_error());
			echo "<br>";
		}
		else {
			//enregistrement du groupe
			$id_user_no = $db->sql_nextid();
			if ($thegroup != "") { 
				$thegroup = explode(",",$thegroup);
				foreach ($thegroup as $groupencours) { //normalement, il n'y en a qu'un
					$result = $result && $db->sql_query("INSERT INTO ".$user_prefix."_users_temp_groups (user_id, group_id) VALUES ('".$id_user_no."','".$groupencours."')");
				}
			}
			
			//envoyer un mail  l'admin pour valider le compte 
			$nom = str_replace("''", "'",$nom);
			$prenom = str_replace("''", "'",$prenom);
			
			$subject = ""._SUBSGENSUBJECT." \"".$sitename."\"";
			$message = str_replace("<!--nom-->", $nom, _SUBSGENPACEMAIL);
			$message = str_replace("<!--prenom-->", $prenom, $message);
			$message = str_replace("<!--lien-->", $finishlink, $message);
			$objutil = new utilFuncs_simpleUsers();
			$objutil->send_email($simpleusersgenadminmail, $simpleusersgenadminmail,$subject,$message);
			
			$subject = ""._SUBGENSUBJECT2." \"".$sitename."\"";
			$contenu = _SUBGENREGISTRATION2;
			$contenu = str_replace("<!--login-->", $username, $contenu);
			$contenu = str_replace("<!--password-->", $user_password, $contenu);
			$objutil->send_email($email, $simpleusersgenadminmail,$subject,$contenu);
			//$contenu = str_replace("<!--lien-->", $modiflink, _SUBDATAREGISTRATION1);
			$contenu = _SUBGENREGISTRATION1;
			//$contenu = str_replace("<!--login-->", $username, $contenu);
			//$contenu = str_replace("<!--password-->", $user_password, $contenu);
			echo '<div id="bloc_repere_fond">';
			echo "<h1>"._SUBGENUSER."</h1>";
			echo "<p>".nl2br($contenu)."</p>\n";
			echo '</div>';
		}
	}
	else {
		if ($nom.$prenom.$email.$username.$user_password == "") {
			$stop = "";
		}
		
		/*$groupesbox = "";
		$result = $db->sql_query("SELECT id, name FROM ".$user_prefix."_groups ORDER BY name ASC");//$_SERVER[HTTP_HOST]
		if ($db->sql_numrows($result) != 0) {
			while ($ligneencours = $db->sql_fetchrow($result)) {
				$ok = true;
				$sql = "SELECT group_id FROM ".$user_prefix."_domain_name_groups INNER JOIN ".$user_prefix."_domain_name ON domain_id=".$user_prefix."_domain_name.id WHERE name='".$_SERVER[HTTP_HOST]."' AND group_id='".$ligneencours["id"]."'";
				$result2 = $db->sql_query($sql);
				$sql = "SELECT domain_id FROM ".$user_prefix."_domain_name_groups WHERE group_id='".$ligneencours["id"]."'";
				$result3 = $db->sql_query($sql);
				if ($db->sql_numrows($result2) == 0 && $db->sql_numrows($result3) != 0) {
					$ok = false;
				}
				if (in_array($ligneencours["id"],$simpleusersprivateprivgroups)) {
					$ok = false;
				}
				if ($ok) {
					$groupesbox .= '<input name="groups[]" type="checkbox" id="'.$ligneencours["id"].'" value="'.$ligneencours["id"].'">';
					$groupesbox .= '<label for="'.$ligneencours["id"].'">'.$ligneencours["name"].'</label><br />';
				}
			}
		}*/
		
		$nom = stripslashes($nom);
		$prenom = stripslashes($prenom);
		$email = stripslashes($email);
		$username = stripslashes($username);
		$user_password = stripslashes($user_password);
		
		echo "<h1>"._SUBGENUSER."</h1>";
		if ($stop != "") {
			$contenu = str_replace("<!--raison-->", "</p>".$stop."<p>", _SUBSGENNOSUBERR);
		}
		else {
			$contenu = "<p>"._SUBGENREGISTRATION."</p>";
		}
		echo "<p>".nl2br($contenu)."<br /></p>\n";
		$content = '<script type="text/javascript" src="javascripts/lang/lang-french.js"></script>
<script type="text/javascript" src="javascripts/control_form.js"></script>
';
		$content .= "<form action=\"modules.php?name=$module_name&op=submitusergen\" onsubmit=\"return submit_form(this)\" method=\"post\">";
		$content .= "<fieldset><legend>"._SUBNLCOORDS."</legend>";
		$content .= '<table cellpadding="0" cellspacing="0" border="0" align="center" class="formulaire">';
		
		$content .= '<tr><td colspan="3" class="legende">';
		$content .= ''._SUBRUBGENREQUIRED.'';
		$content .= "</td></tr>";
		
		$content .= '<tr><td>*'._SUBNAME2.'</td><td width="20"></td><td>';
		$content .= "<champ lib=\""._SUBNAME."\" nom=\"nom\" lim=\"1,100\"></champ><input type=\"text\" name=\"nom\" size=\"15\" class=\"zoneSubscribe2\" value=\"".$nom."\">";
		$content .= "</td></tr>";
		$content .= '<tr><td>*'._SUBPRENAME2.'</td><td width="20"></td><td>';
		$content .= "<champ lib=\""._SUBPRENAME."\" nom=\"prenom\" lim=\"1,100\"></champ><input type=\"text\" name=\"prenom\" size=\"15\" class=\"zoneSubscribe2\" value=\"".$prenom."\">";
		$content .= "</td></tr>";
		
		$content .= '<tr><td>&nbsp;</td><td></td></tr>';
		
		
		$content .= '<tr><td>'._SUBFUNCTION.'</td><td width="20"></td><td>';
		$content .= "<input type=\"text\" name=\"user_func\" size=\"15\" class=\"zoneSubscribe2\" value=\"".$user_func."\">";
		$content .= "</td></tr>";
		$content .= '<tr><td>'._SUBORGANISME2.'</td><td width="20"></td><td>';
		$content .= "<input type=\"text\" name=\"adh_entreprise\" size=\"15\" class=\"zoneSubscribe2\" value=\"".$adh_entreprise."\">";
		$content .= "</td></tr>";
		$content .= '<tr><td>'._SUBADRESSE.'</td><td width="20"></td><td>';
		$content .= "<textarea name=\"adh_adresse\" rows=\"3\" class=\"zoneSubscribe2\">".$adh_adresse."</textarea>";
		$content .= "</td></tr>";
		$content .= '<tr><td>*'._SUBTELEPHONE2.'</td><td width="20"></td><td>';
		$content .= "<champ lib=\""._SUBTELEPHONE."\" nom=\"adh_tel\" lim=\"1,100\"></champ><input type=\"text\" name=\"adh_tel\" size=\"15\" class=\"zoneSubscribe2\" value=\"".$adh_tel."\">";
		$content .= "</td></tr>";
		
		$content .= '<tr><td>*'._SUBMAIL2.'</td><td width="20"></td><td>';
		$content .= "<champ ctl=\"email\" lib=\""._SUBMAIL."\" nom=\"email\" lim=\"3,100\"></champ><input type=\"text\" name=\"email\" size=\"15\" class=\"zoneSubscribe2\" value=\"".$email."\">";
		$content .= "</td></tr>";
		$content .= '<tr><td>'._SUBWEB2.'</td><td width="20"></td><td>';
		$content .= "<input type=\"text\" name=\"adh_web\" size=\"15\" class=\"zoneSubscribe2\" value=\"".$adh_web."\">";
		$content .= "</td></tr>";
		
		$content .= '<tr><td>&nbsp;</td><td></td></tr>';
		$content .= '<tr><td colspan="3" class="legende"><span class="legende">'._SUBNICKUSEGEN.'</span></td></tr>';
		
		$content .= '<tr><td>*'._SUBNICKNAME2.'</td><td width="20"></td><td>';
		$content .= "<champ lib=\""._SUBNICKNAME."\" nom=\"username\" lim=\"1,100\"></champ><input type=\"text\" name=\"username\" size=\"15\" class=\"zoneSubscribe2\" value=\"".$username."\">";
		$content .= "</td></tr>";
		$content .= '<tr><td>*'._SUBPASS2.'</td><td width="20"></td><td>';
		$content .= "<champ lib=\""._SUBPASS."\" nom=\"user_password\" lim=\"1,100\"></champ><input type=\"password\" name=\"user_password\" size=\"15\" class=\"zoneSubscribe2\" value=\"".$user_password."\">";
		$content .= '</td></tr>';
		
		/*$content .= '<tr><td>&nbsp;</td><td></td></tr>';
		$content .= '<tr><td colspan="3" class="legende"><span class="legende">'._SUBGROUPCHOOSE.'</span></td></tr>';
		
		$content .= '<tr><td colspan="3">';
		$content .= '<div align="center"><table border="0" cellpadding="0" cellspacing"0"><tr><td>'.$groupesbox.'</td></tr></table></div>';
		$content .= '</td></tr>';*/
		
		$content .= '<tr><td colspan="3" class="legende">';
		if ($thegroup != "") {
			$thegroup = explode(",",$thegroup);
			foreach ($thegroup as $groupencours) {
				$content .= '<input name="groups[]" type="hidden" value="'.$groupencours.'">';
			}
		}
		$content .= "<input type=\"submit\" value=\""._SUBSAVE."\" name=\"validsub\" id =\"validsub\">";
		$content .= "</td></tr></table>";
		$content .= "</fieldset>";
		$content .= "</form>";
		echo $content;
	}
	include("footer.php");
}

function activate_user($check_num) {
	global $db, $user_prefix, $module_name, $language, $prefix, $simplenewsletteradminmail,$simplenewslettergroup, $typeusergroup, $nukeurl;
	
	$past = time()-86400;
	$db->sql_query("DELETE FROM ".$user_prefix."_users_temp WHERE time < $past");
	$sql = "SELECT * FROM ".$user_prefix."_users_temp WHERE check_num='$check_num'";
	$result = $db->sql_query($sql);
	if ($db->sql_numrows($result) == 1) {
		$row = $db->sql_fetchrow($result);
		$user_password = htmlspecialchars(stripslashes($row['user_password']),ENT_QUOTES,'ISO-8859-1',true);
		
		$row['username'] = filter($row['username'], "nohtml");
		$row['user_email'] = filter($row['user_email'], "nohtml");
		$row['user_name'] = filter($row['user_name'], "nohtml");
		$row['user_firstname'] = filter($row['user_firstname'], "nohtml");
		$row['user_town'] = filter($row['user_town'], "nohtml");
		$row['user_filiere'] = filter($row['user_filiere'], "nohtml");
		$row['user_categorie'] = filter($row['user_categorie'], "nohtml");
		
		$db->sql_query("INSERT INTO ".$user_prefix."_users (uname, email, pass, user_regdate, user_lang, newsletter, user_group, user_name, user_firstname, user_town, user_filiere, user_categorie) VALUES ('".$row['username']."', '".$row['user_email']."', '$user_password', '".$row['user_regdate']."', '$language', '1', '".$row['user_group']."', '".$row['user_name']."', '".$row['user_firstname']."', '".$row['user_town']."', '".$row['user_filiere']."', '".$row['user_categorie']."')");
		if ($typeusergroup == "1") { //si groupes multiples
			$db->sql_query("INSERT INTO ".$user_prefix."_users_groups (user_id, group_id) VALUES ('".$db->sql_nextid()."','".$simplenewslettergroup."')");
		}
		/*if ($db->sql_error()) {
		 print_r($db->sql_error());
			die();
		}*/
		$db->sql_query("DELETE FROM ".$user_prefix."_users_temp WHERE check_num='$check_num'");

		$row['user_name'] = str_replace("''", "'",$row['user_name']);
		$row['user_firstname'] = str_replace("''", "'",$row['user_firstname']);
		
		$content = str_replace("<!--nom-->", $row['user_name'], _SUBSNACTIVATED);
		$content = str_replace("<!--prenom-->", $row['user_firstname'], $content);
		
		include("header.php");
		echo "<h1>"._SUBSIMPLENEWSLETTER."</h1>";
		echo "<p>".nl2br($content)."</p>\n";
		include("footer.php");
		
		$nukeurl = format_nuke_url($nukeurl);
		$viewlink = "$nukeurl/system.php?op=users_newsletter";
		$subject = ""._SUBSNNEWSUBSUBJECT."";
		$message = str_replace("<!--nom-->", $row['user_name'], _SUBSNNEWSUBMAIL);
		$message = str_replace("<!--prenom-->", $row['user_firstname'], $message);
		$message = str_replace("<!--lien-->", $viewlink, $message);
		$objutil = new utilFuncs_simpleUsers();
		$objutil->send_email($simplenewsletteradminmail, $simplenewsletteradminmail,$subject,$message);
			
	}
	else {
		include("header.php");
		echo "<h1>"._SUBSIMPLENEWSLETTER."</h1>";
		echo "<p>"._SUBSNNOTACTIVATED."</p>";
		include("footer.php");
	}
}

function activate_user_data($check_num) {
	global $db, $user_prefix, $module_name, $language, $prefix, $nukeurl, $simplenewsletteradminmail;
	$past = time()-86400;
	$db->sql_query("DELETE FROM ".$user_prefix."_users_temp WHERE time < $past");
	$sql = "SELECT * FROM ".$user_prefix."_users_temp WHERE check_num='$check_num'";
	$result = $db->sql_query($sql);
	if ($db->sql_numrows($result) == 1) {
		$row = $db->sql_fetchrow($result);
		if ($row["user_valid"] == "1") {
			$user_password = htmlspecialchars(stripslashes($row['user_password']),ENT_QUOTES,'ISO-8859-1',true);
			$row['username'] = filter($row['username'], "nohtml");
			$row['user_email'] = filter($row['user_email'], "nohtml");
			$row['user_name'] = filter($row['user_name'], "nohtml");
			$row['user_firstname'] = filter($row['user_firstname'], "nohtml");
			
			$db->sql_query("INSERT INTO ".$user_prefix."_users (uname, email, pass, user_regdate, user_lang, user_group, user_name, user_firstname, user_datalevel) VALUES ('".$row['username']."', '".$row['user_email']."', '$user_password', '".$row['user_regdate']."', '$language', '".$row['user_group']."', '".$row['user_name']."', '".$row['user_firstname']."', '".$row['user_level']."')");
			/*if ($db->sql_error()) {
			  print_r($db->sql_error());
				die();
			}*/
			$db->sql_query("DELETE FROM ".$user_prefix."_users_temp WHERE check_num='$check_num'");
	
			$row['username'] = str_replace("''", "'",$row['username']);
			$row['user_name'] = str_replace("''", "'",$row['user_name']);
			$row['user_firstname'] = str_replace("''", "'",$row['user_firstname']);
			
			
			$content = str_replace("<!--nom-->", $row['user_name'], _SUBSDATAACTIVATED);
			$content = str_replace("<!--prenom-->", $row['user_firstname'], $content);
			
			include("header.php");
			echo "<h1>"._SUBSIMPLEDATA."</h1>";
			echo "<p>".nl2br($content)."</p>\n";
			include("footer.php");
		}
	}
	else {
		include("header.php");
		echo "<h1>"._SUBSIMPLEDATA."</h1>";
		echo "<p>"._SUBSDATANOTACTIVATED."</p>";
		include("footer.php");
	}
}

function activate_user_privatesp($check_num) {
	global $db, $user_prefix, $module_name, $language, $prefix, $simpleusersprivateadminmail;
	$nukeurl = "http://".$_SERVER["HTTP_HOST"].($_SERVER["SERVER_PORT"]!="80" ? ":".$_SERVER["SERVER_PORT"] : "");
	
	$past = time()-86400;
	$db->sql_query("DELETE FROM ".$user_prefix."_users_temp WHERE time < $past");
	$sql = "SELECT * FROM ".$user_prefix."_users_temp WHERE check_num='$check_num' AND user_valid='1'";
	$result = $db->sql_query($sql);
	if ($db->sql_numrows($result) == 1) {
		$row = $db->sql_fetchrow($result);
		if ($row["user_valid"] == "1") {
			$user_password = htmlspecialchars(stripslashes($row['user_password']),ENT_QUOTES,'ISO-8859-1',true);
			$row['username'] = filter($row['username'], "nohtml");
			$row['user_email'] = filter($row['user_email'], "nohtml");
			$row['user_name'] = filter($row['user_name'], "nohtml");
			$row['user_firstname'] = filter($row['user_firstname'], "nohtml");
			$row['adh_entreprise'] = filter($row['adh_entreprise'], "nohtml");
			$row['adh_tel'] = filter($row['adh_tel'], "nohtml");
			
			$result = $db->sql_query("INSERT INTO ".$user_prefix."_users (uname, email, pass, user_regdate, user_lang, user_name, user_firstname, umode, adh_entreprise, adh_tel) VALUES ('".$row['username']."', '".$row['user_email']."', '$user_password', '".$row['user_regdate']."', '$language', '".$row['user_name']."', '".$row['user_firstname']."', 'nested', '".$row['adh_entreprise']."', '".$row['adh_tel']."')");
			if (!$result) {
				print_r($db->sql_error());
				die();
			}
			
			$id_user = $db->sql_nextid();
			$sql = "SELECT group_id FROM ".$user_prefix."_users_temp_groups WHERE user_id='".$row['user_id']."'";
			$result2 = $db->sql_query($sql);
			if ($db->sql_numrows($result2) > 0) {
				while(list($id_group) = $db->sql_fetchrow($result2)) {
					$sql = "INSERT INTO ".$user_prefix."_users_groups (user_id, group_id) VALUES ('$id_user', '$id_group');";
					$db->sql_query($sql);
				}
			}
			
			$db->sql_query("DELETE FROM ".$user_prefix."_users_temp WHERE check_num='$check_num'");
			$db->sql_query("DELETE FROM ".$user_prefix."_users_temp_groups WHERE user_id='".$row['user_id']."'");
	
			$row['username'] = str_replace("''", "'",$row['username']);
			$row['user_name'] = str_replace("''", "'",$row['user_name']);
			$row['user_firstname'] = str_replace("''", "'",$row['user_firstname']);
			
			
			$content = str_replace("<!--nom-->", $row['user_name'], _SUBSPRIVATESPACTIVATED);
			$content = str_replace("<!--prenom-->", $row['user_firstname'], $content);
			
			include("header.php");
			echo "<h1>"._SUBPRIVATESPACE."</h1>";
			echo "<p>".nl2br($content)."</p>\n";
			include("footer.php");
		}
	}
	else {
		include("header.php");
		echo "<h1>"._SUBPRIVATESPACE."</h1>";
		echo "<p>"._SUBSPRIVATESPNOTACTIVATED."</p>";
		include("footer.php");
	}
}

function activate_user_general($check_num) {
	global $db, $user_prefix, $module_name, $language, $prefix, $simpleusersgenadminmail;
	$nukeurl = "http://".$_SERVER["HTTP_HOST"].($_SERVER["SERVER_PORT"]!="80" ? ":".$_SERVER["SERVER_PORT"] : "");
	
	$past = time()-86400;
	$db->sql_query("DELETE FROM ".$user_prefix."_users_temp WHERE time < $past");
	$sql = "SELECT * FROM ".$user_prefix."_users_temp WHERE check_num='$check_num' AND user_valid='1'";
	$result = $db->sql_query($sql);
	if ($db->sql_numrows($result) == 1) {
		$row = $db->sql_fetchrow($result);
		if ($row["user_valid"] == "1") {
			$user_password = htmlspecialchars(stripslashes($row['user_password']),ENT_QUOTES,'ISO-8859-1',true);
			$row['username'] = filter($row['username'], "nohtml");
			$row['user_email'] = filter($row['user_email'], "nohtml");
			$row['user_name'] = filter($row['user_name'], "nohtml");
			$row['user_firstname'] = filter($row['user_firstname'], "nohtml");
			$row['adh_entreprise'] = filter($row['adh_entreprise'], "nohtml");
			$row['adh_tel'] = filter($row['adh_tel'], "nohtml");
			$row['user_func'] = filter($row['user_func'], "nohtml");
			$row['adh_adresse'] = filter($row['adh_adresse'], "nohtml");
			$row['adh_web'] = filter($row['adh_web'], "nohtml");
			
			$result = $db->sql_query("INSERT INTO ".$user_prefix."_users (uname, email, pass, user_regdate, user_lang, user_name, user_firstname, umode, adh_entreprise, adh_tel, user_func, adh_adresse, adh_web) VALUES ('".$row['username']."', '".$row['user_email']."', '$user_password', '".$row['user_regdate']."', '$language', '".$row['user_name']."', '".$row['user_firstname']."', 'nested', '".$row['adh_entreprise']."', '".$row['adh_tel']."', '".$row['user_func']."', '".$row['adh_adresse']."', '".$row['adh_web']."')");
			if (!$result) {
				print_r($db->sql_error());
				die();
			}
			
			$id_user = $db->sql_nextid();
			$sql = "SELECT group_id FROM ".$user_prefix."_users_temp_groups WHERE user_id='".$row['user_id']."'";
			$result2 = $db->sql_query($sql);
			if ($db->sql_numrows($result2) > 0) {
				while(list($id_group) = $db->sql_fetchrow($result2)) {
					$sql = "INSERT INTO ".$user_prefix."_users_groups (user_id, group_id) VALUES ('$id_user', '$id_group');";
					$db->sql_query($sql);
				}
			}
			
			$db->sql_query("DELETE FROM ".$user_prefix."_users_temp WHERE check_num='$check_num'");
			$db->sql_query("DELETE FROM ".$user_prefix."_users_temp_groups WHERE user_id='".$row['user_id']."'");
	
			$row['username'] = str_replace("''", "'",$row['username']);
			$row['user_name'] = str_replace("''", "'",$row['user_name']);
			$row['user_firstname'] = str_replace("''", "'",$row['user_firstname']);
			
			
			$content = str_replace("<!--nom-->", $row['user_name'], _SUBSGENACTIVATED);
			$content = str_replace("<!--prenom-->", $row['user_firstname'], $content);
			
			include("header.php");
			echo "<h1>"._SUBGENUSER."</h1>";
			echo "<p>".nl2br($content)."</p>\n";
			include("footer.php");
		}
	}
	else {
		include("header.php");
		echo "<h1>"._SUBGENUSER."</h1>";
		echo "<p>"._SUBSGENNOTACTIVATED."</p>";
		include("footer.php");
	}
}

function unsubscribe_user() {
	global $module_name, $currentlang;
	include("header.php");
	echo "<h1>"._UNSUBSIMPLENEWSLETTER."</h1>";
	echo "<p>".nl2br(_SNLUNSUB)."<br /></p>\n";
	$content = '<script type="text/javascript" src="javascripts/lang/lang-'.$currentlang.'.js"></script>
<script type="text/javascript" src="javascripts/control_form.js"></script>';
	$content .= "<form action=\"modules.php?name=$module_name&op=send_unsubscribe\" onsubmit=\"return submit_form(this)\" method=\"post\">";
	$content .= "<fieldset><legend>"._SUBNLCOORDS."</legend>";
	$content .= '<table cellpadding="0" cellspacing="0" border="0" align="center">';
	$content .= '<tr><td><p>'._SUBNAMEANDFIRST2.'</p></td><td width="20"></td>';
	$content .= "<td><champ lib=\""._SUBNAMEANDFIRST."\" nom=\"nom\" lim=\"1,100\"></champ><input type=\"text\" name=\"nom\" size=\"15\" class=\"zoneSubscribe2\" value=\"\"></td>";
	$content .= "</tr>";
	$content .= '<tr><td><p>'._SUBMAIL2.'</p></td><td width="20"></td>';
	$content .= "<td><champ ctl=\"email\" lib=\""._SUBMAIL."\" nom=\"email\" lim=\"3,100\"></champ><input type=\"text\" name=\"email\" size=\"15\" class=\"zoneSubscribe2\" value=\"\"></td>";
	$content .= "</tr>";
	$content .= '<tr><td colspan="3" align="center">';
	$content .= "<br/><input type=\"submit\" value=\""._SUBSEND."\" name=\"validsub\" id =\"validsub\"><br />";
	$content .= "</td></tr></table>";
	$content .= "</fieldset>";
	$content .= "</form>";
	echo $content;
	include("footer.php");
}

function send_unsubscribe($nom, $email) {
	global $simplenewsletteradminmail;
	$nukeurl = "http://".$_SERVER["HTTP_HOST"].($_SERVER["SERVER_PORT"]!="80" ? ":".$_SERVER["SERVER_PORT"] : "");
	
	$nukeurl = format_nuke_url($nukeurl);
	$viewlink = "$nukeurl/system.php?op=users_newsletter";
	$subject = ""._UNSUBSUBJECT."";
	$message = str_replace("<!--nom-->", $nom, _UNSUBMESSAGE);
	$message = str_replace("<!--email-->", $email, $message);
	$message = str_replace("<!--lien-->", $viewlink, $message);
	$objutil = new utilFuncs_simpleUsers();
	$objutil->send_email($simplenewsletteradminmail, $simplenewsletteradminmail,$subject,$message);
	
	include("header.php");
	echo "<h1>"._UNSUBSIMPLENEWSLETTER."</h1>";
	echo "<p>".nl2br(_UNSUBSENT)."</p>\n";
	include("footer.php");
}

function array_implode( $glue, $separator, $array ) {
    if ( ! is_array( $array ) ) return $array;
    $string = array();
    foreach ( $array as $key => $val ) {
        if ( is_array( $val ) )
            $val = implode( ',', $val );
        $string[] = "{$key}{$glue}{$val}";
       
    }
    return implode( $separator, $string );
   
}

function array_explode( $glue, $separator, $string ) {
	$groupes = explode($separator, $string);
	$sortie = array();
	foreach($groupes as $groupe) {
		list($key, $value) = explode ($glue,$groupe);
		$sortie[$key]=$value;
	}
	return $sortie;
}

function docookie($setuid, $setusername, $setpass, $setstorynum, $setumode, $setuorder, $setthold, $setnoscore, $setublockon, $settheme, $setcommentmax, $groups, $url_perso="") {
	$lesgroupes = array_implode("@",";",$groups);
	$info = base64_encode("$setuid:$setusername:$setpass:$setstorynum:$setumode:$setuorder:$setthold:$setnoscore:$setublockon:$settheme:$setcommentmax:$lesgroupes:$url_perso");
	setcookie("user","$info",time()+2592000);
	//ajout vince pour prise en compte immdiate
	global $user;
	$user = $info;
}
/**
 * TestCookie
 * remove cookie
 */
function undocookie(){
	setcookie ("user", "", time() - 3600);
}

function login_data($username, $user_password, $redirect, $mode, $f, $t, $random_num, $gfx_check) {
	global $setinfo, $user_prefix, $db, $module_name, $pm_login, $prefix,$simpleusersdatahomepage;
	
	$user_password = htmlspecialchars(stripslashes($user_password),ENT_QUOTES,'ISO-8859-1',true);
	include("config.php");
	$sql = "SELECT pass, uid, storynum, umode, uorder, thold, noscore, ublockon, theme, commentmax FROM ".$user_prefix."_users WHERE uname='$username'";
	$result = $db->sql_query($sql);
	$setinfo = $db->sql_fetchrow($result);
	$forward = preg_replace("#redirect=#", "", "$redirect");
	if (preg_match("#privmsg#", $forward)) {
		$pm_login = "active";
	}
	if (($db->sql_numrows($result)==1) AND ($setinfo['uid'] != 1) AND (!empty($setinfo['pass']))) {
		$dbpass=$setinfo['pass'];
		$non_crypt_pass = $user_password;
		$old_crypt_pass = crypt($user_password,substr($dbpass,0,2));
		$new_pass = md5($user_password);
		if (($dbpass == $non_crypt_pass) OR ($dbpass == $old_crypt_pass)) {
			$db->sql_query("UPDATE ".$user_prefix."_users SET pass='$new_pass' WHERE uname='$username'");
			$sql = "SELECT pass FROM ".$user_prefix."_users WHERE uname='$username'";
			$result = $db->sql_query($sql);
			$row = $db->sql_fetchrow($result);
			$dbpass = $row['pass'];
		}
		if ($dbpass != $new_pass) {
			Header("Location: modules.php?name=$module_name&stop=1");
			return;
		}
		$datekey = date("F j");
		$rcode = hexdec(md5($_SERVER['HTTP_USER_AGENT'] . $sitekey . $random_num . $datekey));
		$code = substr($rcode, 2, 6);
		if (extension_loaded("gd") AND $code != $gfx_check AND ($gfx_chk == 2 OR $gfx_chk == 4 OR $gfx_chk == 5 OR $gfx_chk == 7)) {
			Header("Location: modules.php?name=$module_name&stop=1");
			die();
		}
		else {
			docookie($setinfo['uid'], $username, $new_pass, $setinfo['storynum'], $setinfo['umode'], $setinfo['uorder'], $setinfo['thold'], $setinfo['noscore'], $setinfo['ublockon'], $setinfo['theme'], $setinfo['commentmax']);
			$uname = $_SERVER['REMOTE_ADDR'];
			$db->sql_query("DELETE FROM ".$prefix."_session WHERE username='$uname' AND guest='1'");
			$db->sql_query("UPDATE ".$prefix."_users SET last_ip='$uname' WHERE uname='$username'");
		}
		
		include("header.php");
		if ($simpleusersdatahomepage != "") {
			require_once("modules/Sections/connector_class.php");
			$sectmodule = new pageconnector();
			echo  "\n".$sectmodule->getPageContent($simpleusersdatahomepage);
		}
		else {
			echo "<h1>"._SM_TITLESPACE."</h1>";
			echo "<p><br /><br />"._SM_WELCOME."<br /></p>";
		}
		include("footer.php");
	}
	else {
		Header("Location: modules.php?name=$module_name&stop=1");
	}
}

function login_general($username, $user_password) {
	global $setinfo, $user_prefix, $db, $module_name, $pm_login, $prefix,$simpleusersgenhomepage;
	global $withuserabt;
	
	$simpleusersgenhomepagepero = "";
	
	$user_password = htmlspecialchars(stripslashes($user_password),ENT_QUOTES,'ISO-8859-1',true);
	include("config.php");
	$sql = "SELECT pass, uid, storynum, umode, uorder, thold, noscore, ublockon, theme, commentmax, user_url_login, user_master_id FROM ".$user_prefix."_users WHERE uname='$username'";
	$result = $db->sql_query($sql);
	$setinfo = $db->sql_fetchrow($result);
	
	if (($db->sql_numrows($result)==1) AND ($setinfo['uid'] != 1) AND (!empty($setinfo['pass']))) {
		if ($setinfo["user_url_login"] != "") {
			$simpleusersgenhomepagepero = $setinfo["user_url_login"];
		}
		$dbpass=$setinfo['pass'];
		$non_crypt_pass = $user_password;
		$old_crypt_pass = crypt($user_password,substr($dbpass,0,2));
		$new_pass = md5($user_password);
		if (($dbpass == $non_crypt_pass) OR ($dbpass == $old_crypt_pass)) {
			$db->sql_query("UPDATE ".$user_prefix."_users SET pass='$new_pass' WHERE uname='$username'");
			$sql = "SELECT pass FROM ".$user_prefix."_users WHERE uname='$username'";
			$result = $db->sql_query($sql);
			$row = $db->sql_fetchrow($result);
			$dbpass = $row['pass'];
		}
		if ($dbpass != $new_pass) {
			Header("Location: modules.php?name=$module_name&stop=1");
			return;
		}
		$datekey = date("F j");
		$rcode = hexdec(md5($_SERVER['HTTP_USER_AGENT'] . $sitekey . $random_num . $datekey));
		$code = substr($rcode, 2, 6);
		if (extension_loaded("gd") AND $code != $gfx_check AND ($gfx_chk == 2 OR $gfx_chk == 4 OR $gfx_chk == 5 OR $gfx_chk == 7)) {
			Header("Location: modules.php?name=$module_name&stop=1");
			die();
		}
		else {
			/** vrif abonnement avant de valider le login **/
			if ($withuserabt == 1) {
			    if ($setinfo["user_master_id"] != "" && $setinfo["user_master_id"] != "0" ) {
			        $sql = "SELECT `id` FROM `".$user_prefix."_users_abt` WHERE `id_user`=".$setinfo['user_master_id']." AND `du` <= '".date("Y-m-d")."' AND `au` >= '".date("Y-m-d")."';";
			        $result3 = $db->sql_query($sql);
			        if ($db->sql_numrows($result3) == 0) {
			            Header("Location: modules.php?name=$module_name&stop=2");
			            die();
			        }
		        }
		        else {
    				$sql = "SELECT `id` FROM `".$user_prefix."_users_abt` WHERE `id_user`=".$setinfo['uid']." AND `du` <= '".date("Y-m-d")."' AND `au` >= '".date("Y-m-d")."';";
    				$result3 = $db->sql_query($sql);
    				if ($db->sql_numrows($result3) == 0) {
    					Header("Location: modules.php?name=$module_name&stop=2");
    					die();
    				}
		        }
			}
			
			$sql = "SELECT ".$user_prefix."_groups.id, ".$user_prefix."_groups.name FROM ".$user_prefix."_groups inner join ".$user_prefix."_users_groups on group_id=".$user_prefix."_groups.id WHERE user_id='".$setinfo['uid']."'";
			$result2 = $db->sql_query($sql);
			if ($db->sql_numrows($result2)) {
				$lesgroupes = array();
				while ($ligne = $db->sql_fetchrow($result2)) {
					$lesgroupes[$ligne["id"]] = $ligne["name"];
				}
				$setinfo['groups'] = $lesgroupes;
			}
			else {
				$setinfo['groups'] = array();
			}
			docookie($setinfo['uid'], $username, $new_pass, $setinfo['storynum'], $setinfo['umode'], $setinfo['uorder'], $setinfo['thold'], $setinfo['noscore'], $setinfo['ublockon'], $setinfo['theme'], $setinfo['commentmax'], $setinfo['groups'], $simpleusersgenhomepagepero);
			$uname = $_SERVER['REMOTE_ADDR'];
			$db->sql_query("DELETE FROM ".$prefix."_session WHERE username='$uname' AND guest='1'");
			$db->sql_query("UPDATE ".$prefix."_users SET last_ip='$uname' WHERE uname='$username'");
		}
		
		
		if ($simpleusersgenhomepagepero != "") {
			global $mmg;
			$menuid = "";
			if ($mmg != "" && strpos($simpleusersgenhomepagepero, ".php")) {
				if (strpos($simpleusersgenhomepagepero, "?")) {
					$menuid = "&";
				}
				else {
					$menuid = "?";
				}
				$menuid .= "mmg=".$mmg;
			}
			header("Location: ".$simpleusersgenhomepagepero.$menuid);
			die();
		}
		else {
			include("header.php");
			if ($simpleusersgenhomepage != "") {
				require_once("modules/Sections/connector_class.php");
				$sectmodule = new pageconnector();
				echo  "\n".$sectmodule->getPageContent($simpleusersgenhomepage);
			}
			else {
				echo "<h1>"._SM_TITLESPACE."</h1>";
				echo "<p><br /><br />"._SM_WELCOME."<br /></p>";
			}
			include("footer.php");
		}
	}
	else {
		Header("Location: modules.php?name=$module_name&stop=1");
	}
}

function main($user,$force=0) {
	global $stop, $module_name, $redirect, $mode, $t, $f, $gfx_chk, $simpleusersgenhomepage;
	global $bypass,$hid,$url,$mmg;
	if(!is_user($user)) {
		include("header.php");
		echo '<div id="bloc_repere_fond">';
		echo "<h1>"._USERIDENT."</h1>";
		if ($stop == 1) {
			echo "<p style=\"text-align: center\"><br /><b>"._LOGININCOR."</b></p>";
		}
		elseif ($stop == 2) {
			echo "<p style=\"text-align: center\"><br /><b>".'Votre abonnement est expir. Veuillez le renouveler SVP.'."</b></p>";
		}
		else {
			echo "<p style=\"text-align: center\"><br /><b>"._USERREGLOGIN."</b></p>";
		}
		echo "<br /><br />";
		if (!is_user($user)) {
			//OpenTable();
			mt_srand ((double)microtime()*1000000);
			$maxran = 1000000;
			$random_num = mt_rand(0, $maxran);

			echo "<fieldset class=\"loginuser\"><legend>"._USERLOGIN."</legend>"
			."<form action=\"modules.php?name=$module_name\" method=\"post\">\n"
			."<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" align=\"center\">"
			."<tr align=center><td valign=\"top\"><!--<img src=\"images/security.png\">--></td>"
			."<td>"
			."<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"tabform\"> "
			."<tr><td class=\"label\"><p>"._NICKNAME."</p></td>"
			."<td width=\"10\"></td>"
			."<td><input type=\"text\" NAME=\"username\" SIZE=\"20\" class=\"zoneSubscribe2\"></td></tr>"
			."<tr><td class=\"label\"><p>"._PASSWORD."</p></td>"
			."<td width=\"10\"></td>"
			."<td><input type=\"password\" NAME=\"user_password\" SIZE=\"20\" class=\"zoneSubscribe2\"></td></tr>";
			echo "<tr><td style=\"text-align: center\" colspan=\"3\">"
			."<input type=\"hidden\" name=\"redirect\" value=\"$redirect\">\n"
			."<input type=\"hidden\" name=\"mode\" value=$mode>\n"
			."<input type=\"hidden\" name=\"f\" value=$f>\n"
			."<input type=\"hidden\" name=\"t\" value=$t>\n"
			//."<input type=\"hidden\" name=\"op\" value=\"logindata\">\n"
			."<input type=\"hidden\" name=\"op\" value=\"logingen\"><input type=\"hidden\" name=\"mmg\" value=\"".$mmg."\"> \n"
			."<br /><input type=\"submit\" value=\""._LOGIN."\" id=\"validbtnloguser\"> "
			."</td></tr></table>"
			."</td></tr></table>"
			."</form>";
			echo "<p>&nbsp</p>";
			echo "<p style=\"text-align: center\" id=\"act_passwd_lost\"><a href=\"modules.php?name=$module_name&op=pass_lost\">"._PASSWORDLOST."</a></p>\n";
			echo "<p style=\"text-align: center\" id=\"act_new_account\"><a href=\"modules.php?name=$module_name&op=submitusergen\">"._NEWUSERACCOUNT."</a></p>\n";
			echo "</fieldset>";
			echo "<br />";
			
			//CloseTable();
		}
		echo '</div>';
		include("footer.php");
	}
	elseif (is_user($user)) {
		if ($simpleusersgenhomepage != "") {
			/*require_once("modules/Sections/connector_class.php");
			$sectmodule = new pageconnector();
			echo  "\n".$sectmodule->getPageContent($simpleusersgenhomepage);*/
			//Header("Location: modules.php?name=Sections&sop=viewarticle&artid=".$simpleusersgenhomepage);
			Header("Location: Adherent_page_".$simpleusersgenhomepage.".htm");
		}
		else {
			Header("Location: index.php");
		}
	}
}

function logout() {
	global $prefix, $db, $user, $cookie, $redirect;
	cookiedecode($user);
	$r_uid = $cookie[0];
	$r_username = $cookie[1];
	setcookie("user", false);
	$db->sql_query("DELETE FROM ".$prefix."_session WHERE username='$r_username'");
	$user = "";
	undocookie();
	include("header.php");
	if (!empty($redirect)) {
		echo "<META HTTP-EQUIV=\"refresh\" content=\"3;URL=modules.php?name=$redirect\">";
	} else {
		echo "<META HTTP-EQUIV=\"refresh\" content=\"3;URL=index.php\">";
	}
	echo "<h1>"._USERIDENT."</h1>";
	echo "<p style=\"text-align: center\"><br /><b>"._YOUARELOGGEDOUT."</b></p>\n";
	include("footer.php");
}

function pass_lost() {
	global $user, $module_name;
	global $bypass,$hid,$url;
	if (!is_user($user)) {
		include("header.php");
		echo '<div id="bloc_repere_fond">';
		echo "<h1>"._USERIDENT."</h1>";
		echo "<p style=\"text-align: center\"><br /><b>"._USERREGLOGIN."</b></p>\n";
		echo "<br /><br />\n";
		echo "<fieldset class=\"loginuser\"><legend>"._USERLOGINPARAM."</legend>"
		."<p>"._NOPROBLEM."</p>\n"
		."<form action=\"modules.php?name=$module_name\" method=\"post\">\n"
		."<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" align=\"center\" class=\"tabform\"><tr><td><p>"
		.""._MYPSEUDO."</p></td><td width=\"10\"></td><td><input type=\"text\" name=\"username\" size=\"15\" class=\"zoneSubscribe2\"></td></tr>\n"
		."<tr><td><p>"._MYEMAIL."</p></td><td width=\"10\"></td><td><input type=\"text\" name=\"usermail\" size=\"15\" class=\"zoneSubscribe2\"></td></tr>"
		."<tr><td colspan=\"3\" style=\"text-align: center\"><br /><input type=\"submit\" value=\""._SENDPASSWORD."\" id=\"validbtnloguser\"></td></tr>"
		."</table><br>\n"
		."<input type=\"hidden\" name=\"op\" value=\"mailpasswd\">\n"
		."</form>\n"
		//."<p style=\"text-align: center\"><a href=\"modules.php?name=$module_name\">"._USERLOGINNOW."</a></p>"
		."</fieldset>"
		."<br />";
		echo '</div>';
		include("footer.php");
	}
	elseif(is_user($user)) {
		global $cookie;
		cookiedecode($user);
		userinfo($cookie[1],$bypass,$hid,$url);
	}
}

function mail_password($username, $usermail) {
	global $sitename, $adminmail, $nukeurl, $user_prefix, $db, $module_name;
	$username = filter($username, "nohtml", 1);
	$username = substr($username, 0, 25);
	$username = htmlspecialchars($username,ENT_QUOTES,'ISO-8859-1',true);
	$sql = "SELECT uid, uname,email  FROM ".$user_prefix."_users WHERE uname='$username' AND email='$usermail'";
	$result = $db->sql_query($sql);
	if($db->sql_numrows($result) != 0) {
		//ok
		if (list($uid, $uname,$email) = $db->sql_fetchrow($result)) {
			$new_pass = substr(md5(time()),-8);
			$sql = "UPDATE ".$user_prefix."_users SET pass='".md5($new_pass)."' WHERE uid='$uid'";
			if ($db->sql_query($sql)) {
				//email utilisateur
				$message = _SMEMBERSNEWPASSBODY;
				$message = str_replace("<!--login-->", $uname,$message);
				$message = str_replace("<!--passwd-->", $new_pass,$message);
				utilFuncs_simpleUsers::send_email($email,$adminmail,_SMEMBERSNEWPASSSUB,$message);
				//affichage ok
				include("header.php");
				echo '<div id="bloc_repere_fond">';
				echo "<h1>"._USERIDENT."</h1>";
				echo "<p><br />"._SMEMBERSNEWPASSSENT."</p>\n";
				echo "<br /><br />";
				echo '</div>';
				include ("footer.php");
			}
		}
	}
	else {
		//pas ok
		include("header.php");
		echo '<div id="bloc_repere_fond">';
		echo "<h1>"._USERIDENT."</h1>";
		echo "<p><br />"._SMEMBERSNEWPASSNOTSENT."</p>\n";
		echo "<br /><br />";
		echo '</div>';
		include("footer.php");
	}
}

/**
 * Fonction permettant d'enregistrer un telephone
 * @param unknown $deviceid l'id du telephone
 * @param unknown $registerid l'id d'enregistrement
 * @param unknown $nameos le nom de l'os
 */
function registerPhone($deviceid, $registerid, $nameos) {
	global $db, $user_prefix;

	if( $deviceid != "" && $registerid != "" && $nameos != "" ) {
		$nameos = utilFuncs_simpleUsers::conditionnertodb($nameos);
		$nameos = mb_strtolower($nameos);

		$sql = "select id_tel from ".$user_prefix."_users_push where id_tel='".$deviceid."'";
		$result = $db->sql_query($sql);

		if( $db->sql_numrows($result) == 0 ) {
			$sql = "insert into becms_users_push (id_user, id_tel, id_register, os)
				values('-1', '".$deviceid."', '".$registerid."', '".$nameos."')";
		} else {
			$sql = "update ".$user_prefix."_users_push set id_register='".$registerid."' where id_tel='".$deviceid."'";
		}
		if( $db->sql_query($sql) ) {
			echo "ok";
		}
	}
}

function unregisterPhone($deviceid) {
	global $db, $user_prefix;

	if( $deviceid != "" ) {

		$sql = "Delete from ".$user_prefix."_users_push where id_tel='".$deviceid."';";

		if( $db->sql_query($sql) ) {
			echo "ok";
		}
	}
}

if (!isset($hid)) { $hid = ""; }
if (!isset($url)) { $url = ""; }
if (!isset($bypass)) { $bypass = ""; }
if ( isset($groups) && count($groups) > 0) {
	$thegroups = join(",",$groups);
}

// -------------------------------- SWITCH PART --------------------------------
switch($op) {
	case "submituser" :
		submit_new_user($nom, $prenom, $email, $ville);
		break;
	case "submituserodarc" :
		submit_new_userodarc($nom, $prenom, $email, $ville, $filiere, $categorie, $autre);
		break;
	case "submituserdata" :
		submit_new_user_data($nom, $prenom, $email,$username, $user_password);
		break;
	case "submituserprivate" :
		submit_new_user_private($nom, $prenom, $email,$username, $user_password, $adh_entreprise, $adh_tel, $groups);
		break;
	case "submitusergen" :
		submit_new_user_general($nom, $prenom, $email,$username, $user_password, $adh_entreprise, $adh_tel, $user_func, $adh_adresse, $adh_web, $thegroups);
		break;
	case "unsubscribe" :
		unsubscribe_user();
		break;
	case "send_unsubscribe":
		send_unsubscribe($nom, $email);
		break;
	case "activate" :
		activate_user($check_num);
		break;
	case "activatedata" :
		activate_user_data($check_num);
		break;
	case "activateprivatesp":
		activate_user_privatesp($check_num);		
		break;
	case "activateusergen":
		activate_user_general($check_num);		
		break;
	case "logindata":
		login_data($username, $user_password, $redirect, $mode, $f, $t, $random_num, $gfx_check);
		break;
	case "logingen":	
		login_general($username, $user_password);
		break;
	case "logout":
		logout();
		break;
	case "pass_lost":
		pass_lost();
		break;
	case "mailpasswd":
		mail_password($username, $usermail);
		break;
	case "registerPhone":
		registerPhone($deviceid, $registerid, $nameos);
		break;
	case "unregisterPhone":
		unregisterPhone($deviceid);
		break;
	default:
		main($user,$force=0);
		break;

}

?>