<?php

/************************************************************************/
/* BALISTE ECMS                                                         */
/* ===========================                                          */
/* Copyright (c) 2004 by Stephan Acquatella (stephan@balistis.com)      */
/* http://www.baliste.org                                               */
/*                                                                      */
/* Enhanced with PHP-NUKE                                               */
/* =======================                                              */
/* Copyright (c) 2002 by Francisco Burzi (fbc@mandrakesoft.com)         */
/* http://phpnuke.org                                                   */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

if (!preg_match("#system.php#i", $_SERVER['PHP_SELF'])) { die ("Access Denied"); }

if (checkModuleRight($module_name)) {
setPath(_TXT_User,0);
setPath(_EDITUSERS,1);

//require_once("modules/$module_name/lib_db.php");
require_once("modules/$module_name/utils.php");
require_once("modules/$module_name/language/lang-".$currentlang.".php");
require_once("core/becms_ui_component.php");

function list_index($nbreFiches, $page, $ligne_par_page,$letter,$url) {
	global $sortby, $selectgroup;
		$nboites = 5;
		$letterurl = ($letter != "" ) ? "&letter=".$letter : ""; 
		$sortbyurl = ($sortby != "") ? "&sortby=".$sortby :  "";
		$selectgroupurl = ($selectgroup != "" ) ? "&selectgroup=".$selectgroup : "";
		$liminf = $page - floor($nboites/2);
		$limsup = $page + floor($nboites/2);
		if ($liminf < 1) {
			$liminf = 1;
			$limsup = $nboites;
			if ($limsup > ceil($nbreFiches/$ligne_par_page)) {
				$limsup = ceil($nbreFiches/$ligne_par_page);
			}
		}
		if ($limsup > ceil($nbreFiches/$ligne_par_page)) {
			$limsup = ceil($nbreFiches/$ligne_par_page);
			$liminf = $limsup - $nboites;
			if ($liminf < 1) {
				$liminf = 1;
			}
		}
		$min = 1;
		$max = ceil($nbreFiches/$ligne_par_page);


		$repParPage = $ligne_par_page;
		$p = $page;
		$nbrepages = ceil($nbreFiches/$repParPage);
		if ($p>$nbrepages) {
			$p = $nbrepages;
		}
		$indexPages .= "<div class=\"pages\">";
		if ($nbreFiches != 0) {
			$indexPages .= $nbreFiches._SNLUSERSFOUND."\"".$letter."\"";
			$indexPages .= _SNLUSERSPAGES;
			if ($min < $liminf) {
				if ($min == $p ) {
					$indexPages .= "<div class=\"pagevide\">";
					$indexPages .= "$min";
					$indexPages .= "</div>";
				}
				else {
					$indexPages .= "<div class=\"page\">";
					$indexPages .= "<a href=\"$url&page=$min".$selectgroupurl.$sortbyurl.$letterurl."\">$min</a>";
					$indexPages .= "</div>";
				}
				if ($min < $liminf - 1) {
					$indexPages .= "...";
				}
			}
			for ($i=$liminf;$i<=$limsup;$i++) {
				if ($i == $p ) {
					$indexPages .= "<div class=\"pagevide\">";
					$indexPages .= "$i";
					$indexPages .= "</div>";
				}
				else {
					$indexPages .= "<div class=\"page\">";
					$indexPages .= "<a href=\"$url&page=$i".$selectgroupurl.$sortbyurl.$letterurl."\">$i</a>";
					$indexPages .= "</div>";
				}
			}
			if ($max > $limsup) {
				if ($max > $limsup + 1) {
					$indexPages .= "...";
				}
				if ($max == $p ) {
					$indexPages .= "<div class=\"pagevide\">";
					$indexPages .= "$max";
					$indexPages .= "</div>";
				}
				else {
					$indexPages .= "<div class=\"page\">";
					$indexPages .= "<a href=\"$url&page=$max".$selectgroupurl.$sortbyurl.$letterurl."\">$max</a>";
					$indexPages .= "</div>";
				}

			}
		}
		else {
			$indexPages .= _SNLUSERSNOTFOUND;
		}
		$indexPages .= "</div>";
		return $indexPages;
	}

/**
 * userList()
 *
 *
 *
 */
function list_users_gen($letter, $sortby, $page, $onglet, $selectgroup, $kw="", $rub=""){
	global $user_prefix,$prefix, $db, $ongletDef, $admin, $user, $action, $op;
	global $withuserabt;
	
	$result3 = $db->sql_query("SELECT * FROM ".$user_prefix."_groups ORDER BY name ASC");
	$menugroup = "";
	if ($db->sql_numrows($result3) != 0) {
		$menugroup = '<select size="1" name="selectgroup" onchange="this.form.submit()">';
		$menugroup .= '<option value="">'._SNLUSERSLISTEFILTERGROUP."</option>";
		while ($ligneencours = $db->sql_fetchrow($result3)) {
			$selected = ($selectgroup == $ligneencours["id"]) ? " selected=\"selected\"" : "";
			$menugroup .= '<option value="'.$ligneencours["id"].'"'.$selected.'>'.$ligneencours["name"]."</option>";
		}
		$menugroup .= "</select>";
	}
	
	$pagesize = 20;

	$resultbuff=$db->sql_query("select uid from ".$user_prefix."_users");
	if (!$resultbuff) {
		print_r($db->sql_error());
		die('Invalid query:');
	}
	$numrows = $db->sql_numrows($resultbuff);

	$min = $pagesize * ($page - 1); // This is where we start our record set from
	$max = $pagesize; // This is how many rows to select
	
	$rub_lim_abt = "";
	if ($withuserabt) {
		$rub_lim_abt = ', max(abt.au) as maxabt, max(abt2.au) as maxabt2';
	}
	
	$count = "SELECT COUNT(DISTINCT uid) AS total FROM ".$user_prefix."_users "; // Count all the users in the db..
	//$select = "SELECT uid, uname, email, user_name, user_firstname, user_tel, user_filiere, user_categorie, ".$user_prefix."_groups.name as groupe  from ".$user_prefix."_users left join ".$user_prefix."_groups ON ".$user_prefix."_users.user_group=".$user_prefix."_groups.id "; //select our data
	$select = "SELECT uid, uname, email, user_name, user_firstname, adh_tel$rub_lim_abt from ".$user_prefix."_users "; //select our data
	$where = " WHERE uname <> 'Anonymous'";
	if (( $letter != "Other" ) AND ( $letter != "All" ) ) {
		$where .= "AND uname like '".$letter."%'";
	} 
	else if ( ( $letter == "Other" ) AND ( $letter != "All" ) ) {
		$where .= "AND uname REGEXP \"^\[1-9]\"";
	} 
	else {
		$where .= "";
	}
	$join = "";
	if ($selectgroup != "") {
		$join .= " left join ".$user_prefix."_users_groups ON ".$user_prefix."_users.uid=".$user_prefix."_users_groups.user_id ";
		$where .= ($where =="") ? " WHERE " : " AND ";
		$where .= $user_prefix."_users_groups.group_id='".$selectgroup."'";
	}
	if ($kw != "") {
		$kwdb = str_replace("'", "''", trim($kw));
		$where .= ($where =="") ? " WHERE " : " AND ";
		if ($rub =="") {
			$where .= '('.$user_prefix."_users.uname LIKE '%".$kwdb."%'" . "||" . $user_prefix."_users.user_name LIKE '%".$kwdb."%'" . "||" . $user_prefix."_users.user_firstname LIKE '%".$kwdb."%'" . "||" . $user_prefix."_users.email LIKE '%".$kwdb."%'" . "||" . $user_prefix."_users.adh_entreprise LIKE '%".$kwdb."%'" .")";
		}
		else {
			$where .= '('.$user_prefix."_users.$rub LIKE '%".$kwdb."%'".")";
		}
	}
	$groupby = "";
	if ($withuserabt) {
		$join .= " left join ".$user_prefix."_users_abt as abt ON ".$user_prefix."_users.uid=abt.id_user ";
		$join .= " left join ".$user_prefix."_users_abt as abt2 ON ".$user_prefix."_users.user_master_id=abt2.id_user ";
		$groupby .= " group by uid ";
	}
	if ($sortby == "") {
		$sortby = "uname";
	}
	$sort = " ORDER BY $sortby ASC";
	$limit = " LIMIT ".$min.", ".$max;

	$count_result = $db->sql_query($count.$join.$where);
	if (!$count_result) {
		print_r($db->sql_error());
		die('Invalid query:');
	}
	list($num_rows_per_order) = $db->sql_fetchrow($count_result);
	
	$valrubs = array("dans le nom"=>"user_name", "dans le prnom"=>"user_firstname", "dans l'entreprise"=>"adh_entreprise", "dans l'e-mail"=>"email", "dans le pseudo"=>"uname");
	$menurub = "";
	$menurub ='<select size="1" name="rub">';
	$menurub .= '<option value="">dans toutes les rubriques</option>';
	foreach ($valrubs as $key=>$value) {
		$selected = ($value == $rub) ? " selected=\"selected\"" : "";
		$menurub .= '<option value="'.$value.'"'.$selected.'>'.$key."</option>";
	}
	$menurub .='</select>';
	
	if ($action != "list_usersno") {
		$action = "list_users";
	}
	
	$sortie = '<table border="0" cellpadding="0" cellspacing="0" align="center"><tr><td>';
	$paramplus = "";
	if ($selectgroup != "") {
		$paramplus.= "&selectgroup=".$selectgroup;
	}
	if ($kw != "") {
		$paramplus.= "&kw=".urlencode(utf8_encode($kw))."&rub=".$rub;
	}
	$sortie .= list_index($num_rows_per_order,$page,$pagesize,$letter,"system.php?op=users_general&action=list_users".$paramplus);
	$sortie .= '</td><td width="30">&nbsp;</td><td>';
	$sortie .= '<form name="formgroup" action="system.php" method="POST">';
	$sortie .= '<input type="hidden" name="letter" value="'.$letter.'">';
	$sortie .= '<input type="hidden" name="sortby" value="'.$sortby.'">';
	//$sortie .= '<input type="hidden" name="page" value="'.$page.'">';
	$sortie .= '<input type="hidden" name="onglet" value="'.$onglet.'">';
	//$sortie .= '<input type="hidden" name="op" value="'.$op.'">';
	$sortie .= '<input type="hidden" name="op" value="users_general">';
	$sortie .= '<input type="hidden" name="action" value="'.$action.'">';
	$sortie .= '<input type="text" name="kw" value="'.$kw.'" placeholder="recherche textuelle">';
	$sortie .= '&nbsp;';
	$sortie .= $menurub;
	$sortie .= '&nbsp;';
	$sortie .= '<input name="validsearch" value="Go" type="submit">';
	$sortie .= '&nbsp;&nbsp;&nbsp;&nbsp;';
	$sortie .= '&nbsp;&nbsp;&nbsp;&nbsp;';
	$sortie .= '&nbsp;&nbsp;&nbsp;&nbsp;';
	$sortie .= $menugroup;
	$sortie .= "</form>";
	$sortie .= '</td><td width="30">&nbsp;</td><td>';
	$sortie .= alpha($sortby,$onglet,$action,$selectgroup,$kw,$rub);
	$sortie .= '</td></tr></table>';

	$result = $db->sql_query($select.$join.$where.$groupby.$sort.$limit); // Now lets do it !!
	if (!$result) {
	    echo $select.$join.$where.$groupby.$sort.$limit;
		print_r($db->sql_error());
		die('Invalid query:');
	}

	$sortie .= "<table class=\"lisTable\"><tr class=\"systemTabHeader\">\n";
	$sortie .= "<td class=\"systemTabHeader\">"._SNLLISTPSEUDO." ".SortLinks($letter,$sortby,"uname")."</td>\n";
	$sortie .= "<td class=\"systemTabHeader\">"._SNLLISTNOM." ".SortLinks($letter,$sortby,"user_name")."</td>\n";
	$sortie .= "<td class=\"systemTabHeader\">"._SNLLISTMAIL."</td>\n";
	$sortie .= "<td class=\"systemTabHeader\">"._SNLLISTTEL."</td>\n";
	//$sortie .= "<td class=\"systemTabHeader\">"._SNLLISTGROUP." ".SortLinks($letter,$sortby,"user_group")."</td>\n";
	$sortie .= "<td class=\"systemTabHeader\">"._SNLLISTGROUP."</td>\n";
	if ($withuserabt) {
		$sortie .= "<td class=\"systemTabHeader\">Date validit</td>\n";
	}
	$sortie .= "<td class=\"systemTabHeader\">"._FUNCTIONS."</font></td>\n";
	$sortie .= "</tr>";
	$a = 0;
	$dcolor_A = "$bgcolor2";
	$dcolor_B = "$bgcolor1";

	if (($result)){
		$num_users = $db->sql_numrows($result); 
	} 
	else {
		$num_users=0;
	}

	if ( $num_rows_per_order > 0  ) {
		$pos=0;
		while($user = $db->sql_fetchrow($result)) {
			if ($pos % 2 == 0){
				$thestyle="listTableOdd";
			} 
			else {
				$thestyle="listTableNone";
			}
			$result2 = $db->sql_query("SELECT name FROM ".$user_prefix."_groups JOIN ".$user_prefix."_users_groups ON ".$user_prefix."_users_groups.group_id=".$user_prefix."_groups.id WHERE ".$user_prefix."_users_groups.user_id='".$user["uid"]."'");
			$groupes = "";
			if ($db->sql_numrows($result2)>0) {
				while ($legroupe = $db->sql_fetchrow($result2)) {
					$groupes .= ($groupes != "") ? ", " : "";
					$groupes .= $legroupe["name"];
				}
			}
			$dcolor = ($a == 0 ? $dcolor_A : $dcolor_B);
			$sortie .= "<tr class=\"$thestyle\">";
			$sortie .= "<td >&nbsp;&nbsp;&nbsp;&nbsp;<b>$user[uname]</b></td>\n";
			$sortie .= "<td ><b>$user[user_name] $user[user_firstname]</b></td>\n";
			$sortie .= "<td><a href=\"mailto:".$user["email"]."\">$user[email]</a></td>\n";
			$sortie .= "<td>$user[adh_tel]</td>\n";
			//$sortie .= "<td >$user[groupe]</td>\n";
			$sortie .= "<td >$groupes</td>\n";
			if ($withuserabt) {
			    $sortie .= "<td >".max(array($user[maxabt], $user[maxabt2]))."</td>\n";
			}
			$barDef=array(
				"edit"=> array( "text"=>_EDIT,"icon"=>"edit_16x16.png","url"=>"system.php?op=users_general&action=edit_user&Id=$user[uid]&letter=".$letter."&onglet=".$onglet."&sortby=".$sortby."&page=".$page.$paramplus,"comment"=>_EDIT, "status"=>"ON"),
				"delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png","url"=>"system.php?op=users_general&action=delete_user&Id=$user[uid]&letter=".$letter."&onglet=".$onglet."&sortby=".$sortby."&page=".$page.$paramplus,"comment"=>_DELETE,"status"=>"ON"));
			$sortie .= "<td>";
			$sortie .= displayActionBar("add","Bar d'action",$barDef,"img","",true);
			$sortie .= "</td>";	
			$sortie .= "</tr>";
			$a = ($dcolor == $dcolor_A ? 1 : 0);
			$pos++;
		}
	}
	$sortie .= "\n</table>";
	$sortie .= '<a href="system.php?op=users_general&action=new_user">'._SNLUSERSLISTEADD.'</a>';
	$sortie .= '<br><a href="system.php?op=users_general&action=usersToExcel">'._SNLUSERSLISTEEXPORTXLS.'</a>';
	return $sortie;
}

function list_users_gen_no($letter, $sortby, $page, $onglet){
	global $user_prefix,$prefix, $db, $ongletDef, $admin, $user, $action;
	
	$pagesize = 20;

	$min = $pagesize * ($page - 1); // This is where we start our record set from
	$max = $pagesize; // This is how many rows to select

	$count = "SELECT COUNT(user_id) AS total FROM ".$user_prefix."_users_temp "; // Count all the users in the db..
	$select = "SELECT user_id, username, user_email, user_name, user_firstname, user_valid from ".$user_prefix."_users_temp";
	//$where = " WHERE user_valid = '0'";
	$where = "";
	if (( $letter != "Other" ) AND ( $letter != "All" ) ) {
		$where .= ($where == "") ? " WHERE " : " AND ";
		$where .= "username like '".$letter."%'";
	} 
	else if ( ( $letter == "Other" ) AND ( $letter != "All" ) ) {
		$where .= ($where == "") ? " WHERE " : " AND ";
		$where .= "username REGEXP \"^\[1-9]\"";
	} 
	else {
		$where .= "";
	}
	if ($sortby == "") {
		$sortby = "username";
	}
	$sort = " ORDER BY $sortby ASC";
	$limit = " LIMIT ".$min.", ".$max;
	$count_result = $db->sql_query($count.$where);
	if (!$count_result) {
		print_r($db->sql_error());
		die('Invalid query:');
	}
	list($num_rows_per_order) = $db->sql_fetchrow($count_result);
	
	$sortie = '<table border="0" cellpadding="0" cellspacing="0" align="center"><tr><td>';
	$sortie .= list_index($num_rows_per_order,$page,$pagesize,$letter,"system.php?action=list_usersno&op=users_general&onglet=users_notvalid");
	$sortie .= '</td><td width="50">&nbsp;</td><td>';
	$sortie .= alpha($sortby,$onglet,"list_usersno");
	$sortie .= '</td></tr></table>';
	$result = $db->sql_query($select.$where.$sort.$limit); // Now lets do it !!
	if (!$result) {
		echo $select.$where.$sort.$limit;
		print_r($db->sql_error());
		die('Invalid query:');
	}

	$sortie .= "<table class=\"lisTable\"><tr class=\"systemTabHeader\">\n";
	$sortie .= "<td class=\"systemTabHeader\">"._SNLLISTPSEUDO." ".SortLinks($letter,$sortby,"username")."</td>\n";
	$sortie .= "<td class=\"systemTabHeader\">"._SNLLISTNOM." ".SortLinks($letter,$sortby,"user_name")."</td>\n";
	$sortie .= "<td class=\"systemTabHeader\">"._SNLLISTMAIL."</td>\n";
	$sortie .= "<td class=\"systemTabHeader\">"._SNLLISTGROUP."</td>\n";
	$sortie .= "<td class=\"systemTabHeader\">"._SNLLISTSTATUS."</td>\n";
	$sortie .= "<td class=\"systemTabHeader\">"._FUNCTIONS."</font></td>\n";
	$sortie .= "</tr>";
	$a = 0;
	$dcolor_A = "$bgcolor2";
	$dcolor_B = "$bgcolor1";

	if (($result)){
		$num_users = $db->sql_numrows($result); 
	} 
	else {
		$num_users=0;
	}

	if ( $num_rows_per_order > 0  ) {
		$pos=0;
		while($user = $db->sql_fetchrow($result)) {
			if ($pos % 2 == 0){
				$thestyle="listTableOdd";
			} 
			else {
				$thestyle="listTableNone";
			}
			$result2 = $db->sql_query("SELECT name FROM ".$user_prefix."_groups JOIN ".$user_prefix."_users_temp_groups ON ".$user_prefix."_users_temp_groups.group_id=".$user_prefix."_groups.id WHERE ".$user_prefix."_users_temp_groups.user_id='".$user["user_id"]."'");
			$groupes = "";
			if ($db->sql_numrows($result2)>0) {
				while ($legroupe = $db->sql_fetchrow($result2)) {
					$groupes .= ($groupes != "") ? ", " : "";
					$groupes .= $legroupe["name"];
				}
			}
			$status = ($user["user_valid"] == "1") ? _SNLLISTSTATUSOK : "<b>"._SNLLISTSTATUSPASOK."</b>";
			$dcolor = ($a == 0 ? $dcolor_A : $dcolor_B);
			$sortie .= "<tr class=\"$thestyle\">";
			$sortie .= "<td >&nbsp;&nbsp;&nbsp;&nbsp;<b>$user[username]</b></td>\n";
			$sortie .= "<td ><b>$user[user_name] $user[user_firstname]</b></td>\n";
			$sortie .= "<td><a href=\"mailto:".$user["user_email"]."\">$user[user_email]</a></td>\n";
			$sortie .= "<td >$groupes</td>\n";
			$sortie .= "<td >$status</td>\n";
			$barDef=array(
				"edit"=> array( "text"=>_EDIT,"icon"=>"edit_16x16.png","url"=>"system.php?op=users_general&action=edit_user_no&Id=$user[user_id]&letter=".$letter."&onglet=".$onglet."&sortby=".$sortby."&page=".$page,"comment"=>_EDIT, "status"=>"ON"),
				"delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png","url"=>"system.php?op=users_general&action=delete_userno&Id=$user[user_id]&letter=".$letter."&onglet=".$onglet."&sortby=".$sortby."&page=".$page,"comment"=>_DELETE,"status"=>"ON"));
			$sortie .= "<td>";
			$sortie .= displayActionBar("add","Bar d'action",$barDef,"img","",true);
			$sortie .= "</td>";	
			$sortie .= "</tr>";
			$a = ($dcolor == $dcolor_A ? 1 : 0);
			$pos++;
		}
	}
	$sortie .= "\n</table>";
	//$sortie .= '<a href="system.php?op=users_data&action=new_user">'._SNLUSERSLISTEADD.'</a>';
	return $sortie;
}

function edit_abt($Id,$id_user) {
	global $module_name, $db, $user_prefix, $aid, $admin,$header_system;

	$where = "";
	if ($Id != "" && $Id!="-1" && $Id!="0") {
		$sql = "SELECT `id`, `id_user`, `du` , `au` , `montant` , `le` , `message30` , `message15` , `message3`, `details` FROM `".$user_prefix."_users_abt` WHERE id='".$Id."';";
		$result = $db->sql_query($sql);
		if ($db->sql_numrows($result) != 0) {
			$unabt = $db->sql_fetchrow($result);
		}
	}
	else {
		$unabt = array(
			"id" => "-1",
			"id_user" => $id_user,
			"du" => "0000-00-00 00:00:00",
			"au" => "0000-00-00 00:00:00",
			"montant" => "",
			"le" => date("Y-m-d H:i:s"),
			"details" =>"",
			"message30" => "0",
			"message15" => "0",
			"message3" => "0"
		);
	}

	$mess30 = '<input type="checkbox" name="message30" value="" '.(($unabt["message30"]=="1") ? 'checked="checked"' : '').' onchange="if (this.checked) {this.form.elements[\'abt[message30]\'].value=\'1\'} else {this.form.elements[\'abt[message30]\'].value=\'0\'}" /><input type="hidden" name="abt[message30]" value="'.$unabt["message30"].'" />';
	$mess15 .= '<input type="checkbox" name="message15" value="" '.(($unabt["message15"]=="1") ? 'checked="checked"' : '').' onchange="if (this.checked) {this.form.elements[\'abt[message15]\'].value=\'1\'} else {this.form.elements[\'abt[message15]\'].value=\'0\'}" /><input type="hidden" name="abt[message15]" value="'.$unabt["message15"].'" />';
	$mess3 .= '<input type="checkbox" name="message3" value="" '.(($unabt["message3"]=="1") ? 'checked="checked"' : '').' onchange="if (this.checked) {this.form.elements[\'abt[message3]\'].value=\'1\'} else {this.form.elements[\'abt[message3]\'].value=\'0\'}" /><input type="hidden" name="abt[message3]" value="'.$unabt["message3"].'" />';

	$sortie = '
	<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
	<html>
	<head>
	<meta http-equiv="content-type" content="text/html;charset=iso-8859-1">
	<title>Document</title>
	<link rel="stylesheet" type="text/css" href="system/skins/joomla/system.css">
	<link rel="StyleSheet" href="themes/System/style/style.css" media="screen, handheld" type="text/css">
	<link rel="stylesheet" type="text/css" href="modules/'.$module_name.'/system/css/default.css"/>
	<link rel="stylesheet" type="text/css" media="all" href="javascripts/calendar/styles/calendar-win2k-cold-1.css" title="win2k-cold-1" />
	<script type="text/javascript" src="javascripts/calendar/calendar.js"></script>
	<script type="text/javascript" src="javascripts/calendar/lang/calendar-fr.js"></script>
	<script type="text/javascript" src="javascripts/calendar/calendar-setup.js"></script>
	<script type="text/javascript">
		function setuplecalendrier(elt) {
		 	Calendar.setup({
				inputField     :    elt.id,
		    	ifFormat       :    "%d/%m/%Y",
		    	daFormat       :	"%d/%m/%Y",
		    	showsTime      :    false,
				button         :    elt.id,
				eventName      :    "focus",
		    	align          :    "Bl",
		    	singleClick    :    true
		    });
	    }
	    function setuplecalendrier2(elt) {
		 	Calendar.setup({
				inputField     :    elt.id,
		    	ifFormat       :    "%d/%m/%Y %H:%M:%S",
		    	daFormat       :	"%d/%m/%Y %H:%M:%S",
		    	showsTime      :    true,
				button         :    elt.id,
				eventName      :    "focus",
		    	align          :    "Bl",
		    	singleClick    :    true
		    });
	    }
	</script>
	<script type="text/javascript">
	/*function update_user() {
		window.parent.update_user();
		window.parent.win.close();
	}*/
</script>
</head>

<body style="background-color: #F2F2E6">
';
	//$sortie .= '<p><a href="#" onclick="setParent(\'A\',\'B\',\'C\'); return false">test</a></p>';

	$sortie.='<form action="system.php" method="post" name="abtform">
	<input type="hidden" name="abt[id_user]" value="'.$unabt["id_user"].'">
	<input type="hidden" name="action" value="save_abt">
	<input type="hidden" name="op" value="users_general">
	<input type="hidden" name="abt[id]" value="'.$unabt["id"].'">
	<table border="0" cellpadding="0" cellspacing="0" width="770" align="center" class="dialog">
	<tr><td class="titre" colspan="2"><b>Fiche d\'abonnement du membre.</b></td><td valign="top"></td></tr>
	<tr class="eltlist"><td class="titre">Dbut abonnement : </td><td><input type="text" name="abt[du]" value="'.utilFuncs_simpleUsers::date2JMA($unabt["du"]).'" size="50" maxlength="250" class="saisie" id="abt[du]" onmouseover="setuplecalendrier(this)"></td></tr>
	<tr class="eltlist"><td class="titre">Fin abonnement : </td><td><input type="text" name="abt[au]" value="'.utilFuncs_simpleUsers::date2JMA($unabt["au"]).'" size="50" maxlength="250" class="saisie" id="abt[au]" onmouseover="setuplecalendrier(this)"></td></tr>
	<tr class="eltlist"><td class="titre">Souscrit le : </td><td><input type="text" name="abt[le]" value="'.utilFuncs_simpleUsers::date2JMA($unabt["le"]).'" size="50" maxlength="250" class="saisie" id="abt[le]" onmouseover="setuplecalendrier2(this)"></td></tr>
	<tr class="eltlist"><td class="titre">Pour un montant de : </td><td><input type="text" name="abt[montant]" value="'.$unabt["montant"].'" size="50" maxlength="250" class="saisie"></td></tr>
	<tr class="eltlist"><td class="titre">Dtails : </td><td><textarea name="abt[details]" class="saisie" rows="4">'.$unabt["details"].'</textarea></td></tr>
	<tr class="eltlist"><td class="titre">Rappel 30 jours expdi : </td><td>'.$mess30.'</td></tr>
	<tr class="eltlist"><td class="titre">Rappel 15 jours expdi : </td><td>'.$mess15.'</td></tr>
	<tr class="eltlist"><td class="titre">Rappel 3 jours expdi : </td><td>'.$mess3.'</td></tr>
	<tr><td colspan="2" class="btn"><input type="button" value="Annuler" onclick="window.parent.win.close()">&nbsp;&nbsp;&nbsp;&nbsp;<input type="submit" value="Enregistrer"></td></tr>
	</table></form>';

	$sortie .= '
	</body>
	</html>';
	return $sortie;

}

function save_abt($unabt) {
	global $module_name, $db, $user_prefix, $aid, $admin,$header_system;

	$unabt["du"] = utilFuncs_simpleUsers::date2AMJ($unabt["du"]);
	$unabt["au"] = utilFuncs_simpleUsers::date2AMJ($unabt["au"]);
	$unabt["le"] = utilFuncs_simpleUsers::date2AMJ($unabt["le"]);
	$unabt["montant"] = ($unabt["montant"] == "") ? "0" : floatval(str_replace(",", ".", str_replace(" ", "", $unabt["montant"])));
	$unabt = array_map(array('utilFuncs_simpleUsers', 'conditionnertodb'), $unabt);

	$list_champs = "";
	$list_valeurs = "";
	if (!($unabt["id"] != "" && $unabt["id"]!="-1" && $unabt["id"]!="0")) {
		foreach($unabt as $key => $value) {
			if ($key != "id") {
				$list_champs .= ($list_champs == "") ? "" : ", ";
				$list_champs .= "`".$key."`";
				$list_valeurs .= ($list_valeurs == "") ? "" : ", ";
				$list_valeurs .= "'".$value."'";
			}
		}
		$sql = "INSERT INTO `".$user_prefix."_users_abt` (".$list_champs.")";
		$sql .= " VALUES (".$list_valeurs.");";
	}
	else {
		foreach($unabt as $key => $value) {
			if ($key != "id") {
				$list_champs .= ($list_champs == "") ? "" : ", ";
				$list_champs .= "`".$key."` = '".$value."'";
			}
		}
		$sql = "UPDATE `".$user_prefix."_users_abt` SET ".$list_champs." WHERE `id` = '".$unabt["id"]."';";
	}

	if (!$db->sql_query($sql)) {
		die("Erreur enrgistrement abonnement");
	}
	
	$sortie = '
	<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
	<html>
	<head>
	<meta http-equiv="content-type" content="text/html;charset=iso-8859-1">
	<title>Document</title>
	<link rel="stylesheet" type="text/css" href="system/skins/joomla/system.css">
	<link rel="StyleSheet" href="themes/System/style/style.css" media="screen, handheld" type="text/css">
	<link rel="stylesheet" type="text/css" href="modules/'.$module_name.'/system/css/default.css"/>
	<script type="text/javascript">
	function update_user() {
		//setTimeout("window.parent.win.close()", 5000);
		setTimeout("window.parent.update_user()", 3000);
	}
	</script>
</head>

<body style="background-color: #F2F2E6" onload="update_user()">
';
	//$sortie .= '<p><a href="#" onclick="setParent(\'A\',\'B\',\'C\'); return false">test</a></p>';

	$sortie.='<table border="0" cellpadding="0" cellspacing="0" width="770" align="center" class="dialog">
	<tr class="eltlist"><td colspan="7">Abonnement enregistr</td></tr>
	</table>';

	$sortie .= '
	</body>
	</html>';
	return $sortie;

}

function del_abt($id) {
	global $module_name, $db, $user_prefix, $aid, $admin,$header_system;
	
	$sql = "DELETE FROM `".$user_prefix."_users_abt` WHERE id='".$id."';";
	return $db->sql_query($sql);
}

function edit_member_gen($Id, $page="",$letter="", $onglet="",$membre=array(),$stop="",$selectgroup="", $sortby="", $kw="", $rub="") {
	global $module_name, $db, $user_prefix,$language;
	global $header_system;
	global $withuserabt;
	
	$header_system .= '
	<script type="text/javascript" src="javascripts/windows_js/javascripts/prototype.js"></script>
	<script type="text/javascript" src="javascripts/windows_js/javascripts/effects.js"></script>
	<script type="text/javascript" src="javascripts/windows_js/javascripts/window.js"></script>
	<script type="text/javascript" src="javascripts/windows_js/javascripts/window_ext.js"></script>
	<script type="text/javascript" src="javascripts/windows_js/javascripts/debug.js"></script>
	<link href="javascripts/windows_js/themes/default.css" rel="stylesheet" type="text/css" />
	<link href="javascripts/windows_js/themes/becms_alphacube.css" rel="stylesheet" type="text/css" />
	<script type="text/javascript">
	var win=null;
	function ouvre_dialogue(titre,url,width) {
		win = new Window({className: "becms_alphacube", title: titre, width:width, height:400, destroyOnClose: true, recenterAuto:true, url: url, minimizable: false, maximizable: false});
		win.showCenter(true);
	}
	function update_user() {
		window.location.reload();
	}
	function confirm_delete() {
		if (confirm("En tes-vous sr(e) ?")) {
			return true;
		}
		else {
			return false;
		}
	}
    function setProprio(id, nom) {
		document.forms["edit_member"].elements["user_master_id"].value = id;
		document.forms["edit_member"].elements["user_master_name"].value = nom;
	}
	</script>
	<link rel="stylesheet" type="text/css" media="all" href="javascripts/calendar/styles/calendar-win2k-cold-1.css" title="win2k-cold-1" />
	<script type="text/javascript" src="javascripts/calendar/calendar.js"></script>
	<script type="text/javascript" src="javascripts/calendar/lang/calendar-fr.js"></script>
	<script type="text/javascript" src="javascripts/calendar/calendar-setup.js"></script>
	<script type="text/javascript">
		function setuplecalendrier(elt) {
		 	Calendar.setup({
				inputField     :    elt.id,
		    	ifFormat       :    "%d/%m/%Y",
		    	daFormat       :	"%d/%m/%Y",
		    	showsTime      :    false,
				button         :    elt.id,
				eventName      :    "focus",
		    	align          :    "Bl",
		    	singleClick    :    true
		    });
	    }
	    function setuplecalendrier2(elt) {
		 	Calendar.setup({
				inputField     :    elt.id,
		    	ifFormat       :    "%d/%m/%Y %H:%M:%S",
		    	daFormat       :	"%d/%m/%Y %H:%M:%S",
		    	showsTime      :    true,
				button         :    elt.id,
				eventName      :    "focus",
		    	align          :    "Bl",
		    	singleClick    :    true
		    });
	    }
	</script>
	';
	
	if ($Id != "" && $Id != "-1") {
		$select = "SELECT uid, uname, email, user_name, user_firstname, user_town, user_filiere, user_categorie, user_group, adh_tel, adh_entreprise, user_func, adh_adresse, adh_web, user_url_login, adh_date_creation, user_master_id  from ".$user_prefix."_users WHERE uid='$Id'"; //select our data
		$result = $db->sql_query($select);
		$membre = $db->sql_fetchrow($result);
		$lesgroupes= array();
		$result = $db->sql_query("SELECT * FROM ".$user_prefix."_users_groups WHERE user_id='".$membre["uid"]."'");
		if ($db->sql_numrows($result) != 0) {
			while ($ligneencours = $db->sql_fetchrow($result)) {
				$lesgroupes[$ligneencours["group_id"]] = "ok";
			}
		}
	}
	else {
		$membre["uid"] = $Id;
		$lesgroupes= array();
		if (!isset($membre["groups"])) {
			$membre["groups"] = array();
		}
		foreach ($membre["groups"] as $groupencours) {
			$lesgroupes[$groupencours] = "ok";
		}
	}
	$groupesbox = "";
	$result = $db->sql_query("SELECT * FROM ".$user_prefix."_groups ORDER BY name ASC");
	if ($db->sql_numrows($result) != 0) {
		while ($ligneencours = $db->sql_fetchrow($result)) {
			$checked = ($lesgroupes[$ligneencours["id"]] == "ok") ? " checked=\"checked\"" : "";
			$groupesbox .= '<input name="groups[]" type="checkbox" id="'.$ligneencours["id"].'" value="'.$ligneencours["id"].'"'.$checked.'>';
			$groupesbox .= '<label for="'.$ligneencours["id"].'">'.$ligneencours["name"].'</label><br />';
		}
	}
	
	$sortie_locale .= '<script type="text/javascript" src="javascripts/lang/lang-'.$language.'.js"></script>
	<script type="text/javascript" src="javascripts/control_form.js"></script>
	';
	$sortie_locale .= '<form name="edit_member" action="system.php?op=users_general&action=save_user&onglet='.$onglet.'" method="POST" onsubmit="return submit_form(this)" autocomplete="off">';
	$sortie_locale .= '<center><div class="fiche_adh">';
	if ($stop !="") {
		$sortie_locale .= '&nbsp;<br />'.'<b>'.$stop.'</b>'; 
	}
	$sortie_locale .= '&nbsp;<br />';
	
	$sortie_locale .= '<fieldset><legend>'._SNLUSERBLOC.'</legend>';
	$sortie_locale .= '<table border="0" cellpadding="5" cellspacing="0">';
	
	$sortie_locale .= '<tr><td class="label">';
	$sortie_locale .= _SNLUSERSBLOCNAME;
	$sortie_locale .= '*</td><td>';
	//$sortie_locale .= '<champ lib="'._SUBNAME.'" nom="user_name" lim="1,100"></champ>';
	$sortie_locale .= '<input type="text" name="user_name" value="'.$membre["user_name"].'" class="saisie">';
	$sortie_locale .= '</td></tr>';
	
	$sortie_locale .= '<tr><td class="label">';
	$sortie_locale .= _SNLUSERSBLOCFIRSTNAME;
	$sortie_locale .= '*</td><td>';
	//$sortie_locale .= '<champ lib="'._SUBPRENAME.'" nom="user_firstname" lim="1,100"></champ>';
	$sortie_locale .= '<input type="text" name="user_firstname" value="'.$membre["user_firstname"].'" class="saisie">';
	$sortie_locale .= '</td></tr>';
	
	$sortie_locale .= '<tr><td class="label">';
	$sortie_locale .= _SNLUSERSBLOCFUNC;
	$sortie_locale .= '</td><td>';
	$sortie_locale .= '<input type="text" name="user_func" value="'.$membre["user_func"].'" class="saisie">';
	$sortie_locale .= '</td></tr>';
	
	$sortie_locale .= '<tr><td class="label">';
	$sortie_locale .= _SNLUSERSBLOCSOCIETE;
	$sortie_locale .= '</td><td>';
	$sortie_locale .= '<input type="text" name="adh_entreprise" value="'.$membre["adh_entreprise"].'" class="saisie">';
	$sortie_locale .= '</td></tr>';
	
	$sortie_locale .= '<tr><td class="label">';
	$sortie_locale .= _SNLUSERSBLOCADRESSE;
	$sortie_locale .= '</td><td>';
	$sortie_locale .= '<textarea name="adh_adresse" class="saisie" rows="3">'.$membre["adh_adresse"].'</textarea>';
	$sortie_locale .= '</td></tr>';
	
	$sortie_locale .= '<tr><td class="label">';
	$sortie_locale .= _SNLUSERSBLOCTEL;
	$sortie_locale .= '</td><td>';
	$sortie_locale .= '<input type="text" name="adh_tel" value="'.$membre["adh_tel"].'" class="saisie">';
	$sortie_locale .= '</td></tr>';
	
	$sortie_locale .= '<tr><td class="label">';
	$sortie_locale .= _SNLUSERSBLOCEMAIL;
	$sortie_locale .= '*</td><td>';
	//$sortie_locale .= '<champ ctl="email" lib="'._SUBMAIL.'" nom="email" lim="3,100"></champ>';
	$sortie_locale .= '<input type="text" name="email" value="'.$membre["email"].'" class="saisie">';
	$sortie_locale .= '</td></tr>';
	
	$sortie_locale .= '<tr><td class="label">';
	$sortie_locale .= _SNLUSERSBLOCEWEB;
	$sortie_locale .= '</td><td>';
	$sortie_locale .= '<input type="text" name="adh_web" value="'.$membre["adh_web"].'" class="saisie">';
	$sortie_locale .= '</td></tr>';
	
	$sortie_locale .= '<tr><td class="label">';
	$sortie_locale .= _SNLUSERSBLOCGROUP;
	$sortie_locale .= '</td><td>';
	$sortie_locale .= $groupesbox;
	$sortie_locale .= '</td></tr>';
	
	$sortie_locale .= '<tr><td class="label">';
	$sortie_locale .= 'Date de premire adhsion';
	$sortie_locale .= '</td><td>';
	$sortie_locale .= '<input type="text" name="adh_date_creation" value="'.utilFuncs_simpleUsers::date2JMA($membre["adh_date_creation"]).'" class="saisie" id="adh_date_creation" onmouseover="setuplecalendrier(this)">';
	$sortie_locale .= '</td></tr>';
	
	$sortie_locale .= '<tr><td class="label">';
	$sortie_locale .= _SNLUSERSBLOCNICKNAME;
	$sortie_locale .= '*</td><td>';
	$sortie_locale .= '<champ lib="'._SUBSURNAME.'" nom="uname" lim="1,100"></champ>';
	$sortie_locale .= '<input type="text" name="uname" value="'.$membre["uname"].'" class="saisie">';
	$sortie_locale .= '</td></tr>';
	
	$sortie_locale .= '<tr><td class="label">';
	$sortie_locale .= _SNLUSERSBLOCPASSWD;
	$sortie_locale .= '</td><td>';
	$sortie_locale .= '<input type="password" name="newpass" value="" class="saisie">';
	$sortie_locale .= '</td></tr>';
	
	$sortie_locale .= '</table>';
	$sortie_locale .= '</fieldset>';
	
	$sortie_locale .= '&nbsp<br />';
	
	if ($withuserabt == 1) {
		$barDef=array(
			"edit"=> array( "text"=>_EDIT,"icon"=>"edit_16x16.png","comment"=>_EDIT, "status"=>"ON", "target"=>"_blank", "title" => "Abonnement"),
			"delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png","comment"=>_DELETE,"status"=>"ON")
		);
	
		if ($membre["user_master_id"] != "" && $membre["user_master_id"] != "0") {
		    $Id = $membre["user_master_id"];
		}
		
		$sql = "SELECT `id` , `du` , `au` , `montant` , `le` , `message30` , `message15` , `message3` FROM `".$user_prefix."_users_abt` WHERE `id_user`='".$Id."' ORDER BY `au` DESC;";
		$result = $db->sql_query($sql);
		$lignesTab = "";
		if ($db->sql_numrows($result) != 0) {
			while ($ligneencours = $db->sql_fetchrow($result)) {
				$barDef["edit"]["onclick_a"] = "ouvre_dialogue(this.title, this.href, 800); return false";
				$barDef["edit"]["url"] = "system.php?op=users_general&action=edit_abt&Id=".$ligneencours["id"]."&user_id=".$Id;
				
				$barDef["delete"]["onclick_a"] = "return confirm_delete()";
				$barDef["delete"]["url"] = "system.php?op=users_general&action=del_abt&Id=".$ligneencours["id"]."&user_id=".$Id."&page=".$page."&letter=".$letter."&onglet=".$onglet."&selectgroup=".$selectgroup."&sortby=".$sortby."&kw=".$kw."&rub=".$rub;
				
				$lignesTab .= '<tr>';
				$lignesTab .= '<td>'.utilFuncs_simpleUsers::date2JMA($ligneencours["du"]).'</td>';
				$lignesTab .= '<td>'.utilFuncs_simpleUsers::date2JMA($ligneencours["au"]).'</td>';
				$lignesTab .= '<td>'.number_format($ligneencours["montant"],2,","," ")."&euro;".'</td>';
				$lignesTab .= '<td>'.utilFuncs_simpleUsers::date2JMA($ligneencours["le"]).'</td>';
				$lignesTab .= '<td align="center">'.'<input type="checkbox" name="no_name1" value="" '.(($ligneencours["message30"]=="1") ? 'checked="checked"' : '').' disabled="disabled" readonly="readonly" />'.'</td>';
				$lignesTab .= '<td align="center">'.'<input type="checkbox" name="no_name2" value="" '.(($ligneencours["message15"]=="1") ? 'checked="checked"' : '').' disabled="disabled" readonly="readonly" />'.'</td>';
				$lignesTab .= '<td align="center">'.'<input type="checkbox" name="no_name3" value="" '.(($ligneencours["message3"]=="1") ? 'checked="checked"' : '').' disabled="disabled" readonly="readonly" />'.'</td>';
				$lignesTab .= '<td align="center">'. displayActionBar("add","Bar d'action",$barDef,"img","",true).'</td>';
				$lignesTab .= '<tr>';
			}
		}
		
		$sortie_locale .= '<fieldset><legend>'.'Abonnements souscrits'.'</legend>';
		$sortie_locale .= '<table border="0" cellpadding="5" cellspacing="0">';
		$sortie_locale .= '<tr><td align="center"><b>Dbut</b></td><td align="center"><b>Fin</b></td><td align="center"><b>Montant</b></td><td align="center"><b>Date</b></td><td align="center"><b>Rappel 30</b></td><td align="center"><b>Rappel 15</b></td><td align="center"><b>Rappel 3</b></td><td align="center"><b>Actions</b></td></tr>';
		$sortie_locale .= $lignesTab;
		$sortie_locale .= '</table>&nbsp;<br />
		<a href="system.php?op=users_general&action=edit_abt&Id=-1&user_id='.$Id.'" target="_blank" onclick="ouvre_dialogue(this.title, this.href, 800); return false" title="Abonnement">[+] Ajouter un abonnement</a><br />
		&nbsp;<br />';
		
		$nom_maitre = "";
		if ($membre["user_master_id"] != "" && $membre["user_master_id"] != "0") {
		    $sql = 'SELECT `'.$user_prefix.'_users`.`uid`, `user_name`, `user_firstname`';
		    $sql .= ' FROM '.$user_prefix.'_users';
		    $sql .= ' WHERE uid=\''.$membre["user_master_id"].'\'';
		    $result = $db->sql_query($sql);
		    if ($db->sql_numrows($result) > 0) {
		        if ($ligne = $db->sql_fetchrow($result)) {
		            $nom_maitre = ($ligne["user_firstname"].(($ligne["user_firstname"].$ligne["user_name"] != '') ? " " : "").$ligne["user_name"]);
		        }
		    }
		    else {
		        $nom_maitre = "";
		    }
		}
		
		$sortie_locale .= '<table border="0" cellpadding="5" cellspacing="0">
                        		<tr><td>Compte matre</td>
                        		<td><input type="hidden" name="user_master_id" value="'.$membre["user_master_id"].'">
                        		<input type="text" name="user_master_name" value="'.$nom_maitre.'"size="50" maxlength="50" readonly="readonly">&nbsp;&nbsp;&nbsp;&nbsp
                        		<a href="system.php?op=cursinu&action=choose_proprio" title="Choix du propritaire" onclick="ouvre_dialogue(this.title, this.href, 800); return false"><img src="images/netvibes.gif" alt="Choisir le propritaire" align="absmiddle" /></a>
                        		&nbsp;&nbsp;&nbsp;&nbsp</td></tr>
                            </table>';
		
		
		$sortie_locale .= '</fieldset>';
		
	$sortie_locale .= '&nbsp<br />';
	}
	
	require_once 'modules/becmsDynMenu/lib/g_params.php';
	$Myqsl["maBase"] = $db;
	$langueMenuEnCours = "French";
	$rub_url = "user_url_login";
	$urlEnCours = $membre[$rub_url];
	require_once 'modules/becmsDynMenu/lib/get_all_urls_modules.php';
	
	$sortie_locale .= '<fieldset><legend>'._SNLUSERURL.'</legend>';
	$sortie_locale .= '<table border="0" cellpadding="5" cellspacing="0">';
	$sortie_locale .= '<tr><td class="label">';
	$sortie_locale .= _SNLUSERURL2;
	$sortie_locale .= '</td><td>';
	$sortie_locale .= '<input class="saisie" type="text" id="'.$rub_url.'" name="'.$rub_url.'" size="24" value="'.$urlEnCours.'">';
	$sortie_locale .= '</td></tr>';
	
	$sortie_locale .= '</table>&nbsp;<br />';
	$sortie_locale .= $menus_modules;
	$sortie_locale .= '</fieldset>';
	
	$sortie_locale .= '<br />&nbsp;<br />';
	$sortie_locale .= '<input type="submit" value="'._SNLUSERSSAVEBTN.'" name="valid">';
	$sortie_locale .= '<input type="hidden" value="'.$membre["uid"].'" name="uid">';
	$sortie_locale .= '<input type="hidden" value="'.$page.'" name="page">';
	$sortie_locale .= '<input type="hidden" value="'.$letter.'" name="letter">';
	$sortie_locale .= '<input type="hidden" value="'.$selectgroup.'" name="selectgroup">';
	$sortie_locale .= '<input type="hidden" value="'.$sortby.'" name="sortby">';
	$sortie_locale .= '<input type="hidden" value="'.$kw.'" name="kw">';
	$sortie_locale .= '<input type="hidden" value="'.$rub.'" name="rub">';
	
	$sortie_locale .= '<br />&nbsp;';
	$sortie_locale .= '</div></center>';
	$sortie_locale .= "</form>";
	
	return $sortie_locale;
}

function edit_member_gen_no($Id, $page="",$letter="", $onglet="",$membre=array(),$stop="") {
	global $module_name, $db, $user_prefix,$language;
	if ($Id != "" && $Id != "-1") {
		$select = "SELECT user_id, username, user_email, user_name, user_firstname, user_valid,adh_entreprise,adh_tel, user_func, adh_adresse, adh_web from ".$user_prefix."_users_temp WHERE user_id='$Id'"; //select our data
		$result = $db->sql_query($select);
		$membre = $db->sql_fetchrow($result);
		$lesgroupes= array();
		$result = $db->sql_query("SELECT * FROM ".$user_prefix."_users_temp_groups WHERE user_id='".$membre["user_id"]."'");
		if ($db->sql_numrows($result) != 0) {
			while ($ligneencours = $db->sql_fetchrow($result)) {
				$lesgroupes[$ligneencours["group_id"]] = "ok";
			}
		}
	}
	else {
		//un enregistrement ne s'est pas bien droul
	}
	$groupesbox = "";
	$result = $db->sql_query("SELECT * FROM ".$user_prefix."_groups ORDER BY name ASC");
	if ($db->sql_numrows($result) != 0) {
		while ($ligneencours = $db->sql_fetchrow($result)) {
			$checked = ($lesgroupes[$ligneencours["id"]] == "ok") ? " checked=\"checked\"" : "";
			$groupesbox .= '<input name="groups[]" type="checkbox" id="'.$ligneencours["id"].'" value="'.$ligneencours["id"].'"'.$checked.'>';
			$groupesbox .= '<label for="'.$ligneencours["id"].'">'.$ligneencours["name"].'</label><br />';
		}
	}
	
	
	$checked = "";
	if ($membre["user_valid"] == "1") {
		$checked = " checked=\"checked\"";
	}
	$radiovalid = '<input type="checkbox" value="1" name="user_valid"'.$checked.'>';
	
	
	$sortie_locale .= '<script type="text/javascript" src="javascripts/lang/lang-'.$language.'.js"></script>
	<script type="text/javascript" src="javascripts/control_form.js"></script>
	';
	$sortie_locale .= '<form name="edit_member" action="system.php?op=users_general&action=save_userno&onglet='.$onglet.'" method="POST" onsubmit="return submit_form(this)">';
	$sortie_locale .= '<center><div class="fiche_adh">';
	if ($stop !="") {
		$sortie_locale .= '&nbsp;<br />'.'<b>'.$stop.'</b>'; 
	}
	$sortie_locale .= '&nbsp;<br />';
	$sortie_locale .= '<fieldset><legend>'._SNLUSERBLOC.'</legend>';
	$sortie_locale .= '<table border="0" cellpadding="5" cellspacing="0">';
	
	$sortie_locale .= '<tr><td class="label">';
	$sortie_locale .= _SNLUSERSBLOCNICKNAME;
	$sortie_locale .= '</td><td>';
	$sortie_locale .= '<champ lib="'._SUBSURNAME.'" nom="username" lim="1,100"></champ>';
	$sortie_locale .= '<input type="text" name="username" value="'.$membre["username"].'" class="saisie">';
	$sortie_locale .= '</td></tr>';
	
	$sortie_locale .= '<tr><td class="label">';
	$sortie_locale .= _SNLUSERSBLOCNAME;
	$sortie_locale .= '</td><td>';
	$sortie_locale .= '<champ lib="'._SUBNAME.'" nom="user_name" lim="1,100"></champ>';
	$sortie_locale .= '<input type="text" name="user_name" value="'.$membre["user_name"].'" class="saisie">';
	$sortie_locale .= '</td></tr>';
	
	$sortie_locale .= '<tr><td class="label">';
	$sortie_locale .= _SNLUSERSBLOCFIRSTNAME;
	$sortie_locale .= '</td><td>';
	$sortie_locale .= '<champ lib="'._SUBPRENAME.'" nom="user_firstname" lim="1,100"></champ>';
	$sortie_locale .= '<input type="text" name="user_firstname" value="'.$membre["user_firstname"].'" class="saisie">';
	$sortie_locale .= '</td></tr>';
	
	$sortie_locale .= '<tr><td class="label">';
	$sortie_locale .= _SNLUSERSBLOCFUNC;
	$sortie_locale .= '</td><td>';
	$sortie_locale .= '<input type="text" name="user_func" value="'.$membre["user_func"].'" class="saisie">';
	$sortie_locale .= '</td></tr>';
	
	$sortie_locale .= '<tr><td class="label">';
	$sortie_locale .= _SNLUSERSBLOCSOCIETE;
	$sortie_locale .= '</td><td>';
	$sortie_locale .= '<input type="text" name="adh_entreprise" value="'.$membre["adh_entreprise"].'" class="saisie">';
	$sortie_locale .= '</td></tr>';
	
	$sortie_locale .= '<tr><td class="label">';
	$sortie_locale .= _SNLUSERSBLOCADRESSE;
	$sortie_locale .= '</td><td>';
	$sortie_locale .= '<textarea name="adh_adresse" class="saisie" rows="3">'.$membre["adh_adresse"].'</textarea>';
	$sortie_locale .= '</td></tr>';
	
	$sortie_locale .= '<tr><td class="label">';
	$sortie_locale .= _SNLUSERSBLOCTEL;
	$sortie_locale .= '</td><td>';
	$sortie_locale .= '<input type="text" name="adh_tel" value="'.$membre["adh_tel"].'" class="saisie">';
	$sortie_locale .= '</td></tr>';
	
	$sortie_locale .= '<tr><td class="label">';
	$sortie_locale .= _SNLUSERSBLOCEMAIL;
	$sortie_locale .= '</td><td>';
	$sortie_locale .= '<champ ctl="email" lib="'._SUBMAIL.'" nom="user_email" lim="3,100"></champ>';
	$sortie_locale .= '<input type="text" name="user_email" value="'.$membre["user_email"].'" class="saisie">';
	$sortie_locale .= '</td></tr>';
	
	$sortie_locale .= '<tr><td class="label">';
	$sortie_locale .= _SNLUSERSBLOCEWEB;
	$sortie_locale .= '</td><td>';
	$sortie_locale .= '<input type="text" name="adh_web" value="'.$membre["adh_web"].'" class="saisie">';
	$sortie_locale .= '</td></tr>';
	
	$sortie_locale .= '<tr><td class="label">';
	$sortie_locale .= _SNLUSERSBLOCGROUP;
	$sortie_locale .= '</td><td>';
	$sortie_locale .= $groupesbox;
	$sortie_locale .= '</td></tr>';
	
	$sortie_locale .= '<tr><td class="label">';
	$sortie_locale .= _SDDATAVALID;
	$sortie_locale .= '</td><td>';
	$sortie_locale .= $radiovalid;
	$sortie_locale .= '</td></tr>';
	
	$sortie_locale .= '<tr><td class="label">';
	$sortie_locale .= _SNLUSERSBLOCPASSWD;
	$sortie_locale .= '</td><td>';
	$sortie_locale .= '<input type="text" name="user_password" value="" class="saisie">';
	$sortie_locale .= '</td></tr>';
	
	$sortie_locale .= '</table>';
	$sortie_locale .= '</fieldset>';
	
	$sortie_locale .= '&nbsp<br />';
	
	require_once 'modules/becmsDynMenu/lib/g_params.php';
	$Myqsl["maBase"] = $db;
	$langueMenuEnCours = "French";
	$rub_url = "user_url_login";
	$urlEnCours = $membre[$rub_url];
	require_once 'modules/becmsDynMenu/lib/get_all_urls_modules.php';

	$sortie_locale .= '<fieldset><legend>'._SNLUSERURL.'</legend>';
	$sortie_locale .= '<table border="0" cellpadding="5" cellspacing="0">';
	$sortie_locale .= '<tr><td class="label">';
	$sortie_locale .= _SNLUSERURL2;
	$sortie_locale .= '</td><td>';
	$sortie_locale .= '<input class="saisie" type="text" id="'.$rub_url.'" name="'.$rub_url.'" size="24" value="'.$urlEnCours.'">';
	$sortie_locale .= '</td></tr>';
	
	$sortie_locale .= '</table>&nbsp;<br />';
	$sortie_locale .= $menus_modules;
	$sortie_locale .= '</fieldset>';
	
	$sortie_locale .= '<br />&nbsp;<br />';
	$sortie_locale .= '<input type="submit" value="'._SNLUSERSSAVEBTN.'" name="valid">';
	$sortie_locale .= '<input type="hidden" value="'.$membre["user_id"].'" name="user_id">';
	$sortie_locale .= '<input type="hidden" value="'.$page.'" name="page">';
	$sortie_locale .= '<input type="hidden" value="'.$letter.'" name="letter">';
	
	$sortie_locale .= '<br />&nbsp;';
	$sortie_locale .= '</div></center>';
	$sortie_locale .= "</form>";
	
	return $sortie_locale;
}

function save_user_gen($member) {
	global $module_name, $db, $user_prefix, $simplenewslettergroup, $language,$stop;
	if ($member["uname"] == "") {
		$member["uname"] = $member["user_name"]." ".$member["user_firstname"];
	}
	$member["uname"] = str_replace(" ", "_", $member["uname"]);
	$member["uname"] = str_replace("'", "", $member["uname"]);
	$member["uname"] = filter($member["uname"], "nohtml");
	$obj_util = new utilFuncs_simpleUsers();
	$member["uname"] = $obj_util->normaliser($member["uname"]);
	$member["uname"] = substr($member["uname"],0,25);
	
	$member["email"] = filter($member["email"], "nohtml");
	$member["user_name"] = filter($member["user_name"], "nohtml");
	$member["user_firstname"] = filter($member["user_firstname"], "nohtml");
	
	$member["adh_entreprise"] = filter($member["adh_entreprise"], "nohtml");
	$member["adh_tel"] = filter($member["adh_tel"], "nohtml");
	
	$member["user_url_login"] = filter($member["user_url_login"], "nohtml");
	
	$member["adh_date_creation"] = utilFuncs_simpleUsers::date2AMJ($member["adh_date_creation"]);
	
	$member["user_master_id"] = ($member["user_master_id"] == "") ? "0" : $member["user_master_id"] ;
	
	if ($member["uid"] == "-1" || $member["uid"]=="") {
		$stop = userCheck($member["uname"], $member["email"], $member["uid"], false);
		if ($stop =="") {
			$user_regdate = date("M d, Y");
			$user_password = "nopass";
			$newpass = md5($member["pass"]);
			$newpass = htmlspecialchars(stripslashes($newpass),ENT_QUOTES,'ISO-8859-1',true);
			$result = $db->sql_query("INSERT INTO ".$user_prefix."_users (uname, pass, user_regdate, user_lang, email, user_name, user_firstname, adh_entreprise, adh_tel, user_func, adh_adresse, adh_web, user_url_login, adh_date_creation, user_master_id) VALUES ('".$member['uname']."', '".$newpass."', '".$user_regdate."', '".$language."', '".$member['email']."', '".$member['user_name']."', '".$member['user_firstname']."', '".$member["adh_entreprise"]."', '".$member['adh_tel']."', '".$member['user_func']."', '".$member['adh_adresse']."', '".$member['adh_web']."', '".$member["user_url_login"]."', '".$member["adh_date_creation"]."', '".$member["user_master_id"]."')");
			$member["uid"] = $db->sql_nextid();
		}
	}
	else {
	    $result = $db->sql_query("UPDATE ".$user_prefix."_users SET `uname` = '".$member["uname"]."',`email` = '".$member["email"]."', `user_name` = '".$member["user_name"]."', `user_firstname` = '".$member["user_firstname"]."', `adh_entreprise`='".$member["adh_entreprise"]."', `adh_tel` = '".$member["adh_tel"]."', `user_func` = '".$member["user_func"]."', `adh_adresse` = '".$member["adh_adresse"]."', `adh_web` = '".$member["adh_web"]."', `user_url_login` = '".$member["user_url_login"]."', `adh_date_creation`='".$member["adh_date_creation"]."', `user_master_id`='".$member["user_master_id"]."'  WHERE `uid` = '".$member["uid"]."';");
		//modification du mot de passe
		if ($member["pass"] != "") {
			$new_password = md5($member["pass"]);
			$new_password = htmlspecialchars(stripslashes($new_password),ENT_QUOTES,'ISO-8859-1',true);
			$db->sql_query("UPDATE ".$user_prefix."_users SET `pass`='".$new_password."' WHERE `uid` = '".$member["uid"]."';");
		}
	}
	if (($stop=="") && ($result)) {
		//supprimer anciens groupes
		$result = $db->sql_query("DELETE FROM ".$user_prefix."_users_groups WHERE user_id='".$member["uid"]."'");
		//ajouter nouveaux groupes
		foreach ($member["groups"] as $groupencours) {
			$result = $db->sql_query("INSERT INTO ".$user_prefix."_users_groups (user_id, group_id) VALUES ('".$member["uid"]."','".$groupencours."')");
		}
		return true;
	}
	return false;
}

function format_nuke_url($nukeurl) {
	$tab_serveur = parse_url($nukeurl);
	$racine = $tab_serveur["scheme"]."://";
	if ($tab_serveur["user"] != "") {
		$racine .= $tab_serveur["user"];
	}
	if ($tab_serveur["pass"] != "") {
		$racine .= ":".$tab_serveur["pass"];
	}
	if ($tab_serveur["pass"] != "" || $tab_serveur["user"] != "") {
		$racine .= "@";
	}
	$racine .= $tab_serveur["host"];
	if ($tab_serveur["port"] != "") {
		$racine .= ":".$tab_serveur["port"];
	}
	return $racine;	
}

function save_user_gen_no($member) {
	global $module_name, $db, $user_prefix, $simplenewslettergroup, $language,$stop, $sitename, $simpleusersgenadminmail;
	$nukeurl = "http://".$_SERVER["HTTP_HOST"].($_SERVER["SERVER_PORT"]!="80" ? ":".$_SERVER["SERVER_PORT"] : "");
	
	$member["username"] = str_replace(" ", "_", $member["username"]);
	$member["username"] = str_replace("'", "", $member["username"]);
	$member["username"] = filter($member["username"], "nohtml");
	$obj_util = new utilFuncs_simpleUsers();
	$member["username"] = $obj_util->normaliser($member["username"]);
	$member["username"] = substr($member["username"],0,25);
	
	$member["user_email"] = filter($member["user_email"], "nohtml");
	$member["user_name"] = filter($member["user_name"], "nohtml");
	$member["user_firstname"] = filter($member["user_firstname"], "nohtml");

	$member["adh_entreprise"] = filter($member["adh_entreprise"], "nohtml");
	$member["adh_tel"] = filter($member["adh_tel"], "nohtml");
	$member["user_url_login"] = filter($member["user_url_login"], "nohtml");
	if ($member["user_id"] == "-1" || $member["user_id"]=="") {
		die("Erreur : cration d'utilisateurs non autorise");
	}
	else {
		$stop = userCheck($member["username"], $member["user_email"], 0);
		if ($stop =="") {
			$result = $db->sql_query("UPDATE ".$user_prefix."_users_temp SET `username` = '".$member["username"]."',`user_email` = '".$member["user_email"]."',`user_group` = '".$member["user_group"]."', `user_name` = '".$member["user_name"]."', `user_firstname` = '".$member["user_firstname"]."', `user_level` = '".$member["user_level"]."', `user_valid` = '".$member["user_valid"]."', `adh_entreprise` = '".$member["adh_entreprise"]."',`adh_tel` = '".$member["adh_tel"]."', `time`='".(time()+(3600*24*8))."' , `user_func` = '".$member["user_func"]."', `adh_adresse` = '".$member["adh_adresse"]."', `adh_web` = '".$member["adh_web"]."', `user_url_login` = '".$member["user_url_login"]."'  WHERE `user_id` = '".$member["user_id"]."';");
			if ($result) {
				//modification du mot de passe
				if ($member["user_password"] != "") {
					$new_password = md5($member["user_password"]);
					$new_password = htmlspecialchars(stripslashes($new_password),ENT_QUOTES,'ISO-8859-1',true);
					$db->sql_query("UPDATE ".$user_prefix."_users_temp SET `user_password` = '".$new_password."' WHERE `user_id` = '".$member["user_id"]."';");
				}
				//enregistrement des groupes attribus
				$result = $db->sql_query("DELETE FROM ".$user_prefix."_users_temp_groups WHERE user_id='".$member["user_id"]."'");
				//ajouter nouveaux groupes
				foreach ($member["groups"] as $groupencours) {
					$result = $result && $db->sql_query("INSERT INTO ".$user_prefix."_users_temp_groups (user_id, group_id) VALUES ('".$member["user_id"]."','".$groupencours."')");
				}
				if ($result && ($member["user_valid"]=="1")) {
					//email au membre qui veut s'enregistrer
					$result = $db->sql_query("SELECT check_num from ".$user_prefix."_users_temp WHERE `user_id` = '".$member["user_id"]."'");
					$ligneencours = $db->sql_fetchrow($result);
					$nukeurl = format_nuke_url($nukeurl);
					$finishlink = "$nukeurl/modules.php?name=$module_name&op=activateprivatesp&check_num=".$ligneencours["check_num"];
					if ($member["user_password"] != "") {
						$identifiants = str_replace("<!--login-->", $member["username"], _SUBSPRIVSPMAILMESSAGELOG);
						$identifiants = str_replace("<!--password-->", $member["user_password"], $identifiants);
					}
					else {
						$identifiants = "";
					}
					
					$member["user_name"] = str_replace("''", "'",$member["user_name"]);
					$member["user_firstname"] = str_replace("''", "'",$member["user_firstname"]);
	//echo $finishlink;				
					$subject = ""._SUBSGENMAILSUBJECT."\"".$sitename."\"";
					$message = str_replace("<!--nom-->", $member["user_name"], _SUBSGENMAILMESSAGE);
					$message = str_replace("<!--prenom-->", $member["user_firstname"], $message);
					$message = str_replace("<!--lien-->", $finishlink, $message);
					$message = str_replace("<!--identifiants-->", $identifiants, $message);
					$objutil = new utilFuncs_simpleUsers();
					$objutil->send_email($member["user_email"], $simpleusersgenadminmail,$subject,$message);
				}
			}
		}
	}
	return (($stop=="") && ($result));
}
	
function userCheck($username, $user_email,$uid, $testEmail=true) {
	$username = filter($username, "nohtml");
	$user_email = filter($user_email, "nohtml");
	global $user_prefix, $db;
	$stop = "";
	if ($testEmail) {
		if ((!$user_email) || (empty($user_email)) || (!preg_match("#^[_\.0-9a-z-]+@([0-9a-z][0-9a-z-]+\.)+[a-z]{2,25}$#i",$user_email))) $stop = "<center>"._ERRORINVEMAIL."</center><br>";
		if (strrpos($user_email,' ') > 0) $stop = "<center>"._ERROREMAILSPACES."</center>";
	}
	if ((!$username) || (empty($username)) || (preg_match("#[^a-zA-Z0-9_-]#",$username))) $stop = "<center>"._ERRORINVNICK."</center><br>";
	if (strlen($username) > 25) $stop = "<center>"._NICK2LONG."</center>";
	if (preg_match("#^((root)|(adm)|(linux)|(webmaster)|(admin)|(god)|(administrator)|(administrador)|(nobody)|(anonymous)|(anonimo)|(annimo)|(operator)|(JackFromWales4u2))$#i",$username)) $stop = "<center>"._NAMERESERVED."</center>";
	if (strrpos($username,' ') > 0) $stop = "<center>"._NICKNOSPACES."</center>";
	if ($db->sql_numrows($db->sql_query("SELECT uname FROM ".$user_prefix."_users WHERE uname='$username' AND uid<>'$uid'")) > 0) $stop = "<center>"._NICKTAKEN."</center><br>";
	if ($db->sql_numrows($db->sql_query("SELECT username FROM ".$user_prefix."_users_temp WHERE username='$username' AND uid<>'$uid'")) > 0) $stop = "<center>"._NICKTAKEN."</center><br>";
	if ($testEmail) {
		if ($db->sql_numrows($db->sql_query("SELECT email FROM ".$user_prefix."_users WHERE email='$user_email' AND uid<>'$uid'")) > 0) $stop = "<center>"._EMAILREGISTERED."</center><br>";
	}
	if ($db->sql_numrows($db->sql_query("SELECT user_email FROM ".$user_prefix."_users_temp WHERE user_email='$user_email' AND uid<>'$uid'")) > 0) $stop = "<center>"._EMAILREGISTERED."</center><br>";
	return $stop;
}

function delete_user_gen($Id,$confirm="n",$letter,$sortby,$page, $onglet,$selectgroup="", $kw="", $rub="") {
	global $db, $user_prefix;
	if ($Id != "") {
		if ($confirm == "y"){
			$sql ="DELETE FROM ".$user_prefix."_users WHERE uid=".$Id;
			if ($db->sql_query($sql)) {
				$db->sql_query("DELETE FROM ".$user_prefix."_users_groups WHERE user_id='".$Id."'");
				$db->sql_query("DELETE FROM ".$user_prefix."_users_abt WHERE id_user ='".$Id."'");
				return "";
			}
			else {
				die("Error : DB problem");
			}
		}
		else {
			$paramplus = "";
			if ($selectgroup != "") {
				$paramplus .= "&selectgroup=".$selectgroup;
			}
			if ($kw != "") {
				$paramplus.= "&kw=".urlencode(utf8_encode($kw))."&rub=".$rub;
			}
			$sortie = "<div style=\"text-align: center; font-weight: bold\">";
			$sortie .= "<p>"._SNLUSERSCONFIRMDELETEMEMEMBER."</p>";
			$sortie .= "<p>&nbsp;</p>";
			$sortie .= "<p>";
			$sortie .= '<a href="system.php?op=users_general&action=delete_user&Id='.$Id.'&letter='.$letter.'&onglet='.$onglet.'&sortby='.$sortby.'&page='.$page.'&confirm=y'.$paramplus.'">';
			$sortie .= "["._YES."]";
			$sortie .= "</a>";
			$sortie .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
			$sortie .= '<a href="javascript:window.history.back()">';
			$sortie .= "["._NO."]";
			$sortie .= '</a>';
			$sortie .= "</p>";
			$sortie .= "</div>";
			return $sortie;
		}
	}
}

function delete_user_gen_no($Id,$confirm="n",$letter,$sortby,$page, $onglet) {
	global $db, $user_prefix;
	if ($Id != "") {
		if ($confirm == "y"){
			$sql ="DELETE FROM ".$user_prefix."_users_temp WHERE user_id=".$Id;
			if ($db->sql_query($sql)) {
				$db->sql_query("DELETE FROM ".$user_prefix."_users_temp_groups WHERE user_id='".$Id."'");
				return "";
			}
			else {
				die("Error : DB problem");
			}
		}
		else {
			$sortie = "<div style=\"text-align: center; font-weight: bold\">";
			$sortie .= "<p>"._SNLUSERSCONFIRMDELETEMEMEMBERNO."</p>";
			$sortie .= "<p>&nbsp;</p>";
			$sortie .= "<p>";
			$sortie .= '<a href="system.php?op=users_general&action=delete_userno&Id='.$Id.'&letter='.$letter.'&onglet='.$onglet.'&sortby='.$sortby.'&page='.$page.'&confirm=y">';
			$sortie .= "["._YES."]";
			$sortie .= "</a>";
			$sortie .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
			$sortie .= '<a href="javascript:window.history.back()">';
			$sortie .= "["._NO."]";
			$sortie .= '</a>';
			$sortie .= "</p>";
			$sortie .= "</div>";
			return $sortie;
		}
	}
}

function alpha($sortby,$onglet,$action,$selectgroup="", $kw="", $rub="") {
	/* Creates the list of letters and makes them a link. */
	$sortie = "";
	$alphabet = array ("All", "A","B","C","D","E","F","G","H","I","J","K","L","M",
	"N","O","P","Q","R","S","T","U","V","W","X","Y","Z","Other");
	$num = count($alphabet) - 1;
	$sortie .= "<div>";
	$sortie .= _SNLUSERSLISTEFILTER;
	$sortie .= "[ ";
	$counter = 0;
	$paramplus = "";
	if ($selectgroup != "") {
		$paramplus .= "&selectgroup=".$selectgroup;
	}
	if ($kw != "") {
		$paramplus.= "&kw=".urlencode(utf8_encode($kw))."&rub=".$rub;
	}
	while (list(, $ltr) = each($alphabet)) {
		$sortie .= "<A HREF=\"system.php?op=users_general&action=$action&letter=$ltr&sortby=$sortby&onglet=$onglet$paramplus\">$ltr</a>";
		if ( $counter == round($num/2) ) {
			$sortie .= " ]\n[ ";
		} elseif ( $counter != $num ) {
			$sortie .= "&nbsp;|&nbsp;\n";
		}
		$counter++;
	}
	$sortie .= " ]\n</div>\n\n";
	return $sortie;
}

function SortLinks($letter, $sortby, $what) {  // Makes order by links..
	global $Default_Skin,$action,$onglet,$page,$selectgroup;
	
	$skinPath="system/skins/$Default_Skin";
       if ($letter == "front") {
		$letter = "All";
	}
	$sorticon="$skinPath/down.png";
	//echo "$sortby||$what//";
	if ($sortby != $what || $sortby == "") {
		$sortimg= "<img src=\"$sorticon\" onclick=\"window.location.href='system.php?op=users_general&action=$action&onglet=$onglet&letter=$letter&sortby=$what&page=$page&selectgroup=$selectgroup'\">";
	}
	else {
		$sortimg= "";
	}
	return $sortimg;       
}

function usersToExcel() {
	global $prefix, $db, $module_name;
	global $withuserabt;

	if ($withuserabt) {
	    $abt1 = array();
	    $annee_en_cours = date("Y");
	    $sql = "SELECT `id_user` FROM `".$prefix."_users_abt` where `du`<'".$annee_en_cours."-06-31' and `au`>'".$annee_en_cours."-06-31';";
	    $result3 = $db->sql_query($sql);
	    if ($db->sql_numrows($result3) > 0) {
	        while ($ligne = $db->sql_fetchrow($result3)) {
	            $abt1[$ligne["id_user"]] = "1";
	        }
	    }
	    $abt2 = array();
	    $annee_en_cours = $annee_en_cours - 1;
	    $sql = "SELECT `id_user` FROM `".$prefix."_users_abt` where `du`<'".$annee_en_cours."-06-31' and `au`>'".$annee_en_cours."-06-31';";
	    $result3 = $db->sql_query($sql);
	    if ($db->sql_numrows($result3) > 0) {
	        while ($ligne = $db->sql_fetchrow($result3)) {
	            $abt2[$ligne["id_user"]] = "1";
	        }
	    }
	    $abt3 = array();
	    $annee_en_cours = $annee_en_cours - 1;
	    $sql = "SELECT `id_user` FROM `".$prefix."_users_abt` where `du`<'".$annee_en_cours."-06-31' and `au`>'".$annee_en_cours."-06-31';";
	    $result3 = $db->sql_query($sql);
	    if ($db->sql_numrows($result3) > 0) {
	        while ($ligne = $db->sql_fetchrow($result3)) {
	            $abt3[$ligne["id_user"]] = "1";
	        }
	    }
	}

	$sql = " SELECT `id` , `name` FROM `".$prefix."_groups` ORDER BY `name` ASC";
	$result = $db->sql_query($sql);
	if ($db->sql_numrows($result) > 0) {
		set_time_limit(60);
		require_once "modules/$module_name/php_writeexcel/class.writeexcel_workbook.inc.php";
		require_once "modules/$module_name//php_writeexcel/class.writeexcel_worksheet.inc.php";
		$fname = tempnam("/tmp", "Export.xls");
		$workbook = new writeexcel_workbook($fname);
		$entete  =& $workbook->addformat(array(
										font		=> 'Arial',
										bg_color	=> 'silver',
                                        bold    => 1,
                                        color   => 'black',
                                        size    => 12,
                                        merge   => 1,
                                        bold    => 1
                                        ));
        $donnee  =& $workbook->addformat(array(
										font		=> 'Arial',
										bold    => 0,
                                        color   => 'black',
                                        size    => 10,
                                        merge   => 1,
                                        text_h_align => 0,
                                        num_format => '@'
                                        ));
        $titres = array("Nom", "Prnom", "Organisme", "Adresse postale", "Tlphone", "E-mail", "Pseudo");
        if ($withuserabt) {
            $annee_en_cours = date("Y");
            $titres[] = "Abt. ".$annee_en_cours;
            $titres[] = "Abt. ".($annee_en_cours-1);
            $titres[] = "Abt. ".($annee_en_cours-2);
        }
		while ($thegroup = $db->sql_fetchrow($result)) {
			$worksheet =& $workbook->addworksheet(substr($thegroup["name"],0,31));
			if ($withuserabt) {
			    $worksheet->set_column(0, 9, 30);
			}
			else {
                $worksheet->set_column(0, 6, 30);
			}
			$worksheet->write_row('A1', $titres, $entete);
			$compteur = 2;
			$sql = "SELECT uid, uname, email, user_name, user_firstname, adh_adresse, adh_tel, adh_entreprise, user_master_id  from ".$prefix."_users INNER JOIN becms_users_groups ON user_id=uid WHERE group_id='".$thegroup["id"]."' order by user_name;";
			$result2 = $db->sql_query($sql);
			if ($db->sql_numrows($result2) > 0) {
				while ($theuser = $db->sql_fetchrow($result2)) {
					$ligne = array($theuser["user_name"], $theuser["user_firstname"], $theuser["adh_entreprise"], str_replace("\n", "", $theuser["adh_adresse"]), $theuser["adh_tel"], $theuser["email"], $theuser["uname"]);
					if ($withuserabt) {
					    if (isset($abt1[$theuser["uid"]]) || isset($abt1[$theuser["user_master_id"]])) {
					        $ligne[] = "oui";
					    }
					    else {
					        $ligne[] = "-";
					    }
					    if (isset($abt2[$theuser["uid"]]) || isset($abt2[$theuser["user_master_id"]])) {
					        $ligne[] = "oui";
					    }
					    else {
					        $ligne[] = "-";
					    }
					    if (isset($abt3[$theuser["uid"]]) || isset($abt3[$theuser["user_master_id"]])) {
					        $ligne[] = "oui";
					    }
					    else {
					        $ligne[] = "-";
					    }
					}
					$worksheet->write_row('A'.$compteur, $ligne, $donnee);
					$compteur++;
				}
			}
		}
		$workbook->close();
		header("Content-Type: application/x-msexcel; name=\"example-demo.xls\"");
		header('Content-Disposition: inline; filename="Membres '.date("d-m-Y").'.xls"');
		$fh=fopen($fname, "rb");
		fpassthru($fh);
		unlink($fname);
	}
}

function process_members(){
		global $prefix, $db, $language, $multilingual, $Default_Skin, $SkinPath, $onglet,$module_name,$action,$page,$confirm,$valid,$letter,$sortby;
		global $Id, $uid, $uname, $user_name, $user_firstname, $user_town,$email, $user_group, $user_filiere, $user_categorie, $newsletter, $stop, $autre;
		global $groups, $user_tel, $selectgroup,$kw, $rub;
		global $user_id, $username, $user_name, $user_firstname, $user_email, $user_valid, $groups, $adh_entreprise, $adh_tel,$newpass, $user_func, $adh_adresse, $adh_web, $user_url_login, $adh_date_creation, $user_master_id;
		global $abt;

		if (!isset($action) || (action == "")) {
			$action = "list_users";
		}
		if (!isset($letter) || ($letter == "")) {
			$letter = "All"; 
		}
		if (!isset($sortby)) {
			$sortby = "";
		}
		if (!isset($page) || $page == "" || $page == 0) {
			$page = 1;
		}
		if (!isset($onglet) || $onglet == "") {
			$onglet = "users_gen";
		}
		if (!isset($confirm) || $confirm == "") {
			$confirm = "n";
		}
		if (!isset($selectgroup)) {
			$selectgroup = "";
		}
		if (!isset($kw)) {
			$kw = "";
		}
		$kw = stripslashes($kw);
		if (!isset($rub)) {
			$rub = "";
		}
		$rub = stripslashes($rub);
		
		$sortie = "";
		$operationOnglet = "";
		switch ($action) {
			case "list_usersno" :
				$sortie = list_users_gen_no($letter, $sortby, $page, $onglet);
				$operationOnglet = _SNLUSERSLISTOP;
				break;
			case "list_users" :
				$sortie = list_users_gen($letter,$sortby,$page,$onglet, $selectgroup,$kw,$rub);
				$operationOnglet = _SNLUSERSLISTOP;
				break;
			case "edit_user" :
				$sortie = edit_member_gen($Id,$page,$letter,$onglet,array(),"",$selectgroup,$sortby,$kw,$rub);
				$operationOnglet = _SNLUSERSEDITOP;
				break;
			case "edit_user_no":
				$sortie = edit_member_gen_no($Id,$page,$letter,$onglet);
				$operationOnglet = _SNLUSERSEDITOP;
				break;
			case "save_user" :
				if (!isset($groups)) {
					$groups = array();
				}	
				$the_user = array(
				"uid" => $uid,
				"uname" => $uname,
				"user_name" => $user_name,
				"user_firstname" => $user_firstname,
				"user_func" => $user_func,
				"email" => $email,
				"adh_entreprise" => $adh_entreprise,
				"adh_adresse" => $adh_adresse,
				"adh_tel" => $adh_tel,
				"adh_web" => $adh_web,
				"pass" => $newpass,
				"groups" => $groups,
				"user_url_login" => $user_url_login,
			    "adh_date_creation" => $adh_date_creation,
				"user_master_id" => $user_master_id
				);
				//print_r ($the_user);
				//die();
				if (save_user_gen($the_user)) {
					$sortie = list_users_gen($letter,$sortby,$page,$onglet, $selectgroup,$kw,$rub);
					$operationOnglet = _SNLUSERSLISTOP;
				}
				else {
					$sortie = edit_member_gen($uid,$page,$letter,$onglet,$the_user,$stop,$selectgroup,$kw,$rub);
					$operationOnglet = _SNLUSERSEDITOP;
				}
				break;
			case "save_userno":
				if (!isset($groups)) {
					$groups = array();
				}
				if (!isset($user_valid) || $user_valid == "") {
					$user_valid = 0;
				}
				$the_user = array(
				"user_id" => $user_id,
				"username" => $username,
				"user_name" => $user_name,
				"user_firstname" => $user_firstname,
				"user_func" => $user_func,
				"user_email" => $user_email,
				"user_valid" => $user_valid,
				"adh_entreprise" => $adh_entreprise,
				"adh_adresse" => $adh_adresse,
				"adh_tel" => $adh_tel,
				"adh_web" => $adh_web,
				"user_password" => $user_password,
				"groups" => $groups,
				"user_url_login" => $user_url_login
				);
				//print_r ($the_user);
				if (save_user_gen_no($the_user)) {
					$sortie = list_users_gen_no($letter,$sortby,$page,$onglet, $selectgroup);
					$operationOnglet = _SNLUSERSLISTOP;
				}
				else {
					$sortie = edit_member_gen_no($user_id,$page,$letter,$onglet,$the_user,$stop);
					$operationOnglet = _SNLUSERSEDITOP;
				}
				break;	
			case "new_user" :
				$sortie = edit_member_gen("-1",$page,$letter,$onglet);
				$operationOnglet = _SNLUSERSEDITOP;
				break;		
			case "delete_user" :
				$sortie = delete_user_gen($Id,$confirm,$letter,$sortby,$page, $onglet);
				$operationOnglet = _SNLUSERSDELSUSER;
				if ($sortie == "") {
					$sortie = list_users_gen($letter,$sortby,$page,$onglet, $selectgroup);
					$operationOnglet = _SNLUSERSLISTOP;
				}
				break;
			case "delete_userno" :
				$sortie = delete_user_gen_no($Id,$confirm,$letter,$sortby,$page, $onglet);
				$operationOnglet = _SNLUSERSDELSUSER;
				if ($sortie == "") {
					$sortie = list_users_gen_no($letter,$sortby,$page,$onglet);
					$operationOnglet = _SNLUSERSLISTOP;
				}
				break;
			case "usersToExcel":
				usersToExcel();
				die();
				break;
			case "edit_abt":
				$sortie = edit_abt($Id,$user_id);
				header('Content-Type: text/html; charset=ISO-8859-1');
				echo $sortie;
				die();
				break;
			case "save_abt":
				$sortie = save_abt($abt);
				header('Content-Type: text/html; charset=ISO-8859-1');
				echo $sortie;
				die();
				break;
			case "del_abt":
				if (del_abt($Id)) {
					header("Location: system.php?op=users_general&action=edit_user&Id=".$user_id."&letter=".$letter."&onglet=".$onglet."&sortby=".$sortby."&page=".$page."&selectgroup=".$selectgroup."&kw=".$kw."&rub=".$rub);
					die();
				}
				else {
					die("Erreur sur suppression d'abonnement !");
				}
				break;
		}
		$ongletDef=array("users_gen"=> array( "text"=>_SNLUSERSLISTPRIV, "url"=>"system.php?action=list_users&op=users_general&onglet=users_gen"),
						//"doms"=> array( "text"=>_SMEMBERSDOMAIN, "url"=>"system.php?action=list_dom&op=members&onglet=doms"),
						"users_notvalid"=> array( "text"=>_SNLUSERSLISTPRIVTEMP, "url"=>"system.php?action=list_usersno&op=users_general&onglet=users_notvalid"),
						//"stats"=> array( "text"=>_SMEMBERSSTATS, "url"=>"system.php?action=list_stats&op=members&onglet=stats")
						);

		include("system/header_system.php");
		echo "<link rel=\"StyleSheet\" type=\"text/css\" href=\"modules/".$module_name."/system/stl_users.css\">";
		GraphicAdmin(_SIMPLEUSERPRIVATESP);
		OpenOngletTable();
		displayOngletBar($onglet,$operationOnglet,$ongletDef);
		//OpenSysTable();
		echo $sortie;
		//CloseSysTable();
		CloseOngletTable();
		include("system/footer_system.php");
	}
	
//--------------------------------------------------
//            Switch part
//--------------------------------------------------
	switch($op) {
	    case "users_general":
			process_members();
			break;
	}
}
else {
    display_denied();
}
?>