<?php
/**
* Classes d'accs  la base de donnes pour la gestion des sudokus.
* 
* Toutes les fonctions utilisent l'API de la plateforme pour tre indpendante de la base de donnes utilise
* @package Sudoku
* @version 0.1
* @author Vincent RUIZ <webmaster@arobase.fr>
* @copyright Copyright  2007, Vincent RUIZ
* @license http://opensource.org/licenses/gpl-license.php GNU Public License 
*/

/**
* Classe d'accs  la base de donnes sudoku pour isoler les fonctions.
* 
* @package Sudoku
*/
class BD_Sudoku {
/**
* Enregistre un sudoku
* 
* Si le sudoku esiste dj, il est simplement modifi, sinon il est cr.
* @param array $My_SQL Paramtres de la base de donnes
* @param array $sudoku Tableau contenant tous les champs du sudoku  enregistrer
* @return boolean Retourne true si l'opration s'est bien passe, false sinon
*/
	function saveSudoku($My_SQL,$sudoku) {
		$db=$My_SQL["maBase"];
		if ($sudoku["Id"] == "-1") {
			$sql = "INSERT INTO `".$My_SQL["sudoku"]."` (`grille`,`masque`,`niveau`,`date`)";
			$sql .= " VALUES ('".$sudoku["grille"]."','".$sudoku["masque"]."','".$sudoku["niveau"]."','".$sudoku["date"]."');";
		}
		else {
			$sql = "UPDATE `".$My_SQL["sudoku"]."` SET `grille` = '".$sudoku["grille"]."',`masque` = '".$sudoku["masque"]."',`niveau` = '".$sudoku["niveau"]."',`date` = '".$sudoku["date"]."' WHERE `Id` = '".$sudoku["Id"]."';";
		}
		return $db->sql_query($sql);
	}
	
/**
* Renvoie la liste des sudokus correspondants  la demande
* 
* Un tableau vide est renvoy si aucun sudoku n'est trouv. Si Id vaut "", tous les sudokus sont renvoys.
* @param array $My_SQL Paramtres de la base de donnes
* @param integer $Id Identifiant du sudoku  renvoyer
* @param string $tri_par Nom de la rubrique servant au tri.
* @return array Retourne la liste des sudokus retrouvs
*/	
	function getSudokus($My_SQL,$Id,$tri_par="",$limit="",$inf="",$sup="") {
		$db=$My_SQL["maBase"];
		
		$sudokus = array();
		$cond = "";
		if ($Id != "-1" && $Id != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$My_SQL["sudoku"]."`.`Id`='".$Id."'";
		}
		if ($inf != "" && $sup != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$My_SQL["sudoku"]."`.`niveau`>'".$inf."' AND `".$My_SQL["sudoku"]."`.`niveau`<='".$sup."'";
		}
		$oderby = "";
		if ($tri_par =="") {
			$oderby = " ORDER BY `".$My_SQL["sudoku"]."`.`Id` ASC";
		}
		if ($tri_par =="identifiant") {
			$oderby = " ORDER BY `".$My_SQL["sudoku"]."`.`Id` ASC";
		}
		if ($tri_par == "niveau") {
			$oderby = " ORDER BY `".$My_SQL["sudoku"]."`.`niveau` ASC, `".$My_SQL["sudoku"]."`.`date` ASC";
		}
		if ($tri_par == "date") {
			$oderby = " ORDER BY `".$My_SQL["sudoku"]."`.`date` ASC, `".$My_SQL["sudoku"]."`.`Id` ASC";
		}
		if ($limit != "") {
			$limit = " LIMIT ".trim($limit);
		}
		$resultatRecherche = $db->sql_query("SELECT `".$My_SQL["sudoku"]."`.`Id`,`".$My_SQL["sudoku"]."`.`grille`,`".$My_SQL["sudoku"]."`.`masque`,`".$My_SQL["sudoku"]."`.`niveau`,`".$My_SQL["sudoku"]."`.`date` FROM `".$My_SQL["sudoku"]."` ".$cond.$oderby.$limit.";");
		if ($db->sql_numrows($resultatRecherche) != 0) {
			while ($ligneCourante = $db->sql_fetchrow($resultatRecherche)) {
				//$ligneCourante["niveau"] = ceil($ligneCourante["niveau"]*7/1000);
				array_push($sudokus, $ligneCourante);
			}
		}
		return $sudokus;
	}

/**
* Efface la fiche du sodoku dsign
* @param array $My_SQL Paramtres de la base de donnes
* @param integer $Id Identifiant de la grille  supprimer
* @return boolean Retourne true si l'opration s'est bien passe, false sinon
*/		
	function delSudoku($My_SQL,$Id) {
		$db=$My_SQL["maBase"];
		
		if ($Id != "") {
			$cond = "`Id` = ".$Id;
			$sql = "DELETE FROM `".$My_SQL["sudoku"]."` WHERE ".$cond.";";
			return $db->sql_query($sql);
		}
		else {
			return false;
		}
	}
	
/**
* Efface la fiche du sodoku dsign
* @param array $My_SQL Paramtres de la base de donnes
* @param integer $Id Identifiant de la grille  supprimer
* @return boolean Retourne true si l'opration s'est bien passe, false sinon
*/		
	function delPartieSudoku($My_SQL,$Id) {
		$db=$My_SQL["maBase"];
		
		if ($Id != "") {
			$cond = "`Id` = ".$Id;
			$sql = "DELETE FROM `".$My_SQL["parties"]."` WHERE ".$cond.";";
			echo $sql;
			return $db->sql_query($sql);
		}
		else {
			return false;
		}
	}

/**
* Retourne l'identifiant de la partie en cours de l'utilisateur
* @param array $My_SQL Paramtres de la base de donnes
* @param integer $IdClient Identifiant du client en cours
* @param integer $IdSudoku Identifiant de la grille en cours
* @return boolean Retourne l'identifiant de la partie trouve ou -1
*/
	function getPartieId($My_SQL,$IdClient,$IdSudoku) {
		$db=$My_SQL["maBase"];
	  	
		$sql = 'SELECT `Id` FROM `'.$My_SQL["parties"].'` WHERE `id_sudoku`='.$IdSudoku.' AND `id_utilisateur`='.$IdClient;
		$query = $db->sql_query($sql);
		if ($db->sql_numrows($query) != 0) {
			$row = $db->sql_fetchrow($query);
			return $row["Id"];
		}
		else {
		 	return "-1";
		}
	}
	
/**
* Enregistre la partie d'un utilisateur
* @param array $My_SQL Paramtres de la base de donnes
* @param array $partie Tableau contenant les informations de la partie  enregistre
* @return boolean Retourne true si l'opration s'est bien passe, false sinon
*/
	function savePartieSudoku($My_SQL,$partie) {
		$db=$My_SQL["maBase"];
		
		$id_partie = $this->getPartieId($My_SQL,$partie["id_utilisateur"],$partie["id_sudoku"]);
		
		$dateEnCours = date("Y-m-d");
	
		if ($id_partie != "-1") {
			$sql = "UPDATE `".$My_SQL["parties"]."` SET `id_sudoku` = '".$partie["id_sudoku"]."',`id_utilisateur` = '".$partie["id_utilisateur"]."',`grille_utilisateur` = '".$partie["grille_utilisateur"]."',`masque_utilisateur` = '".$partie["masque_utilisateur"]."', `date` = '".$dateEnCours."' WHERE `Id` = '".$id_partie."';";
		}
		else {
			$sql = "INSERT INTO `".$My_SQL["parties"]."` (`id_sudoku`, `id_utilisateur`, `grille_utilisateur`, `masque_utilisateur`,`date`) VALUES ('".$partie["id_sudoku"]."', '".$partie["id_utilisateur"]."', '".$partie["grille_utilisateur"]."', '".$partie["masque_utilisateur"]."', '".$dateEnCours."');";
		}
		return $db->sql_query($sql);
	}
	
/**
* Renvoie la liste des parties de sudokus correspondants  la demande
* 
* Un tableau vide est renvoy si aucune partie n'est trouve. Si Id vaut "", toutes les parties sont renvoyes.
* @param array $My_SQL Paramtres de la base de donnes
* @param integer $Id Identifiant de la partie  renvoyer
* @param integer $id_client Identifiant du client en cours
* @param integer $id_sudoku Identifiant du sudoku correspondant
* @param string $tri_par Nom de la rubrique servant au tri.
* @return array Retourne la liste des sudokus retrouvs
*/	
	function getPartiesSudoku($My_SQL,$Id,$id_sudoku,$id_client,$tri_par="",$limit="") {
		$db=$My_SQL["maBase"];
		
		$sudokus = array();
		$cond = "";
		if ($Id != "-1" && $Id != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$My_SQL["parties"]."`.`Id`='".$Id."'";
		}
		if ($id_sudoku != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$My_SQL["parties"]."`.`id_sudoku`='".$id_sudoku."'";
		}
		if ($id_client != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$My_SQL["parties"]."`.`id_utilisateur`='".$id_client."'";
		}
		$oderby = "";
		if ($tri_par =="" || $tri_par == "date") {
			$oderby = " ORDER BY `".$My_SQL["parties"]."`.`date` DESC, `".$My_SQL["parties"]."`.`Id` ASC";
		}
		if ($tri_par == "utilisateur") {
			$oderby = " ORDER BY `".$My_SQL["parties"]."`.`id_utilisateur` ASC, `".$My_SQL["parties"]."`.`Id` ASC";
		}
		if ($limit != "") {
			$limit = " LIMIT ".trim($limit);
		}
		$resultatRecherche = $db->sql_query("SELECT `".$My_SQL["parties"]."`.`Id`,`".$My_SQL["parties"]."`.`id_sudoku`,`".$My_SQL["parties"]."`.`id_utilisateur`,`".$My_SQL["parties"]."`.`grille_utilisateur`,`".$My_SQL["parties"]."`.`masque_utilisateur`,`".$My_SQL["parties"]."`.`date` FROM `".$My_SQL["parties"]."` ".$cond.$oderby.$limit.";");
		if ($db->sql_numrows($resultatRecherche) != 0) {
			while ($ligneCourante = $db->sql_fetchrow($resultatRecherche)) {
				array_push($sudokus, $ligneCourante);
			}
		}
		return $sudokus;
	}
	
/**
* Rcupre la valeur de l'indentifiant du dernier enregistrement cr.
* @param array $My_SQL Paramtres de la base de donnes
* @return integer Identifiant
*/
	function getLastId($My_SQL) {
		$db=$My_SQL["maBase"];
		return $db->sql_nextid();
	}
	
/**
* Renvoie le nombre de sudokus correspondants  la demande.
* @param array $My_SQL Paramtres de la base de donnes.
* @param integer $Id Identifiant du sudoku  tester.
* @return integer Retourne le nombre de grilles trouves.
*/	
	function getNumSudokus($My_SQL,$Id="",$inf="",$sup="") {
		$db=$My_SQL["maBase"];
		
		$cond = "";
		if ($Id != "-1" && $Id != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$My_SQL["sudoku"]."`.`Id`='".$Id."'";
		}
		if ($inf != "" && $sup != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$My_SQL["sudoku"]."`.`niveau`>'".$inf."' AND `".$My_SQL["sudoku"]."`.`niveau`<='".$sup."'";
		}
		$resultatRecherche = $db->sql_query("SELECT COUNT(`".$My_SQL["sudoku"]."`.`Id`) as `nbrefiches` FROM `".$My_SQL["sudoku"]."` ".$cond.";");
		if ($db->sql_numrows($resultatRecherche) != 0) {
			if ($ligneCourante = $db->sql_fetchrow($resultatRecherche)) {
				return $ligneCourante["nbrefiches"];
			}
		}
		return 0;
	}

/**
* Renvoie le nombre de parties enregistres.
* @param array $My_SQL Paramtres de la base de donnes.
* @param integer $Id Identifiant du sudoku  tester.
* @return integer Retourne le nombre de grilles trouves.
*/	
	function getNumParties($My_SQL,$Id="",$id_client="") {
		$db=$My_SQL["maBase"];
		
		$cond = "";
		if ($Id != "-1" && $Id != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$My_SQL["parties"]."`.`Id`='".$Id."'";
		}
		if ($id_client != "-1" && $id_client != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$My_SQL["parties"]."`.`id_utilisateur`='".$id_client."'";
		}
		$resultatRecherche = $db->sql_query("SELECT COUNT(`".$My_SQL["parties"]."`.`Id`) as `nbrefiches` FROM `".$My_SQL["parties"]."` ".$cond.";");
		if ($db->sql_numrows($resultatRecherche) != 0) {
			if ($ligneCourante = $db->sql_fetchrow($resultatRecherche)) {
				return $ligneCourante["nbrefiches"];
			}
		}
		return 0;
	}

/**
* Renvoie l'utilisateur correspondant  l'identifiant.
* @param integer $id_user Numro identifiant l'utilisateur.
* @return array Retourne l'utilisateur retrouv.
*/	
	function get_user($id_user) {
		global $prefix,$db;
		$select = "select uid, uname from ".$prefix."_users where uid='".$id_user."';";
		$resultatRecherche = $db->sql_query($select);
		if ($db->sql_numrows($resultatRecherche) != 0) {
			if ($ligneCourante = $db->sql_fetchrow($resultatRecherche)) {
				return array("uid" => $ligneCourante["uid"],"uname" => $ligneCourante["uname"]);
			}
		}
		else {
			return array();
		}
	}
}

/**
* Classe d'enregistrement des variables des session dans la base de donnes.
* @package becmsSimpleCatalog
*/
class BD_Sessions { 
/**
* @var integer Dure de vie des variables de session.
*/
	var $lifeTime;
/**
* @var mixed Objet base de donnes utilisant l'API de la plateforme.
*/
	var $dbHandle;
/**
* Initialisation des sessions.
* 
* @param string $savePath Chemin de sauvegarde des variables de session. Non utilise.
* @param string $sessName Nom de la session. Non utilise.
* @return boolean Retourne true si la base de donnes est ouverte, false sinon.
*/
	function open($savePath, $sessName) {
		// get session-lifetime 
		//$this->lifeTime = get_cfg_var("session.gc_maxlifetime");
		$this->lifeTime = 24 * 60 * 60; //dure de vie d'une journe
		// open database-connection 
		global $db;
		$dbHandle = $db;
		if(!$dbHandle) {
			return false;
		} 
		$this->dbHandle = $dbHandle;
		return true;
	}
/**
* Fermeture des sessions. Dtruit les sesssions arrives  terme
*/
	function close() {
		$this->gc(ini_get('session.gc_maxlifetime')); 
		// close database-connection 
	}
/**
* Lecture des variables de session.
* 
* @param integer $sessID Identifiant de la session.
* @return mixed Retourne la valeur trouvs ou NULL. NULL est utilis pour que isset($SESSION["xxx"]) renvoie false.
*/	
	function read($sessID) {
		// fetch session-data 
		$res = $this->dbHandle->sql_query("SELECT session_data AS d FROM becms_sudoku_sessions  
							WHERE session_id = '$sessID' 
							AND session_expires > ".time()); 
		// return data or NULL at failure 
		if($row = $this->dbHandle->sql_fetchrow($res)) 
			return $row['d']; 
		return NULL; 
	}
/**
* Ecriture des variables de session.
* 
* Chaque criture repousse le dlai d'expiration.
* @param integer $sessID Identifiant des variables de session en cours.
* @param mixed $sessData Variables de session  mmoriser.
* @return boolean Retourne true les donnes sont enregistres, false sinon.
*/	
	function write($sessID,$sessData) {
		// new session-expire-time
		$newExp = time() + $this->lifeTime; 
		// is a session with this id in the database? 
		$res = $this->dbHandle->sql_query("SELECT * FROM becms_sudoku_sessions
						WHERE session_id = '$sessID'"); 
		// if yes, 
		if($this->dbHandle->sql_numrows($res)) {
			// ...update session-data 
			$this->dbHandle->sql_query("UPDATE becms_sudoku_sessions  
						 SET session_expires = '$newExp', 
						 session_data = '$sessData' 
						 WHERE session_id = '$sessID'"); 
			// if something happened, return true 
			if($this->dbHandle->sql_affectedrows()) 
				return true; 
		}
		// if no session-data was found, 
		else { 
			// create a new row
			$this->dbHandle->sql_query("INSERT INTO becms_sudoku_sessions ( 
						 session_id, 
						 session_expires, 
						 session_data) 
						 VALUES( 
						 '$sessID', 
						 '$newExp', 
						 '$sessData')"); 
			// if row was created, return true 
			if($this->dbHandle->sql_affectedrows()) 
				return true;
		} 
		// an unknown error occured 
		return false;
	}
/**
* Dtruit une session particulire.
* 
* @param integer $sessID Identifiant des variables de session  dtruire.
* @return boolean Retourne true si la session a t dtruite, false sinon.
*/
	function destroy($sessID) { 
		// delete session-data 
		$this->dbHandle->sql_query("DELETE FROM becms_sudoku_sessions WHERE session_id = '$sessID'"); 
		// if session was deleted, return true, 
		if($this->dbHandle->sql_affectedrows()) 
			return true; 
		// ...else return false 
		return false; 
	}
/**
* Dtruit les sessions trop anciennes.
* 
* @param string $sessMaxLifeTime Dure de survie d'une variable de session. Non utilise.
* @return boolean Retourne true si une ou plusieurs session ont t dtruites, false sinon.
*/
	function gc($sessMaxLifeTime) { 
		// delete old sessions 
		$this->dbHandle->sql_query("DELETE FROM becms_sudoku_sessions WHERE session_expires < ".time()); 
		// return affected rows 
		return $this->dbHandle->sql_affectedrows(); 
	}
 }
?>