<?php
/**
 * Interfaage du module avec le Front Office du CMS.
 *
 * Son inclusion dans le Back Office est automatique, et son accs se trouve dans le menu "Modules"
 * @package becmsSimpleClient
 * @version 1.0
 * @author Vincent RUIZ <webmaster@arobase.fr>
 * @copyright Copyright  2007, Vincent RUIZ
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 */


if (!preg_match("#modules.php#i", $_SERVER['PHP_SELF'])) {
	die ("You can't access this file directly...");
}

$module_name = basename(dirname(__FILE__));
get_lang($module_name);

/**
 * Affiche la liste des clients enregistrs.
 *
 * @param array $My_SQL Paramtres de la base de donnes
 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
 */
function displayListNewsletter() {
	global $db,$prefix;

	include ('header.php');
	echo "<h1>"._TITLENEWSLETTER."</h1>";
	echo "<p>&nbsp;<br />&nbsp;</p>";
	$result = $db->sql_query("select newsletterid, seccont_artid, title,  date, informant from ".$prefix."_newsletter order by date DESC");
	if ($db->sql_numrows($result) != 0) {
		echo "<ul>";
	}
	while(list($newsletterid, $seccont_artid, $title, $date, $informant ) = $db->sql_fetchrow($result)) {
		echo "<li><b><a href=\"modules.php?name=Sections&sop=viewarticle&artid=$seccont_artid\">$title</a></b>"
		._NEWSLETTERSENTON.preg_replace("#([0-9]{4})-([0-9]{2})-([0-9]{2}) ([0-9]{2}):([0-9]{2}):([0-9]{2})#","\\3/\\2/\\1 \\4:\\5:\\6",$date)
		._NEWSLETTERWRITTENBY.$informant."</li>";
	}
	if ($db->sql_numrows($result) != 0) {
		echo "</ul>";
	}
	include ('footer.php');
}

/**
 * Appel des fonctions en fonction du paramtre $sop.
 */
switch($sop) {
	case "list":
		displayListNewsletter();
		break;
	default:
		displayListNewsletter();
		break;
}

?>