var theme = null;
var circuit = null;
var recherche = null;

/**
 * Permet de creer un cookie
 * @param nom le nom
 * @param valeur la valeur
 */
function setCookie(nom, valeur) {
	document.cookie = nom + "=" + encodeURIComponent(valeur) + ";";
}

/**
 * Permet de recuperer la valeur d'un cookie
 * @param nom le nom du cookie
 * @returns la valeur du cookie, null sinon
 */
function getCookie(nom) {
    var oRegex = new RegExp("(?:; )?" + nom + "=([^;]*);?");
    if (oRegex.test(document.cookie)) {
            return decodeURIComponent(RegExp["$1"]);
    } else {
            return null;
    }
}

/**
 * Permet de memoriser les parametres
 */
function memoParamsItineraires() {
	if( document.getElementById('themeItineraire') != null )
		setCookie("themeParam", document.getElementById('themeItineraire').value);
	if( document.getElementById('circuitItineraire') != null )
		setCookie("circuitParam", document.getElementById('circuitItineraire').value);
	if( document.getElementById('recherche') != null )
		setCookie("rechercheParam", document.getElementById('recherche').value);
	setCookie("activeParam", "false");
}

/**
 * Permet la recuperations des parametres
 */
function recupParamsItineraires() {
	var active = getCookie("activeParam");
	if( active == "true" ) {
		theme = getCookie("themeParam");
		circuit = getCookie("circuitParam");
		recherche = getCookie("rechercheParam");
	} else {
		theme = "";
		circuit = "";
		recherche = "";
	}
}

/**
 * Permet de mettre a jour le parametre des cookies
 */
function setParamsCookiesItineraire() {
	setCookie("activeParam", "true");
}

/**
 * Permet d'initialiser les menus (theme, circuit et recherche) par rapport aux cookies
 */
function initMenu() {
	/*if( document.getElementById('themeItineraire') != null )
		document.getElementById('themeItineraire').value = theme;*/
	if( document.getElementById('circuitItineraire') != null )
		document.getElementById('circuitItineraire').value = circuit;
	if( document.getElementById('recherche') != null )
		document.getElementById('recherche').value = recherche;
}