<?php
/**
* Module de gestion dynamique de menu.
* 
* Ce module ne peut tre excut directement dans le Front Office.
* Pour l'utiliser, il dispose de trois fonctions publiques :
* - string getmenu(integer Idmenu) : retourne le code HTML du menu Idmenu
* - string getJS() : retourne le code Javascript  inclure pour certains types de menu
* - string getnavig(integer Idmenu,string TitreNavig) : retourne le code HTML de la barre de navigation correspondant au menu Idmenu avec le titre Titrenavig
* Son inclusion dans le Back Office est automatique, et son accs se trouve dans le menu "Modules"
* @package becmsDynMenu
* @version 1.0
* @author Vincent RUIZ <webmaster@arobase.fr>
* @copyright Copyright  2006, Vincent RUIZ
* @license http://opensource.org/licenses/gpl-license.php GNU Public License 
* @todo Coller d'avantage au look des litings d'lments par l'usage de lignes  couleurs alternes
* @todo Amliorer un peu le formulaire de saisie
* @todo Instancier la notion de menu non public : il ne doit s'afficher que pour les membres inscrits
* @todo Crer des styles de menu par dfaut, et les utiliser si le style du thme n'est pas trouv
*/

if (!preg_match("#modules.php#i", $_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

$module_name = basename(dirname(__FILE__));
get_lang($module_name);

//require_once("core/becms_mainlib_lib.php");
require_once("modules/$module_name/lib/g_params.php");
require_once("modules/$module_name/connector_lib.php");

$Myqsl["maBase"] = $db;
/**
* Affiche le plan correspondant aux menus demands.
* 
* Utilise le fichier "pattern_plan.html" comme modle.
* @param string $typePlan Type de plan  Afficher (seul le 1 est disponible pour l'instant)
* @param string $menus Identifiants des menus  retourner, spars par des virgules (1,4)
* @param string $titre Titre de la page
*/
function displayPlan($typePlan,$menus,$titre) {
	$plan_content = getplan($typePlan,$menus);
    	$plan_title .= $titre;	
	$tmpl_file = "themes/".get_theme()."/pattern_plan.html";
    $content = "";
    if (!file_exists($tmpl_file)) {
	    $content .= "<h1>".$plan_title."</h1>";
	    $content .= $plan_content;
    }
    else {
		$thefile = implode("", file($tmpl_file));
	    $thefile = addslashes($thefile);
	    $thefile = "\$r_file=\"".$thefile."\";";
	    eval($thefile);
	    $r_file = stripslashes($r_file);
	    $content .= $r_file; 
    }
    echo $content;
    adminEditButton("system.php?op=menu&onglet=edit");
}

function displayAllPlans() {
	global $Myqsl;
	$familles = getFamilies($Myqsl);
	$menusTab = array();
	foreach($familles as $famille) {
		$menusTab[] = $famille["Id"];
	}
	$menus = join(",",$menusTab);
	displayPlan("1",$menus,_MENUSTITREALL);
}

function getXML($Id) {
	require_once("connector_lib.php");
	$sortie = getmenuXML($Id);
	header("Content-Type: text/xml; charset=UTF-8");
	echo $sortie;
}

/**
 * Appel des fonctions en fonction du paramtre $sop.
 */

switch($sop) {
    case "display":
    		include ('header.php');
   		//displayPlan("1","1,4","Plan du site");
   		displayPlan($plan_tp,$plan_ms,$plan_titre);
   		include ('footer.php');
	    break;
    case "menuXML":
    		getXML($Id);
    		break;
    default:
    		include ('header.php');
	    //echo "Aucune opration  effectuer n'a t choisie'";
		displayAllPlans();
		include ('footer.php');
	    break;
}
?>
