<?php

/************************************************************************/
/* BALISTE ECMS                                                         */
/* ===========================                                          */
/* Copyright (c) 2004 by Stephan Acquatella (stephan@balistis.com)      */
/* http://www.baliste.org                                               */
/*                                                                      */
/* Enhanced with PHP-NUKE                                               */
/* =======================                                              */
/* Copyright (c) 2002 by Francisco Burzi (fbc@mandrakesoft.com)         */
/* http://phpnuke.org                                                   */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

if (!preg_match("#mobiles.php#i", $_SERVER['PHP_SELF'])) {
	die ("You can't access this file directly...");
}

require_once("core/becms_mainlib_lib.php");

$module_name = basename(dirname(__FILE__));
get_lang($module_name);
require_once("modules/$module_name/utils.php");

function displayAlphabet($thelink,$lettreencours="A"){
    global $db,$prefix;
    $acteurLink=$thelink."&myfilter=";
    
    $lettres = array();
    $result = $db->sql_query("SELECT DISTINCT SUBSTRING(".$prefix."_annuaireacteur_acteur.nom_acteur,1,1) as initiale FROM ".$prefix."_annuaireacteur_acteur order by initiale");
    if ($db->sql_numrows($result)) {
        while($initiale = $db->sql_fetchrow($result)) {
            $lettres[] = $initiale[0];
        }
    }
    
    $alpha = "";
    foreach($lettres as $lettre) {
        $styleenplus = "";
        if ($lettreencours == $lettre) {
            $styleenplus = " select";
        }

        $alpha .= '<a href="'.$acteurLink.$lettre.'" class="btn alpha'.$styleenplus.'">'.$lettre.'</a>';
    }
    return $alpha;
}

function listActeurByChar($myfilter){
    global $sitename, $prefix, $db, $module_name, $Default_Theme;
    
    if ($myfilter == "") $myfilter="A";
    $thefilter = "";
    if ($myfilter != "") {
        $thefilter="WHERE nom_acteur LIKE '\\$myfilter%'";
    }
    $result = $db->sql_query("select * from ".$prefix."_annuaireacteur_acteur $thefilter order by nom_acteur");
    
    if (file_exists('themes/'.$Default_Theme.'/pattern_orgdir_alpha.php')) {
        $result2 = $db->sql_query("SELECT DISTINCT SUBSTRING(".$prefix."_annuaireacteur_acteur.nom_acteur,1,1) as initiale FROM ".$prefix."_annuaireacteur_acteur order by initiale");
        $lettres = array();
        if ($db->sql_numrows($result2)) {
            while($initiale = $db->sql_fetchrow($result2)) {
                $lettres[] = $initiale[0];
            }
        }
        
        $acteurs = array();
        /*while(list($actid, $nom_acteur, $sigle_acteur) = $db->sql_fetchrow($result)) {
            $acteurs[] = array(
                $actid,
                trim($nom_acteur),
                trim($sigle_acteur)
            );
        }*/
        $acteurs = array();
        while($ligne = $db->sql_fetchrow($result)) {
            $acteurs[] = $ligne;
        }
        require_once('themes/'.$Default_Theme.'/pattern_orgdir_alpha.php');
    }
    else {   
        if (file_exists('themes/'.$Default_Theme.'/btn_retour.php')) {
            require_once('themes/'.$Default_Theme.'/btn_retour.php');
        }
        
        $sortie = '<div class="container">';
        $sortie .='<div class="row">
                <div class="grid_12">
                    <h3>Annuaire des acteurs</h3>
                </div>
            </div>
            <div class="row">
                <div class="grid_9">
                    <p class="ta__center"><span class="fwn">Choisissez la premire lettre du nom : </span><br />'        
        .displayAlphabet("mobiles.php?name=$module_name&sop=listActeurByChar",$myfilter).
    '               </p>
                </div>
                <div class="grid_3">
                    <p class="ta__center"><span class="view_5">&nbsp;<br /></span><a href="mobiles.php?name=becmsOrgDirectory&sop=listActeurByCat" class="btn milieu mt5"><i class="fa fa-arrow-right fa-fw fa-lg" aria-hidden="true">&nbsp;</i>RECHERCHE PAR CATGORIE</a></p>
                </div>
            </div>
        </div>';
        
        
        $liste_acteurs = "";
        $liste_temp = "";
        while(list($actid, $nom_acteur, $sigle_acteur) = $db->sql_fetchrow($result)) {
            $sigle_acteur = trim($sigle_acteur);
            $ligne = "<a href=\"mobiles.php?name=$module_name&sop=viewActeur&actid=$actid\" >";
            $ligne .= $nom_acteur;
            if ($sigle_acteur != "") {
                $ligne .= '- <span class="sigle">'.$sigle_acteur . '</span>';
            }
            else {
                $ligne .= '<span class="sigle"></span>';
            }
            $ligne .= "</a>";
            
            $liste_temp .= "<li>".$ligne."</li>";
        }
        $titreresult = '<h4>Initiale "'.$myfilter.'"</h4>';
        $liste_acteurs = ($liste_temp != "") ? '<article class="content_gray"><div class="container"><div class="row"><div class="grid_12">'.$titreresult.'<ul class="list-1 acteurs">'.$liste_temp.'</ul><p>&nbsp;</p></div></div></div></article>' : "";
        
        $sortie .= $liste_acteurs;
        
        $sortie .= $btn_retour;
    }
        
    include("header_mobile.php");
    
    echo utilFuncs_becmsOrgDirectory::conditionnerMobile($sortie);
    
    include ('footer_mobile.php');
}

function displayAccess() {
    global $sitename, $prefix, $db, $module_name, $Default_Theme;
    
    $sortie = '<div class="container">';
    $sortie .='<div class="row">
            <div class="grid_12">
                <h3>Annuaire des acteurs</h3>
            </div>
        </div>
        <div class="row">
            <div class="grid_3 preffix_9">
                <p class="ta__center"><span class="view_5">&nbsp;<br /></span><a href="mobiles.php?name=becmsOrgDirectory&sop=listActeurByChar" class="btn milieu mt5"><i class="fa fa-arrow-right fa-fw fa-lg" aria-hidden="true">&nbsp;</i>RECHERCHE ALPHABTIQUE</a></p>
            </div>
        </div>';
    
    $result = $db->sql_query("select domid, domainename from ".$prefix."_annuaireacteur_liste_domaine order by domainename");
    if ($db->sql_numrows($result) != 0){
        $nbretotal = $db->sql_numrows($result);
        $nbre = ceil($nbretotal/2);
        
        $domaines1 ="<ul class=\"list-1 acteurs\">";
        $domaines2 ="<ul class=\"list-1 acteurs\">";
        $compteur = 1;
        while(list($domid, $domainename) = $db->sql_fetchrow($result)) {
            if ($compteur <= $nbre)  {
                $domaines1.="<li><a href=\"mobiles.php?name=$module_name&amp;sop=listActeurByCat&domid=$domid#acteurs\">".ucfirst($domainename)."</a></li>";
            }
            else {
                $domaines2.="<li><a href=\"mobiles.php?name=$module_name&amp;sop=listActeurByCat&domid=$domid#acteurs\">".ucfirst($domainename)."</a></li>";
            }
            $compteur++;
        }
        $domaines1.="</ul>";
        $domaines2.="</ul>";
    }
    else {
        $domaines1 = "<p>"._ANNULISTNOTHING."</p>";
    }
    
    $sortie .= '
            <div class="row">
                <div class="grid_12"><h4>'._ANNULISTDOMAINCOMP.'</h4></div>
            </div>
            <div class="row">
                <div class="grid_6">
                    '.$domaines1.'
                </div>
                <div class="grid_6">
                    '.$domaines2.'
                </div>
            </div>';
    
    
    $result = $db->sql_query("select typid, type_organisme from ".$prefix."_annuaireacteur_liste_type order by type_organisme");
    if ($db->sql_numrows($result) != 0){
        $nbretotal = $db->sql_numrows($result);
        $nbre = ceil($nbretotal/2);
        
        $categories1 = "<ul class=\"list-1 acteurs\">";
        $categories2 = "<ul class=\"list-1 acteurs\">";
        $compteur = 1;
        while(list($typid, $type_organisme) = $db->sql_fetchrow($result)) {
            if ($compteur <= $nbre)  {
                $categories1 .= "<li><a href=\"mobiles.php?name=$module_name&amp;sop=listActeurByCat&typid=$typid#acteurs\">".ucfirst($type_organisme)."</a></li>";
            }
            else {
                $categories2 .= "<li><a href=\"mobiles.php?name=$module_name&amp;sop=listActeurByCat&typid=$typid#acteurs\">".ucfirst($type_organisme)."</a></li>";
            }
            $compteur++;
        }
        $categories1 .= "</ul>";
        $categories2 .= "</ul>";
    }
    else {
        $categories1 = "<p>"._ANNULISTNOTHING."</p>";
    }
    
    $sortie .= '
            <div class="row">
                <div class="grid_12"><h4>'._ANNULISTTYPEORGA.'</h4></div>
            </div>
            <div class="row">
                <div class="grid_6">
                    '.$categories1.'
                </div>
                <div class="grid_6">
                    '.$categories2.'
                </div>
            </div>';
    
    $sortie .= '</div>';
    
    return $sortie;
}

function liastActeurByCat($typid, $domid) {
    global $sitename, $prefix, $db, $module_name, $Default_Theme;
    
    if (file_exists('themes/'.$Default_Theme.'/pattern_orgdir_cat.php')) {
        $domaines = array();
        $result = $db->sql_query("select domid, domainename from ".$prefix."_annuaireacteur_liste_domaine order by domainename");
        if ($db->sql_numrows($result) != 0){
            while(list($domidb, $domainename) = $db->sql_fetchrow($result)) {
                $domaines[] = array($domidb, $domainename);
            }
        }
        $categories = array();
        $result = $db->sql_query("select typid, type_organisme from ".$prefix."_annuaireacteur_liste_type order by type_organisme");
        if ($db->sql_numrows($result) != 0){
            while(list($typidb, $type_organisme) = $db->sql_fetchrow($result)) {
                $categories[] = array($typidb, $type_organisme);
            }
        }
        $acteurs = array();
        if (!is_null($typid)) {
            if ($typid == "-1") {
                $result2 = $db->sql_query("select type_organisme,typid from ".$prefix."_annuaireacteur_liste_type order by type_organisme asc");
            }
            else {
                $result2 = $db->sql_query("select type_organisme,typid from ".$prefix."_annuaireacteur_liste_type where typid='$typid'");
            }
            if (!$result2) {
                print_r ( $db->sql_error () );
                die('Invalid query');
            }
            while (list($type_organisme,$typid)= $db->sql_fetchrow($result2)) {
                $lacategorie = trim($type_organisme);
                $result = $db->sql_query("select * from ".$prefix."_annuaireacteur_acteur where type_acteur='$typid' order by nom_acteur");
                if (!$result) {
                    print_r ( $db->sql_error () );
                    die('Invalid query');
                }
                if ($db->sql_numrows($result) > 0) {
                    /*while(list($actid, $nom_acteur, $sigle_acteur) = $db->sql_fetchrow($result)) {
                        $acteurs[] = array(
                            $actid,
                            trim($nom_acteur),
                            trim($sigle_acteur)
                        );
                    }*/
                    while($ligne = $db->sql_fetchrow($result)) {
                        $acteurs[] = $ligne;
                    }
                }
            }
        }
        if (!is_null($domid)) {
            if ($domid == "-1") {
                $result2 = $db->sql_query("select domainename,domid from ".$prefix."_annuaireacteur_liste_domaine order by domainename asc ");
            }
            else {
                $result2 = $db->sql_query("select domainename,domid from ".$prefix."_annuaireacteur_liste_domaine where domid='$domid'");
            }
            if (!$result2) {
                print_r ( $db->sql_error () );
                die('Invalid query');
            }
            while (list($domaine,$domid)= $db->sql_fetchrow($result2)) {
                $lacategorie = trim($domaine);
                //$result = $db->sql_query("select ".$prefix."_annuaireacteur_domaine.acteur_actid, ".$prefix."_annuaireacteur_domaine.domaine, ".$prefix."_annuaireacteur_domaine.com_domaine, ".$prefix."_annuaireacteur_acteur.nom_acteur,".$prefix."_annuaireacteur_acteur.sigle_acteur from ".$prefix."_annuaireacteur_domaine inner join ".$prefix."_annuaireacteur_acteur on ".$prefix."_annuaireacteur_domaine.acteur_actid = ".$prefix."_annuaireacteur_acteur.actid where domaine_domid='$domid' order by ".$prefix."_annuaireacteur_acteur.nom_acteur");
                $result = $db->sql_query("select ".$prefix."_annuaireacteur_acteur.* from ".$prefix."_annuaireacteur_domaine inner join ".$prefix."_annuaireacteur_acteur on ".$prefix."_annuaireacteur_domaine.acteur_actid = ".$prefix."_annuaireacteur_acteur.actid where domaine_domid='$domid' order by ".$prefix."_annuaireacteur_acteur.nom_acteur");
                if (!$result) {
                    print_r ( $db->sql_error () );
                    die('Invalid query');
                }
                if ($db->sql_numrows($result) > 0) {
                    /*while(list($actid, $domaine, $com_domaine, $nom_acteur, $sigle_acteur) = $db->sql_fetchrow($result)) {
                        $acteurs[] = array(
                            $actid,
                            trim($nom_acteur),
                            trim($sigle_acteur)
                        );
                        }*/
                    while($ligne = $db->sql_fetchrow($result)) {
                        $acteurs[] = $ligne;
                    }
                }
            }
        }
        require_once('themes/'.$Default_Theme.'/pattern_orgdir_cat.php');
    }
    else {   
        if (file_exists('themes/'.$Default_Theme.'/btn_retour.php')) {
            require_once('themes/'.$Default_Theme.'/btn_retour.php');
        }
        
        $sortie = displayAccess();
        
        if (!is_null($typid) || !is_null($domid)) {
            $withsearch = true;
            $sortie .= '<article class="content_gray"><div class="container">';
        }
        else {
            $sortie .= '<div class="container">';
            $withsearch = false;
        }
        
        if (!is_null($typid)) {
            if ($typid == "-1") {
                $result2 = $db->sql_query("select type_organisme,typid from ".$prefix."_annuaireacteur_liste_type order by type_organisme asc");
            }
            else {
                $result2 = $db->sql_query("select type_organisme,typid from ".$prefix."_annuaireacteur_liste_type where typid='$typid'");
            }
            if (!$result2) {
                print_r ( $db->sql_error () );
                die('Invalid query');
            }
            while (list($type_organisme,$typid)= $db->sql_fetchrow($result2)) {
                $sortie .= '<div class="row"><div class="grid_12"><h4><a name="acteurs"></a>'.ucfirst($type_organisme).'</h4></div></div>';
    
                $result = $db->sql_query("select actid, nom_acteur,sigle_acteur from ".$prefix."_annuaireacteur_acteur where type_acteur='$typid' order by nom_acteur");
                if (!$result) {
                    print_r ( $db->sql_error () );
                    die('Invalid query');
                }
                if ($db->sql_numrows($result) > 0) {
                    $liste_acteurs = "";
                    $liste_temp = "";
                    while(list($actid, $nom_acteur, $sigle_acteur) = $db->sql_fetchrow($result)) {
                        $sigle_acteur = trim($sigle_acteur);
                        $ligne = "<a href=\"mobiles.php?name=$module_name&sop=viewActeur&actid=$actid\" >";
                        $ligne .= $nom_acteur;
                        if ($sigle_acteur != "") {
                            $ligne .= '- <span class="sigle">'.$sigle_acteur . '</span>';
                        }
                        else {
                            $ligne .= '<span class="sigle"></span>';
                        }
                        $ligne .= "</a>";
                        
                        $liste_temp .= "<li>".$ligne."</li>";
                    }
                    $liste_acteurs = ($liste_temp != "") ? ' <div class="row"><div class="grid_12"><ul class="list-1 acteurs">'.$liste_temp.'</ul><p>&nbsp;</p></div></div>' : "";
                    
                    $sortie .= $liste_acteurs;
                }
                else {
                    $sortie .= '<div class="row"><div class="grid_12"><p>'._ANNUNOORGTYPE.'</p></div></div>';
                }
            }
        }
        
        if (!is_null($domid)) {
            if ($domid == "-1") {
                $result2 = $db->sql_query("select domainename,domid from ".$prefix."_annuaireacteur_liste_domaine order by domainename asc ");
            }
            else {
                $result2 = $db->sql_query("select domainename,domid from ".$prefix."_annuaireacteur_liste_domaine where domid='$domid'");
            }
            if (!$result2) {
                print_r ( $db->sql_error () );
                die('Invalid query');
            }
            while (list($domaine,$domid)= $db->sql_fetchrow($result2)) {
                //echo "<h2>".ucfirst($type_organisme)."</h2>";
                $sortie .= '<div class="row"><div class="grid_12"><h4><a name="acteurs"></a>'.ucfirst($domaine).'</h4></div></div>';
                
                $result = $db->sql_query("select ".$prefix."_annuaireacteur_domaine.acteur_actid, ".$prefix."_annuaireacteur_domaine.domaine, ".$prefix."_annuaireacteur_domaine.com_domaine, ".$prefix."_annuaireacteur_acteur.nom_acteur,".$prefix."_annuaireacteur_acteur.sigle_acteur from ".$prefix."_annuaireacteur_domaine inner join ".$prefix."_annuaireacteur_acteur on ".$prefix."_annuaireacteur_domaine.acteur_actid = ".$prefix."_annuaireacteur_acteur.actid where domaine_domid='$domid' order by ".$prefix."_annuaireacteur_acteur.nom_acteur");
                if (!$result) {
                    print_r ( $db->sql_error () );
                    die('Invalid query');
                }
                if ($db->sql_numrows($result) > 0) {
                    $liste_acteurs = "";
                    $liste_temp = "";
                    while(list($actid, $domaine, $com_domaine, $nom_acteur, $sigle_acteur) = $db->sql_fetchrow($result)) {
                        $sigle_acteur = trim($sigle_acteur);
                        $ligne = "<a href=\"mobiles.php?name=$module_name&sop=viewActeur&actid=$actid\" >";
                        $ligne .= $nom_acteur;
                        if ($sigle_acteur != "") {
                            $ligne .= '- <span class="sigle">'.$sigle_acteur . '</span>';
                        }
                        else {
                            $ligne .= '<span class="sigle"></span>';
                        }
                        $ligne .= "</a>";
                        
                        $liste_temp .= "<li>".$ligne."</li>";
                    }
                    $liste_acteurs = ($liste_temp != "") ? ' <div class="row"><div class="grid_12"><ul class="list-1 acteurs">'.$liste_temp.'</ul><p>&nbsp;</p></div></div>' : "";
                    
                    $sortie .= $liste_acteurs;
                }
                else {
                    
                    $sortie .= '<div class="row"><div class="grid_12"><p>'._ANNUNOORGTYPE.'</p></div></div>';
                }
            }
        }
    
        if ($withsearch) {
            $sortie .= '</div></article>';
        }
        else {
            $sortie .= '</div>';
        }
        
        $sortie .= $btn_retour;
    }
    
    include("header_mobile.php");
    
    echo utilFuncs_becmsOrgDirectory::conditionnerMobile($sortie);
    
    include ('footer_mobile.php');
}

function display_line_not_null($libelle,$texte) {
    $texte = trim($texte);
    if ($texte != "") {
        return '<tr><td>'.$libelle.'</td><td>'.$texte.'</td></tr>';
    }
    else {
        return "";
    }
}

function viewActeur($actid) {
    global $sitename, $prefix, $db, $admin, $module_name, $module_name, $Default_Theme;
    
    if (file_exists('themes/'.$Default_Theme.'/btn_retour.php')) {
        require_once('themes/'.$Default_Theme.'/btn_retour.php');
    }
    
    $result = $db->sql_query("select actid, nom_acteur, adresse_acteur, ville_acteur, codepostal_acteur, pays_acteur, sigle_acteur, telephone_acteur, fax_acteur, email_acteur, web_acteur, nom_president_acteur, nom_directeur_acteur, status_acteur, mission_acteur, carte_acteur, type_acteur, projets_acteur   from ".$prefix."_annuaireacteur_acteur where actid='$actid'");
    if (!$result) {
        print_r ( $db->sql_error () );
        die('Invalid query');
    }
    list($actid, $nom_acteur, $adresse_acteur, $ville_acteur, $codepostal_acteur, $pays_acteur, $sigle_acteur, $telephone_acteur, $fax_acteur, $email_acteur, $web_acteur, $nom_president_acteur, $nom_directeur_acteur, $status_acteur, $mission_acteur, $carte_acteur, $type_acteur, $projets_acteur )= $db->sql_fetchrow($result);
    // get information about Competences
    $result2 = $db->sql_query("select domaine from ".$prefix."_annuaireacteur_domaine where acteur_actid='$actid'");
    if (!$result2) {
        print_r ( $db->sql_error () );
        die('Invalid query');
    }
    // get Information about Activities
    $result3 = $db->sql_query("select activite from ".$prefix."_annuaireacteur_activite where acteur_actid='$actid'");
    if (!$result3) {
        print_r ( $db->sql_error () );
        die('Invalid query');
    }
    // get Contacts
    $result4 = $db->sql_query("select nom_contact, prenom_contact, telephone_contact, telephone_mobile_contact, fax_contact, email_contact, web_contact, titre_contact, domaine_contact, role_contact from ".$prefix."_annuaireacteur_contact where acteur_actid='$actid' order by position_contact ");
    if (!$result4) {
        print_r ( $db->sql_error () );
        die('Invalid query');
    }
    $result5 = $db->sql_query("select statusname from ".$prefix."_annuaireacteur_liste_status where statusid='$status_acteur'");
    if (!$result5) {
        print_r ( $db->sql_error () );
        die('Invalid query');
    }
    $result6 = $db->sql_query("select type_organisme from ".$prefix."_annuaireacteur_liste_type where typid='$type_acteur'");
    if (!$result6) {
        print_r ( $db->sql_error () );
        die('Invalid query');
    }
    
    
    list($statusname) = $db->sql_fetchrow($result5);
    list($typename) = $db->sql_fetchrow($result6);
    
    
    if (file_exists('themes/'.$Default_Theme.'/pattern_orgdir_act.php')) {
        
        if (($db->sql_numrows($result2) != 0) || ($db->sql_numrows($result3) != 0)) {
            $domaines = array();
            while(list($domaine) = $db->sql_fetchrow($result2)) {
                $domaines[] = trim($domaine);
            }
            $activites = array();
            while(list($activite) = $db->sql_fetchrow($result3)) {
                $activites[] = trim($activite);
            }
        }
        if ($db->sql_numrows($result4) != 0) {
            $contacts= array();
            while($contact = $db->sql_fetchrow($result4)) {
                $contacts[] = array_map("trim", $contact);
            }
        }
        require_once('themes/'.$Default_Theme.'/pattern_orgdir_act.php');
    }
    else {
        $sortie = '<div class="container">';
        
        if (trim($sigle_acteur) != "") {
            $sigle_acteur = '<div class="text2">'.$sigle_acteur.'</div>';
        }
        else {
            $sigle_acteur = "";
        }
    
        $adresse = '<table cellpadding="0" cellspacing="0" border="0" class="adresse">';
        $adresse .= display_line_not_null(_ADRESSE_ACTEUR,nl2br($adresse_acteur)."<br />".$codepostal_acteur." ".$ville_acteur.((trim($pays_acteur) != "") ? "<br />".trim($pays_acteur) : ""));
        $adresse .= display_line_not_null(_TELEPHONE_ACTEUR,$telephone_acteur);
        $adresse .= display_line_not_null(_FAX_ACTEUR,$fax_acteur);
        $adresse .= display_line_not_null(_EMAIL_ACTEUR,$email_acteur);
        $adresse .= display_line_not_null(_WEB_ACTEUR,$web_acteur);
        $adresse .= display_line_not_null(_STATUS_ACTEUR,$statusname);
        $adresse .= display_line_not_null(_TYPE_ACTEUR,$typename);
        $adresse .= '</table>';
        
        $responsable = "";
        if (trim($nom_president_acteur) != "") {
            $responsable .= '<p class="view_1 view_2">&nbsp;</p>';
            $responsable .= '<div class="text2">';
            $responsable .= _PRESIDENT_ACTEUR;
            $responsable .= '</div>';
            $responsable .= '<p>'.trim($nom_president_acteur).'</p>';
        }
        if (trim($nom_directeur_acteur) != "") {
            $responsable .= '<div class="text2">';
            $responsable .= _DIRECTEUR_ACTEUR;
            $responsable .= '</div>';
            $responsable .= '<p>'.trim($nom_directeur_acteur).'</p>';
        }
        
        
        
        $sortie .= '<div class="row"><div class="grid_12"><h3>'.$nom_acteur.$sigle_acteur.'</h3></div></div>';
        $sortie .= '<div class="row">
            <div class="grid_2">
                <p class="ta__center"><img src="'.$carte_acteur.'"></p>
            </div>
            <div class="grid_6">
                '.$adresse.'
            </div>
            <div class="grid_4">
                '.$responsable.'
            </div>
        </div>';
        
        $sortie .= '<div class="row">
                    <div class="grid_12">
                        <p class="view_3 view_4 view_5">&nbsp;</p>
                    </div>
                </div>';
        
        if ($mission_acteur != "") {
            $sortie .= '<div class="row">
                    <div class="grid_12">
                        <div class="text2">'._MISSION.'</div>
                        <p>'.$mission_acteur.'</p>
                    </div>
                </div>';
        }
        if ($projets_acteur != "") {
            $sortie .= '<div class="row">
                    <div class="grid_12">
                        <div class="text2">'._PROJETS.'</div>
                        <p>'.$projets_acteur.'</p>
                    </div>
                </div>';
        }
        
        if (($db->sql_numrows($result2) != 0) || ($db->sql_numrows($result3) != 0)) {
            $domaine_list = "";
            while(list($domaine) = $db->sql_fetchrow($result2)) {
                $domaine_list .= "<li>$domaine</li>";
            }
            $domaine_list = ($domaine_list != "") ? "<ul>".$domaine_list."</ul>" : "";
            $activite_list = "";
            while(list($activite) = $db->sql_fetchrow($result3)) {
                $activite_list .= "<li>$activite</li>";
            }
            $activite_list = ($activite_list != "") ? "<ul>".$activite_list."</ul>" : "";
            
            if ($domaine_list != "" && $activite_list != "") {
                $sortie .= '<div class="row">
                    <div class="grid_6">
                        <div class="text2">'._DOMAINE_ACTEUR.'</div>
                        '.$domaine_list.'
                    </div>
                    <div class="grid_6">
                        <div class="text2">'._ACTIVITE_ACTEUR.'</div>
                        '.$activite_list.'
                    </div>
                </div>';
            }
            else {
                if ($domaine_list != "") {
                    $sortie .= '<div class="row">
                    <div class="grid_12">
                        <div class="text2">'._DOMAINE_ACTEUR.'</div>
                        '.$domaine_list.'
                    </div>
                </div>';
                }
                if ($activite_list != "") {
                    $sortie .= '<div class="row">
                    <div class="grid_12">
                        <div class="text2">'._ACTIVITE_ACTEUR.'</div>
                        '.$activite_list.'
                    </div>
                </div>';
                }
            }
        }
        
        $sortie .= '</div>';
        
        if ($db->sql_numrows($result4) != 0) {
            $contacts_list = "";
            
            while(list($nom_contact, $prenom_contact, $telephone_contact, $telephone_mobile_contact, $fax_contact, $email_contact, $web_contact, $titre_contact, $domaine_contact, $role_contact) = $db->sql_fetchrow($result4)) {
                $contacts_list .= '<div class="row contact">
                    <div class="grid_3">
                        <div class="fwn mt10 view_1 view_2">'.$nom_contact.' '.$prenom_contact.'</div>
                        <ul class="mt0 view_3 view_4 view_5"><li><span class="fwn">'.$nom_contact.' '.$prenom_contact.'</span></li></ul>
                    </div>
                    <div class="grid_4">
                        '.trim($domaine_contact.' - '.$role_contact.' - '.$titre_contact,' - ').'
                    </div>
                    <div class="grid_2">
                        '.$telephone_contact.'
                    </div>
                    <div class="grid_3">
                        <a href="mailto:'.$email_contact.'">'.$email_contact.'</a>
                    </div>
                </div>';
            }
     
            $sortie .= '
            <article class="content_gray"><div class="container">
                <div class="row">
                    <div class="grid_12">
                        <h4>'._CONTACT.'</h4>
                    </div>
                </div>'.
                $contacts_list.
            '</div></article>';
        }
        
        $sortie .= $btn_retour;
    }
    
    include("header_mobile.php");
    
    echo utilFuncs_becmsOrgDirectory::conditionnerMobile($sortie);
    
    include ('footer_mobile.php');
}

// ------------------------------- SWITCH PART ---------------------------------------------
if (!isset($highlite)) {
	$highlite = "";
}
switch($sop) {
    case "viewActeur":
        viewActeur($actid);
        break;
    case "listActeurByCat":
        liastActeurByCat($typid, $domid);
        break;
    case "listActeurByChar":
    default:
        listActeurByChar($myfilter);
        break;
}

?>