<?php
global $locale;
setlocale(LC_TIME, "$locale");

global $scripts_extra;
	$scripts_extra .= '
<script type="text/javascript" src="themes/'.$Default_Theme.'/js/jquery-ias.min.js"></script>';

function truncate_html($text, $length, $suffix = '&hellip;', $isHTML = true) {
    $i = 0;
    $simpleTags=array('br'=>true,'hr'=>true,'input'=>true,'image'=>true,'link'=>true,'meta'=>true);
    $tags = array();
    if($isHTML){
        preg_match_all('/<[^>]+>([^<]*)/', $text, $m, PREG_OFFSET_CAPTURE | PREG_SET_ORDER);
        foreach($m as $o){
            if($o[0][1] - $i >= $length)
                break;
            $t = substr(strtok($o[0][0], " \t\n\r\0\x0B>"), 1);
            // test if the tag is unpaired, then we mustn't save them
            if($t[0] != '/' && (!isset($simpleTags[$t])))
                $tags[] = $t;
            elseif(end($tags) == substr($t, 1))
                array_pop($tags);
            $i += $o[1][1] - $o[0][1];
        }
    }

    // output without closing tags
    $output = substr($text, 0, $length = min(strlen($text),  $length + $i));
    // closing tags
    $output2 = (count($tags = array_reverse($tags)) ? '</' . implode('></', $tags) . '>' : '');

    // Find last space or HTML tag (solving problem with last space in HTML tag eg. <span class="new">)
    $pos = (int)end(end(preg_split('/<.*>| /', $output, -1, PREG_SPLIT_OFFSET_CAPTURE)));
    // Append closing tags to output
    $output.=$output2;

    // Get everything until last space
    $one = substr($output, 0, $pos);
    // Get the rest
    $two = substr($output, $pos, (strlen($output) - $pos));
    // Extract all tags from the last bit
    preg_match_all('/<(.*?)>/s', $two, $tags);
    // Add suffix if needed
    if (strlen($text) > $length) { $one .= $suffix; }
    // Re-attach tags
    $output = $one . implode($tags[0]);

    //added to remove  unnecessary closure
    $output = str_replace('</!-->','',$output); 

    return $output;
}

function clearDescription($description){
   if (preg_match_all("#(<script[^>]*>)(.*)(</script>)#imsU", $description, $matches)) {
        for ($i=1;$i<count($matches); $i++) {
            $description = str_replace($matches[$i], "", $description);
        }
    }
    //return substr(trim(strip_tags($description)),0, 500);
    return trim(strip_tags(truncate_html($description,500)));
}

function template_section($row, $query){
	
	//artid, secid, title, content, popup
	
    $description = clearDescription($row["content"]);

    $datesql = explode(" ",$row["date"]);
    $datecourte = $datesql[0];
    list($an, $mois, $jour) = explode("-",$datesql[0]);
    $moislong = strftime("%B",mktime(0,0,0,$mois,$jour,$an));

    $href = 'mobiles.php?name=Sections&sop=viewarticle&artid='.$row['artid'].'&highlite='.urlencode($query);

    /*if($row["secid"] == 25){//ID spcifique de la rubrique eleveur
        $href = 'mobiles.php?name=Sections&sop=listarticles&secid=25&idh=192&highlite='.urlencode($query);  
    }
	if($row["secid"] == 28){//ID spcifique de la rubrique membres du comit
        $href = 'mobiles.php?name=Sections&sop=listarticles&secid=28&idh=210&highlite='.urlencode($query);  
    }*/

    return  '
    <div class="itemRecherche grid_12 clear top_36">
	    <h4>
	        <a class="color4" href="'.$href.'">'.$row["title"].'</a>
	    </h4>
	    <div>'.$description.'</div>
	    <div>
	    	<a href="'.$href.'" class="link-1">Lire plus</a>
	    </div>
    </div>';
}

function template_stories($row, $query){
	
	//Champs accessible sid, aid, informant, title, time, hometext, bodytext, a.url, comments, topic
    
	$description = clearDescription($row["hometext"].$row["bodytext"]);

    $datesql = explode(" ",$row["time"]);
    $datecourte = $datesql[0];
    list($an, $mois, $jour) = explode("-",$datesql[0]);
    $moislong = strftime("%B",mktime(0,0,0,$mois,$jour,$an));
    
    $href = 'mobiles.php?name=News&op=viewactu&sid='.$row["sid"].'&highlite='.urlencode($query).'';

    return  
    '<div class="itemRecherche grid_12 clear top_36">
    	<h4><a href="'.$href.'">'.$row["title"].'</a></h4>
    	<p><span class="color2 fwn"><strong>'.$jour." ".$moislong." ".$an.'</strong></span><br>
    	<div>'.$description.'</div>
    	<div><a href="'.$href.'" class="link-1">Lire plus</a></div>
    </div>';
    
}

function template_main($tabResults, $query){
    global $page;  

    /*
        Supprime les modules non voulus 
    */
    $arrayRowSauvee = array();

    foreach($tabResults as $key => $tab){
        if($tab["typeSearch"] == "stories" ||  $tab["typeSearch"] == "sections"){                  
            array_push($arrayRowSauvee, $tab);
        }  
    }

    $tabResults = $arrayRowSauvee;

	foreach ($tabResults as $key => $row) {
        $cpt[$key]  = $row['cpt'];
    }
    array_multisort($cpt, SORT_DESC, $tabResults);    
    
    global $nbrEltSearchListperpage;
    $nbrResultPerPage = $nbrEltSearchListperpage;
    if (!isset($page)) {
		$page = 1;
    }
    
    $nbrresult= count($tabResults);

    if ($nbrresult > $nbrResultPerPage){
        $deb = $nbrResultPerPage * ($page - 1);
        $fin = $nbrResultPerPage * $page;
    }
    else {
        $deb = 0;
        $fin = $nbrresult;
    }

    if($fin >= $nbrresult){
        $fin = $nbrresult;
    }  

    $nombrePage = ceil($nbrresult/ $nbrResultPerPage);
    
    $msortie = '
    <article class="content_gray offset__1">
        <div class="container">
            <div class="row resultatsRecherche">
    			<div class="grid_12"><h3>Rsultats de la recherche</h3></div>';
                for ($i=$deb;$i<$fin;$i++) {
                    if($tabResults[$i]["typeSearch"] == "stories"){
                        $msortie .= template_stories($tabResults[$i], $query);

                    }
                    else if($tabResults[$i]["typeSearch"] == "sections"){
                        $msortie .= template_section($tabResults[$i], $query); 
                    } 
                }
    $msortie .= '
            </div>
        </div>
    </article>';

    $listepages = '<ul id="pagination">';
	for($i=1;$i<=$nombrePage;$i++) {
		$classnext = '';
		if ($page + 1 == $i) {
			$classnext = ' class="next"';
		}
		$listepages .='
        <li'.$classnext.'><a href="mobiles.php?name=Search&query='.$query.'&page='.$i.'">'.$i.'</a></li>';
	}
    $listepages .= '</ul>';
   
    $msortie .= $listepages;
    return $msortie;
}

function template_header($author, $topic ,$type, $query, $days, $min, $max,$category, $secid = ""){
    global $prefix, $db, $multilingual,$queryrlang, $articlecomm ;

    if ($type == "stories") {
    	$styleopts = " style=\"display: none\""; //n'est pas  "" pour en neutraliser l'affichage
    }
    elseif ($type == "comments") {
    	$styleopts = " style=\"display: none\"";
    }
    elseif (($type == "sections") OR ($type == "")) {
    	$styleopts = " style=\"display: none\"";
    }
    elseif ($type == "users") {
    	$styleopts = " style=\"display: none\"";
    }
    elseif ($type == "reviews") {
    	$styleopts = " style=\"display: none\"";
    }
    elseif ($type == "acteurs") {
    	$styleopts = " style=\"display: none\"";
    }
    elseif ($type == "annuaire") {
    	$styleopts = " style=\"display: none\"";
    }
    elseif ($type == "typology") {
    	$styleopts = " style=\"display: none\"";
    }
    elseif ($type == "adherents") {
    	$styleopts = " style=\"display: none\"";
    }
    elseif ($type == "profil") {
    	$styleopts = " style=\"display: none\"";
    }
    elseif ($type == "agenda") {
    	$styleopts = " style=\"display: none\"";
    }


	$msortie .= '
		<div id="page-search">    
        	<div class="container">
        		<div class="row">
        			<div class="grid_12">';

	$msortie .='
		<h4>Rechercher : '.$query.'</h4>
		<form action="mobiles.php?name=Search" method="POST">
			<table cellpadding="0" cellspacing="0" border="0" width="100%" align="center" >
				<tr>
					<td height="60" valign="middle" bgcolor="#fff">
						<input size="25" type="text" name="query" name="query" value="'.$query.'" id="query" type="text" placeholder="Rechercher" autocomplete="off"  >
					</td>
					<td height="60" width="60" valign="middle" bgcolor="#333" align="center">
						<button type="submit">
							<i class="fa fa-search  fa-lg" aria-hidden="true" title="Recherche"></i>
						</button>
					</td>
				</tr>
			</table>';

	$msortie .= '
		<div class="search_options">';

	if(count($type)> 0){
		foreach ($type as $typeCurrent) {
			# code...
			if ($typeCurrent == "stories") {
				$sel1 = "checked";
			}
			elseif ($typeCurrent == "comments") {
				$sel2 = "checked";
			}
			elseif (($typeCurrent == "sections")) {
				$sel3 = "checked";
			}
			elseif ($typeCurrent == "users") {
				$sel4 = "checked";
			}
			elseif ($typeCurrent == "reviews") {
				$sel5 = "checked";
			}
			elseif ($typeCurrent == "acteurs") {
				$sel6 = "checked";
			}
			elseif ($typeCurrent == "annuaire") {
				$sel7 = "checked";
			}
			elseif ($typeCurrent == "typology") {
				$sel8 = "checked";
			}
			elseif ($typeCurrent == "adherents") {
				$sel9 = "checked";
			}
			elseif ($typeCurrent == "profil") {
				$sel10 = "checked";
			}
			elseif ($typeCurrent == "agenda") {
				$sel11 = "checked";
			}
		}
	}
                              
	$num_sec = $db->sql_numrows($db->sql_query("select * from ".$prefix."_sections"));
	$num_rev = $db->sql_numrows($db->sql_query("select * from ".$prefix."_reviews"));

    $msortie .= '
			    			</div>
			    		</form>
			    	</div>
			    </div>
			</div>
		</div>';

	return $msortie;
}

$sortie .= template_header($author, $topic ,$type, $query, $days, $min, $max,$category, $secid);

if($query != ""){
	$sortie .= template_main($arrayResults, $query);
}
?>
