$( document ).ready(function() {
    
    
    /**
     * new editmap(bool coucheSavedAuto)
     *      coucheSavedAuto : true les couches ajoutés manuellements sont "sauvegardés" automatiquement
     * function init({option})
     *      option 
     *          style*
     *              //optionnel, définit les styles par default
     *          buttonsEdition, liste des buttons d'editions
     */
    (map_arob.editmap = new editmap(true)).init({
        stylePolygonDefault: {
            color: "#111111",
            weight: 2,
            fillColor: "#111111",
            fillOpacity: 0.2
        },
        styleBackgroundPolygonDefault : {
            color: "#2e6da4",
            weight: 2,
            fillColor: "#049fff",
            fillOpacity: 0.4
        },
        styleLineStringDefault : {
            color: "#FF2600",
            weight: 5
        },
        buttonsEdition : ["Polygon", "Rectangle", "LineString", "Marker"],
        displayControlBackground : false
    });

    //Centrer la caméra
    map_arob.map.panTo(new L.latLng(43,9));

    //définir le zoom
    map_arob.map.setZoom(7);


    //Redefinit le nom de la capture du screenshot
    map_arob.screenshot.setNameFile("capture.jpg")

    //Pour que le screenshot n'apparaisse pas dans la page
    map_arob.screenshot.imgToDom = function(img){download(img.src, map_arob.screenshot._nameFile );}

    //Evenement lorsqu'une feature est modifié (terminé de modifier)
    map_arob.editmap.changed = function () {
        console.info("map_arob.editmap.changed");
        //Récupérer le géojson de toutes les features modifiés
        console.log(map_arob.editmap.GET_geoJSON());
    }

    //Ajout de la couche des features editable en haut à droite + son nom 
    map_arob.layerControl.addOverlay( map_arob.editmap.theLayers, "Observation", {collapsed: false,autoZIndex: true});

    //Exemple requete ajax récupérer GEOJSON
    $.get( "DATA_SAMPLES/test_j.geojson", function( data ) {

        //Ajout d'un geojson editable 
        map_arob.editmap.SET_EditableGeojson(JSON.parse(data), "newLayers");
        //UImap_arob.Editmap.mGeoJSON = (new GeoJSONParser(map_arob.editmap.GET_geoJSON())).geojson;
        //UImap_arob.Editmap.updateTableVector(false);
    });

    var kml =    L.Control.fileLayerLoad({
        // Allows you to use a customized version of L.geoJson.
        // For example if you are using the Proj4Leaflet leaflet plugin,
        // you can pass L.Proj.geoJson and load the files into the
        // L.Proj.GeoJson instead of the L.geoJson.
        layer: L.geoJson,
        // See http://leafletjs.com/reference.html#geojson-options
        layerOptions: {style: {color:'red'}},
        // Add to map after loading (default: true) ?
        addToMap: true,
        // File size limit in kb (default: 1024) ?
        fileSizeLimit: 1024,
        // Restrict accepted file formats (default: .geojson, .json, .kml, and .gpx) ?
        formats: [
            '.geojson',
            '.kml'
        ]
    }).addTo(map_arob.map);
    kml.loader.on('data:loaded', function(event){
      
        var a = event.layer.toGeoJSON();
        map_arob.map.removeLayer(event.layer);
        map_arob.editmap.SET_EditableGeojson(a,"newLayers");
       
    })
    
    //Ajout d'un geojson en fond non éditable, uniquement opacité
    //Le nom de la couche est dans le geojson "name" au niveau le plus haut
    var t = JSON.parse('\
    {"type":"FeatureCollection",\
    "name" : "La bouche de fond",\
    "features":[{"type":"Feature","properties":{},"geometry":{"type":"Point","coordinates":[9,42]}},{"type":"Feature","properties":{},"geometry":{"type":"Point","coordinates":[9,42.0005]}},{"type":"Feature","properties":{"style":{"color": "#111","weight": 2}},"geometry":{"type":"LineString","coordinates":[[7.163086,43.540585],[9.558105,43.604262],[10.656738,42.948381],[10.557861,41.426253],[9.667969,41.129021]]}},{"type":"Feature","properties":{},"geometry":{"type":"Polygon","coordinates":[[[9.286686,42.642178],[8.836389,42.642178],[8.836389,42.467057],[9.286686,42.467057],[9.286686,42.642178]]]}}]}');
     map_arob.editmap.SET_backgroundGeojson(t);
    map_arob.map.fitBounds(map_arob.editmap.BGLayers.getLayers()[map_arob.editmap.BGLayers.getLayers().length - 1].getBounds())
       

   
});
    
