"use strict";
(function() {
  function Editmap() {
    var _this = this;
    this.latlng = null;

    this._strings = {
      fr: {
        labelMarker : "Marker",
        labelPolygon : "Polygon",
        labelLinestring : "Chemin",
        erreurConversionCheminEnPolygon : "Un chemin doit possèder au moins 3 sommets pour être converti en polygon"
      }
    };

    this.editionCour = null;
    this.featureCour = null;
    this.indexSommet = null;
    this.indexFeature = null;
    this.mGeoJSON = new GeoJSON("FeatureCollection");

    /**
     *
     * @param {string} s retourne un label dans la langue courrante (map_arob.langue)
     */
    this.getString = function(s) {
      return _this._strings[UImap_arob.langue][s];
    };


    this.refreshMap = function(indexFeatureToFocus){
        refreshMap(indexFeatureToFocus);
    }
    function refreshMap(indexFeatureToFocus){
        map_arob.map.removeLayer(map_arob.editmap.theLayers);
        map_arob.editmap.SET_EditableGeojson(UImap_arob.Editmap.mGeoJSON.export(), "theLayers"); 
        if(indexFeatureToFocus != null){
            map_arob.editmap.focusWithIndex("theLayers", indexFeatureToFocus);
        }
    } 

    this.isEditingTheLayers = function(e){
        console.log(e);
    }

    this._isEditingTheLayers = function(){
        var a = false;
        if(UImap_arob.Editmap.editionCour != null){
            a = true;
        }
        _this.isEditingTheLayers(a);
      }

    function V_refreshTableVector(refreshmap){
        if(refreshmap){refreshMap(_this.indexFeature)}
        $("#inputGeojson").val(UImap_arob.Editmap.mGeoJSON.export(true));
        function html(i, nom){
            return '<tr>\
            <td>'+(i+1)+'</td>\
            <td>'+nom+'</td>\
            <td>\
                <button type="button" class="btn btn-default btn-xs _edition" indexFeature="'+i+'"><i class="fa fa-pencil-square" aria-hidden="true"></i></button>\
                &nbsp;&nbsp;<button type="button" class="btn btn-default btn-xs _editionLayerProp" indexFeature="'+i+'"><i class="fa fa-database" aria-hidden="true"></i></button>\
            </td>\
            </tr>';
        }

        $("#UImap_arob_editmap #tableVector tbody").html("");
        if(UImap_arob.Editmap.mGeoJSON.type == "Feature"){
            var f = UImap_arob.Editmap.mGeoJSON.feature;
            if(f.geometry.type == "Point"){ 
                $("#tableVector tbody").append(html(0, _this.getString("labelMarker")));
            }else
            if(f.geometry.type == "LineString"){
               $("#tableVector tbody").append(html(0,  _this.getString("labelLinestring")));
            }else
            if(f.geometry.type == "Polygon"){
               $("#tableVector tbody").append(html(0,  _this.getString("labelPolygon")));
            }
        }else{
            var f = UImap_arob.Editmap.mGeoJSON.featureCollection.getFeatures();
            for(var i = 0, len = f.length; i < len; i++){
                if(f[i].geometry.type == "Point"){ 
                    $("#tableVector tbody").append(html(i, _this.getString("labelMarker")));
                }else
                if(f[i].geometry.type == "LineString"){
                   $("#tableVector tbody").append(html(i, _this.getString("labelLinestring")));
                }else
                if(f[i].geometry.type == "Polygon"){
                   $("#tableVector tbody").append(html(i, _this.getString("labelPolygon")));
                }
            }
        }
        
        UImap_arob.Editmap.cancelCreation();
    }

    function V_refreshTableChemin(){
        $("#UImap_arob_editmap #tablePoint tbody").html("");

        var tabMarker = UImap_arob.Editmap.editionCour.toArray();
        for(var i = 0, len = UImap_arob.Editmap.editionCour._points.length; i < len; i++){
            var p = UImap_arob.Editmap.editionCour._points[i];         
            var s = '<tr>\
            <td>'+(i+1)+'</td>\
            <td>'+p.longitude()+'</td>\
            <td>'+p.latitude()+'</td>\
            <td><button type="button" indexSommet="'+i+'" class="btn btn-default btn-xs _editSommet"><i class="fa fa-pencil-square" aria-hidden="true"></i></button></td>\
            </tr>';
            $("#UImap_arob_editmap #tablePoint tbody").append(s); 
        }
    }

    function V_refreshTablePolygon(){
        $("#UImap_arob_editmap #tablePoint tbody").html("");

        var tabMarker = UImap_arob.Editmap.editionCour.toArray();
        for(var i = 0, len = tabMarker[0].length; i < len; i++){            
            var s = '<tr>\
            <td>'+(i+1)+'</td>\
            <td>'+tabMarker[0][i][0]+'</td>\
            <td>'+tabMarker[0][i][1]+'</td>\
            <td><button type="button" indexSommet="'+i+'" class="btn btn-default btn-xs _editSommet"><i class="fa fa-pencil-square" aria-hidden="true"></i></button></td>\
            </tr>';
            $("#UImap_arob_editmap #tablePoint tbody").append(s); 
        }
    }

    function clickAddMarker(creationPolyOrLine){
        _this.indexSommet = null;
        if(typeof creationPolyOrLine == "undefined" || creationPolyOrLine == null || typeof creationPolyOrLine == "object" ){
            creationPolyOrLine = false;
        }
        UImap_arob.Proj.clearForms();
        //ajout d'un marker 
        if(UImap_arob.Editmap.editionCour == null){
            UImap_arob.Proj.updating = false;
            UImap_arob.Editmap.disableButtonsAdd();
            UImap_arob.Editmap.disableButtonsEdition();
            map_arob.editmap.disableAllEasyButton();
            var geoMarker = new Geometry("Point");
            geoMarker.coordinates = new Point(0,0);
            _this.indexFeature = -1;
            UImap_arob.Editmap.featureCour = UImap_arob.Editmap.mGeoJSON.addFeature({},geoMarker);            
            UImap_arob.Editmap.editionCour = geoMarker.coordinates;
            _this._isEditingTheLayers();
            UImap_arob.Proj.enableForms();
            //V_refreshTableVector(true);
        }else //ajout d'un marker d'un chemin
        if(UImap_arob.Editmap.editionCour instanceof LineString){
            UImap_arob.Proj.updating = false;
            var mPoint = new Point(0,0);
            UImap_arob.Editmap.editionCour.addPoint(mPoint);
            if(!creationPolyOrLine){
                UImap_arob.Proj.point = mPoint;
            }
            V_refreshTableChemin();
        }else
        if(UImap_arob.Editmap.editionCour instanceof Polygon){
            UImap_arob.Proj.updating = false;
            var mPoint = new Point(0,0);
            UImap_arob.Editmap.editionCour.addPoint(mPoint);
            if(!creationPolyOrLine){
                UImap_arob.Proj.point = mPoint;
            }
            V_refreshTablePolygon();
        }
    }

    function clickAddChemin(){
        map_arob.editmap.disableAllEasyButton();
        UImap_arob.Proj.clearForms();
        UImap_arob.Editmap.editionCour = null;_this.indexSommet = null;_this.indexFeature = null;_this._isEditingTheLayers();
        UImap_arob.Editmap.featureCour = null;
        UImap_arob.Proj.updating = false;
        var geoMarker = new Geometry("LineString");
        geoMarker.setGeo([]);
        _this.indexFeature = -1;
        UImap_arob.Editmap.editionCour = geoMarker.coordinates;_this._isEditingTheLayers();
        UImap_arob.Editmap.featureCour = UImap_arob.Editmap.mGeoJSON.addFeature({}, geoMarker);
        UImap_arob.Editmap.disableButtonsAdd();
        UImap_arob.Editmap.disableButtonsEdition();
        $("#UImap_arob_editmap #tablePoint tbody").html("");
        $("#UImap_arob_editmap_editChemin").show();
        clickAddMarker(true);

        //V_refreshTableVector(true);
    }

    function clickAddPolygon(){
        map_arob.editmap.disableAllEasyButton();
        UImap_arob.Proj.clearForms();
        UImap_arob.Editmap.editionCour = null;_this.indexSommet = null;_this.indexFeature = null;_this._isEditingTheLayers();
        UImap_arob.Editmap.featureCour = null;
        _this.updating = false;
        var geoMarker = new Geometry("Polygon");
        _this.indexFeature = -1;
        geoMarker.setGeo([]);
        UImap_arob.Editmap.editionCour = geoMarker.coordinates;_this._isEditingTheLayers();
        UImap_arob.Editmap.featureCour = UImap_arob.Editmap.mGeoJSON.addFeature({}, geoMarker);
        UImap_arob.Editmap.disableButtonsAdd();
        UImap_arob.Editmap.disableButtonsEdition();
        $("#UImap_arob_editmap #tablePoint tbody").html("");
        $("#UImap_arob_editmap_editPolygon").show();
        clickAddMarker(true);
    }

    function clickSaveChemin(){
        V_refreshTableVector(true);
        UImap_arob.Editmap.editionCour = null;_this.indexSommet = null;_this.indexFeature = null;_this._isEditingTheLayers();
        UImap_arob.Editmap.featureCour = null;
        UImap_arob.Editmap.updating = false;
        $("#UImap_arob_editmap_editChemin").hide();
        UImap_arob.Editmap.enableButtonsAdd();
        UImap_arob.Editmap.enableButtonsEdition();
        map_arob.editmap.enableAllEasyButton();
    }

    function clickSavePolygon(){
        V_refreshTableVector(true);
        UImap_arob.Editmap.editionCour = null;_this.indexSommet = null;_this.indexFeature = null;_this._isEditingTheLayers();
        UImap_arob.Editmap.featureCour = null;
        UImap_arob.Editmap.updating = false;
        $("#UImap_arob_editmap_editPolygon").hide();
        UImap_arob.Editmap.enableButtonsAdd();
        UImap_arob.Editmap.enableButtonsEdition();
        map_arob.editmap.enableAllEasyButton();
    }

    this.editmapChange = function(refreshmap){
        V_refreshTableVector(refreshmap);

        if(UImap_arob.Editmap.editionCour == null){
            UImap_arob.Editmap.enableButtonsAdd ();
            UImap_arob.Editmap.enableButtonsEdition();
        }
        UImap_arob.Editmap.editionCour = null;_this.indexSommet = null;_this.indexFeature = null;_this._isEditingTheLayers();
        UImap_arob.Editmap.featureCour = null;
        UImap_arob.Editmap.updating = false;
        
        map_arob.editmap.enableAllEasyButton();
        UImap_arob.Proj.clearForms();
        $("#UImap_arob_editmap_editChemin").hide();
    }
    
    this.updateAjoutPoint = function(x, y){
        if(UImap_arob.Editmap.editionCour instanceof Point){
            UImap_arob.Editmap.editionCour.setLatitude(y);
            UImap_arob.Editmap.editionCour.setLongitude(x);
            V_refreshTableVector(true);
            UImap_arob.Editmap.editionCour = null;_this.indexSommet = null;_this.indexFeature = null;_this._isEditingTheLayers();
            UImap_arob.Editmap.featureCour = null;
            UImap_arob.Editmap.updating = false;
            UImap_arob.Editmap.enableButtonsAdd();
            UImap_arob.Editmap.enableButtonsEdition();
            map_arob.editmap.enableAllEasyButton();
        }else
        if(UImap_arob.Editmap.editionCour instanceof LineString){
            V_refreshTableChemin();
        }else
        if(UImap_arob.Editmap.editionCour instanceof Polygon){
            //UImap_arob.Editmap.editionCour.addPoint(UImap_arob.Proj.point);
            var lengthHuman = _this.editionCour._points.length - 1;
            if(_this.indexSommet == 0  ){
                _this.editionCour._points[lengthHuman] = new Point(_this.editionCour._points[0].longitude(),_this.editionCour._points[0].latitude()) 
                
            }else
            if(_this.indexSommet == (lengthHuman)){
                lengthHuman
                _this.editionCour._points[0] = new Point(_this.editionCour._points[lengthHuman].longitude(),_this.editionCour._points[lengthHuman].latitude()) 
                
            }
            V_refreshTablePolygon();
        }
    }

    this.enableButtonsAdd = function(){
        $("#UImap_arob_editmap_add button").each(function(){
            $(this).removeAttr("disabled")
        });
        $("#UImap_arob_editmap_add").show();
        $("#UImap_arob_editmap_cancel").hide();
    }

    this.disableButtonsAdd = function(){
        $("#UImap_arob_editmap_add button").each(function(){
            $(this).attr("disabled", "")
        });
        $("#UImap_arob_editmap_cancel").show();
        $("#UImap_arob_editmap_add").hide();   
    }

    this.enableButtonsEdition = function(){
        $("#UImap_arob_editmap ._edition").each(function(){
            $(this).removeAttr("disabled")
        });
    }

    this.disableButtonsEdition = function(){
        $("#UImap_arob_editmap ._edition").each(function(){
            $(this).attr("disabled", "")
        }); 
    }

    this.cancelCreation = function(){
        if(typeof UImap_arob.Proj.updating != "undefined"){
            if(!UImap_arob.Proj.updating){
                UImap_arob.Editmap.mGeoJSON.removeFeature(UImap_arob.Editmap.featureCour);
            }
            
        }
        
        UImap_arob.Editmap.editionCour = null;
        _this.indexSommet = null;
        _this.indexFeature = null;
        _this._isEditingTheLayers();
        UImap_arob.Editmap.featureCour = null;
        UImap_arob.Editmap.updating = false;
        UImap_arob.Editmap.enableButtonsAdd();
        UImap_arob.Editmap.enableButtonsEdition();
        map_arob.editmap.enableAllEasyButton();
        UImap_arob.Proj.clearForms();
        UImap_arob.Proj.disableForms(); 
        $("#UImap_arob_editmap_editChemin").hide();
        $("#UImap_arob_editmap_editPolygon").hide();
    }
    this.updateTableVector = function(b){
        V_refreshTableVector(b);
    }

    this.editionVector = function(){

        var index = $(this).attr("indexfeature");
        _this.disableButtonsAdd();
        _this.disableButtonsEdition();
        map_arob.editmap.disableAllEasyButton();
        UImap_arob.Proj.clearForms();
        UImap_arob.Editmap.editionCour = null;_this.indexSommet = null;_this.indexFeature = null;_this._isEditingTheLayers();
        UImap_arob.Editmap.featureCour = null;
        UImap_arob.Editmap.updating = true;
        _this.indexFeature = index;
        var f = UImap_arob.Editmap.mGeoJSON.featureCollection.features[index];
        UImap_arob.Editmap.featureCour = f;

        if(f.geometry.type == "Polygon"){
            UImap_arob.Editmap.editionCour = f.geometry.coordinates;_this._isEditingTheLayers();
            $("#UImap_arob_editmap_editPolygon #tablePoint tbody").html("");
            $("#UImap_arob_editmap_editPolygon").show();
            V_refreshTablePolygon();
        }else
        if(f.geometry.type == "LineString"){
            UImap_arob.Editmap.editionCour = f.geometry.coordinates;_this._isEditingTheLayers();
            $("#UImap_arob_editmap_editChemin #tablePoint tbody").html("");
            $("#UImap_arob_editmap_editChemin").show();
            V_refreshTableChemin();
        }else
        if(f.geometry.type == "Point"){
            //UImap_arob.Editmap.editionCour = f;
            //UImap_arob.Editmap.featureCour = f;
            UImap_arob.Editmap.editionCour = f.geometry.coordinates;_this._isEditingTheLayers();
            $("#UImap_arob_editmap #tablePoint tbody").html("");

            $("#UImap_arob_proj_DDFORM_projection").val($("#UImap_arob_proj_DDFORM_projection option:first").val());
            UImap_arob.Proj.enableForms(); 
            UImap_arob.Proj.point = f.geometry.coordinates;
            UImap_arob.Proj.setLatLng(UImap_arob.Proj.point.latitude(), UImap_arob.Proj.point.longitude());
        }
    }

    this.editionLayerProp = function(){
        var index = $(this).attr("indexfeature");
        map_arob.editLayerProperties.openLayerPropertiesFromObject(index, UImap_arob.Editmap.mGeoJSON.featureCollection.features[index]);
    }

    this.editionSommet = function(){
        var index = $(this).attr("indexSommet");
        UImap_arob.Proj.point = UImap_arob.Editmap.editionCour._points[index];
        _this.indexSommet = index;
        $("#UImap_arob_proj_DDFORM_projection").val($("#UImap_arob_proj_DDFORM_projection option:first").val());
        UImap_arob.Proj.enableForms(); 
        UImap_arob.Proj.setLatLng(UImap_arob.Proj.point.latitude(), UImap_arob.Proj.point.longitude());
    }

    this.convertCheminToPolygon = function(){
        if(UImap_arob.Editmap.editionCour instanceof LineString){
            console.log(_this.indexFeature);

            var mGeoPoly = new Geometry("Polygon");
            var arr = UImap_arob.Editmap.editionCour.toArray();
            if(arr.length == 3){
                arr.push(arr[0]);
            }
            if(arr.length > 3){
                mGeoPoly.coordinates = new Polygon([arr]);
                UImap_arob.Editmap.featureCour = new Feature ({},mGeoPoly); 
                UImap_arob.Editmap.editionCour = mGeoPoly.coordinates;
                UImap_arob.Editmap.mGeoJSON.featureCollection.features[_this.indexFeature] = UImap_arob.Editmap.featureCour;
                clickSaveChemin();
            }else{
                alert(_this.getString("erreurConversionCheminEnPolygon"))
            }
            
        }
    }

    this.convertPolygonToChemin = function(){
        if(UImap_arob.Editmap.editionCour instanceof Polygon){
            console.log(_this.indexFeature);
            var arrayPolyHole = UImap_arob.Editmap.editionCour.toArray();
            for (var i = 0, len = arrayPolyHole.length;i < len; i++){
                var mGeoPoly = new Geometry("LineString");
                var arr = arrayPolyHole[i];
                arr.pop();
                mGeoPoly.coordinates = new LineString(arr);
                if(i == 0){
                    UImap_arob.Editmap.featureCour = new Feature ({},mGeoPoly); 
                    UImap_arob.Editmap.editionCour = mGeoPoly.coordinates;
                    UImap_arob.Editmap.mGeoJSON.featureCollection.features[_this.indexFeature] = UImap_arob.Editmap.featureCour;
                }else{
                    var f = new Feature ({},mGeoPoly);
                    UImap_arob.Editmap.mGeoJSON.featureCollection.features.splice(_this.indexFeature,0,f);
                }
            }
            clickSaveChemin();
        }
    }

    this.private = function() {
        $("body").on("click", "#UImap_arob_editmap ._addMarker", clickAddMarker);
        $("body").on("click", "#UImap_arob_editmap ._addChemin", clickAddChemin);
        $("body").on("click", "#UImap_arob_editmap ._addPolygon", clickAddPolygon);
        $("body").on("click", "#UImap_arob_editmap ._saveChemin", clickSaveChemin);
        $("body").on("click", "#UImap_arob_editmap ._savePolygon", clickSavePolygon);
        $("body").on("click", "#UImap_arob_editmap ._cancel", this.cancelCreation);
        $("body").on("click", "#UImap_arob_editmap ._edition", this.editionVector);
        $("body").on("click", "#UImap_arob_editmap ._editionLayerProp", this.editionLayerProp);
        
        $("body").on("click", "#UImap_arob_editmap ._editSommet", this.editionSommet);
        $("body").on("click", "#UImap_arob_editmap ._convertCheminToPolygon", this.convertCheminToPolygon);
        $("body").on("click", "#UImap_arob_editmap ._convertPolygonToChemin", this.convertPolygonToChemin);
    };

    this.init = function(options){
        if (typeof options == "object") {
            if(typeof options.strings == "object"){
                for (var k in options.strings){
                    for(var kk in options.strings[k]){
                        _this._strings[k][kk] = options.strings[k][kk];
                    };
                }
            }
        }

        UImap_arob.Editmap.private();

    }
  }
  UImap_arob.Editmap = new Editmap();
})();