(function () {
    /**
     * Necessite le plugin leaflet fullscreen
     * Ce plugin ajoute un bouton toggle fullscreen aux controls de la map
     * @constructor
     */
    function fullscreen(){
        /**
         * Init le plugin, ajoute Fullscreen aux controls de la map
         */
        this.private = function(){
            var mmap = map_arob.map;
    
            mmap.addControl( new L.Control.Fullscreen({
                title: {
                    'false': 'Ouvrir Plein écran',
                    'true': 'Fermer Plein écran'
                }
            }));
        }
        /**
         * Toggle le plein écran
         */
        this.toggle = function(){
            map_arob.map.toggleFullscreen();
        }
        
        /**
         * Retourne l'état du plein écran
         */
        this.isFullscreen = function(){
            return map_arob.map.isFullscreen();
        }
    }

    map_arob.fullscreen = new fullscreen();
    map_arob.fullscreen.private();
})();

