
var lonlat_to_decimal = {
    ParseDMS : function(input) {
        var parts = input.split(/[^\d\w\.]+/); 
        var lat = lonlat_to_decimal.ConvertDMSToDD(parts[0], parts[1], parts[2], parts[3]);
        var lng = lonlat_to_decimal.ConvertDMSToDD(parts[4], parts[5], parts[6], parts[7]);
    
        return {
            Latitude : lat,
            Longitude: lng
        }
    },

    ConvertDMSToDD : function(degrees, minutes, seconds, direction) {   
        var dd = Number(degrees) + Number(minutes)/60 + Number(seconds)/(60*60);
    
        if (direction == "S" || direction == "W") {
            dd = dd * -1;
        } // Don't do anything for N or E
        return dd;
    },
     ConvertDDToDMS : function(D, lng){
        return {
            dir : D<0?lng?'W':'S':lng?'E':'N',
            deg : 0|(D<0?D=-D:D),
            min : 0|D%1*60,
            sec :(0|D*60%1*6000)/100
        };
    }
}
/*
console.log(lonlat_to_decimal.ParseDMS("36 °57 '9\" N 110°4'21\" W"));
console.log({lat : lonlat_to_decimal.ConvertDMSToDD(36, 57, 9, "N")});  //degree, minute, seconde, direction ("S" ou "W" sinon "N" ou "E" ou n'importe)
console.log({lon : lonlat_to_decimal.ConvertDMSToDD(110, 4, 21, "W")}); //degree, minute, seconde, direction ("S" ou "W" sinon "N" ou "E" ou n'importe)Ê
console.log({"degre min sec" : lonlat_to_decimal.ConvertDDToDMS(36.9525, false)}); // false pour latitude
console.log({"degre min sec" : lonlat_to_decimal.ConvertDDToDMS(-110.07249999999999, true)}); //true pour longitude
*/