<?php
/************************************************************************/
/* BALISTE ECMS                                                         */
/* ===========================                                          */
/* Copyright (c) 2004 by Stephan Acquatella (stephan@balistis.com)      */
/* http://www.balistis.com                                              */                                           
/*                                                                      */
/*   																	*/
/* Balsite "Annuaire de Acteur" Module . Stephan ACQUATELLA 2004		*/
/* Project: Environmental Corsican observatory       					*/
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

if (!eregi("system.php", $_SERVER['PHP_SELF'])) { die ("Access Denied"); }


if (checkModuleRight("becmsOrgDirectory")) {
setPath(_TXT_Modules,0);
setPath(_ANNUAIRE_AC,1);
/************************** Onglet definition ***********************/
$ongletDef=array("acteur"=> array( "text"=>_ACTEUR,
                                   "url"=>"system.php?op=annuaireActeur&onglet=acteur"),
                 "contact"=> array( "text"=>_ACT_CONTACT,
                                   "url"=>"system.php?op=annuaireActeur&onglet=contact"),          
                 "competence"=> array( "text"=>_ACT_DOMAINE,
                                   "url"=>"system.php?op=annuaireActeur&onglet=competence"),
                 "status"=> array( "text"=>_ACT_STATUS,
                                   "url"=>"system.php?op=annuaireActeur&onglet=status"),
                 "type"=> array( "text"=>_ACT_TYPE,
                                   "url"=>"system.php?op=annuaireActeur&onglet=type")
                                   );
/**
* annuaireActeur()
* Display list of exixting element trought tabs
* @param onglet need to be displayed
* @param acteur id
* @return
* @see
*/
function annuaireActeur($onglet, $editid, $editForm, $myfilter="",$myfiltertwo="") {
global $prefix, $dbi, $language, $multilingual,$ongletDef, $SkinPath;
    include("system/header_system.php");
    GraphicAdmin(_ACTEURADMIN);
    $barDef=array(	"view"=> array( "text"=>_PREVIEW,"icon"=>"icon_eye.gif","url"=>"","comment"=>_PREVIEW, "status"=>"ON"),
    					"edit"=> array( "text"=>_EDIT,"icon"=>"edit_16x16.png", "url"=>"","comment"=>_EDIT, "status"=>"ON"),
  			      	"delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png", "url"=>"","comment"=>_DELETE,"status"=>"ON"));
    //$onglet="acteur";
    if (!isset($onglet)) {
	    $onglet=acteur;
	}
    switch ($onglet) {
	/* -----------------------------------------------------------------*/
	/*              List of All blocks									*/ 
	/* -----------------------------------------------------------------*/
	// ############################## ACTEUR ####################################
	  case "acteur":
	    $thefilter="";
	    if ($myfilter!="") 		$thefilter="WHERE type_acteur='$myfilter'";
	    if ($myfiltertwo!="") 	$thefilter="WHERE nom_acteur LIKE '$myfiltertwo%'";
	    OpenSysTable();
	    $result = sql_query("select actid, nom_acteur, type_acteur, date_acteur from ".$prefix."_annuaireacteur_acteur $thefilter order by nom_acteur", $dbi);
   
	if ($onglet=="") $onglet="sections"; 
	    OpenOngletTable();
		displayOngletBar("acteur",_ACTEURADMIN,$ongletDef);
		displayAlphabet("system.php?op=annuaireActeur&onglet=acteur");
		echo "<table class=lisTable><tr class=systemTabHeader>"
	    	."<td class=systemTabHeader width=\"43%\"><b>"._ACTEUR_NAME."</b></td>"
	    	."<td class=systemTabHeader width=\"25%\"><b>"._ACTEUR_TYPE."</b></td>"
	    	."<td class=systemTabHeader width=\"20%\"><b>"._ACTEUR_DATE."</b></td>"
	    	."<td class=systemTabHeader width=\"17%\"><b>"._FUNCTIONS."</b></td>"
	    	."</tr>";
		
		$pos=0;
		while(list($actid, $nom_acteur, $type_acteur, $date_acteur) = sql_fetch_array($result, $dbi)) {
		if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
		$myresult = sql_query("select type_organisme from ".$prefix."_annuaireacteur_liste_type where typid='$type_acteur'", $dbi);
		list($type_organisme) = sql_fetch_array($myresult, $dbi);
		$sectionLink="<a href=\"system.php?op=annuaireActeur&onglet=contact&myfilter=$actid\" >";
		echo "<tr class=\"$thestyle\">"
		."<td align=\"left\">$sectionLink $nom_acteur</a></td>"
		."<td align=\"center\">$type_organisme</td>"
		."<td align=\"center\">$date_acteur</td>";
		echo "<td  nowrap>";
				$barDef["view"]["url"]="modules.php?name=becmsOrgDirectory&sop=viewActeur&actid=".$actid;
				$barDef["edit"]["url"]="system.php?op=acteurEdit&onglet=acteur&amp;actid=$actid&editForm=1";
				$barDef["delete"]["url"]="system.php?op=acteurDelete&amp;actid=$actid&amp;ok=0";
	    		displayActionBar("add","Bar d'action",$barDef,"img");
		echo "</td></tr>";
		$pos++;
		} // End While
		echo "</table>";
		
        CloseOngletTable();
	    CloseSysTable();
	    
	    OpenSysTable();
	    echo "<SCRIPT language=\"JavaScript\" src=\"javascripts/displayIframe.js\"></SCRIPT>\n";
	    echo "<a href=\"javascript:switchdisplayIFrame('formframe');\">[+] Ajouter un nouvel Acteur</a>";
	    
	    echo acteurEdit($editid,$editForm,1);
		
		CloseSysTable();
	    
	    
      break;
      // ############################## CONTACT ####################################
      case "contact":
        
        $thefilter="";
	    if ($myfilter!="") 		$thefilter="WHERE acteur_actid='$myfilter'";
	    if ($myfiltertwo!="") 	$thefilter="WHERE nom_contact LIKE '$myfiltertwo%'";
	    OpenSysTable();
	    $result = sql_query("select contactid, nom_contact, prenom_contact, acteur_actid, role_contact from ".$prefix."_annuaireacteur_contact $thefilter order by nom_contact", $dbi);
  	
		OpenOngletTable();
		displayOngletBar("contact",_ACTEURADMIN,$ongletDef);
		displayAlphabet("system.php?op=annuaireActeur&onglet=contact");
		echo "<table class=lisTable><tr class=systemTabHeader>"
	    	."<td class=systemTabHeader width=10% >"._CONTACT_NAME."</td>"
	    	."<td class=systemTabHeader width=10% >"._CONTACT_SURNAME."</td>"
	    	."<td class=systemTabHeader width=40% >"._ACTEUR_NAME."</td>"
	    	."<td class=systemTabHeader width=10% >"._CONTACT_ROLE."</td>"
	    	."<td class=systemTabHeader width=10% >"._FUNCTIONS."</td>"
	    	
	    	."</tr>";
		
		$pos=0;
		while(list($contactid, $nom_contact, $prenon_contact, $acteur_actid, $role_contact) = sql_fetch_array($result, $dbi)) {
		if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
		$myresult = sql_query("select nom_acteur from ".$prefix."_annuaireacteur_acteur where actid='$acteur_actid'", $dbi);
		list($nom_acteur) = sql_fetch_array($myresult, $dbi);
		//$sectionLink="<a href=\"system.php?op=annuaireActeur&onglet=contact&contactid=$contactid\" >";
		$iconeacteur="<img src=\"images/smallicone/user.png\">";
		echo "<tr class=\"$thestyle\">"
		."<td align=\"left\">$iconeacteur $nom_contact</td>"
		."<td> $prenon_contact </td>"
		."<td align=\"left\"> $nom_acteur </td>"
		."<td align=\"center\"> $role_contact </td>";
		echo "<td  nowrap>";
				$barDef["edit"]["url"]="system.php?op=contactEdit&amp;onglet=contact&contactid=$contactid&editForm=1";
				$barDef["delete"]["url"]="system.php?op=contactDelete&amp;contactid=$contactid&amp;ok=0";
	    		displayActionBar("add","Bar d'action",$barDef,"img");
		echo "</td></tr>";
			
		$pos++;
		} // End While
		echo "</table>";
		
        CloseOngletTable();
	    CloseSysTable();
	    
	    OpenOngletTable();
	    echo "<SCRIPT language=\"JavaScript\" src=\"javascripts/displayIframe.js\"></SCRIPT>\n";
	    echo "<a href=\"javascript:switchdisplayIFrame('formframe');\">[+] Ajouter un nouveau contact</a>";
	    
		echo contactEdit($editid,$editForm,1);
		
		CloseOngletTable();
	    
	    
      break;
      // ############################## COMPETENCE ####################################
      case "competence":
	    OpenSysTable();
	    $result = sql_query("select domid, domainename from ".$prefix."_annuaireacteur_liste_domaine order by domainename", $dbi);
	    
		OpenOngletTable();
		displayOngletBar("competence",_ACTEURADMIN,$ongletDef);
		
		echo "<br><table class=lisTable><tr class=systemTabHeader>"
	    	."<td class=systemTabHeader>"._DOMAINE_NAME."</td>"
	    	."<td class=systemTabHeader>"._FUNCTIONS."</td>"
	    	."</tr>";
	    	
	    $pos=0;	
	    while(list($domid, $domainename) = sql_fetch_array($result, $dbi)) {
	    if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
		//$sectionLink="<a href=\"system.php?op=annuaireActeur&onglet=competence&domid=$domid\" >";
		echo "<tr class=\"$thestyle\">"
		."<td align=\"left\" > $domainename</td>";
		echo "<td  nowrap>";
				$barDef["edit"]["url"]="system.php?op=annuaireActeur&amp;&onglet=competence&editid=$domid&editForm=1";
				$barDef["delete"]["url"]="system.php?op=competenceDelete&amp;domid=$domid&amp;ok=0";
	    		displayActionBar("add","Bar d'action",$barDef,"img");
		echo "</td></tr>";
		//."<td align=\"center\"><a href=\"system.php?op=annuaireActeur&amp;&onglet=competence&editid=$domid&editForm=1\">[ "._EDIT."</a> | "
		//."<a href=\"system.php?op=competenceDelete&amp;domid=$domid&amp;ok=0\">"._DELETE."</a> ]</td></tr>";
		$pos++;
		} // End While
		echo "</table>";	
		
        CloseOngletTable();
	    CloseSysTable();
	     OpenOngletTable();
	    echo "<SCRIPT language=\"JavaScript\" src=\"javascripts/displayIframe.js\"></SCRIPT>\n";
	    echo "<a href=\"javascript:switchdisplayIFrame('formframe');\">[+] Ajouter un domaine de competence</a>";
	    
		echo competenceEdit($editid,$editForm,1);
		
		if ($editForm=="1") 
		{
			echo "<SCRIPT language=\"JavaScript\">switchdisplayIFrame('formframe');</SCRIPT>\n";
		}
			
		
		 CloseOngletTable();
		
      break;
      // ############################## STATUS ####################################
      case "status":
	    OpenSysTable();
	    $result = sql_query("select statusid, statusname from ".$prefix."_annuaireacteur_liste_status order by statusname", $dbi);
	    
	    OpenOngletTable();
		displayOngletBar("status",_ACTEURADMIN,$ongletDef);
		
		echo "<br><table class=lisTable><tr class=systemTabHeader>"
	    	."<td class=systemTabHeader>"._STATUS_NAME."</td>"
	    	."<td class=systemTabHeader>"._FUNCTIONS."</td>"
	    	."</tr>";
		$pos=0;
		while(list($statusid, $statusname) = sql_fetch_array($result, $dbi)) {
		if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
		//$sectionLink="<a href=\"system.php?op=annuaireActeur&onglet=activite&activiteid=$statusid\" >";
		echo "<tr class=\"$thestyle\">"
		."<td align=\"left\"> $statusname</td>";
		echo "<td  nowrap>";
				$barDef["edit"]["url"]="system.php?op=annuaireActeur&amp;onglet=status&editid=$statusid&editForm=1";
				$barDef["delete"]["url"]="system.php?op=statusDelete&amp;statusid=$statusid&amp;ok=0";
	    		displayActionBar("add","Bar d'action",$barDef,"img");
		echo "</td></tr>";
		//."<td align=\"center\"><a href=\"system.php?op=annuaireActeur&amp;onglet=status&editid=$statusid&editForm=1\">[ "._EDIT."</a> | "
		//."<a href=\"system.php?op=statusDelete&amp;statusid=$statusid&amp;ok=0\">"._DELETE."</a> ]</td></tr>";
		$pos++;
		} // End While
		echo "</table>";
		
        CloseOngletTable();
	    CloseSysTable();
	    
	    OpenOngletTable();
	    echo "<SCRIPT language=\"JavaScript\" src=\"javascripts/displayIframe.js\"></SCRIPT>\n";
	    echo "<a href=\"javascript:switchdisplayIFrame('formframe');\">[+] Ajouter un status</a>";
	    
		echo statusEdit($editid,$editForm,1);
		if ($editForm=="1") 
		{
			echo "<SCRIPT language=\"JavaScript\">switchdisplayIFrame('formframe');</SCRIPT>\n";
		}
		 CloseOngletTable();
	    
      break;
       // ############################## TYPE ####################################
      case "type":
	    OpenSysTable();
	    
	    $result = sql_query("select typid, type_organisme from ".$prefix."_annuaireacteur_liste_type order by type_organisme", $dbi);
	    
	    OpenOngletTable();
		displayOngletBar("type",_ACTEURADMIN,$ongletDef);
		
		echo "<br><table class=lisTable><tr class=systemTabHeader>"
	    	."<td class=systemTabHeader>"._TYPE_NAME."</td>"
	    	."<td class=systemTabHeader>"._FUNCTIONS."</td>"
	    	."</tr>";
		
		$pos=0;
		while(list($typid, $type_organisme) = sql_fetch_array($result, $dbi)) {
		if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
		$sectionLink="<a href=\"system.php?op=annuaireActeur&onglet=acteur&myfilter=$typid\" >";
		echo "<tr class=\"$thestyle\">"
		."<td align=\"left\" >$sectionLink $type_organisme</a></td>";
		echo "<td  nowrap>";
				$barDef["edit"]["url"]="system.php?op=annuaireActeur&amp;onglet=type&editid=$typid&editForm=1";
				$barDef["delete"]["url"]="system.php?op=typeDelete&amp;typid=$typid&amp;ok=0";
	    		displayActionBar("add","Bar d'action",$barDef,"img");
		echo "</td></tr>";
		
		//."<td align=\"center\"><a href=\"system.php?op=annuaireActeur&amp;onglet=type&editid=$typid&editForm=1\">[ "._EDIT."</a> | "
		//."<a href=\"system.php?op=typeDelete&amp;typid=$typid&amp;ok=0\">"._DELETE."</a> ] </td></tr>";
		$pos++;
		} // End While
		echo "</table>";
		
        CloseOngletTable();
	    CloseSysTable();
	    
	    OpenOngletTable();
	    echo "<SCRIPT language=\"JavaScript\" src=\"javascripts/displayIframe.js\"></SCRIPT>\n";
	    echo "<a href=\"javascript:switchdisplayIFrame('formframe');\">[+] Ajouter un type d'organisme</a>";
		
		echo typeEdit($editid,$editForm,1);
		if ($editForm=="1") 
		{
			echo "<SCRIPT language=\"JavaScript\">switchdisplayIFrame('formframe');</SCRIPT>\n";
		}
		CloseOngletTable();
	    
	    
      break;
      
    }// end switch 
   
    include("system/footer_system.php");
}
/**
* acteurEdit()
* Modify fiche datas
* @param acteur id
* @param $editForm if value= 1 form is opened for edition, if value =0 creation mode. Default value 0.
* @param $asHtml if value=0 the form is display by the function. If value =1 metho retrun html code. Default value is 0.
* @return html code of the form : only if asHtml parm is 1.
* @see
*/
function acteurEdit($actid, $editForm=0, $asHtml=0) {
global $prefix, $dbi,$ongletDef;
$domaineArray=array();
if ($editForm){
// get information about Acteur
$result = sql_query("select actid, nom_acteur, adresse_acteur, ville_acteur, codepostal_acteur, sigle_acteur, telephone_acteur, fax_acteur, email_acteur, web_acteur, nom_president_acteur, nom_directeur_acteur, type_acteur, status_acteur, mission_acteur, carte_acteur  from ".$prefix."_annuaireacteur_acteur where actid='$actid'", $dbi);
	if (!$result) {
    	die('Invalid query:'.mysql_error());
	}
list($actid, $nom_acteur, $adresse_acteur, $ville_acteur, $codepostal_acteur, $sigle_acteur, $telephone_acteur, $fax_acteur, $email_acteur, $web_acteur, $nom_president_acteur, $nom_directeur_acteur,$type_acteur, $status_acteur, $mission_acteur, $carte_acteur)= sql_fetch_row($result, $dbi);
// get domaine
$result2 = sql_query("select domaine_domid  from ".$prefix."_annuaireacteur_domaine where acteur_actid='$actid'", $dbi);
	if (!$result) {
    	die('Invalid query:'.mysql_error());
	}
while(list($domaine_domid) = sql_fetch_array($result2, $dbi)) {
	    $domaineArray[]= $domaine_domid;
	    }
}
$acteurForm= "<DIV ID=\"formframe\" CLASS=\"formiframe\" ONCLICK=\"\" >\n"
		."<SCRIPT language=\"JavaScript\" src=\"javascripts/insert.js\"></SCRIPT>\n"
		."<center>"._ADD_NEW_ACTEUR."</center><br>"
	    ."<center><form action=\"system.php\" method=\"post\" name=\"acteur_edit_form\">"
	    ."<input type=\"hidden\" name=\"actid\" value=\"$actid\">"
		."<input type=\"hidden\" name=\"op\" value=\"acteurSave\">"
		."<table class=systemTab>"
		."<tr><td>"._NAME_ACTEUR."</td> "
		."<td><input type=\"text\" name=\"nom_acteur\" size=\"40\" maxlength=\"255\" value=\"$nom_acteur\"></td>"
		."<td rowspan=\"11\" align=\"center\" valign=\"top\">"._DOMAINE_ACTEUR."<br> <select name=\"domaine_acteur[]\" size=\"16\" multiple=\"yes\">";
		
		$myresult = sql_query("select domid, domainename from ".$prefix."_annuaireacteur_liste_domaine order by domainename", $dbi);
		$isSelected="";
		while(list($domid, $domainename) = sql_fetch_array($myresult, $dbi)) {
		if (in_array($domid,$domaineArray)) $isSelected="selected"; else $isSelected="";
		$acteurForm.= "<option value=\"$domid\" $isSelected>$domainename</option>";
		}
		$acteurForm.= "</select>"
		."</td>"
		."</tr>"
		."<tr><td>"._SIGLE_ACTEUR."</td> "
		."<td><input type=\"text\" name=\"sigle_acteur\" size=\"40\" maxlength=\"40\" value=\"$sigle_acteur\"></td>"
		."</tr>"
		."<tr><td>"._REF_ACTEUR."</td> "
		."<td><input type=\"text\" name=\"ref_acteur\" size=\"40\" maxlength=\"40\" value=\"$ref_acteur\"></td>"
		."</tr>"
		."<tr><td>"._ADRESSE_ACTEUR."</td> "
		."<td><!--<input type=\"text\" name=\"adresse_acteur\" size=\"40\" maxlength=\"255\" value=\"$adresse_acteur\">-->
				<textarea cols=\"40\" name=\"adresse_acteur\" rows=\"3\" maxlength=\"255\">$adresse_acteur</textarea></td>"
		."</tr>"
		."<tr><td>"._CITY_ACTEUR."</td> "
		."<td><input type=\"text\" name=\"ville_acteur\" size=\"40\" maxlength=\"80\" value=\"$ville_acteur\"></td>"
		."</tr>"
		."<tr><td>"._POSTALCODE_ACTEUR."</td> "
		."<td><input type=\"text\" name=\"codepostal_acteur\" size=\"40\" maxlength=\"40\" value=\"$codepostal_acteur\"></td>"
		."</tr>"
		."<tr><td>"._TELEPHONE_ACTEUR."</td> "
		."<td><input type=\"text\" name=\"telephone_acteur\" size=\"40\" maxlength=\"40\" value=\"$telephone_acteur\"></td>"
		."</tr>"
		."<tr><td>"._FAX_ACTEUR."</td> "
		."<td><input type=\"text\" name=\"fax_acteur\" size=\"40\" maxlength=\"40\" value=\"$fax_acteur\"></td>"
		."</tr>"
		."<tr><td>"._EMAIL_ACTEUR."</td> "
		."<td><input type=\"text\" name=\"email_acteur\" size=\"40\" maxlength=\"80\" value=\"$email_acteur\"></td>"
		."</tr>"
		."<tr><td>"._WEB_ACTEUR."</td> "
		."<td><input type=\"text\" name=\"web_acteur\" size=\"40\" maxlength=\"255\" value=\"$web_acteur\"></td>"
		."</tr>"
		."<tr><td>"._PRESIDENT_ACTEUR."</td> "
		."<td><input type=\"text\" name=\"nom_president_acteur\" size=\"40\" maxlength=\"255\" value=\"$nom_president_acteur\"></td>"
		."</tr>"
		."<tr><td>"._DIRECTEUR_ACTEUR."</td> "
		."<td colspan=2><input type=\"text\" name=\"nom_directeur_acteur\" size=\"40\" maxlength=\"255\" value=\"$nom_directeur_acteur\"></td>"
		."</tr>"
		."<td>"._TYPE_ACTEUR."</td>"
		."<td colspan=2> <select name=\"type_acteur\" >";
		$isSelected="";
		$myresult = sql_query("select typid, type_organisme from ".$prefix."_annuaireacteur_liste_type order by type_organisme", $dbi);
		while(list($typid, $type_organisme) = sql_fetch_array($myresult, $dbi)) {
		if ($type_acteur==$typid) $isSelected="selected"; else $isSelected="";
		$acteurForm.= "<option value=\"$typid\" $isSelected>$type_organisme</option>";
		}
		$acteurForm.= "</select>"
		."</td></tr>"
		."<td >"._STATUS_ACTEUR." </td>"
		."<td colspan=2> <select name=\"status_acteur\" >";
		$isSelected="";
		$myresult = sql_query("select statusid, statusname from ".$prefix."_annuaireacteur_liste_status order by statusname", $dbi);
		while(list($statusid, $statusname) = sql_fetch_array($myresult, $dbi)) {
		if ($status_acteur==$statusid) $isSelected="selected"; else $isSelected="";
		$acteurForm.= "<option value=\"$statusid\" $isSelected >$statusname</option>";
		}
		$acteurForm.= "</select>"
		."</td></tr>"
		."<tr><td>"._MISSION_ACTEUR."</td> "
		."<td colspan=2> <textarea name=\"mission_acteur\" cols=\"80\" rows=\"10\">$mission_acteur</textarea> </td>"
		."</tr>"
		."<tr><td>"._CARTE_ACTEUR."</td> "
		."<td><input type=\"text\" id=\"myfield\" name=\"carte_acteur\" size=\"40\" maxlength=\"80\" value=\"$carte_acteur\"></td>"
		."<td>";
		//$acteurForm.= "<input type=\"button\" id=\"ins_map\" value=\"Parcourir ...\" Onclick=\"javascript:insert('download')\">";
		$acteurForm.= '
<script type="text/javascript">
function  SetUrl( url ) {
	window.document.forms["acteur_edit_form"].elements["carte_acteur"].value = url;
}
function OpenFileBrowser( url, width, height ) {
	var iLeft = ( screen.availWidth  - width ) / 2 ;
	var iTop  = ( screen.availHeight - height ) / 2 ;

	var sOptions = "toolbar=no,status=no,resizable=yes,dependent=yes,scrollbars=yes" ;
	sOptions += ",width=" + width ;
	sOptions += ",height=" + height ;
	sOptions += ",left=" + iLeft ;
	sOptions += ",top=" + iTop ;

	fenetre = window.open( url, \'FCKBrowseWindow\', sOptions ) ;
	if (! fenetre) {
		alert("Veuillez autorisez les fentres pop-up sur cette page SVP");
	}
}
</script>
';
		$acteurForm .= '<input id="btnBrowse" onclick="OpenFileBrowser(\'javascripts/fckeditor/editor/filemanager/browser/default/browser.html?Connector=connectors/php/connector.php&Type=Image\',eval(screen.availWidth * 0.7),eval(screen.availHeight * 0.7))" type="button" value="Parcourir le serveur" />';
		$acteurForm.= "</td>"
		."</tr>"
		."<tr>"
		."<SCRIPT language=\"JavaScript\" src=\"javascripts/selectbox.js\"></SCRIPT>\n"
		."<td>"._ACTIVITE_ACTEUR."</td>"
		."<td><input type=\"text\" id=\"add_activite\" size=\"60\" maxlength=\"255\" value=\"\"></td>"
		."<td align=\"left\"><input type=\"button\" name=\"add_button\" value=\"Ajouter\" Onclick=\"javascript:addOption(document.getElementById('activite_act'),document.getElementById('add_activite').value,document.getElementById('add_activite').value,false) \"></td>"
		."<tr>"
		."<td></td>"
		."<td class=inputFormL valign=\"top\" colspan=2><select id=\"activite_act\" name=\"activite_acteur[]\" width=60 size=\"8\" multiple=\"yes\">";
		$myresult = sql_query("select activite from ".$prefix."_annuaireacteur_activite where acteur_actid='$actid' order by com_activite", $dbi);
		while(list($activite) = sql_fetch_array($myresult, $dbi)) {
			$acteurForm.= "<option value=\"$activite\" >$activite</option>";
		}
		$acteurForm.="</select>"
		."<input type=\"button\" id=\"del_button\" value=\"Effacer\" Onclick=\"javascript:removeSelectedOptions(document.getElementById('activite_act'))\"></td>"
		."</tr>";
		$acteurForm .= "</table>"
		."\n <br>"
		."<input type=\"submit\" value=\""._SAVECHANGES."\" Onclick=\"javascript:selectAllOptions(document.getElementById('activite_act'))\"> [ <a href=\"system.php?op=acteurDelete&actid=".$actid."&ok=0\">"._DELETE."</a> ]"
		."</form></center>"
		."</DIV>";

if ($asHtml) {
   return $acteurForm;
}else {
	include("system/header_system.php");
    GraphicAdmin(_ACTEURADMIN);
    OpenOngletTable();
    
	echo "<div align=\"right\">";
		displayOngletBar('acteur',_ACTEURADMIN,$ongletDef);
		echo "</div>";
	 	echo $acteurForm;
	 	echo "<SCRIPT language=\"JavaScript\" src=\"javascripts/displayIframe.js\"></SCRIPT>\n";
	    echo "<SCRIPT language=\"JavaScript\">switchdisplayIFrame('formframe');</SCRIPT>\n";
	 
	 CloseOngletTable();
	 include("system/footer_system.php");
}// if else
}
/**
* contactEdit()
* Modify contact data's
* @param conatct id
* @return
* @see
*/
function contactEdit($contactid, $editForm=0, $asHtml=0) {
global $prefix, $dbi,$ongletDef;
if ($editForm){
// get information about Acteur
$result = sql_query("select contactid, acteur_actid, nom_contact, prenom_contact, telephone_contact, telephone_mobile_contact,  fax_contact, email_contact, web_contact, titre_contact, domaine_contact, position_contact, role_contact  from ".$prefix."_annuaireacteur_contact where contactid='$contactid'", $dbi);
	if (!$result) {
    	die('Invalid query:'.mysql_error());
	}
list($contactid, $acteur_actid, $nom_contact, $prenom_contact, $telephone_contact, $telephone_mobile_contact,  $fax_contact, $email_contact, $web_contact, $titre_contact, $domaine_contact, $position_contact, $role_contact)= sql_fetch_row($result, $dbi);
}
if ($editForm==0) $contactid=""; // force id to null 
$formframe="<DIV ID=\"formframe\" CLASS=\"formiframe\" ONCLICK=\"\" >\n"
	    ."<center>"._ADD_NEW_CONTACT."</center><br>"
	    ."<center><form action=\"system.php\" method=\"post\">"
	    ."<input type=\"hidden\" name=\"contactid\" value=\"$contactid\">"
		."<input type=\"hidden\" name=\"op\" value=\"contactSave\">"
		."<table class=systemTab>"
		."<tr><td>"._NAME_CONTACT."</td> "
		."<td><input type=\"text\" name=\"nom_contact\" size=\"40\" maxlength=\"40\" value=\"$nom_contact\"></td>"
		."<td rowspan=\"11\" align=\"center\" valign=\"top\">"._ACTEUR_CONTACT."<br> <select name=\"acteur_actid\" size=\"16\">";
		
		$myresult = sql_query("select actid, nom_acteur from ".$prefix."_annuaireacteur_acteur order by nom_acteur", $dbi);
		while(list($actid, $nom_acteur) = sql_fetch_array($myresult, $dbi)) {
		$isSelected="";
		if ($actid==$acteur_actid) $isSelected="selected";
		$formframe.= "<option value=\"$actid\" $isSelected>$nom_acteur</option>";
		}
		$formframe.= "</select>"
		."</td></tr>"
		."<tr><td>"._SURNAME_CONTACT."</td> "
		."<td><input type=\"text\" name=\"prenom_contact\" size=\"40\" maxlength=\"40\" value=\"$prenom_contact\"></td>"
		."</tr>"
		."<tr><td>"._PHONENUMBER_CONTACT."</td> "
		."<td><input type=\"text\" name=\"telephone_contact\" size=\"40\" maxlength=\"40\" value=\"$telephone_contact\"></td>"
		."</tr>"
		."<tr><td>"._MOBILEPHONE_CONTACT."</td> "
		."<td><input type=\"text\" name=\"telephone_mobile_contact\" size=\"40\" maxlength=\"40\" value=\"$telephone_mobile_contact\"></td>"
		."</tr>"
		."<tr><td>"._FAX_CONTACT."</td> "
		."<td><input type=\"text\" name=\"fax_contact\" size=\"40\" maxlength=\"40\" value=\"$fax_contact\"></td>"
		."</tr>"
		."<tr><td>"._EMAIL_CONTACT."</td> "
		."<td><input type=\"text\" name=\"email_contact\" size=\"40\" maxlength=\"40\" value=\"$email_contact\"></td>"
		."</tr>"
		."<tr><td>"._WEB_CONTACT."</td> "
		."<td><input type=\"text\" name=\"web_contact\" size=\"40\" maxlength=\"40\" value=\"$web_contact\"></td>"
		."</tr>"
		."<tr><td>"._TITLE_CONTACT."</td> "
		."<td><input type=\"text\" name=\"titre_contact\" size=\"40\" maxlength=\"40\" value=\"$titre_contact\"></td>"
		."</tr>"
		."<tr><td>"._DOMAINE_CONTACT."</td> "
		."<td><input type=\"text\" name=\"domaine_contact\" size=\"40\" maxlength=\"40\" value=\"$domaine_contact\"></td>"
		."</tr>"
		."<tr><td>"._POSITION_CONTACT."</td> "
		."<td><input type=\"text\" name=\"position_contact\" size=\"40\" maxlength=\"40\" value=\"$position_contact\"></td>"
		."</tr>"
		."<tr><td>"._ROLE_CONTACT."</td> "
		."<td><input type=\"text\" name=\"role_contact\" size=\"40\" maxlength=\"40\" value=\"$role_contact\"></td>"
		."</tr>"
		."</table>"
		."\n <br><br>"
		."<input type=\"submit\" value=\""._SAVECHANGES."\"> [ <a href=\"system.php?op=contactDelete&amp;contactid=$contactid&amp;ok=0\">"._DELETE."</a> ]"
		."</form></center>"
		."</DIV>";
if ($asHtml) {
   return $formframe;
}else {
	include("system/header_system.php");
    GraphicAdmin(_ACTEURADMIN);
    OpenOngletTable();
		echo "<div align=\"right\">";
		displayOngletBar('contact',_ACTEURADMIN,$ongletDef );
		echo "</div>";
	 	echo $formframe;
	 	echo "<SCRIPT language=\"JavaScript\" src=\"javascripts/displayIframe.js\"></SCRIPT>\n";
	    echo "<SCRIPT language=\"JavaScript\">switchdisplayIFrame('formframe');</SCRIPT>\n";
	 CloseOngletTable();
	 include("system/footer_system.php");
}// if else
}
/**
* competenceEdit()
* Modify Competences data's
* @param competence id
* @return
* @see
*/
function competenceEdit($domid,$editForm=0, $asHtml=0) {
global $prefix, $dbi;
if ($editForm){
// get information about Acteur
$result = sql_query("select  domainename  from ".$prefix."_annuaireacteur_liste_domaine where domid='$domid'", $dbi);
	if (!$result) {
    	die('Invalid query:'.mysql_error());
	}
list($domainename)= sql_fetch_row($result, $dbi);
}
if ($editForm==0) $domid=""; // force id to null 
$formframe="<DIV ID=\"formframe\" CLASS=\"formiframe\" ONCLICK=\"\" >\n"
	    ."<center>"._ADD_NEW_COMPETENCE."</center><br>"
	    ."<form action=\"system.php\" method=\"post\">"
	    ."<input type=\"hidden\" name=\"domid\" value=\"$domid\">"
		."<input type=\"hidden\" name=\"op\" value=\"competenceSave\">"
		.""._DOMAINE_NAME." "
		."<input type=\"text\" name=\"domainename\" size=\"40\" maxlength=\"255\" value=\"$domainename\">"
		."\n <br><br>"
		."<input type=\"submit\" value=\""._SAVECHANGES."\"> [ <a href=\"system.php?op=competenceDelete&amp;secid=$domid&amp;ok=0\">"._DELETE."</a> ]"
		."</form>"
		."</DIV>";
if ($asHtml) {
   return $formframe;
}else {
	include("system/header_system.php");
    GraphicAdmin();
    echo "<table width=\"100%\" border=\"0\">"
		."<tr>"
        ."<td height=\"139\" align=\"center\" valign=\"top\" bgcolor=\"#ece9d8\">"
		."<div align=\"right\">";
		displayOnglet('competence',_BLOCKSADMIN_TXT);
		echo "</div>";
	 	echo $formframe;
	 	echo "<SCRIPT language=\"JavaScript\" src=\"javascripts/displayIframe.js\"></SCRIPT>\n";
	    echo "<SCRIPT language=\"JavaScript\">switchdisplayIFrame('formframe');</SCRIPT>\n";
	 	echo "</td></tr></table>";
	 include("system/footer_system.php");
}// if else	

}

/**
* statusEdit()
* Modify Status data's 
* @param statusid id
* @return
* @see
*/
function statusEdit($statusid,$editForm=0, $asHtml=0) {
global $prefix, $dbi;
if ($editForm){
// get information about Acteur
$result = sql_query("select  statusname  from ".$prefix."_annuaireacteur_liste_status where statusid='$statusid'", $dbi);
	if (!$result) {
    	die('Invalid query:'.mysql_error());
	}
list($statusname)= sql_fetch_row($result, $dbi);
}
if ($editForm==0) $statusid=""; // force id to null 
$formframe="<DIV ID=\"formframe\" CLASS=\"formiframe\" ONCLICK=\"\" >\n"
	    ."<center>"._ADD_NEW_STATUS."</center><br>"
	    ."<form action=\"system.php\" method=\"post\">"
	    ."<input type=\"hidden\" name=\"statusid\" value=\"$statusid\">"
		."<input type=\"hidden\" name=\"op\" value=\"statusSave\">"
		.""._STATUS_NAME." "
		."<input type=\"text\" name=\"statusname\" size=\"40\" maxlength=\"40\" value=\"$statusname\">"
		."\n <br><br>"
		."<input type=\"submit\" value=\""._SAVECHANGES."\"> [ <a href=\"system.php?op=statusDelete&amp;secid=$domid&amp;ok=0\">"._DELETE."</a> ]"
		."</form>"
		."</DIV>";
if ($asHtml) {
   return $formframe;
}else {
	include("system/header_system.php");
    GraphicAdmin();
    echo "<table width=\"100%\" border=\"0\">"
		."<tr>"
        ."<td height=\"139\" align=\"center\" valign=\"top\" bgcolor=\"#ece9d8\">"
		."<div align=\"right\">";
		displayOnglet('status',_BLOCKSADMIN_TXT);
		echo "</div>";
	 	echo $formframe;
	 	echo "<SCRIPT language=\"JavaScript\" src=\"javascripts/displayIframe.js\"></SCRIPT>\n";
	    echo "<SCRIPT language=\"JavaScript\">switchdisplayIFrame('formframe');</SCRIPT>\n";
	 	echo "</td></tr></table>";
	 include("system/footer_system.php");
}// if else			
}
/**
* typeEdit()
* Modify type of organism data's 
* @param typid activiy id
* @return
* @see
*/
function typeEdit($typid, $editForm=0, $asHtml=0) {
global $prefix, $dbi;
if ($editForm){
// get information about Acteur
$result = sql_query("select  type_organisme  from ".$prefix."_annuaireacteur_liste_type where typid='$typid'", $dbi);
	if (!$result) {
    	die('Invalid query:'.mysql_error());
	}
list($type_organisme)= sql_fetch_row($result, $dbi);
}
if ($editForm==0) $typid=""; // force id to null 
$formframe="<DIV ID=\"formframe\" CLASS=\"formiframe\" ONCLICK=\"\" >\n"
	    ."<center>"._ADD_NEW_TYPE."</center><br>"
	    ."<form action=\"system.php\" method=\"post\">"
	    ."<input type=\"hidden\" name=\"typid\" value=\"$typid\">"
		."<input type=\"hidden\" name=\"op\" value=\"typeSave\">"
		.""._TYPE_NAME." "
		."<input type=\"text\" name=\"typename\" size=\"50\" maxlength=\"255\" value=\"$type_organisme\">"
		."\n <br><br>"
		."<input type=\"submit\" value=\""._SAVECHANGES."\"> [ <a href=\"system.php?op=typeDelete&amp;secid=$domid&amp;ok=0\">"._DELETE."</a> ]"
		."</form>"
		."</DIV>";
if ($asHtml) {
   return $formframe;
}else {
	include("system/header_system.php");
    GraphicAdmin();
    OpenOngletTable();
		echo "<div align=\"right\">";
		displayOnglet('type',_BLOCKSADMIN_TXT);
		echo "</div>";
	 	echo $formframe;
	 	echo "<SCRIPT language=\"JavaScript\" src=\"javascripts/displayIframe.js\"></SCRIPT>\n";
	    echo "<SCRIPT language=\"JavaScript\">switchdisplayIFrame('formframe');</SCRIPT>\n";
	 CloseOngletTable();
	 include("system/footer_system.php");
}// if else			
}
/**
* activiteDelete()
* delete an activity
* @param activity id
* @param if value is 1 data are erased, else ask for confirmation. default value is 0.
* @return
* @see
*/
function activiteDelete($activiteid, $ok=0) {
global $prefix, $dbi;
    if ($ok==1) {
        sql_query("delete from ".$prefix."_annuaireacteur_activite where activiteid='$activiteid'", $dbi);        
        Header("Location: system.php?op=annuaireActeur&onglet=acteur");
    } else {
        include("system/header_system.php");
        GraphicAdmin();
	OpenSysTable();
	echo "<center><font class=\"title\"><b>"._ACTIVITEADMIN_TXT."</b></font></center>";
	CloseSysTable();
	echo "<br>";
	$result=sql_query("select activite from ".$prefix."_annuaireacteur_activite where activiteid='$activiteid'", $dbi);
	list($typename) = sql_fetch_row($result, $dbi);
	OpenSysTable();
	echo "<center><b>"._DELACTIVITE.": $activite</b><br><br>"
	    .""._DELACTIVITEWARNING." $activite?<br>"
	    .""._DELACTIVITEWARNING1."<br><br>"
	    ."[ <a href=\"system.php?op=annuaireActeur&onglet=acteur\">"._NO."</a> | <a href=\"system.php?op=activiteDelete&activiteid=".$activiteid."&ok=1\">"._YES."</a> ]</center>";
	CloseSysTable();
        include("system/footer_system.php");
    }
}
/**
* contactDelete()
* delete a contact
* @param conatct id
* @param if value is 1 data are erased, else ask for confirmation. default value is 0.
* @return
* @see
*/
function contactDelete($contactid, $ok=0) {
global $prefix, $dbi;
    if ($ok==1) {
        sql_query("delete from ".$prefix."_annuaireacteur_contact where contactid='$contactid'", $dbi);
        Header("Location: system.php?op=annuaireActeur&onglet=contact");
    } else {
        include("system/header_system.php");
        GraphicAdmin();
	OpenSysTable();
	echo "<center><font class=\"title\"><b>"._CONTACTADMIN_TXT."</b></font></center>";
	CloseSysTable();
	echo "<br>";
	$result=sql_query("select nom_contact, prenom_contact from ".$prefix."_annuaireacteur_contact where contactid='$contactid'", $dbi);
	list($nom_contact, $prenom_contact) = sql_fetch_row($result, $dbi);
	OpenSysTable();
	echo "<center><b>"._DELCONTACT.": $nom_contact $prenom_contact</b><br><br>"
	    .""._DELCONTACTWARNING." $nom_contact $prenom_contact ?<br>"
	    .""._DELCONTACTWARNING1."<br><br>"
	    ."[ <a href=\"system.php?op=annuaireActeur&onglet=contact\">"._NO."</a> | <a href=\"system.php?op=contactDelete&contactid=".$contactid."&ok=1\">"._YES."</a> ]</center>";
	CloseSysTable();
        include("system/footer_system.php");
    }
}
/**
* competenceDelete()
* delete a competences
* @param domid domaine de competence id
* @param if value is 1 data are erased, else ask for confirmation. default value is 0.
* @return
* @see
*/
function competenceDelete($domid, $ok=0) {
global $prefix, $dbi;
    if ($ok==1) {
        sql_query("delete from ".$prefix."_annuaireacteur_liste_domaine where domid='$domid'", $dbi);
        sql_query("delete from ".$prefix."_annuaireacteur_domaine where domaine_domid='$domid'", $dbi);
        Header("Location: system.php?op=annuaireActeur&onglet=competence");
    } else {
        include("system/header_system.php");
        GraphicAdmin();
	OpenSysTable();
	echo "<center><font class=\"title\"><b>"._COMPTENCEADMIN_TXT."</b></font></center>";
	CloseSysTable();
	echo "<br>";
	$result=sql_query("select domainename from ".$prefix."_annuaireacteur_liste_domaine where domid='$domid'", $dbi);
	list($domainename) = sql_fetch_row($result, $dbi);
	OpenSysTable();
	echo "<center><b>"._DELDOMAINE.": $domainename</b><br><br>"
	    .""._DELCOMPWARNING." $domainename?<br>"
	    .""._DELCOMPWARNING1."<br><br>"
	    ."[ <a href=\"system.php?op=annuaireActeur&onglet=competence\">"._NO."</a> | <a href=\"system.php?op=competenceDelete&domid=".$domid."&ok=1\">"._YES."</a> ]</center>";
	CloseSysTable();
        include("system/footer_system.php");
    }
}
/**
* acteurDelete
* delete an acteur in DB
* @param acteur id
* @param if value is 1 data are erased, else ask for confirmation. default value is 0.
* @return
* @see
*/
function acteurDelete($actid, $ok=0) {
global $prefix, $dbi;
    if ($ok==1) {
        sql_query("delete from ".$prefix."_annuaireacteur_acteur where actid='$actid'", $dbi);
        sql_query("delete from ".$prefix."_annuaireacteur_domaine where acteur_actid='$actid'", $dbi);
        sql_query("delete from ".$prefix."_annuaireacteur_activite where acteur_actid='$actid'", $dbi);
        sql_query("delete from ".$prefix."_annuaireacteur_contact where acteur_actid='$actid'", $dbi);
        Header("Location: system.php?op=annuaireActeur&onglet=acteur");
    } else {
        include("system/header_system.php");
        GraphicAdmin();
	OpenSysTable();
	echo "<center><font class=\"title\"><b>"._ACTEURADMIN_TXT."</b></font></center>";
	CloseSysTable();
	echo "<br>";
	$result=sql_query("select nom_acteur from ".$prefix."_annuaireacteur_acteur where actid='$actid'", $dbi);
	list($nom_acteur) = sql_fetch_row($result, $dbi);
	OpenSysTable();
	echo "<center><b>"._DELACTEUR.": $nom_acteur</b><br><br>"
	    .""._DELACTEURWARNING." $nom_acteur?<br>"
	    .""._DELACTEURWARNING1."<br><br>"
	    ."[ <a href=\"system.php?op=annuaireActeur&onglet=acteur\">"._NO."</a> | <a href=\"system.php?op=acteurDelete&actid=".$actid."&ok=1\">"._YES."</a> ]</center>";
	CloseSysTable();
        include("system/footer_system.php");
    }
}

/**
* typeDelete
* delete an type in DB
* @param typid type of organism id
* @param if value is 1 data are erased, else ask for confirmation. default value is 0.
* @return
* @see
*/
function typeDelete($typid, $ok=0) {
global $prefix, $dbi;
    if ($ok==1) {
        sql_query("delete from ".$prefix."_annuaireacteur_liste_type where typid='$typid'", $dbi);        
        Header("Location: system.php?op=annuaireActeur&onglet=type");
    } else {
        include("system/header_system.php");
        GraphicAdmin();
	OpenSysTable();
	echo "<center><font class=\"title\"><b>"._TYPEADMIN_TXT."</b></font></center>";
	CloseSysTable();
	echo "<br>";
	$result=sql_query("select type_organisme from ".$prefix."_annuaireacteur_liste_type where typid='$typid'", $dbi);
	list($type_organisme) = sql_fetch_row($result, $dbi);
	OpenSysTable();
	echo "<center><b>"._DELDOMAINE.": $type_organisme</b><br><br>"
	    .""._DELTYPEWARNING." $type_organisme?<br>"
	    .""._DELTYPEWARNING1."<br><br>"
	    ."[ <a href=\"system.php?op=annuaireActeur&onglet=type\">"._NO."</a> | <a href=\"system.php?op=typeDelete&typid=".$typid."&ok=1\">"._YES."</a> ]</center>";
	CloseSysTable();
        include("system/footer_system.php");
    }
}
/**
* statusDelete
* delete an status data in DB
* @param statusid type of organism id
* @param ok if value is 1 data are erased, else ask for confirmation. default value is 0.
* @return
* @see
*/
function statusDelete($statusid, $ok=0) {
global $prefix, $dbi;
    if ($ok==1) {
        sql_query("delete from ".$prefix."_annuaireacteur_liste_status where statusid='$statusid'", $dbi);        
        Header("Location: system.php?op=annuaireActeur&onglet=status");
    } else {
        include("system/header_system.php");
        GraphicAdmin();
	OpenSysTable();
	echo "<center><font class=\"title\"><b>"._STATUSADMIN_TXT."</b></font></center>";
	CloseSysTable();
	echo "<br>";
	$result=sql_query("select statusname from ".$prefix."_annuaireacteur_liste_status where statusid='$statusid'", $dbi);
	list($typename) = sql_fetch_row($result, $dbi);
	OpenSysTable();
	echo "<center><b>"._DELSTATUS.": $statusname</b><br><br>"
	    .""._DELSTATUSWARNING." $statusname?<br>"
	    .""._DELSTATUSWARNING1."<br><br>"
	    ."[ <a href=\"system.php?op=annuaireActeur&onglet=status\">"._NO."</a> | <a href=\"system.php?op=statusDelete&statusid=".$statusid."&ok=1\">"._YES."</a> ]</center>";
	CloseSysTable();
        include("system/footer_system.php");
    }
}
/**
* acteurSave()
* save all information about an acteur in DB 
* @param acid :acteur id
* @param array acteurData :Associative Array that containe field name and data value
* @return
* @see
*/
function acteurSave($actid,$refid, $nom_acteur,$adresse_acteur,$ville_acteur,$codepostal_acteur,$sigle_acteur,$telephone_acteur,$fax_acteur,$email_acteur,$web_acteur,$nom_president_acteur,$nom_directeur_acteur,$type_acteur,$status_acteur,$mission_acteur,$carte_acteur,$domaine_acteur, $activite_acteur) {
global $prefix, $dbi;

// $deb=new debug;

 $refid = stripslashes(FixQuotes($refid));
 $nom_acteur = stripslashes(FixQuotes($nom_acteur));
 $adresse_acteur = stripslashes(FixQuotes($adresse_acteur));
 $ville_acteur = stripslashes(FixQuotes($ville_acteur));
 $codepostal_acteur = stripslashes(FixQuotes($codepostal_acteur));
 $sigle_acteur = stripslashes(FixQuotes($sigle_acteur));
 $telephone_acteur = stripslashes(FixQuotes($telephone_acteur));
 $fax_acteur = stripslashes(FixQuotes($fax_acteur));
 $email_acteur = stripslashes(FixQuotes($email_acteur));
 $web_acteur = stripslashes(FixQuotes($web_acteur));
 $nom_president_acteur = stripslashes(FixQuotes($nom_president_acteur));
 $nom_directeur_acteur = stripslashes(FixQuotes($nom_directeur_acteur));
 $type_acteur = stripslashes(FixQuotes($type_acteur));
 $status_acteur = stripslashes(FixQuotes($status_acteur));
 $mission_acteur = stripslashes(FixQuotes($mission_acteur));
 $carte_acteur = stripslashes(FixQuotes($carte_acteur));
 
 //$deb->log(compact("nom_contact","prenom_contact","telephone_contact"));
 
if (isset($actid)&& $actid!="") {
	// update
	$resultIn=sql_query("update ".$prefix."_annuaireacteur_acteur set refid='$refid',nom_acteur='$nom_acteur', adresse_acteur='$adresse_acteur',ville_acteur='$ville_acteur',codepostal_acteur='$codepostal_acteur',sigle_acteur='$sigle_acteur',telephone_acteur='$telephone_acteur',fax_acteur='$fax_acteur',email_acteur='$email_acteur',web_acteur='$web_acteur',nom_president_acteur='$nom_president_acteur',nom_directeur_acteur='$nom_directeur_acteur',type_acteur='$type_acteur',status_acteur='$status_acteur',mission_acteur='$mission_acteur',carte_acteur='$carte_acteur', date_acteur=now() where actid=$actid", $dbi);    
    if (!$resultIn) {
    	die('Invalid query:'.mysql_error());
	}
    // delete competence
    $resultDel=sql_query("delete from ".$prefix."_annuaireacteur_domaine where acteur_actid='$actid'", $dbi);
    // delete activity
    $resultDel2=sql_query("delete from ".$prefix."_annuaireacteur_activite where acteur_actid='$actid'", $dbi);
    
    // recreate activity and domaines
    foreach ($domaine_acteur as $domaineid){
    $resultIn2 = sql_query("select domainename from ".$prefix."_annuaireacteur_liste_domaine where domid='$domaineid'",$dbi);
	if (!$resultIn2) {
    	die('Invalid query:'.mysql_error());
	}
	list($domainename)= sql_fetch_row($resultIn2, $dbi);	
    $domainename = stripslashes(FixQuotes($domainename));	
    $resultIn3=sql_query("INSERT INTO ".$prefix."_annuaireacteur_domaine VALUES (NULL,'$actid','$domaineid','$domainename','$nom_acteur')", $dbi);
    if (!$resultIn3) {
    	die('Invalid query:'.mysql_error());
     }
    }
    activiteSave("",$actid, $activite_acteur);
    
    Header("Location: system.php?op=annuaireActeur&onglet=acteur");
 }else{
	// create
	$result=sql_query("INSERT INTO ".$prefix."_annuaireacteur_acteur VALUES (NULL,'$refid','$nom_acteur','$adresse_acteur','$ville_acteur','$codepostal_acteur','$sigle_acteur','$telephone_acteur','$fax_acteur','$email_acteur','$web_acteur','$nom_president_acteur','$nom_directeur_acteur','$type_acteur','$status_acteur','$mission_acteur','$carte_acteur', now() )", $dbi);
    if (!$result) {
    	die('Invalid query:'.mysql_error());
    }
    $actidc = mysql_insert_id();
    foreach ($domaine_acteur as $domaineid){
     $result2 = sql_query("select domainename from ".$prefix."_annuaireacteur_liste_domaine where domid='$domaineid'",$dbi);
	 if (!$result2) {
    	die('Invalid query:'.mysql_error());
	 } 
	 list($domainename)= sql_fetch_row($result2, $dbi);	
     $domainename = stripslashes(FixQuotes($domainename));	
     $result3=sql_query("INSERT INTO ".$prefix."_annuaireacteur_domaine VALUES (NULL,'$actidc','$domaineid','$domainename','$nom_acteur')", $dbi);
     if (!$result3) {
    	die('Invalid query:'.mysql_error());
     }
    }
    activiteSave("",$actidc, $activite_acteur);
    
    Header("Location: system.php?op=annuaireActeur&onglet=acteur");
 }
}
/**
* activiteSave()
* save all information about an activiy in DB
* @param actid :Activity id
* @param array acteurData :Associative Array that containe field name and data value
* @return
* @see
*/
function activiteSave($activiteid,$acteur_actid, $activite_acteur) {
global $prefix, $dbi;

if (isset($activiteids)) {
	// update
	sql_query("update ".$prefix."_annuaireacteur_activite set domainename='$domainename' where comid=$domid", $dbi);
    Header("Location: system.php?op=annuaireActeur&onglet=competence");
 }else{
	foreach ($activite_acteur as $activite){
	$activite = stripslashes(FixQuotes($activite));
    $result=sql_query("INSERT INTO ".$prefix."_annuaireacteur_activite VALUES (NULL,'$acteur_actid','$activite','com activite')", $dbi);
    if (!$result) {
    	die('Invalid query:'.mysql_error());
     }
    }// end foreach
 } // end if esle
}
/**
* contactSave()
* save all information about a contact
* @param conid :contact id
* @param array acteurData :Associative Array that containe field name and data value
* @return
* @see
*/
//include("core/becms_debug_class.php");
function contactSave($contactid, $acteur_actid, $nom_contact, $prenom_contact, $telephone_contact, $telephone_mobile_contact, $fax_contact, $email_contact, $web_contact, $titre_contact, $domaine_contact, $position_contact, $role_contact) {
global $prefix, $dbi;

// $deb=new debug;

 $nom_contact = stripslashes(FixQuotes($nom_contact));
 $prenom_contact = stripslashes(FixQuotes($prenom_contact));
 $telephone_contact = stripslashes(FixQuotes($telephone_contact));
 $telephone_mobile_contact = stripslashes(FixQuotes($telephone_mobile_contact));
 $fax_contact = stripslashes(FixQuotes($fax_contact));
 $email_contact = stripslashes(FixQuotes($email_contact));
 $titre_contact = stripslashes(FixQuotes($titre_contact));
 $domaine_contact = stripslashes(FixQuotes($domaine_contact));
 $role_contact = stripslashes(FixQuotes($role_contact));
 
 //$deb->log(compact("nom_contact","prenom_contact","telephone_contact"));
 
if (isset($contactid) && $contactid!="") {
	// update
	sql_query("update ".$prefix."_annuaireacteur_contact set acteur_actid='$acteur_actid', nom_contact='$nom_contact', prenom_contact='$prenom_contact', telephone_contact='$telephone_contact', telephone_mobile_contact='$telephone_mobile_contact', fax_contact='$fax_contact', email_contact='$email_contact', web_contact='$web_contact', titre_contact='$titre_contact', domaine_contact='$domaine_contact', position_contact='$position_contact', role_contact='$role_contact' where contactid=$contactid", $dbi);    
    Header("Location: system.php?op=annuaireActeur&onglet=contact");
 }else{
	// create
	$result=sql_query("INSERT INTO ".$prefix."_annuaireacteur_contact VALUES (NULL,'$acteur_actid','$nom_contact','$prenom_contact','$telephone_contact','$telephone_mobile_contact','$fax_contact','$email_contact','$web_contact','$titre_contact','$domaine_contact','$position_contact','$role_contact')", $dbi);
    if (!$result) {
    	die('Invalid query:'.mysql_error());
    }
    Header("Location: system.php?op=annuaireActeur&onglet=contact");
 }
}
/**
* competenceSave()
* save all information about competences
* @param comid :competences id
* @param array acteurData :Associative Array that containe field name and data value
* @return
* @see
*/
function competenceSave($domid, $domainename) {
global $prefix, $dbi;
 $domainename = stripslashes(FixQuotes($domainename));
if (isset($domid) && $domid!="") {
	// update
	sql_query("update ".$prefix."_annuaireacteur_liste_domaine set domainename='$domainename' where domid=$domid", $dbi);
    Header("Location: system.php?op=annuaireActeur&onglet=competence");
 }else{
	// create
	sql_query("INSERT INTO ".$prefix."_annuaireacteur_liste_domaine VALUES (NULL,'$domainename')", $dbi);
    Header("Location: system.php?op=annuaireActeur&onglet=competence");
 }
}

/**
* typeSave()
* save all information about organisme type
* @param typid : organism type id
* @param array typeData :Associative Array that containe field name and data value
* @return
* @see
*/
function typeSave($typid, $typename) {
global $prefix, $dbi;
 $typename = stripslashes(FixQuotes($typename));
if (isset($typid)&& $typid!="") {
	// update
	sql_query("update ".$prefix."_annuaireacteur_liste_type set type_organisme='$typename' where typid=$typid", $dbi);
    Header("Location: system.php?op=annuaireActeur&onglet=type");
 }else{
	// create
	sql_query("INSERT INTO ".$prefix."_annuaireacteur_liste_type VALUES (NULL,'$typename')", $dbi);
    Header("Location: system.php?op=annuaireActeur&onglet=type");
 }
}

/**
* statusSave()
* save all information about organisme type
* @param typid : organism type id
* @param array typeData :Associative Array that containe field name and data value
* @return
* @see
*/
function statusSave($statusid, $statusname) {
global $prefix, $dbi;
 $statusname = stripslashes(FixQuotes($statusname));
if (isset($statusid)&& $statusid!="") {
	// update
	sql_query("update ".$prefix."_annuaireacteur_liste_status set statusname='$statusname' where statusid=$statusid", $dbi);
    Header("Location: system.php?op=annuaireActeur&onglet=status");
 }else{
	// create
	sql_query("INSERT INTO ".$prefix."_annuaireacteur_liste_status VALUES (NULL,'$statusname')", $dbi);
    Header("Location: system.php?op=annuaireActeur&onglet=status");
 }
}
/**
 * displayAlphabet()
 * 
 * @param datatype paramname description
 * @return datatype description
 */
 function displayAlphabet($thelink){
 $acteurLink=$thelink."&myfiltertwo=";
 
 echo "<div align=right>"
 ."<a href=\"".$acteurLink."A\">A </a>"
 ."<a href=\"".$acteurLink."B\">B </a>"
 ."<a href=\"".$acteurLink."C\">C </a>"
 ."<a href=\"".$acteurLink."D\">D </a>"
 ."<a href=\"".$acteurLink."E\">E </a>"
 ."<a href=\"".$acteurLink."F\">F </a>"
 ."<a href=\"".$acteurLink."G\">G </a>"
 ."<a href=\"".$acteurLink."H\">H </a>"
 ."<a href=\"".$acteurLink."I\">I </a>"
 ."<a href=\"".$acteurLink."J\">J </a>"
 ."<a href=\"".$acteurLink."K\">K </a>"
 ."<a href=\"".$acteurLink."L\">L </a>"
 ."<a href=\"".$acteurLink."M\">M </a>"
 ."<a href=\"".$acteurLink."N\">N </a>"
 ."<a href=\"".$acteurLink."O\">O </a>"
 ."<a href=\"".$acteurLink."P\">P </a>"
 ."<a href=\"".$acteurLink."Q\">Q </a>"
 ."<a href=\"".$acteurLink."R\">R </a>"
 ."<a href=\"".$acteurLink."S\">S </a>"
 ."<a href=\"".$acteurLink."T\">T </a>"
 ."<a href=\"".$acteurLink."U\">U </a>"
 ."<a href=\"".$acteurLink."V\">V </a>"
 ."<a href=\"".$acteurLink."X\">X </a>"
 ."<a href=\"".$acteurLink."Y\">Y </a>"
 ."<a href=\"".$acteurLink."Z\">Z </a>"
 ."</div>";
 }

/*--------------------------------------*/
/*           start Switch				*/
/*--------------------------------------*/
switch ($op) {
case "annuaireActeur":
    annuaireActeur($onglet, $editid, $editForm, $myfilter, $myfiltertwo);
    break;
case "acteurEdit":
    acteurEdit($actid, $editForm, $asHtml);
    break;
case "contactEdit":
    contactEdit($contactid, $editForm, $asHtml);
    break;
case "competenceEdit":
    competenceEdit($domid, $editForm, $asHtml);
    break;
case "activiteEdit":
    activiteEdit($actid);
    break;
case "typeEdit":
    typeEdit($typid,$editForm, $asHtml);
    break;
case "statusEdit":
    typeEdit($statusid, $editForm, $asHtml);
    break;
case "activiteDelete":
    activiteDelete($actid, $ok);
    break;
case "contactDelete":
    contactDelete($contactid, $ok);
    break;
case "competenceDelete":
    competenceDelete($domid, $ok);
    break;     
case "acteurDelete":
    acteurDelete($actid, $ok);
    break; 
case "typeDelete":
    typeDelete($typid, $ok);
    break; 
case "statusDelete":
    statusDelete($statusid, $ok);
    break; 
case "acteurSave":
    acteurSave($actid,$refid, $nom_acteur,$adresse_acteur,$ville_acteur,$codepostal_acteur,$sigle_acteur,$telephone_acteur,$fax_acteur,$email_acteur,$web_acteur,$nom_president_acteur,$nom_directeur_acteur,$type_acteur,$status_acteur,$mission_acteur,$carte_acteur,$domaine_acteur, $activite_acteur);
    break; 
case "activiteSave":
    activiteSave($actid, $activiteData);
    break; 
case "contactSave":
    contactSave($contactid, $acteur_actid, $nom_contact, $prenom_contact, $telephone_contact, $telephone_mobile_contact, $fax_contact, $email_contact, $web_contact, $titre_contact, $domaine_contact, $position_contact, $role_contact);
    break;  
case "competenceSave":
    competenceSave($domid, $domainename);
    break;       
case "typeSave":
    typeSave($typid, $typename);
    break;  
case "statusSave":
    statusSave($statusid, $statusname);
    break;                              
}

}
else {
    display_denied();
}

?>